/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.prefs.PathPrefs;

class MemoryMonitorDialog {
    private static final Logger logger = LoggerFactory.getLogger(MemoryMonitorDialog.class);
    private QuPathGUI qupath;
    private Stage stage;
    private XYChart.Series<Number, Number> seriesTotal = new XYChart.Series();
    private XYChart.Series<Number, Number> seriesUsed = new XYChart.Series();
    private long startTimeMillis;
    private LongProperty timeMillis = new SimpleLongProperty();
    private LongProperty maxMemory = new SimpleLongProperty();
    private LongProperty totalMemory = new SimpleLongProperty();
    private LongProperty usedMemory = new SimpleLongProperty();
    private LongProperty cachedTiles = new SimpleLongProperty();
    private LongProperty undoRedoSizeBytes = new SimpleLongProperty();
    private static final double scaleMB = 9.5367431640625E-7;
    private static final double scaleGB = 9.313225746154785E-10;
    private final MemoryService service = new MemoryService();

    MemoryMonitorDialog(QuPathGUI qupath) {
        this.qupath = qupath;
        NumberAxis xAxis = new NumberAxis();
        xAxis.setLabel("Time (seconds)");
        NumberAxis yAxis = new NumberAxis();
        yAxis.setLabel("Memory (GB)");
        AreaChart chart = new AreaChart((Axis)xAxis, (Axis)yAxis);
        yAxis.setAutoRanging(false);
        yAxis.setLowerBound(0.0);
        yAxis.setTickUnit(1.0);
        yAxis.setUpperBound(Math.ceil((double)Runtime.getRuntime().maxMemory() * 9.313225746154785E-10));
        xAxis.setAutoRanging(false);
        xAxis.upperBoundProperty().bind((ObservableValue)Bindings.createLongBinding(() -> Math.max(10L, (this.timeMillis.get() - this.startTimeMillis) / 1000L), (Observable[])new Observable[]{this.timeMillis}));
        this.seriesTotal.nameProperty().bind((ObservableValue)Bindings.createStringBinding(() -> String.format("Total memory (%.1f MB)", (double)this.totalMemory.get() * 9.5367431640625E-7), (Observable[])new Observable[]{this.totalMemory}));
        this.seriesUsed.nameProperty().bind((ObservableValue)Bindings.createStringBinding(() -> String.format("Used memory (%.1f MB)", (double)this.usedMemory.get() * 9.5367431640625E-7), (Observable[])new Observable[]{this.usedMemory}));
        chart.getData().add(this.seriesTotal);
        chart.getData().add(this.seriesUsed);
        chart.setLegendVisible(true);
        chart.setLegendSide(Side.TOP);
        chart.setAnimated(false);
        chart.setCreateSymbols(false);
        Label labelClearCache = new Label();
        labelClearCache.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> String.format("Num cached tiles: %d", this.cachedTiles.get()), (Observable[])new Observable[]{this.cachedTiles}));
        Button btnClearCache = new Button("Clear tile cache");
        btnClearCache.setTooltip(new Tooltip("Clear the cache used to store image tiles for better viewer performance"));
        btnClearCache.setOnAction(e -> {
            try {
                logger.info("Clearing cache...");
                qupath.getViewer().getImageRegionStore().clearCache();
                System.gc();
            }
            catch (Exception e2) {
                logger.error("Error clearing cache", (Throwable)e2);
            }
        });
        btnClearCache.setMaxWidth(Double.MAX_VALUE);
        Label labelUndoRedo = new Label();
        labelUndoRedo.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> String.format("Undo/Redo memory: %.2f GB", (double)this.undoRedoSizeBytes.get() / 1.073741824E9), (Observable[])new Observable[]{this.undoRedoSizeBytes}));
        Button btnClearUndoRedo = new Button("Reset undo/redo");
        btnClearUndoRedo.setTooltip(new Tooltip("Clear all the data needed to support undo/redo"));
        btnClearUndoRedo.setOnAction(e -> {
            try {
                logger.info("Clearing undo/redo...");
                qupath.getUndoRedoManager().clear();
                System.gc();
            }
            catch (Exception e2) {
                logger.error("Error undo/redo", (Throwable)e2);
            }
        });
        btnClearUndoRedo.setMaxWidth(Double.MAX_VALUE);
        Button btnGarbageCollector = new Button("Reclaim memory");
        btnGarbageCollector.setTooltip(new Tooltip("Request all available memory be reclaimed (this helps give a more accurate graph)"));
        btnGarbageCollector.setOnAction(e -> System.gc());
        btnGarbageCollector.setMaxWidth(Double.MAX_VALUE);
        ToggleButton btnToggleMonitoring = new ToggleButton();
        btnToggleMonitoring.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (btnToggleMonitoring.isSelected()) {
                return "Stop monitoring";
            }
            return "Start monitoring";
        }, (Observable[])new Observable[]{btnToggleMonitoring.selectedProperty()}));
        btnToggleMonitoring.setMaxWidth(Double.MAX_VALUE);
        btnToggleMonitoring.selectedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                if (!this.service.isRunning()) {
                    this.service.restart();
                }
            } else if (this.service.isRunning()) {
                this.service.cancel();
                this.service.reset();
            }
        });
        Button btnReset = new Button("Reset monitor");
        btnReset.setOnAction(e -> {
            this.startTimeMillis = 0L;
            this.seriesUsed.getData().clear();
            this.seriesTotal.getData().clear();
        });
        btnReset.setMaxWidth(Double.MAX_VALUE);
        Runtime runtime = Runtime.getRuntime();
        Label labThreads = new Label("Parallel threads");
        TextField tfThreads = new TextField(Integer.toString(PathPrefs.numCommandThreadsProperty().get()));
        PathPrefs.numCommandThreadsProperty().addListener((v, o, n) -> {
            String text = n.toString();
            if (!text.trim().equals(tfThreads.getText().trim())) {
                // empty if block
            }
            tfThreads.setText(text);
        });
        tfThreads.setPrefColumnCount(4);
        tfThreads.textProperty().addListener((v, o, n) -> {
            try {
                PathPrefs.numCommandThreadsProperty().set(Integer.parseInt(n.trim()));
            }
            catch (Exception e) {
                logger.debug(e.getLocalizedMessage(), (Throwable)e);
            }
        });
        labThreads.setLabelFor((Node)tfThreads);
        GridPane paneRight = new GridPane();
        int col = 0;
        int row = 0;
        paneRight.add((Node)new Label("Available processors: " + runtime.availableProcessors()), col, row++, 1, 1);
        paneRight.add((Node)labThreads, col, row, 1, 1);
        paneRight.add((Node)tfThreads, col + 1, row++, 1, 1);
        paneRight.add((Node)labelClearCache, col, row++, 2, 1);
        paneRight.add((Node)btnClearCache, col, row++, 2, 1);
        paneRight.add((Node)labelUndoRedo, col, row++, 2, 1);
        paneRight.add((Node)btnClearUndoRedo, col, row++, 2, 1);
        paneRight.add((Node)btnGarbageCollector, col, row++, 2, 1);
        BorderPane padding = new BorderPane();
        paneRight.add((Node)padding, col, row++, 2, 1);
        padding.setMaxHeight(Double.MAX_VALUE);
        GridPane.setFillHeight((Node)padding, (Boolean)Boolean.TRUE);
        GridPane.setVgrow((Node)padding, (Priority)Priority.ALWAYS);
        paneRight.add((Node)btnToggleMonitoring, col, row++, 2, 1);
        paneRight.add((Node)btnReset, col, row++, 2, 1);
        paneRight.setPadding(new Insets(10.0));
        paneRight.setVgap(5.0);
        BorderPane pane = new BorderPane((Node)chart);
        pane.setRight((Node)paneRight);
        this.service.setPeriod(Duration.seconds((double)1.0));
        this.service.lastValueProperty().addListener((v, o, n) -> {
            if (n == null) {
                return;
            }
            if (this.startTimeMillis <= 0L) {
                this.startTimeMillis = n.timeMillis;
            }
            this.timeMillis.set(n.timeMillis);
            this.maxMemory.set(n.maxMemory);
            this.totalMemory.set(n.totalMemory);
            this.usedMemory.set(n.usedMemory);
            this.undoRedoSizeBytes.set(n.undoRedoSizeBytes);
            this.cachedTiles.set(n.cachedTiles);
            long time = (this.timeMillis.get() - this.startTimeMillis) / 1000L;
            this.seriesUsed.getData().add((Object)new XYChart.Data((Object)time, (Object)((double)this.usedMemory.get() * 9.313225746154785E-10)));
            this.seriesTotal.getData().add((Object)new XYChart.Data((Object)time, (Object)((double)this.totalMemory.get() * 9.313225746154785E-10)));
        });
        this.stage = new Stage();
        this.stage.initOwner((Window)qupath.getStage());
        this.stage.setScene(new Scene((Parent)pane));
        this.stage.setTitle("Memory monitor");
        FXUtils.addCloseWindowShortcuts((Stage)this.stage);
        this.stage.setOnShowing(e -> btnToggleMonitoring.setSelected(true));
        this.stage.setOnHiding(e -> {
            btnToggleMonitoring.setSelected(false);
            btnReset.fire();
        });
    }

    public Stage getStage() {
        return this.stage;
    }

    void snapshot() {
        int time = this.seriesUsed.getData().size() + 1;
        this.seriesUsed.getData().add((Object)new XYChart.Data((Object)time, (Object)((double)this.usedMemory.get() * 9.313225746154785E-10)));
        this.seriesTotal.getData().add((Object)new XYChart.Data((Object)time, (Object)((double)this.totalMemory.get() * 9.313225746154785E-10)));
    }

    class MemoryService
    extends ScheduledService<MemorySnapshot> {
        MemoryService() {
        }

        protected Task<MemorySnapshot> createTask() {
            return new Task<MemorySnapshot>(){

                protected MemorySnapshot call() {
                    return new MemorySnapshot(MemoryMonitorDialog.this.qupath, Runtime.getRuntime());
                }
            };
        }
    }

    static class MemorySnapshot {
        private long timeMillis = System.currentTimeMillis();
        private long totalMemory;
        private long maxMemory;
        private long usedMemory;
        private long undoRedoSizeBytes;
        private long cachedTiles;

        MemorySnapshot(QuPathGUI qupath, Runtime runtime) {
            this.totalMemory = runtime.totalMemory();
            this.maxMemory = runtime.maxMemory();
            this.usedMemory = this.totalMemory - runtime.freeMemory();
            this.undoRedoSizeBytes = qupath.getUndoRedoManager().totalBytes();
            this.cachedTiles = qupath.getViewer().getImageRegionStore().getCache().size();
        }
    }
}

