/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.scripting.QP;

class MeasurementManager {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementManager.class);
    private ComboBox<Class<? extends PathObject>> comboBox;
    private ListView<String> listView;
    private BorderPane pane;
    private StringProperty filterText = new SimpleStringProperty();
    private ImageData<?> imageData;
    private Map<Class<? extends PathObject>, Set<String>> mapMeasurements;
    private ObservableList<String> measurementList = FXCollections.observableArrayList();
    private FilteredList<String> filteredList = this.measurementList.filtered(p -> true);

    public static void showDetectionMeasurementManager(QuPathGUI qupath, ImageData<?> imageData) {
        if (imageData == null) {
            GuiTools.showNoImageError("Measurement Manager");
            return;
        }
        MeasurementManager manager = new MeasurementManager(imageData);
        if (!manager.hasMeasurements()) {
            Dialogs.showErrorMessage((String)"Measurement Manager", (String)"No measurements found!");
            return;
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dialogs.builder().title("Measurement Manager").content((Node)manager.getPane()).buttons(new ButtonType[]{ButtonType.CLOSE}).width(Math.min(600.0, screenSize.getWidth() / 2.0)).resizable().showAndWait();
    }

    private MeasurementManager(ImageData<?> imageData) {
        this.imageData = imageData;
        this.refreshMeasurements();
    }

    Pane getPane() {
        if (this.pane == null) {
            this.initializePane();
        }
        return this.pane;
    }

    private synchronized void refreshMeasurements() {
        Collection objects = this.imageData.getHierarchy().getObjects(null, null);
        Map map = objects.stream().filter(p -> p.hasMeasurements()).collect(Collectors.groupingBy(p -> p.getClass(), Collectors.toList()));
        this.mapMeasurements = new HashMap<Class<? extends PathObject>, Set<String>>();
        for (Map.Entry entry : map.entrySet()) {
            LinkedHashSet set = new LinkedHashSet();
            for (PathObject pathObject : entry.getValue()) {
                set.addAll(pathObject.getMeasurementList().getNames());
            }
            this.mapMeasurements.put(entry.getKey(), set);
        }
        if (this.comboBox != null) {
            Class selected = (Class)this.comboBox.getSelectionModel().getSelectedItem();
            this.comboBox.getItems().setAll(this.mapMeasurements.keySet());
            if (selected != null && this.mapMeasurements.containsKey(selected)) {
                this.comboBox.getSelectionModel().select((Object)selected);
            } else if (!this.mapMeasurements.isEmpty()) {
                this.comboBox.getSelectionModel().selectFirst();
            }
        }
    }

    private synchronized void initializePane() {
        this.comboBox = new ComboBox();
        this.comboBox.setCellFactory(data -> FXUtils.createCustomListCell(c -> PathObjectTools.getSuitableName((Class)c, (boolean)true)));
        this.comboBox.setButtonCell(FXUtils.createCustomListCell(c -> PathObjectTools.getSuitableName((Class)c, (boolean)true)));
        this.comboBox.getItems().setAll(this.mapMeasurements.keySet());
        this.comboBox.getSelectionModel().selectFirst();
        this.comboBox.setMaxWidth(Double.MAX_VALUE);
        BorderPane paneTop = new BorderPane(this.comboBox);
        Tooltip.install((Node)paneTop, (Tooltip)new Tooltip("Select an object type to view all associated measurements"));
        Label label = new Label("Object type: ");
        label.setMaxHeight(Double.MAX_VALUE);
        paneTop.setLeft((Node)label);
        paneTop.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        this.listView = new ListView(this.filteredList);
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.updateCurrentList();
        TitledPane titledMeasurements = new TitledPane("Measurements", this.listView);
        titledMeasurements.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> "Measurements (" + this.measurementList.size() + ")", (Observable[])new Observable[]{this.measurementList}));
        titledMeasurements.setCollapsible(false);
        titledMeasurements.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        TextField tfFilter = new TextField();
        tfFilter.setPromptText("Filter measurements");
        tfFilter.setTooltip(new Tooltip("Enter text to filter measurements"));
        tfFilter.setMaxHeight(Double.MAX_VALUE);
        tfFilter.textProperty().bindBidirectional((Property)this.filterText);
        BorderPane paneMeasurements = new BorderPane((Node)titledMeasurements);
        Button btnRemove = new Button("Delete selected");
        btnRemove.setMaxWidth(Double.MAX_VALUE);
        btnRemove.setOnAction(e -> this.promptToRemoveMeasurements());
        btnRemove.disableProperty().bind((ObservableValue)this.listView.getSelectionModel().selectedItemProperty().isNull());
        Button btnRemoveAll = new Button("Delete all");
        btnRemoveAll.setMaxWidth(Double.MAX_VALUE);
        btnRemoveAll.setOnAction(e -> this.promptToRemoveAllMeasurements());
        btnRemoveAll.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)this.listView.getItems()));
        GridPane paneButton = GridPaneUtils.createRowGrid((Node[])new Node[]{tfFilter, GridPaneUtils.createColumnGrid((Node[])new Node[]{btnRemoveAll, btnRemove})});
        paneMeasurements.setBottom((Node)paneButton);
        this.listView.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.BACK_SPACE || e.getCode() == KeyCode.DELETE) {
                btnRemove.fire();
            }
        });
        this.filterText.addListener((v, o, n) -> this.updatePredicate((String)n));
        this.comboBox.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.updateCurrentList());
        for (Class defaultClass : Arrays.asList(PathCellObject.class, PathDetectionObject.class, PathAnnotationObject.class, TMACoreObject.class)) {
            if (!this.mapMeasurements.containsKey(defaultClass)) continue;
            this.comboBox.getSelectionModel().select((Object)defaultClass);
            break;
        }
        this.pane = new BorderPane();
        this.pane.setTop((Node)paneTop);
        this.pane.setCenter((Node)paneMeasurements);
        this.pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
    }

    boolean hasMeasurements() {
        return !this.mapMeasurements.isEmpty();
    }

    private boolean promptToRemoveAllMeasurements() {
        Object script;
        String number;
        Class selectedClass = (Class)this.comboBox.getSelectionModel().getSelectedItem();
        ArrayList<String> selectedItems = new ArrayList<String>((Collection<String>)this.measurementList);
        if (selectedClass == null || selectedItems.isEmpty()) {
            Dialogs.showErrorMessage((String)"Remove measurements", (String)"No measurements selected!");
            return false;
        }
        String string = number = selectedItems.size() == 1 ? String.format("'%s'", selectedItems.iterator().next()) : selectedItems.size() + " measurements";
        if (!Dialogs.showConfirmDialog((String)"Remove measurements", (String)("Are you sure you want to permanently remove " + number + "?"))) {
            return false;
        }
        logger.info("Removing all measurements for {}", (Object)PathObjectTools.getSuitableName((Class)selectedClass, (boolean)true));
        Class cls = (Class)this.comboBox.getSelectionModel().getSelectedItem();
        PathObjectHierarchy hierarchy = this.imageData.getHierarchy();
        if (cls == PathAnnotationObject.class) {
            script = "removeAnnotationMeasurements()";
            QP.removeAnnotationMeasurements((PathObjectHierarchy)hierarchy);
        } else if (cls == PathCellObject.class) {
            script = "removeCellMeasurements()";
            QP.removeCellMeasurements((PathObjectHierarchy)hierarchy);
        } else if (cls == PathTileObject.class) {
            script = "removeTileMeasurements()";
            QP.removeTileMeasurements((PathObjectHierarchy)hierarchy);
        } else if (cls == PathRootObject.class) {
            script = "removeRootMeasurements()";
            QP.removeRootMeasurements((PathObjectHierarchy)hierarchy);
        } else if (cls == TMACoreObject.class) {
            script = "removeTMACoreMeasurements()";
            QP.removeTMACoreMeasurements((PathObjectHierarchy)hierarchy);
        } else {
            script = "removeMeasurements(" + cls.getName() + ")";
            QP.removeMeasurements((PathObjectHierarchy)hierarchy, (Class)cls);
        }
        DefaultScriptableWorkflowStep step = new DefaultScriptableWorkflowStep("Delete all measurements", (String)script);
        this.imageData.getHistoryWorkflow().addStep((WorkflowStep)step);
        this.refreshMeasurements();
        this.updateCurrentList();
        this.filterText.set((Object)"");
        return true;
    }

    private boolean promptToRemoveMeasurements() {
        String number;
        ArrayList selectedItems = new ArrayList(this.listView.getSelectionModel().getSelectedItems());
        if (selectedItems.isEmpty()) {
            Dialogs.showErrorMessage((String)"Remove measurements", (String)"No measurements selected!");
            return false;
        }
        String string = number = selectedItems.size() == 1 ? String.format("'%s'", selectedItems.iterator().next()) : selectedItems.size() + " measurements";
        if (!Dialogs.showConfirmDialog((String)"Remove measurements", (String)("Are you sure you want to permanently remove " + number + "?"))) {
            return false;
        }
        Object removeString = selectedItems.stream().map(m -> "\"" + m + "\"").collect(Collectors.joining(", "));
        logger.info("Removing measurements: {}", removeString);
        Class cls = (Class)this.comboBox.getSelectionModel().getSelectedItem();
        QP.removeMeasurements((PathObjectHierarchy)this.imageData.getHierarchy(), (Class)cls, (String[])((String[])selectedItems.toArray(String[]::new)));
        if (selectedItems.size() > 200) {
            removeString = "[" + (String)removeString + "] as String[]";
        }
        DefaultScriptableWorkflowStep step = new DefaultScriptableWorkflowStep("Remove measurements", String.format("removeMeasurements(%s, %s)", cls.getName(), removeString));
        this.imageData.getHistoryWorkflow().addStep((WorkflowStep)step);
        this.refreshMeasurements();
        this.updateCurrentList();
        this.filterText.set((Object)"");
        return true;
    }

    private void updatePredicate(String text) {
        if (text == null || text.isBlank()) {
            this.filteredList.setPredicate(p -> true);
        } else {
            String lower = text.toLowerCase();
            this.filteredList.setPredicate(p -> p.toLowerCase().contains(lower));
        }
    }

    private void updateCurrentList() {
        Class selected;
        Class clazz = selected = this.comboBox == null ? null : (Class)this.comboBox.getSelectionModel().getSelectedItem();
        if (selected == null) {
            this.measurementList.clear();
        } else {
            this.measurementList.setAll((Collection)this.mapMeasurements.getOrDefault(selected, Collections.emptySet()));
        }
    }
}

