/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.controlsfx.control.CheckComboBox;
import org.controlsfx.control.ListSelectionView;
import org.controlsfx.dialog.ProgressDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.dialogs.ProjectDialogs;
import qupath.lib.gui.measure.ObservableMeasurementTableData;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.MeasurementExporter;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.projects.Projects;

public class MeasurementExportCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementExportCommand.class);
    private static final String title = "Export Measurements";
    private final QuPathGUI qupath;
    private final ObjectProperty<Future<?>> runningTask = new SimpleObjectProperty();
    private Dialog<ButtonType> dialog = null;
    private Project<BufferedImage> project;
    private final List<ProjectImageEntry<BufferedImage>> previousImages = new ArrayList<ProjectImageEntry<BufferedImage>>();
    private Class<? extends PathObject> type = PathRootObject.class;
    private final TextField outputText = new TextField();
    private ComboBox<String> pathObjectCombo;
    private ComboBox<String> separatorCombo;
    private CheckComboBox<String> includeCombo;
    private final ButtonType btnExport = new ButtonType("Export", ButtonBar.ButtonData.OK_DONE);

    public MeasurementExportCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        this.createAndShowDialog();
    }

    private void createAndShowDialog() {
        this.project = this.qupath.getProject();
        if (this.project == null) {
            GuiTools.showNoProjectError(title);
            return;
        }
        BorderPane mainPane = new BorderPane();
        BorderPane imageEntryPane = new BorderPane();
        GridPane optionPane = new GridPane();
        optionPane.setHgap(5.0);
        optionPane.setVgap(5.0);
        this.project = this.qupath.getProject();
        this.pathObjectCombo = new ComboBox();
        this.separatorCombo = new ComboBox();
        this.includeCombo = new CheckComboBox();
        String sameImageWarning = "A selected image is open in the viewer!\nData should be saved before exporting.";
        ListSelectionView<ProjectImageEntry<BufferedImage>> listSelectionView = ProjectDialogs.createImageChoicePane(this.qupath, this.project.getImageList(), this.previousImages, sameImageWarning);
        int row = 0;
        Label pathOutputLabel = new Label("Output file");
        Button btnChooseFile = new Button("Choose");
        btnChooseFile.setOnAction(e -> {
            String extSelected = (String)this.separatorCombo.getSelectionModel().getSelectedItem();
            String ext = extSelected.equals("Tab (.tsv)") ? ".tsv" : ".csv";
            String extDesc = ext.equals(".tsv") ? "TSV (Tab delimited)" : "CSV (Comma delimited)";
            File pathOut = FileChoosers.promptToSaveFile((String)"Output file", (File)new File(Projects.getBaseDirectory(this.project), "measurements" + ext), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)extDesc, (String[])new String[]{ext})});
            if (pathOut != null) {
                if (pathOut.isDirectory()) {
                    pathOut = new File(pathOut.getAbsolutePath() + File.separator + "measurements" + ext);
                }
                this.outputText.setText(pathOut.getAbsolutePath());
            }
        });
        pathOutputLabel.setLabelFor((Node)this.outputText);
        GridPaneUtils.addGridRow((GridPane)optionPane, (int)row++, (int)0, (String)"Choose output file", (Node[])new Node[]{pathOutputLabel, this.outputText, this.outputText, btnChooseFile, btnChooseFile});
        this.outputText.setMaxWidth(Double.MAX_VALUE);
        btnChooseFile.setMaxWidth(Double.MAX_VALUE);
        Label pathObjectLabel = new Label("Export type");
        pathObjectLabel.setLabelFor(this.pathObjectCombo);
        this.pathObjectCombo.getItems().setAll((Object[])new String[]{"Image", "Annotations", "Detections", "Cells", "TMA cores"});
        this.pathObjectCombo.getSelectionModel().selectFirst();
        this.pathObjectCombo.valueProperty().addListener((v, o, n) -> {
            if (n != null) {
                this.setType((String)n);
            }
        });
        GridPaneUtils.addGridRow((GridPane)optionPane, (int)row++, (int)0, (String)"Choose the export type", (Node[])new Node[]{pathObjectLabel, this.pathObjectCombo, this.pathObjectCombo, this.pathObjectCombo, this.pathObjectCombo});
        Label separatorLabel = new Label("Separator");
        separatorLabel.setLabelFor(this.separatorCombo);
        this.separatorCombo.getItems().setAll((Object[])new String[]{"Tab (.tsv)", "Comma (.csv)", "Semicolon (.csv)"});
        this.separatorCombo.getSelectionModel().selectFirst();
        GridPaneUtils.addGridRow((GridPane)optionPane, (int)row++, (int)0, (String)"Choose a value separator", (Node[])new Node[]{separatorLabel, this.separatorCombo, this.separatorCombo, this.separatorCombo, this.separatorCombo});
        Label includeLabel = new Label("Columns to include (Optional)");
        includeLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        includeLabel.setLabelFor(this.includeCombo);
        this.includeCombo.setShowCheckedCount(true);
        FXUtils.installSelectAllOrNoneMenu(this.includeCombo);
        Button btnPopulateColumns = new Button("Populate");
        ProgressBar progressIndicator = new ProgressBar();
        progressIndicator.setPrefHeight(10.0);
        progressIndicator.setMaxWidth(Double.MAX_VALUE);
        progressIndicator.setProgress(0.0);
        progressIndicator.setOpacity(0.0);
        Button btnResetColumns = new Button("Reset");
        GridPaneUtils.addGridRow((GridPane)optionPane, (int)row++, (int)0, (String)"Choose the specific column(s) to include (default: all)", (Node[])new Node[]{includeLabel, this.includeCombo, btnPopulateColumns, btnResetColumns});
        optionPane.add((Node)progressIndicator, 1, row++);
        btnPopulateColumns.setOnAction(e -> this.populateColumns(List.copyOf(listSelectionView.getTargetItems()), (ProgressIndicator)progressIndicator));
        btnPopulateColumns.disableProperty().addListener((v, o, n) -> {
            if (n != null && n.booleanValue()) {
                this.includeCombo.setDisable(true);
            }
        });
        BooleanBinding targetItemBinding = Bindings.size((ObservableList)listSelectionView.getTargetItems()).isEqualTo(0);
        btnPopulateColumns.disableProperty().bind((ObservableValue)targetItemBinding);
        btnResetColumns.disableProperty().bind((ObservableValue)targetItemBinding);
        btnResetColumns.setOnAction(e -> this.includeCombo.getCheckModel().clearChecks());
        this.separatorCombo.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> {
            if (n == null) {
                return;
            }
            String currentOut = this.outputText.getText();
            if (n.equals("Tab (.tsv)") && currentOut.endsWith(".csv")) {
                this.outputText.setText(currentOut.replace(".csv", ".tsv"));
            } else if ((n.equals("Comma (.csv)") || n.equals("Semicolon (.csv)")) && currentOut.endsWith(".tsv")) {
                this.outputText.setText(currentOut.replace(".tsv", ".csv"));
            }
        });
        FXUtils.getContentsOfType((Parent)optionPane, Label.class, (boolean)false).forEach(e -> e.setMinWidth(160.0));
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{this.outputText, this.pathObjectCombo, this.separatorCombo, this.includeCombo});
        btnPopulateColumns.setMinWidth(75.0);
        btnResetColumns.setMinWidth(75.0);
        this.dialog = Dialogs.builder().title(title).resizable().buttons(new ButtonType[]{this.btnExport, ButtonType.CANCEL}).content((Node)mainPane).build();
        this.dialog.getDialogPane().setPrefSize(600.0, 400.0);
        imageEntryPane.setCenter(listSelectionView);
        BooleanBinding emptyOutputTextBinding = this.outputText.textProperty().isEqualTo("");
        this.dialog.getDialogPane().lookupButton(this.btnExport).disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)emptyOutputTextBinding, (ObservableBooleanValue)targetItemBinding));
        mainPane.setCenter((Node)imageEntryPane);
        mainPane.setBottom((Node)optionPane);
        Optional result = this.dialog.showAndWait();
        if (result.isEmpty() || result.get() != this.btnExport || result.get() == ButtonType.CANCEL) {
            return;
        }
        String curExt = GeneralTools.getExtension((String)this.outputText.getText()).orElse("");
        if (!curExt.equals(".csv") && !curExt.equals(".tsv")) {
            String extSelected = (String)this.separatorCombo.getSelectionModel().getSelectedItem();
            String ext = extSelected.equals("Tab (.tsv)") ? ".tsv" : ".csv";
            this.outputText.setText(this.outputText.getText().substring(0, this.outputText.getText().length() - curExt.length()) + ext);
        }
        if (new File(this.outputText.getText()).getParent() == null) {
            String ext = GeneralTools.getExtension((String)this.outputText.getText()).orElse("").equals(".tsv") ? ".tsv" : ".csv";
            String extDesc = ext.equals(".tsv") ? "TSV (Tab delimited)" : "CSV (Comma delimited)";
            File pathOut = FileChoosers.promptToSaveFile((String)"Output file", (File)new File(Projects.getBaseDirectory(this.project), this.outputText.getText()), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)extDesc, (String[])new String[]{ext})});
            if (pathOut == null) {
                return;
            }
            this.outputText.setText(pathOut.getAbsolutePath());
        }
        ObservableList checkedItems = this.includeCombo.getCheckModel().getCheckedItems();
        String[] include = checkedItems.stream().toList().toArray(new String[checkedItems.size()]);
        String separator = (String)PathPrefs.tableDelimiterProperty().get();
        separator = switch ((String)this.separatorCombo.getSelectionModel().getSelectedItem()) {
            case "Tab (.tsv)" -> "\t";
            case "Comma (.csv)" -> ",";
            case "Semicolon (.csv)" -> ";";
            default -> separator;
        };
        MeasurementExporter exporter = new MeasurementExporter().imageList((List<ProjectImageEntry<BufferedImage>>)listSelectionView.getTargetItems()).separator(separator).includeOnlyColumns(include).exportType(this.type);
        ExportTask worker = new ExportTask(exporter, this.outputText.getText());
        ProgressDialog progress = new ProgressDialog((Worker)worker);
        progress.setWidth(600.0);
        progress.initOwner((Window)this.qupath.getStage());
        progress.setTitle(title);
        progress.getDialogPane().setHeaderText("Exporting measurements...");
        progress.getDialogPane().setGraphic(null);
        progress.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
        progress.getDialogPane().lookupButton(ButtonType.CANCEL).addEventFilter(ActionEvent.ACTION, e -> {
            if (Dialogs.showYesNoDialog((String)"Cancel export", (String)"Are you sure you want to stop the export after the current image?")) {
                worker.cancel(true);
                progress.setHeaderText("Cancelling...");
                progress.getDialogPane().lookupButton(ButtonType.CANCEL).setDisable(true);
            }
            e.consume();
        });
        this.runningTask.set(this.qupath.getThreadPoolManager().getSingleThreadExecutor(this).submit((Runnable)((Object)worker)));
        progress.show();
    }

    private void populateColumns(List<ProjectImageEntry<BufferedImage>> imageList, ProgressIndicator progressIndicator) {
        this.includeCombo.setDisable(true);
        Set allColumnsForCombo = Collections.synchronizedSet(new LinkedHashSet());
        this.setType((String)this.pathObjectCombo.getSelectionModel().getSelectedItem());
        progressIndicator.setProgress(0.0);
        progressIndicator.setOpacity(1.0);
        CompletableFuture.runAsync(() -> {
            int n = imageList.size();
            int counter = 0;
            for (ProjectImageEntry entry : imageList) {
                try {
                    ImageData imageData = entry.readImageData();
                    try {
                        double progress = (double)counter / (double)n;
                        Platform.runLater(() -> progressIndicator.setProgress(progress));
                        ++counter;
                        ObservableMeasurementTableData model = new ObservableMeasurementTableData();
                        model.setImageData(imageData, imageData == null ? Collections.emptyList() : imageData.getHierarchy().getObjects(null, this.type));
                        allColumnsForCombo.addAll(model.getAllNames());
                    }
                    finally {
                        if (imageData == null) continue;
                        imageData.close();
                    }
                }
                catch (Exception ex) {
                    logger.warn("Error loading columns for entry {}: {}", (Object)entry.getImageName(), (Object)ex.getMessage());
                    logger.debug("{}", (Object)ex.getMessage(), (Object)ex);
                }
            }
        }).thenRunAsync(() -> {
            allColumnsForCombo.removeIf(Objects::isNull);
            this.includeCombo.getItems().setAll((Collection)allColumnsForCombo);
            this.includeCombo.getCheckModel().clearChecks();
            this.includeCombo.setDisable(false);
            progressIndicator.setOpacity(0.0);
            progressIndicator.setProgress(1.0);
        }, Platform::runLater);
        this.includeCombo.getCheckModel().clearChecks();
    }

    private void setType(String typeString) {
        if (typeString != null) {
            switch (typeString) {
                case "Image": {
                    this.type = PathRootObject.class;
                    break;
                }
                case "Annotations": {
                    this.type = PathAnnotationObject.class;
                    break;
                }
                case "Detections": {
                    this.type = PathDetectionObject.class;
                    break;
                }
                case "Cells": {
                    this.type = PathCellObject.class;
                    break;
                }
                case "TMA cores": {
                    this.type = TMACoreObject.class;
                }
            }
        }
    }

    static class ExportTask
    extends Task<Void> {
        private final String pathOut;
        private final MeasurementExporter exporter;

        public ExportTask(MeasurementExporter exporter, String pathOut) {
            this.pathOut = pathOut;
            this.exporter = exporter;
        }

        protected Void call() {
            long startTime = System.currentTimeMillis();
            try {
                this.exporter.progressMonitor(p -> this.updateProgress(p, 1.0)).exportMeasurements(new File(this.pathOut));
            }
            catch (IOException e) {
                Dialogs.showErrorMessage((String)"Export failed", (Throwable)e);
                return null;
            }
            catch (InterruptedException e) {
                Dialogs.showErrorNotification((String)"Export interrupted", (String)"Measurement export was cancelled");
                logger.warn(e.getMessage(), (Throwable)e);
                return null;
            }
            long endTime = System.currentTimeMillis();
            long timeMillis = endTime - startTime;
            logger.info("Measurements export to {} ({} seconds)", (Object)this.pathOut, (Object)GeneralTools.formatNumber((double)((double)timeMillis / 1000.0), (int)2));
            Dialogs.showInfoNotification((String)MeasurementExportCommand.title, (String)"Export complete!");
            return null;
        }
    }
}

