/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TableView;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.gui.actions.InfoMessage;
import qupath.lib.gui.prefs.SystemMenuBar;
import qupath.ui.logviewer.ui.main.LogMessageCounts;
import qupath.ui.logviewer.ui.main.LogViewer;
import qupath.ui.logviewer.ui.textarea.TextAreaLogViewer;

public class LogViewerCommand {
    private static final Logger logger = LoggerFactory.getLogger(LogViewerCommand.class);
    private Stage dialog = null;
    private Window parent;
    private Region logviewer;
    private LogMessageCounts counts;
    private LongProperty lastSeenErrorMessageCount = new SimpleLongProperty();
    private LongProperty errorMessageCounts = new SimpleLongProperty();
    private NumberBinding unseenMessageCounts = this.errorMessageCounts.subtract((ObservableNumberValue)this.lastSeenErrorMessageCount);
    private BooleanBinding hasUnseenErrors = this.unseenMessageCounts.greaterThan(0);
    private StringBinding errorMessageBinding = this.createErrorMessageBinding();
    private InfoMessage errorMessage = InfoMessage.error((ObservableValue<String>)this.errorMessageBinding, (ObservableNumberValue)this.unseenMessageCounts);
    private ObjectExpression<InfoMessage> infoMessage = Bindings.createObjectBinding(() -> {
        if (!this.hasUnseenErrors.get()) {
            return null;
        }
        return this.errorMessage;
    }, (Observable[])new Observable[]{this.hasUnseenErrors});

    public LogViewerCommand(Window parent) {
        this.parent = parent;
        try {
            LogViewer logviewer = new LogViewer();
            SystemMenuBar.manageChildMenuBar(logviewer.getMenubar());
            this.counts = logviewer.getAllLogsMessageCounts();
            this.errorMessageCounts.bind((ObservableValue)this.counts.errorLevelCountsProperty());
            TableView table = logviewer.getTable();
            table.setFixedCellSize(25.0);
            this.logviewer = logviewer;
        }
        catch (IOException e) {
            this.logviewer = new TextAreaLogViewer();
            logger.error("Failed to create log viewer - using console instead", (Throwable)e);
        }
    }

    public void show() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.show());
            return;
        }
        if (this.dialog == null) {
            this.dialog = new Stage();
            this.dialog.setTitle("Log");
            this.errorMessageCounts.addListener((v, o, n) -> this.updateLastSeenErrors());
            this.dialog.showingProperty().addListener((v, o, n) -> this.updateLastSeenErrors());
            Scene scene = new Scene((Parent)this.logviewer);
            this.dialog.setScene(scene);
            this.dialog.setResizable(true);
            this.dialog.initModality(Modality.NONE);
            this.dialog.initOwner(this.parent);
            this.dialog.setResizable(true);
            this.dialog.show();
            this.dialog.sizeToScene();
            this.dialog.setMinWidth(600.0);
            this.dialog.setMinHeight(400.0);
            FXUtils.retainWindowPosition((Window)this.dialog);
        } else {
            this.dialog.show();
        }
        Region region = this.logviewer;
        if (region instanceof LogViewer) {
            LogViewer lv = (LogViewer)region;
            TableView table = lv.getTable();
            table.scrollTo(table.getItems().size() - 1);
        }
    }

    private StringBinding createErrorMessageBinding() {
        return Bindings.createStringBinding(() -> {
            int value = this.unseenMessageCounts.intValue();
            if (value == 1) {
                return "1 unseen error";
            }
            return value + " unseen errors";
        }, (Observable[])new Observable[]{this.unseenMessageCounts});
    }

    private void updateLastSeenErrors() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.lastSeenErrorMessageCount.set(this.errorMessageCounts.get());
        }
    }

    public LogMessageCounts getLogMessageCounts() {
        return this.counts;
    }

    public ObservableBooleanValue hasUnseenErrors() {
        return this.hasUnseenErrors;
    }

    public ObjectExpression<InfoMessage> getInfoMessage() {
        return this.infoMessage;
    }
}

