/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.scene.control.ButtonType;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.lib.images.ImageData;
import qupath.lib.io.PathIO;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.projects.ProjectImageEntry;

public final class InteractiveObjectImporter {
    private static final Logger logger = LoggerFactory.getLogger(InteractiveObjectImporter.class);
    public static final String MIME_TYPE_GEOJSON = "application/geo+json";

    public static DataFormat getGeoJsonDataFormat() {
        DataFormat df = DataFormat.lookupMimeType((String)MIME_TYPE_GEOJSON);
        if (df == null) {
            df = new DataFormat(new String[]{MIME_TYPE_GEOJSON});
        }
        return df;
    }

    private InteractiveObjectImporter() {
        throw new AssertionError();
    }

    public static boolean promptToImportObjectsProjectEntry(ImageData<BufferedImage> imageData, ProjectImageEntry<?> entry) {
        Objects.requireNonNull(imageData, "Can't import objects - ImageData is null");
        Objects.requireNonNull(entry, "Can't import objects - project entry is null");
        try {
            PathObjectHierarchy hierarchy = entry.readHierarchy();
            ArrayList pathObjects = new ArrayList(hierarchy.getRootObject().getChildObjects());
            if (pathObjects.isEmpty()) {
                logger.warn("No objects found in entry {}", entry);
                return false;
            }
            return InteractiveObjectImporter.promptToImportObjects(imageData.getHierarchy(), pathObjects);
        }
        catch (Exception e) {
            Dialogs.showErrorNotification((String)"Import objects from project", (String)e.getLocalizedMessage());
            return false;
        }
    }

    public static List<PathObject> readObjectsFromClipboard(ImageData<BufferedImage> imageData) throws IOException, JsonSyntaxException, JsonParseException {
        Objects.requireNonNull(imageData, "Can't import objects - ImageData is null");
        Clipboard clipboard = Clipboard.getSystemClipboard();
        String geojson = (String)clipboard.getContent(InteractiveObjectImporter.getGeoJsonDataFormat());
        if (geojson == null) {
            geojson = (String)clipboard.getContent(DataFormat.PLAIN_TEXT);
        }
        if (geojson == null || !geojson.contains("\"feature\"") && !geojson.contains("\"geometry\"")) {
            return Collections.emptyList();
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(geojson.getBytes(StandardCharsets.UTF_8));){
            List list = PathIO.readObjectsFromGeoJSON((InputStream)stream);
            return list;
        }
    }

    public static boolean promptToPasteObjectsFromClipboard(ImageData<BufferedImage> imageData) {
        try {
            List<PathObject> pathObjects = InteractiveObjectImporter.readObjectsFromClipboard(imageData);
            if (pathObjects.isEmpty()) {
                Dialogs.showWarningNotification((String)"Paste objects", (String)"No objects found on the clipboard!");
                return false;
            }
            return InteractiveObjectImporter.promptToImportObjects(imageData.getHierarchy(), pathObjects);
        }
        catch (Exception e) {
            Dialogs.showErrorMessage((String)"Paste objects", (String)("Unable to paste objects: " + e.getLocalizedMessage()));
            return false;
        }
    }

    public static boolean promptToImportObjectsFromFile(ImageData<BufferedImage> imageData, File file) {
        ArrayList pathObjects;
        Objects.requireNonNull(imageData, "Can't import objects - file is null");
        if (file == null) {
            file = FileChoosers.promptForFile((String)"Choose file to import", (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"QuPath objects", (String[])((String[])PathIO.getObjectFileExtensions((boolean)true).toArray(String[]::new)))});
        }
        if (file == null) {
            return false;
        }
        try {
            pathObjects = PathIO.readObjects((File)file);
            Set tmaCores = pathObjects.stream().filter(PathObject::isTMACore).collect(Collectors.toSet());
            if (!tmaCores.isEmpty()) {
                logger.warn("TMA core objects can't be imported - {} will be skipped", (Object)tmaCores.size());
                pathObjects = new ArrayList(pathObjects);
                pathObjects.removeAll(tmaCores);
            }
        }
        catch (IOException | IllegalArgumentException ex) {
            Dialogs.showErrorNotification((String)"Error importing objects", (String)ex.getLocalizedMessage());
            return false;
        }
        if (pathObjects.isEmpty()) {
            Dialogs.showWarningNotification((String)"Import objects from file", (String)("No objects found in " + file.getAbsolutePath()));
            return false;
        }
        return InteractiveObjectImporter.promptToImportObjects(imageData.getHierarchy(), pathObjects);
    }

    public static boolean promptToImportObjects(PathObjectHierarchy hierarchy, Collection<? extends PathObject> pathObjects) {
        Objects.requireNonNull(hierarchy, "Can't import objects - hierarchy is null");
        if (pathObjects.isEmpty()) {
            logger.debug("No objects to import to the hierarchy");
            return false;
        }
        Set flatSet = pathObjects.stream().flatMap(p -> PathObjectTools.getFlattenedObjectList((PathObject)p, null, (!p.isRootObject() ? 1 : 0) != 0).stream()).collect(Collectors.toSet());
        HashSet idSet = flatSet.stream().map(p -> p.getID()).collect(Collectors.toCollection(HashSet::new));
        Set existingIds = hierarchy.getFlattenedObjectList(null).stream().map(p -> p.getID()).collect(Collectors.toSet());
        boolean containsDuplicates = false;
        for (UUID id : idSet) {
            if (!existingIds.contains(id)) continue;
            containsDuplicates = true;
        }
        int nObjects = flatSet.size();
        Object objString = nObjects == 1 ? "1 object" : nObjects + " objects";
        boolean fixDuplicates = false;
        if (containsDuplicates) {
            String message = "Update IDs for the new objects?\n\nThis is strongly recommended to avoid multiple objects having the same ID.\n\nOnly skip this step if you plan to handle duplicate IDs later.";
            ButtonType result = Dialogs.showYesNoCancelDialog((String)("Import " + (String)objString), (String)message);
            if (result == ButtonType.CANCEL) {
                return false;
            }
            fixDuplicates = result == ButtonType.YES;
        } else {
            logger.info("Pasting {} - IDs unchanged (no duplicates)", objString);
        }
        if (fixDuplicates) {
            for (PathObject toAdd : flatSet) {
                toAdd.refreshID();
            }
        } else if (containsDuplicates) {
            logger.warn("{} being added - IDs not updated, so there will be duplicates!", objString);
        }
        hierarchy.addObjects(pathObjects);
        return true;
    }
}

