/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javafx.stage.FileChooser;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.io.PathIO;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.Workflow;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.scripting.QP;

public final class ExportObjectsCommand {
    private static final String COMPRESS_NONE = "None";
    private static final String COMPRESS_ZIP = "ZIP";
    private static final String COMPRESS_GZIP = "gzip";

    private ExportObjectsCommand() {
        throw new AssertionError();
    }

    public static boolean runGeoJsonExport(QuPathGUI qupath) throws IOException {
        String comp;
        File defaultDirectory;
        ProjectImageEntry entry;
        List<PathObject> toProcess;
        ImageData<BufferedImage> imageData = qupath.getImageData();
        if (imageData == null) {
            return false;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        String allObjects = "All objects";
        String selectedObjects = "Selected objects";
        String defaultObjects = hierarchy.getSelectionModel().noSelection() ? allObjects : selectedObjects;
        ParameterList parameterList = new ParameterList().addChoiceParameter("exportOptions", "Export ", (Object)defaultObjects, Arrays.asList(allObjects, selectedObjects), "Choose which objects to export - run a 'Select annotations/detections' command first if needed").addBooleanParameter("excludeMeasurements", "Exclude measurements", false, "Exclude object measurements during export - for large numbers of detections this can help reduce the file size").addBooleanParameter("doPretty", "Pretty JSON", false, "Pretty GeoJSON is more human-readable but results in larger file sizes").addBooleanParameter("doFeatureCollection", "Export as FeatureCollection", true, "Export as a 'FeatureCollection', which is a standard GeoJSON way to represent multiple objects; if not, a regular JSON object/array will be export").addChoiceParameter("compression", "Compression", (Object)COMPRESS_NONE, List.of(COMPRESS_NONE, COMPRESS_ZIP, COMPRESS_GZIP));
        if (!GuiTools.showParameterDialog("Export objects", parameterList)) {
            return false;
        }
        Object comboChoice = parameterList.getChoiceParameterValue("exportOptions");
        if (comboChoice.equals("Selected objects")) {
            if (hierarchy.getSelectionModel().noSelection()) {
                Dialogs.showErrorMessage((String)"No selection", (String)"No selection detected!");
                return false;
            }
            toProcess = hierarchy.getSelectionModel().getSelectedObjects();
        } else {
            toProcess = hierarchy.getObjects(null, null);
        }
        toProcess = toProcess.stream().filter(e -> !e.isRootObject()).toList();
        Project<BufferedImage> project = qupath.getProject();
        String defaultName = imageData.getServerMetadata().getName();
        if (project != null && (entry = project.getEntry(imageData)) != null) {
            defaultName = entry.getImageName();
        }
        defaultName = GeneralTools.stripExtension((String)defaultName);
        File file = defaultDirectory = project == null || project.getPath() == null ? null : project.getPath().toFile();
        while (defaultDirectory != null && !defaultDirectory.isDirectory()) {
            defaultDirectory = defaultDirectory.getParentFile();
        }
        File defaultFile = new File(defaultDirectory, defaultName);
        File outFile = switch (comp = (String)parameterList.getChoiceParameterValue("compression")) {
            case COMPRESS_ZIP -> FileChoosers.promptToSaveFile((String)"Export to file", (File)defaultFile, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"ZIP archive", (String[])new String[]{".zip"})});
            case COMPRESS_GZIP -> FileChoosers.promptToSaveFile((String)"Export to file", (File)defaultFile, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"gzip archive", (String[])new String[]{".geojson.gz"})});
            default -> FileChoosers.promptToSaveFile((String)"Export to file", (File)defaultFile, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"GeoJSON", (String[])new String[]{".geojson"})});
        };
        if (outFile == null) {
            return false;
        }
        ArrayList<PathIO.GeoJsonExportOptions> options = new ArrayList<PathIO.GeoJsonExportOptions>();
        if (parameterList.getBooleanParameterValue("excludeMeasurements").booleanValue()) {
            options.add(PathIO.GeoJsonExportOptions.EXCLUDE_MEASUREMENTS);
        }
        if (parameterList.getBooleanParameterValue("doPretty").booleanValue()) {
            options.add(PathIO.GeoJsonExportOptions.PRETTY_JSON);
        }
        if (parameterList.getBooleanParameterValue("doFeatureCollection").booleanValue()) {
            options.add(PathIO.GeoJsonExportOptions.FEATURE_COLLECTION);
        }
        QP.exportObjectsToGeoJson(toProcess, (String)outFile.getAbsolutePath(), (PathIO.GeoJsonExportOptions[])((PathIO.GeoJsonExportOptions[])options.toArray(PathIO.GeoJsonExportOptions[]::new)));
        int nObjects = toProcess.size();
        String message = nObjects == 1 ? "1 object was exported to " + outFile.getAbsolutePath() : String.format("%d objects were exported to %s", nObjects, outFile.getAbsolutePath());
        Dialogs.showInfoNotification((String)"Succesful export", (String)message);
        Workflow historyWorkflow = imageData.getHistoryWorkflow();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("path", outFile.getPath());
        String method = comboChoice.equals(allObjects) ? "exportAllObjectsToGeoJson" : "exportSelectedObjectsToGeoJson";
        String methodTitle = comboChoice.equals(allObjects) ? "Export all objects" : "Export selected objects";
        Object optionsString = options.stream().map(o -> "\"" + o.name() + "\"").collect(Collectors.joining(", "));
        map.put("options", (String)optionsString);
        if (!((String)optionsString).isEmpty()) {
            optionsString = ", " + (String)optionsString;
        }
        String methodString = String.format("%s(%s%s)", method, "\"" + GeneralTools.escapeFilePath((String)outFile.getPath()) + "\"", optionsString);
        historyWorkflow.addStep((WorkflowStep)new DefaultScriptableWorkflowStep(methodTitle, map, methodString));
        return true;
    }
}

