/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.util.Arrays;
import java.util.function.Predicate;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.dialogs.ParameterPanelFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.scripting.QP;

public class DeleteObjectsOnBoundsCommand {
    private static final Logger logger = LoggerFactory.getLogger(DeleteObjectsOnBoundsCommand.class);
    private static final String title = "Remove on bounds";
    private final QuPathGUI qupath;
    private ObjectType typeToRemove = ObjectType.ANY_OBJECTS;
    private boolean childObjectsOnly = true;

    public DeleteObjectsOnBoundsCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    public void runForImage(ImageData<?> imageData) {
        DefaultScriptableWorkflowStep step;
        PathObjectFilter filter;
        if (imageData == null) {
            GuiTools.showNoImageError(title);
            return;
        }
        if (imageData.getHierarchy().getSelectionModel().noSelection()) {
            Dialogs.showErrorMessage((String)title, (String)"No objects are selected!");
            return;
        }
        ParameterList params = new ParameterList().addChoiceParameter("objectType", "Type of objects to remove", (Object)this.typeToRemove, Arrays.asList(ObjectType.values()), "Specify which type of objects to remove").addBooleanParameter("childObjectsOnly", "Child objects only", this.childObjectsOnly, "Only remove direct child objects of the selected objects.\nThis is typically used to remove objects (e.g. cells) that touch the bounds\nof their parent object in which they were detected.");
        ButtonType result = Dialogs.builder().owner((Window)this.qupath.getStage()).title(title).content((Node)new ParameterPanelFX(params).getPane()).buttons(new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL}).showAndWait().orElse(ButtonType.CANCEL);
        if (!ButtonType.APPLY.equals(result)) {
            return;
        }
        this.typeToRemove = (ObjectType)((Object)params.getChoiceParameterValue("objectType"));
        this.childObjectsOnly = params.getBooleanParameterValue("childObjectsOnly");
        switch (this.typeToRemove.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 1: {
                PathObjectFilter pathObjectFilter = PathObjectFilter.ANNOTATIONS;
                break;
            }
            case 2: {
                PathObjectFilter pathObjectFilter = PathObjectFilter.DETECTIONS_ALL;
                break;
            }
            case 0: {
                PathObjectFilter pathObjectFilter = filter = null;
            }
        }
        if (this.childObjectsOnly) {
            QP.removeChildObjectsTouchingSelectedBounds((PathObjectHierarchy)imageData.getHierarchy(), (Predicate)filter);
            step = filter == null ? new DefaultScriptableWorkflowStep("Delete child objects on bounds", "removeChildObjectsTouchingSelectedBounds()") : new DefaultScriptableWorkflowStep("Delete child objects on bounds", "removeChildObjectsTouchingSelectedBounds(PathObjectFilter." + filter.name() + ")");
        } else {
            QP.removeObjectsTouchingSelectedBounds((PathObjectHierarchy)imageData.getHierarchy(), (Predicate)filter);
            step = filter == null ? new DefaultScriptableWorkflowStep("Delete objects on bounds", "removeObjectsTouchingSelectedBounds()") : new DefaultScriptableWorkflowStep("Delete objects on bounds", "removeObjectsTouchingSelectedBounds(PathObjectFilter." + filter.name() + ")");
        }
        imageData.getHistoryWorkflow().addStep((WorkflowStep)step);
    }

    private static enum ObjectType {
        ANY_OBJECTS,
        ANNOTATIONS,
        DETECTIONS;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Any objects";
                case 1 -> "Annotations";
                case 2 -> "Detections";
            };
        }
    }
}

