/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.geom.Point2;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.PathObjectLabels;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionListener;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionModel;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.PointsROI;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.interfaces.ROI;

class CountingPane
implements PathObjectSelectionListener,
PathObjectHierarchyListener {
    private QuPathGUI qupath;
    private BorderPane pane = new BorderPane();
    private PathObjectHierarchy hierarchy;
    private ListView<PathObject> listCounts;
    private Action btnAdd = new Action("Add", e -> {
        PathObject pathObjectCounts = PathObjects.createAnnotationObject((ROI)ROIs.createPointsROI((ImagePlane)ImagePlane.getDefaultPlane()));
        this.hierarchy.addObject(pathObjectCounts);
        this.hierarchy.getSelectionModel().setSelectedObject(pathObjectCounts);
    });
    private Action btnEdit = new Action("Edit", e -> this.promptToSetProperties());
    private Action btnDelete = new Action("Delete", e -> {
        PathObject pathObjectSelected = (PathObject)this.listCounts.getSelectionModel().getSelectedItem();
        if (pathObjectSelected != null && PathObjectTools.hasPointROI((PathObject)pathObjectSelected)) {
            GuiTools.promptToRemoveSelectedObject(pathObjectSelected, this.hierarchy);
        }
    });
    private Action btnCreateForClasses = new Action("Create points for all classes", e -> {
        QuPathViewer viewer = this.qupath.getViewer();
        PathObjectHierarchy hierarchy = viewer.getHierarchy();
        List<PathClass> availableClasses = this.qupath.getAvailablePathClasses().stream().filter(p -> p != null && p != PathClass.NULL_CLASS).toList();
        if (hierarchy == null || availableClasses.isEmpty()) {
            return;
        }
        ImagePlane plane = viewer.getImagePlane();
        ArrayList<PathObject> pathObjects = new ArrayList<PathObject>();
        for (PathClass pathClass : availableClasses) {
            pathObjects.add(PathObjects.createAnnotationObject((ROI)ROIs.createPointsROI((ImagePlane)plane), (PathClass)pathClass));
        }
        hierarchy.addObjects(pathObjects);
    });

    public CountingPane(QuPathGUI qupath, PathObjectHierarchy hierarchy) {
        this.qupath = qupath;
        this.listCounts = new ListView();
        this.setHierarchy(hierarchy);
        this.listCounts.getSelectionModel().selectedItemProperty().addListener((e, oldSelection, selectedObject) -> this.updateSelectedObjectFromList((PathObject)selectedObject));
        GridPane paneMainButtons = GridPaneUtils.createColumnGridControls((Node[])new Node[]{ActionUtils.createButton((Action)this.btnAdd), ActionUtils.createButton((Action)this.btnEdit), ActionUtils.createButton((Action)this.btnDelete)});
        ContextMenu popup = new ContextMenu();
        popup.getItems().add((Object)ActionUtils.createMenuItem((Action)this.btnCreateForClasses));
        BorderPane paneButtons = new BorderPane((Node)paneMainButtons);
        Button btnMore = GuiTools.createMoreButton(popup, Side.RIGHT);
        paneButtons.setRight((Node)btnMore);
        this.listCounts.setOnMouseClicked(e -> {
            if (e.getClickCount() > 1) {
                this.promptToSetProperties();
            }
        });
        ContextMenu menu = new ContextMenu();
        Menu menuSetClass = new Menu("Set classification");
        menu.setOnShowing(e -> menuSetClass.getItems().setAll(qupath.getAvailablePathClasses().stream().map(p -> this.createPathClassMenuItem((PathClass)p)).toList()));
        MenuItem miCopy = new MenuItem("Copy to clipboard");
        miCopy.setOnAction(e -> CountingPane.copyCoordinatesToClipboard((PathObject)this.listCounts.getSelectionModel().getSelectedItem()));
        miCopy.disableProperty().bind((ObservableValue)this.listCounts.getSelectionModel().selectedItemProperty().isNull());
        menuSetClass.disableProperty().bind((ObservableValue)this.listCounts.getSelectionModel().selectedItemProperty().isNull());
        menu.getItems().addAll((Object[])new MenuItem[]{menuSetClass, miCopy});
        this.listCounts.setContextMenu(menu);
        this.listCounts.setCellFactory(v -> PathObjectLabels.createListCell(p -> p.toString().replace(" (Points)", "")));
        PathPrefs.colorDefaultObjectsProperty().addListener((v, o, n) -> this.listCounts.refresh());
        BorderPane panelList = new BorderPane();
        panelList.setCenter(this.listCounts);
        panelList.setBottom((Node)paneButtons);
        this.pane.setCenter((Node)panelList);
    }

    MenuItem createPathClassMenuItem(PathClass pathClass) {
        MenuItem mi = new MenuItem(pathClass.toString());
        mi.setMnemonicParsing(false);
        Integer color = pathClass.getColor();
        Rectangle rect = new Rectangle(8.0, 8.0, (Paint)(color == null ? ColorToolsFX.TRANSLUCENT_WHITE_FX : ColorToolsFX.getCachedColor(color)));
        mi.setGraphic((Node)rect);
        mi.setOnAction(e -> {
            PathObject pathObject = (PathObject)this.listCounts.getSelectionModel().getSelectedItem();
            if (pathClass == PathClass.NULL_CLASS) {
                pathObject.resetPathClass();
            } else {
                pathObject.setPathClass(pathClass);
            }
            if (this.hierarchy != null) {
                this.hierarchy.fireObjectClassificationsChangedEvent((Object)mi, Collections.singleton(pathObject));
            }
        });
        return mi;
    }

    public Pane getPane() {
        return this.pane;
    }

    public ListView<PathObject> getListView() {
        return this.listCounts;
    }

    public List<PathObject> getPathObjects() {
        return new ArrayList<PathObject>((Collection<PathObject>)this.listCounts.getItems());
    }

    public void setHierarchy(PathObjectHierarchy hierarchy) {
        if (this.hierarchy == hierarchy) {
            return;
        }
        if (this.hierarchy != null) {
            this.hierarchy.getSelectionModel().removePathObjectSelectionListener((PathObjectSelectionListener)this);
            this.hierarchy.removeListener((PathObjectHierarchyListener)this);
        }
        this.hierarchy = hierarchy;
        PathObject objectSelected = null;
        if (this.hierarchy != null) {
            PathObjectSelectionModel model = this.hierarchy.getSelectionModel();
            model.addPathObjectSelectionListener((PathObjectSelectionListener)this);
            objectSelected = model.getSelectedObject();
            this.hierarchy.addListener((PathObjectHierarchyListener)this);
        }
        if (objectSelected != null && PathObjectTools.hasPointROI(objectSelected)) {
            this.listCounts.getSelectionModel().select((Object)objectSelected);
        } else {
            this.listCounts.getSelectionModel().clearSelection();
        }
        this.hierarchyChanged(null);
    }

    public static void copyCoordinatesToClipboard(PathObject pathObject) {
        if (pathObject == null || !pathObject.hasROI() || !(pathObject.getROI() instanceof PointsROI)) {
            Dialogs.showErrorMessage((String)"Copy points to clipboard", (String)"No points selected!");
            return;
        }
        StringBuilder sb = new StringBuilder();
        String name = pathObject.getDisplayedName();
        PointsROI points = (PointsROI)pathObject.getROI();
        for (Point2 p : points.getAllPoints()) {
            sb.append(name).append("\t").append(p.getX()).append("\t").append(p.getY()).append("\n");
        }
        StringSelection stringSelection = new StringSelection(sb.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public void selectedPathObjectChanged(PathObject pathObjectSelected, PathObject previousObject, Collection<PathObject> allSelected) {
        boolean hasPoints = pathObjectSelected != null && PathObjectTools.hasPointROI((PathObject)pathObjectSelected);
        this.btnEdit.setDisabled(!hasPoints);
        this.btnDelete.setDisabled(!hasPoints);
        if (pathObjectSelected == this.listCounts.getSelectionModel().getSelectedItem()) {
            return;
        }
        if (pathObjectSelected != null && PathObjectTools.hasPointROI((PathObject)pathObjectSelected)) {
            this.listCounts.getSelectionModel().select((Object)pathObjectSelected);
        } else {
            this.listCounts.getSelectionModel().clearSelection();
        }
    }

    private void promptToSetProperties() {
        PathObject pathObjectSelected = (PathObject)this.listCounts.getSelectionModel().getSelectedItem();
        if (pathObjectSelected != null && PathObjectTools.hasPointROI((PathObject)pathObjectSelected)) {
            GuiTools.promptToSetActiveAnnotationProperties(this.hierarchy);
        }
    }

    private void updateSelectedObjectFromList(PathObject selectedObject) {
        if (selectedObject == null || this.hierarchy == null || this.hierarchy.getSelectionModel().getSelectedObject() == selectedObject) {
            return;
        }
        this.hierarchy.getSelectionModel().setSelectedObject(selectedObject);
    }

    public void hierarchyChanged(PathObjectHierarchyEvent event) {
        if (this.hierarchy == null) {
            this.listCounts.getItems().clear();
            return;
        }
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.hierarchyChanged(event));
            return;
        }
        Collection newList = this.hierarchy.getAllPointAnnotations();
        ObservableList items = this.listCounts.getItems();
        if (items.size() == newList.size() && (newList.equals(items) || newList.containsAll((Collection<?>)items))) {
            this.listCounts.refresh();
        } else {
            this.listCounts.getItems().setAll(newList);
        }
        this.selectedPathObjectChanged(this.hierarchy.getSelectionModel().getSelectedObject(), null, this.hierarchy.getSelectionModel().getSelectedObjects());
    }
}

