/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.ToolManager;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.OverlayActions;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.commands.CountingPane;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.tools.PathTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.io.PointIO;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;

public class CountingDialogCommand
implements Runnable,
ChangeListener<ImageData<BufferedImage>> {
    private static final Logger logger = LoggerFactory.getLogger(CountingDialogCommand.class);
    private QuPathGUI qupath;
    private PathObjectHierarchy hierarchy;
    private CountingPane countingPane = null;
    private Stage dialog;
    private Slider sliderRadius;
    private Button btnLoad;
    private Button btnSave;
    private String savingOption = "Selected points";

    public CountingDialogCommand(QuPathGUI qupath) {
        this.qupath = qupath;
        qupath.imageDataProperty().addListener((ChangeListener)this);
        this.changed((ObservableValue<? extends ImageData<BufferedImage>>)qupath.imageDataProperty(), null, qupath.getImageData());
    }

    private ToolBar makeToolbarButtons() {
        if (this.qupath == null) {
            return null;
        }
        OverlayActions overlayActions = this.qupath.getOverlayActions();
        ToolBar toolbar = new ToolBar();
        toolbar.getItems().addAll((Object[])new Node[]{ActionTools.createToggleButtonWithGraphicOnly(this.qupath.getToolManager().getToolAction(PathTools.MOVE)), ActionTools.createToggleButtonWithGraphicOnly(this.qupath.getToolManager().getToolAction(PathTools.POINTS)), new Separator(Orientation.VERTICAL), ActionTools.createToggleButtonWithGraphicOnly(overlayActions.SHOW_ANNOTATIONS), ActionTools.createToggleButtonWithGraphicOnly(overlayActions.FILL_DETECTIONS), ActionTools.createToggleButtonWithGraphicOnly(overlayActions.SHOW_GRID)});
        return toolbar;
    }

    private Pane makeButtonPanel() {
        if (this.qupath == null) {
            return null;
        }
        VBox panel = new VBox();
        panel.setSpacing(10.0);
        this.sliderRadius = new Slider(1.0, 100.0, (double)PathPrefs.pointRadiusProperty().get());
        this.sliderRadius.valueProperty().addListener(event -> {
            PathPrefs.pointRadiusProperty().set((int)this.sliderRadius.getValue());
            this.qupath.getViewer().repaint();
        });
        BorderPane sliderPane = new BorderPane();
        sliderPane.setLeft((Node)new Label("Point size"));
        sliderPane.setCenter((Node)this.sliderRadius);
        this.btnLoad = new Button("Load points");
        this.btnLoad.setOnAction(event -> {
            if (this.hierarchy == null) {
                return;
            }
            File file = FileChoosers.promptForFile((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"TSV (Tab delimited)", (String[])new String[]{"*.tsv"})});
            if (file == null) {
                return;
            }
            try {
                List pointsList = null;
                if (file.toPath().toString().endsWith(".zip")) {
                    pointsList = PointIO.readPointsObjectList((File)file);
                } else if (file.toPath().toString().endsWith(".tsv")) {
                    pointsList = PointIO.readPoints((File)file);
                }
                if (pointsList != null) {
                    for (PathObject points : pointsList) {
                        this.hierarchy.addObject(points);
                    }
                }
            }
            catch (IOException e) {
                Dialogs.showErrorMessage((String)"Load points error", (Throwable)e);
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
        this.btnSave = new Button("Save points");
        this.btnSave.setOnAction(event -> {
            if (this.countingPane == null) {
                return;
            }
            ListView<PathObject> listView = this.countingPane.getListView();
            ObservableList selection = listView.getSelectionModel().getSelectedItems();
            ObservableList pointsList = this.countingPane.getPathObjects();
            if (!selection.isEmpty()) {
                ArrayList<String> choiceList = new ArrayList<String>();
                choiceList.addAll(Arrays.asList("All point annotations", "Selected objects"));
                String choice = (String)Dialogs.showChoiceDialog((String)"Save points", (String)"Choose point annotations to save", Arrays.asList("All points", "Selected points"), (Object)this.savingOption);
                if (choice == null) {
                    return;
                }
                if (choice.equals("Selected points")) {
                    pointsList = selection;
                }
                this.savingOption = choice;
            }
            if (pointsList.isEmpty()) {
                Dialogs.showErrorMessage((String)"Save points", (String)"No points available!");
                return;
            }
            File defaultName = null;
            try {
                String name = ServerTools.getDisplayableImageName(this.qupath.getViewer().getServer()) + "-points.tsv";
                defaultName = new File(name);
            }
            catch (Exception name) {
                // empty catch block
            }
            File file = FileChoosers.promptToSaveFile(null, (File)defaultName, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"TSV (Tab delimited)", (String[])new String[]{"tsv"})});
            if (file == null) {
                return;
            }
            try {
                PointIO.writePoints((File)file, pointsList);
            }
            catch (IOException e) {
                Dialogs.showErrorMessage((String)"Save points error", (Throwable)e);
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
        GridPane panelLoadSave = GridPaneUtils.createColumnGridControls((Node[])new Node[]{this.btnLoad, this.btnSave});
        Label labelDelete = new Label("Delete individual points by clicking on them with the 'Alt' key pressed");
        labelDelete.setWrapText(true);
        labelDelete.setMaxHeight(Double.MAX_VALUE);
        labelDelete.prefWidthProperty().bind((ObservableValue)panel.widthProperty().subtract(10));
        labelDelete.setContentDisplay(ContentDisplay.CENTER);
        labelDelete.setStyle("-fx-font-style: italic; -fx-opacity: 0.8;");
        labelDelete.setTextAlignment(TextAlignment.CENTER);
        Action actionConvexPoints = ActionTools.createSelectableAction((ObservableValue<Boolean>)PathPrefs.showPointHullsProperty(), "Show point convex hull");
        Action actionSelectedColor = ActionTools.createSelectableAction((ObservableValue<Boolean>)PathPrefs.useSelectedColorProperty(), "Highlight selected objects by color");
        Action actionDetectionsToPoints = this.qupath.createImageDataAction(imageData -> Commands.convertDetectionsToPoints(imageData, true));
        actionDetectionsToPoints.setText("Convert detections to points");
        Button btnConvert = ActionTools.createButton(actionDetectionsToPoints);
        Pane convertPane = new Pane(new Node[]{btnConvert});
        btnConvert.prefWidthProperty().bind((ObservableValue)convertPane.widthProperty());
        CheckBox cbConvex = ActionTools.createCheckBox(actionConvexPoints);
        CheckBox cbSelected = ActionTools.createCheckBox(actionSelectedColor);
        panel.getChildren().addAll((Object[])new Node[]{cbConvex, cbSelected, sliderPane, convertPane, panelLoadSave, labelDelete});
        return panel;
    }

    private void attemptToSelectPoints() {
        if (this.hierarchy == null || this.countingPane == null) {
            return;
        }
        logger.trace("Attempting to select");
        PathObject pathObjectSelected = this.hierarchy.getSelectionModel().getSelectedObject();
        if (pathObjectSelected == null || !PathObjectTools.hasPointROI((PathObject)pathObjectSelected)) {
            List<PathObject> pointObjects = this.countingPane.getPathObjects();
            if (pointObjects.isEmpty()) {
                this.hierarchy.getSelectionModel().setSelectedObject(null);
            } else {
                this.hierarchy.getSelectionModel().setSelectedObject(pointObjects.get(0));
            }
        }
    }

    @Override
    public void run() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.run());
            return;
        }
        ToolManager toolManager = this.qupath.getToolManager();
        if (this.dialog != null) {
            if (toolManager.getSelectedTool() != PathTools.POINTS) {
                toolManager.setSelectedTool(PathTools.POINTS);
            }
            this.attemptToSelectPoints();
            if (!this.dialog.isShowing()) {
                this.dialog.show();
            }
            return;
        }
        this.dialog = new Stage();
        this.dialog.setTitle("Points");
        FXUtils.addCloseWindowShortcuts((Stage)this.dialog);
        this.countingPane = new CountingPane(this.qupath, this.hierarchy);
        BorderPane pane = new BorderPane();
        ToolBar toolbar = this.makeToolbarButtons();
        if (toolbar != null) {
            pane.setTop((Node)toolbar);
        }
        pane.setCenter((Node)this.countingPane.getPane());
        Pane panelButtons = this.makeButtonPanel();
        panelButtons.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        if (panelButtons != null) {
            pane.setBottom((Node)panelButtons);
        }
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Scene scene = new Scene((Parent)pane, 300.0, 450.0);
        this.dialog.setScene(scene);
        this.dialog.setOnCloseRequest(e -> toolManager.setSelectedTool(PathTools.MOVE));
        if (toolManager.getSelectedTool() != PathTools.POINTS) {
            toolManager.setSelectedTool(PathTools.POINTS);
        }
        this.attemptToSelectPoints();
        this.dialog.initModality(Modality.NONE);
        this.dialog.setResizable(true);
        this.dialog.initOwner((Window)this.qupath.getStage());
        this.dialog.show();
    }

    public void changed(ObservableValue<? extends ImageData<BufferedImage>> manager, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        PathObjectHierarchy pathObjectHierarchy = this.hierarchy = imageDataNew == null ? null : imageDataNew.getHierarchy();
        if (this.countingPane != null) {
            this.countingPane.setHierarchy(this.hierarchy);
            if (this.dialog != null && this.dialog.isShowing()) {
                this.attemptToSelectPoints();
            }
        }
    }
}

