/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.LongBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.Window;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.display.ImageDisplay;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.InfoMessage;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.classes.PathClass;

public class ContextHelpViewer {
    private static Map<QuPathGUI, ContextHelpViewer> INSTANCES = new ConcurrentHashMap<QuPathGUI, ContextHelpViewer>();
    private StringProperty title;
    private QuPathGUI qupath;
    private int iconSize;
    private Stage stage;
    private ObservableList<Window> windows;
    private EventHandler<MouseEvent> handler;
    private StringProperty defaultText;
    private StringProperty helpText;
    private Label label;
    private Node lastNode;
    private VBox vbox;
    private ObservableList<HelpListEntry> allHelpEntries;
    private LongBinding warningCount;
    private LongBinding infoCount;
    private BooleanBinding hasWarnings;
    private BooleanBinding hasInfo;
    private InfoMessage warningMessage;
    private InfoMessage infoMessage;
    private ObjectExpression<InfoMessage> infoOrWarningMessage;
    private ObjectProperty<ImageData<?>> imageDataProperty;
    private PropertyChangeListener imageDataPropertyChange;
    private ObjectProperty<PixelCalibration> currentPixelSize;
    private BooleanBinding pixelCalibrationUnset;
    private static Set<Double> typicalDpiPixelSizes = Set.of(Integer.valueOf(72), Integer.valueOf(96), Integer.valueOf(120), Integer.valueOf(144), Integer.valueOf(300)).stream().map(ContextHelpViewer::dpiToMicrons).collect(Collectors.toSet());
    private BooleanBinding pixelSizeLikelyDpi;
    private ObjectProperty<ImageData.ImageType> currentImageType;
    private BooleanBinding imageTypeUnset;
    private BooleanProperty largeNonPyramidalImage;
    private BooleanProperty classificationAndDefaultObjectColorsSimilar;

    private static double dpiToMicrons(double dpi) {
        return 25400.0 / dpi;
    }

    /*
     * Exception decompiling
     */
    private ContextHelpViewer(QuPathGUI qupath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void imageDataChanged(ObservableValue<? extends ImageData<?>> observable, ImageData<?> oldValue, ImageData<?> newValue) {
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.imageDataPropertyChange);
        }
        if (newValue != null) {
            newValue.addPropertyChangeListener(this.imageDataPropertyChange);
            this.currentPixelSize.set((Object)newValue.getServer().getPixelCalibration());
            this.currentImageType.set((Object)newValue.getImageType());
        } else {
            this.currentPixelSize.set(null);
            this.currentImageType.set(null);
        }
        this.updateLargeNonPyramidalProperty();
    }

    private void imageDataPropertyChange(PropertyChangeEvent evt) {
        ImageData imageData = (ImageData)this.imageDataProperty.get();
        if (imageData != null) {
            this.currentPixelSize.set((Object)imageData.getServer().getPixelCalibration());
            this.currentImageType.set((Object)imageData.getImageType());
        }
    }

    private void updateSimilarClassificationColors() {
        ObservableList<PathClass> pathClasses = this.qupath.getAvailablePathClasses();
        IntegerProperty defaultColor = PathPrefs.colorDefaultObjectsProperty();
        for (PathClass pathClass : pathClasses) {
            if (!ContextHelpViewer.similarColors(pathClass.getColor(), defaultColor.get())) continue;
            this.classificationAndDefaultObjectColorsSimilar.set(true);
            return;
        }
        this.classificationAndDefaultObjectColorsSimilar.set(false);
    }

    private static boolean similarColors(Integer rgba1, Integer rgba2) {
        if (rgba1 == null || rgba2 == null) {
            return false;
        }
        double tol = 10.0;
        if ((double)Math.abs(ColorTools.red((int)rgba1) - ColorTools.red((int)rgba2)) > tol) {
            return false;
        }
        if ((double)Math.abs(ColorTools.green((int)rgba1) - ColorTools.green((int)rgba2)) > tol) {
            return false;
        }
        return !((double)Math.abs(ColorTools.blue((int)rgba1) - ColorTools.blue((int)rgba2)) > tol);
    }

    private void updateLargeNonPyramidalProperty() {
        ImageData imageData = (ImageData)this.imageDataProperty.get();
        if (imageData == null) {
            this.largeNonPyramidalImage.set(false);
        } else {
            ImageServer server = imageData.getServer();
            if (server.nResolutions() == 1 && Math.max(server.getWidth(), server.getHeight()) > 10000) {
                this.largeNonPyramidalImage.set(true);
            } else {
                this.largeNonPyramidalImage.set(false);
            }
        }
    }

    private void initializeWindowListeners() {
        this.windows = Window.getWindows().filtered(this::filterWindows);
        for (Window w : this.windows) {
            this.addMouseListener(w);
        }
        this.windows.addListener(this::handleWindowChange);
    }

    private Stage createStage(Scene scene) {
        Stage stage = new Stage();
        stage.initOwner((Window)this.qupath.getStage());
        stage.setResizable(true);
        stage.titleProperty().bind((ObservableValue)this.title);
        stage.setWidth(300.0);
        stage.setHeight(400.0);
        stage.setScene(scene);
        FXUtils.addCloseWindowShortcuts((Stage)stage);
        return stage;
    }

    private void createHelpLabels() {
        for (HelpListEntry entry : this.createHelpEntries()) {
            this.allHelpEntries.add((Object)entry);
            this.createHelpLabel(entry);
        }
    }

    private List<HelpListEntry> createHelpEntries() {
        return Arrays.asList(this.createUnseenErrors(), this.createLargeNonPyramidal(), this.createPixelSizeMissing(), this.createPixelSizeLikelyDpi(), this.createImageTypeMissing(), this.createMaskImageNames(), this.createSelectionModelEntry(), this.createAnnotationsHiddenEntry(), this.createDetectionsHiddenEntry(), this.createPixelClassificationOverlayHiddenEntry(), this.createTMAGridHiddenEntry(), this.createHiddenObjectsPredicate(), this.createHiddenClassificationsEntry(), this.createNoImageEntry(), this.createNoProjectEntry(), this.createOpacityZeroEntry(), this.createGammaNotDefault(), this.createInvertedColors(), this.createGreyscaleColors(), this.createNoChannelsVisible(), this.createColorsTooSimilar());
    }

    public ObjectExpression<InfoMessage> getInfoMessage() {
        return this.infoOrWarningMessage;
    }

    private Label createHelpTextLabel() {
        Label label = new Label();
        label.setContentDisplay(ContentDisplay.CENTER);
        label.setAlignment(Pos.CENTER);
        label.setTextAlignment(TextAlignment.CENTER);
        label.setWrapText(true);
        label.textProperty().bindBidirectional((Property)this.helpText);
        label.setPadding(new Insets(10.0));
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{label});
        GridPaneUtils.setToExpandGridPaneHeight((Node[])new Node[]{label});
        label.setPrefHeight(100.0);
        return label;
    }

    private boolean filterWindows(Window window) {
        if (window == this.stage) {
            return false;
        }
        Stage mainStage = this.qupath.getStage();
        if (window == mainStage) {
            return true;
        }
        return window instanceof Stage && ((Stage)window).getOwner() == mainStage;
    }

    public static ContextHelpViewer getInstance(QuPathGUI qupath) {
        return INSTANCES.computeIfAbsent(qupath, ContextHelpViewer::new);
    }

    public Stage getStage() {
        return this.stage;
    }

    private void handleWindowChange(ListChangeListener.Change<? extends Window> change) {
        while (change.next()) {
            for (Window window : change.getRemoved()) {
                this.addMouseListener(window);
            }
            for (Window window : change.getAddedSubList()) {
                this.removeMouseListener(window);
            }
        }
    }

    private void addMouseListener(Window window) {
        window.addEventFilter(MouseEvent.MOUSE_MOVED, this.handler);
    }

    private void removeMouseListener(Window window) {
        window.addEventFilter(MouseEvent.MOUSE_MOVED, this.handler);
    }

    private void handleMouseMove(MouseEvent event) {
        if (!this.stage.isShowing()) {
            this.lastNode = null;
            return;
        }
        PickResult result = event.getPickResult();
        Node node = result.getIntersectedNode();
        if (node == this.lastNode) {
            return;
        }
        this.lastNode = node;
        String help = ContextHelpViewer.findHelpText(event, node);
        if (help == null || help.isEmpty()) {
            this.helpText.bind((ObservableValue)this.defaultText);
            this.label.setOpacity(0.5);
        } else {
            this.helpText.unbind();
            this.helpText.set((Object)help);
            this.label.setOpacity(1.0);
        }
    }

    private static String findHelpText(MouseEvent event, Node node) {
        Point2D local;
        if (node == null) {
            return null;
        }
        String help = ContextHelpViewer.getHelpOrTooltipText(node);
        if (help != null && !help.isBlank() && node.isVisible() && node.contains(local = node.screenToLocal(event.getScreenX(), event.getScreenY()))) {
            return help;
        }
        return ContextHelpViewer.findHelpText(event, (Node)node.getParent());
    }

    private static String getHelpOrTooltipText(Node node) {
        if (node == null) {
            return null;
        }
        String help = node.getAccessibleHelp();
        if (help != null) {
            return help;
        }
        return ContextHelpViewer.getTooltipText(node);
    }

    private static String getTooltipText(Node node) {
        Tooltip tooltip = ContextHelpViewer.tryToGetTooltip(node);
        if (tooltip != null) {
            return tooltip.getText();
        }
        return null;
    }

    private static Tooltip tryToGetTooltip(Node node) {
        Control control;
        Tooltip tt;
        if (node instanceof Control && (tt = (control = (Control)node).getTooltip()) != null) {
            return tt;
        }
        Object tooltip = node.getProperties().get((Object)"javafx.scene.control.Tooltip");
        if (tooltip instanceof Tooltip) {
            tt = (Tooltip)tooltip;
            return tt;
        }
        return null;
    }

    Label createHelpLabel(HelpListEntry entry) {
        Label label = new Label();
        label.setGraphicTextGap(8.0);
        label.setAlignment(Pos.CENTER);
        label.textProperty().bind((ObservableValue)entry.textProperty());
        label.graphicProperty().bind(entry.graphicProperty());
        label.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        label.setWrapText(true);
        entry.visibleProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.vbox.getChildren().add((Object)label);
            } else {
                this.vbox.getChildren().remove((Object)label);
            }
        });
        if (entry.visibleProperty().get()) {
            this.vbox.getChildren().add((Object)label);
        }
        return label;
    }

    private HelpListEntry createMaskImageNames() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.maskImageNames");
        entry.visibleProperty().bind((ObservableValue)PathPrefs.maskImageNamesProperty());
        return entry;
    }

    private HelpListEntry createSelectionModelEntry() {
        HelpListEntry entry = HelpListEntry.createInfo("ContextHelp.warning.selectionMode", this.createIcon(IconFactory.PathIcons.SELECTION_MODE));
        entry.visibleProperty().bind((ObservableValue)PathPrefs.selectionModeProperty());
        return entry;
    }

    private HelpListEntry createUnseenErrors() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.unseenErrors", this.createIcon(IconFactory.PathIcons.LOG_VIEWER));
        entry.visibleProperty().bind((ObservableValue)this.qupath.getLogViewerCommand().hasUnseenErrors());
        return entry;
    }

    private HelpListEntry createHiddenObjectsPredicate() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.hiddenObjectsPredicate");
        entry.visibleProperty().bind((ObservableValue)this.qupath.getOverlayOptions().showObjectPredicateProperty().isNotNull());
        return entry;
    }

    private HelpListEntry createAnnotationsHiddenEntry() {
        HelpListEntry entry = HelpListEntry.createInfo("ContextHelp.warning.annotationsHidden", this.createIcon(IconFactory.PathIcons.ANNOTATIONS));
        entry.visibleProperty().bind((ObservableValue)this.qupath.getOverlayOptions().showAnnotationsProperty().not());
        return entry;
    }

    private HelpListEntry createTMAGridHiddenEntry() {
        HelpListEntry entry = HelpListEntry.createInfo("ContextHelp.warning.tmaCoresHidden", this.createIcon(IconFactory.PathIcons.TMA_GRID));
        entry.visibleProperty().bind((ObservableValue)this.qupath.getOverlayOptions().showTMAGridProperty().not());
        return entry;
    }

    private HelpListEntry createHiddenClassificationsEntry() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.classificationsHidden");
        entry.visibleProperty().bind((ObservableValue)Bindings.isEmpty(this.qupath.getOverlayOptions().selectedClassesProperty()).not());
        return entry;
    }

    private HelpListEntry createDetectionsHiddenEntry() {
        HelpListEntry entry = HelpListEntry.createInfo("ContextHelp.warning.detectionsHidden", this.createIcon(IconFactory.PathIcons.DETECTIONS));
        entry.visibleProperty().bind((ObservableValue)this.qupath.getOverlayOptions().showDetectionsProperty().not());
        return entry;
    }

    private HelpListEntry createPixelClassificationOverlayHiddenEntry() {
        HelpListEntry entry = HelpListEntry.createInfo("ContextHelp.warning.pixelOverlayHidden", this.createIcon(IconFactory.PathIcons.PIXEL_CLASSIFICATION));
        entry.visibleProperty().bind((ObservableValue)this.qupath.getOverlayOptions().showPixelClassificationProperty().not());
        return entry;
    }

    private HelpListEntry createOpacityZeroEntry() {
        HelpListEntry entry = HelpListEntry.createInfo("ContextHelp.warning.opacityZero");
        entry.visibleProperty().bind((ObservableValue)this.qupath.getOverlayOptions().opacityProperty().lessThanOrEqualTo(0.0));
        return entry;
    }

    private HelpListEntry createNoImageEntry() {
        HelpListEntry entry = HelpListEntry.createInfo("ContextHelp.warning.noImage");
        entry.visibleProperty().bind((ObservableValue)this.imageDataProperty.isNull());
        return entry;
    }

    private HelpListEntry createNoProjectEntry() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.noProject");
        entry.visibleProperty().bind((ObservableValue)this.qupath.projectProperty().isNull());
        return entry;
    }

    private HelpListEntry createGammaNotDefault() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.gamma");
        entry.visibleProperty().bind((ObservableValue)PathPrefs.viewerGammaProperty().isNotEqualTo(1));
        return entry;
    }

    private HelpListEntry createInvertedColors() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.invertedBackground");
        entry.visibleProperty().bind(this.qupath.viewerProperty().map(QuPathViewer::getImageDisplay).flatMap(ImageDisplay::useInvertedBackgroundProperty));
        return entry;
    }

    private HelpListEntry createGreyscaleColors() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.greyscale");
        entry.visibleProperty().bind(this.qupath.viewerProperty().map(QuPathViewer::getImageDisplay).flatMap(ImageDisplay::useGrayscaleLutProperty));
        return entry;
    }

    private HelpListEntry createNoChannelsVisible() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.noChannels", this.createIcon(IconFactory.PathIcons.CONTRAST));
        ObservableValue emptyChannels = this.qupath.viewerProperty().map(QuPathViewer::getImageDisplay).map(ImageDisplay::selectedChannels).flatMap(Bindings::isEmpty);
        entry.visibleProperty().bind((ObservableValue)this.qupath.imageDataProperty().isNotNull().and((ObservableBooleanValue)Bindings.createBooleanBinding(() -> emptyChannels == null || emptyChannels.getValue() == null ? false : (Boolean)emptyChannels.getValue(), (Observable[])new Observable[]{emptyChannels})));
        return entry;
    }

    private HelpListEntry createColorsTooSimilar() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.colorsSimilar");
        this.qupath.getAvailablePathClasses().addListener(c -> this.updateSimilarClassificationColors());
        PathPrefs.colorDefaultObjectsProperty().addListener((v, o, n) -> this.updateSimilarClassificationColors());
        entry.visibleProperty().bind((ObservableValue)this.classificationAndDefaultObjectColorsSimilar);
        return entry;
    }

    private HelpListEntry createPixelSizeMissing() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.pixelSizeMissing");
        entry.visibleProperty().bind((ObservableValue)this.pixelCalibrationUnset);
        return entry;
    }

    private HelpListEntry createPixelSizeLikelyDpi() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.pixelSizeDpi");
        entry.visibleProperty().bind((ObservableValue)this.pixelSizeLikelyDpi);
        return entry;
    }

    private HelpListEntry createImageTypeMissing() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.imageTypeMissing");
        entry.visibleProperty().bind((ObservableValue)this.imageTypeUnset);
        return entry;
    }

    private HelpListEntry createLargeNonPyramidal() {
        HelpListEntry entry = HelpListEntry.createWarning("ContextHelp.warning.largeNonPyramidalImage");
        entry.visibleProperty().bind((ObservableValue)this.largeNonPyramidalImage);
        return entry;
    }

    Node createIcon(IconFactory.PathIcons icon) {
        return IconFactory.createNode(this.iconSize, this.iconSize, icon);
    }

    private /* synthetic */ Boolean lambda$new$6() throws Exception {
        PixelCalibration pixelSize = (PixelCalibration)this.currentPixelSize.get();
        if (pixelSize == null) {
            return false;
        }
        if (pixelSize.getPixelWidthUnit() != null && pixelSize.getPixelWidthUnit().startsWith("inch")) {
            return true;
        }
        if (pixelSize.hasPixelSizeMicrons()) {
            for (double d : typicalDpiPixelSizes) {
                if (!GeneralTools.almostTheSame((double)d, (double)pixelSize.getAveragedPixelSizeMicrons(), (double)0.001)) continue;
                return true;
            }
        }
        return false;
    }

    private /* synthetic */ InfoMessage lambda$new$5() throws Exception {
        if (this.hasWarnings.get()) {
            return this.warningMessage;
        }
        if (this.hasInfo.get()) {
            return this.infoMessage;
        }
        return null;
    }

    private /* synthetic */ Long lambda$new$4() throws Exception {
        return this.allHelpEntries.stream().filter(e -> e.visibleProperty().get() && e.getType() == HelpType.INFO).count();
    }

    private /* synthetic */ Long lambda$new$2() throws Exception {
        return this.allHelpEntries.stream().filter(e -> e.visibleProperty().get() && e.getType() == HelpType.WARNING || e.getType() == HelpType.ERROR).count();
    }

    static class HelpListEntry {
        private int iconSize = 16;
        private HelpType type;
        private StringProperty textProperty;
        private SimpleObjectProperty<Node> graphicProperty;
        private BooleanProperty visibleProperty = new SimpleBooleanProperty(false);

        private HelpListEntry(HelpType type, String key, Node graphic) {
            this.type = type;
            this.textProperty = new SimpleStringProperty();
            QuPathResources.getLocalizedResourceManager().registerProperty(this.textProperty, key);
            if (graphic == null) {
                graphic = this.createGraphicFromType(type);
            }
            this.graphicProperty = new SimpleObjectProperty((Object)graphic);
        }

        public ObjectProperty<Node> graphicProperty() {
            return this.graphicProperty;
        }

        private HelpType getType() {
            return this.type;
        }

        public StringProperty textProperty() {
            return this.textProperty;
        }

        private BooleanProperty visibleProperty() {
            return this.visibleProperty;
        }

        static HelpListEntry createWarning(String key, Node graphic) {
            return new HelpListEntry(HelpType.WARNING, key, graphic);
        }

        static HelpListEntry createWarning(String key) {
            return HelpListEntry.createWarning(key, null);
        }

        static HelpListEntry createInfo(String key, Node graphic) {
            return new HelpListEntry(HelpType.INFO, key, graphic);
        }

        static HelpListEntry createInfo(String key) {
            return HelpListEntry.createInfo(key, null);
        }

        private Node createGraphicFromType(HelpType type) {
            Node typeGraphic = null;
            switch (type.ordinal()) {
                case 0: {
                    typeGraphic = this.createIcon(IconFactory.PathIcons.INFO);
                    typeGraphic.setStyle("-fx-text-fill: cornflowerblue;");
                    break;
                }
                case 1: {
                    typeGraphic = this.createIcon(IconFactory.PathIcons.WARNING);
                    typeGraphic.setStyle("-fx-text-fill: -qp-script-warn-color;");
                    break;
                }
                case 2: {
                    typeGraphic = this.createIcon(IconFactory.PathIcons.WARNING);
                    typeGraphic.setStyle("-fx-text-fill: -qp-script-error-color;");
                    break;
                }
            }
            return typeGraphic;
        }

        Node createIcon(IconFactory.PathIcons icon) {
            return IconFactory.createNode(this.iconSize, this.iconSize, icon);
        }
    }

    static enum HelpType {
        INFO,
        WARNING,
        ERROR;

    }
}

