/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import com.google.gson.stream.JsonWriter;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.controlsfx.control.CheckListView;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.analysis.DistanceTools;
import qupath.lib.analysis.features.ObjectMeasurements;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.UserDirectoryManager;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.commands.EstimateStainVectorsCommand;
import qupath.lib.gui.commands.ExportObjectsCommand;
import qupath.lib.gui.commands.InteractiveObjectImporter;
import qupath.lib.gui.commands.MeasurementManager;
import qupath.lib.gui.commands.MemoryMonitorDialog;
import qupath.lib.gui.commands.MiniViewers;
import qupath.lib.gui.commands.PathObjectGridView;
import qupath.lib.gui.commands.RigidObjectEditorCommand;
import qupath.lib.gui.commands.RotateImageCommand;
import qupath.lib.gui.commands.ScriptInterpreter;
import qupath.lib.gui.commands.ShowInstalledExtensionsCommand;
import qupath.lib.gui.commands.ShowLicensesCommand;
import qupath.lib.gui.commands.ShowSystemInfoCommand;
import qupath.lib.gui.commands.SpecifyAnnotationCommand;
import qupath.lib.gui.commands.SummaryMeasurementTableCommand;
import qupath.lib.gui.commands.ZoomCommand;
import qupath.lib.gui.images.servers.RenderedImageServer;
import qupath.lib.gui.panes.MeasurementMapPane;
import qupath.lib.gui.panes.ObjectDescriptionPane;
import qupath.lib.gui.panes.PreferencePane;
import qupath.lib.gui.panes.WorkflowCommandLogView;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.scripting.ScriptEditor;
import qupath.lib.gui.tma.TMASummaryViewer;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.GridLines;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.recording.ViewTrackerControlPane;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.images.writers.ImageWriter;
import qupath.lib.images.writers.ImageWriterTools;
import qupath.lib.io.FeatureCollection;
import qupath.lib.io.GsonTools;
import qupath.lib.io.PathIO;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectIO;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.projects.Projects;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;
import qupath.lib.scripting.QP;

public class Commands {
    private static Logger logger = LoggerFactory.getLogger(Commands.class);
    private static Map<QuPathGUI, RigidObjectEditorCommand> rigidObjectEditorMap = new WeakHashMap<QuPathGUI, RigidObjectEditorCommand>();
    private static DoubleProperty exportDownsample = PathPrefs.createPersistentPreference("exportRegionDownsample", 1.0);
    private static ImageWriter<BufferedImage> lastWriter = null;
    private static StringProperty defaultScreenshotExtension = PathPrefs.createPersistentPreference("defaultScreenshotExtension", "*.png");
    private static File lastSnapshotDirectory = null;

    public static void insertSelectedObjectsInHierarchy(ImageData<?> imageData) {
        if (imageData == null) {
            return;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        hierarchy.insertPathObjects((Collection)hierarchy.getSelectionModel().getSelectedObjects());
    }

    public static void promptToResolveHierarchy(ImageData<?> imageData) {
        PathObjectHierarchy hierarchy;
        if (imageData == null) {
            GuiTools.showNoImageError("Resolve hierarchy");
            return;
        }
        PathObjectHierarchy pathObjectHierarchy = hierarchy = imageData == null ? null : imageData.getHierarchy();
        if (hierarchy == null) {
            return;
        }
        int nObjects = hierarchy.getAllObjects(false).size();
        Object message = "Are you sure you want to resolve object relationships?";
        if (nObjects > 100) {
            message = (String)message + "\nFor large object hierarchies this can take a long time.";
        }
        if (!Dialogs.showConfirmDialog((String)"Resolve hierarchy", (String)message)) {
            return;
        }
        hierarchy.resolveHierarchy();
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Resolve hierarchy", "resolveHierarchy()"));
    }

    public static void createFullImageAnnotation(QuPathViewer viewer) {
        if (PathPrefs.selectionModeStatus().get()) {
            logger.debug("Select all objects (create full image annotation with selection mode on)");
            Commands.selectObjectsOnCurrentPlane(viewer);
            return;
        }
        if (viewer == null) {
            return;
        }
        ImageData<BufferedImage> imageData = viewer.getImageData();
        if (imageData == null) {
            return;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        int z = viewer.getZPosition();
        int t = viewer.getTPosition();
        ImageRegion bounds = viewer.getServerBounds();
        ROI roi = ROIs.createRectangleROI((double)bounds.getX(), (double)bounds.getY(), (double)bounds.getWidth(), (double)bounds.getHeight(), (ImagePlane)ImagePlane.getPlane((int)z, (int)t));
        for (PathObject pathObject : hierarchy.getAnnotationObjects()) {
            ROI r2 = pathObject.getROI();
            if (!(r2 instanceof RectangleROI) || roi.getBoundsX() != r2.getBoundsX() || roi.getBoundsY() != r2.getBoundsY() || roi.getBoundsWidth() != r2.getBoundsWidth() || roi.getBoundsHeight() != r2.getBoundsHeight() || !roi.getImagePlane().equals((Object)r2.getImagePlane())) continue;
            logger.warn("Full image annotation already exists! {}", (Object)pathObject);
            viewer.setSelectedObject(pathObject);
            return;
        }
        PathObject pathObject = PathObjects.createAnnotationObject((ROI)roi);
        hierarchy.addObject(pathObject);
        viewer.setSelectedObject(pathObject);
        if (z == 0 && t == 0) {
            imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Create full image annotation", "createFullImageAnnotation(true)"));
        } else {
            imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Create full image annotation", String.format("createFullImageAnnotation(true, %d, %d)", z, t)));
        }
    }

    public static void editSelectedAnnotation(QuPathGUI qupath) {
        RigidObjectEditorCommand editor = rigidObjectEditorMap.computeIfAbsent(qupath, q -> new RigidObjectEditorCommand((QuPathGUI)q));
        editor.run();
    }

    public static void showAnnotationGridView(QuPathGUI qupath) {
        PathObjectGridView.createAnnotationView(qupath).show();
    }

    public static void showTMACoreGridView(QuPathGUI qupath) {
        PathObjectGridView.createTmaCoreView(qupath).show();
    }

    public static void showDetectionMeasurementTable(QuPathGUI qupath, ImageData<BufferedImage> imageData) {
        new SummaryMeasurementTableCommand(qupath).showTable(imageData, (Predicate<PathObject>)PathObjectFilter.DETECTIONS_ALL);
    }

    public static void showCellMeasurementTable(QuPathGUI qupath, ImageData<BufferedImage> imageData) {
        new SummaryMeasurementTableCommand(qupath).showTable(imageData, (Predicate<PathObject>)PathObjectFilter.CELLS);
    }

    public static void showAnnotationMeasurementTable(QuPathGUI qupath, ImageData<BufferedImage> imageData) {
        new SummaryMeasurementTableCommand(qupath).showTable(imageData, (Predicate<PathObject>)PathObjectFilter.ANNOTATIONS);
    }

    public static void showTMAMeasurementTable(QuPathGUI qupath, ImageData<BufferedImage> imageData) {
        new SummaryMeasurementTableCommand(qupath).showTable(imageData, (Predicate<PathObject>)PathObjectFilter.TMA_CORES);
    }

    public static void promptToEstimateStainVectors(ImageData<BufferedImage> imageData) {
        EstimateStainVectorsCommand.promptToEstimateStainVectors(imageData);
    }

    public static void promptToExportImageRegion(QuPathViewer viewer, boolean renderedImage) {
        File fileOutput;
        PathObject pathObject;
        if (viewer == null || viewer.getServer() == null) {
            Dialogs.showErrorMessage((String)"Export image region", (String)"No viewer & image selected!");
            return;
        }
        ImageServer<BufferedImage> server = viewer.getServer();
        if (renderedImage) {
            try {
                server = RenderedImageServer.createRenderedServer(viewer);
            }
            catch (IOException e2) {
                Dialogs.showErrorMessage((String)"Export image region", (String)"Unable to create rendered image server");
                logger.error(e2.getMessage(), (Throwable)e2);
                return;
            }
        }
        ROI roi = (pathObject = viewer.getSelectedObject()) == null ? null : pathObject.getROI();
        double regionWidth = roi == null ? (double)server.getWidth() : roi.getBoundsWidth();
        double regionHeight = roi == null ? (double)server.getHeight() : roi.getBoundsHeight();
        GridPane pane = new GridPane();
        int row = 0;
        pane.add((Node)new Label("Export format"), 0, row);
        ComboBox comboImageType = new ComboBox();
        Function<ImageWriter, String> fun = writer -> writer.getName();
        comboImageType.setCellFactory(p -> FXUtils.createCustomListCell((Function)fun));
        comboImageType.setButtonCell(FXUtils.createCustomListCell(fun));
        List writers = ImageWriterTools.getCompatibleWriters(server, null);
        comboImageType.getItems().setAll((Collection)writers);
        comboImageType.setTooltip(new Tooltip("Choose export image format"));
        if (writers.contains(lastWriter)) {
            comboImageType.getSelectionModel().select(lastWriter);
        } else {
            comboImageType.getSelectionModel().selectFirst();
        }
        comboImageType.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)comboImageType, (Priority)Priority.ALWAYS);
        pane.add((Node)comboImageType, 1, row++);
        TextArea textArea = new TextArea();
        textArea.setPrefRowCount(2);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        comboImageType.setOnAction(e -> textArea.setText(((ImageWriter)comboImageType.getValue()).getDetails()));
        textArea.setText(((ImageWriter)comboImageType.getValue()).getDetails());
        pane.add((Node)textArea, 0, row++, 2, 1);
        Label label = new Label("Downsample factor");
        pane.add((Node)label, 0, row);
        TextField tfDownsample = new TextField();
        label.setLabelFor((Node)tfDownsample);
        pane.add((Node)tfDownsample, 1, row++);
        tfDownsample.setTooltip(new Tooltip("Amount to scale down image - choose 1 to export at full resolution (note: for large images this may not succeed for memory reasons)"));
        DoubleBinding downsample = Bindings.createDoubleBinding(() -> {
            try {
                return Double.parseDouble(tfDownsample.getText());
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }, (Observable[])new Observable[]{tfDownsample.textProperty()});
        long maxPixels = 100000000L;
        Label labelSize = new Label();
        labelSize.setMinWidth(400.0);
        labelSize.setTextAlignment(TextAlignment.CENTER);
        labelSize.setContentDisplay(ContentDisplay.CENTER);
        labelSize.setAlignment(Pos.CENTER);
        labelSize.setMaxWidth(Double.MAX_VALUE);
        labelSize.setTooltip(new Tooltip("Estimated size of exported image"));
        pane.add((Node)labelSize, 0, row++, 2, 1);
        labelSize.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> Commands.lambda$promptToExportImageRegion$5((ObservableDoubleValue)downsample, labelSize, regionWidth, regionHeight, comboImageType, maxPixels), (Observable[])new Observable[]{downsample, comboImageType.getSelectionModel().selectedIndexProperty()}));
        tfDownsample.setText(Double.toString(exportDownsample.get()));
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{labelSize, textArea, tfDownsample, comboImageType});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{labelSize, textArea, tfDownsample, comboImageType});
        pane.setVgap(5.0);
        pane.setHgap(5.0);
        if (!Dialogs.showConfirmDialog((String)"Export image region", (Node)pane)) {
            return;
        }
        ImageWriter writer2 = (ImageWriter)comboImageType.getSelectionModel().getSelectedItem();
        boolean supportsPyramid = writer2 == null ? false : writer2.supportsPyramidal();
        int w = (int)(regionWidth / downsample.get() + 0.5);
        int h = (int)(regionHeight / downsample.get() + 0.5);
        if (!supportsPyramid && (long)(w * h) > maxPixels) {
            Dialogs.showErrorNotification((String)"Export image region", (String)"Requested export region too large - try selecting a smaller region, or applying a higher downsample factor");
            return;
        }
        if (downsample.get() < 1.0 || !Double.isFinite(downsample.get())) {
            Dialogs.showErrorMessage((String)"Export image region", (String)"Downsample factor must be >= 1!");
            return;
        }
        exportDownsample.set(downsample.get());
        if (renderedImage && downsample.get() != server.getDownsampleForResolution(0)) {
            try {
                server = new RenderedImageServer.Builder(viewer).downsamples(downsample.get()).build();
            }
            catch (IOException e3) {
                Dialogs.showErrorMessage((String)"Export image region", (String)"Unable to create rendered image server");
                logger.error(e3.getMessage(), (Throwable)e3);
                return;
            }
        }
        RegionRequest request = null;
        if (pathObject != null && pathObject.hasROI()) {
            request = RegionRequest.createInstance((String)server.getPath(), (double)exportDownsample.get(), (ROI)roi);
        }
        String ext = writer2.getDefaultExtension();
        String writerName = writer2.getName();
        String defaultName = GeneralTools.getNameWithoutExtension((File)new File(ServerTools.getDisplayableImageName(server)));
        if (roi != null) {
            defaultName = String.format("%s (%s, x=%d, y=%d, w=%d, h=%d)", defaultName, GeneralTools.formatNumber((double)request.getDownsample(), (int)2), request.getX(), request.getY(), request.getWidth(), request.getHeight());
        }
        if ((fileOutput = FileChoosers.promptToSaveFile((String)"Export image region", (File)new File(defaultName), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)writerName, (String[])new String[]{ext})})) == null) {
            return;
        }
        try {
            if (request == null) {
                if (exportDownsample.get() == 1.0) {
                    writer2.writeImage(server, fileOutput.getAbsolutePath());
                } else {
                    writer2.writeImage(ImageServers.pyramidalize(server, (double[])new double[]{exportDownsample.get()}), fileOutput.getAbsolutePath());
                }
            } else {
                writer2.writeImage(server, request, fileOutput.getAbsolutePath());
            }
            lastWriter = writer2;
        }
        catch (IOException e4) {
            Dialogs.showErrorMessage((String)"Export region", (String)e4.getLocalizedMessage());
            logger.error(e4.getMessage(), (Throwable)e4);
        }
    }

    public static void showInstalledExtensions(QuPathGUI qupath) {
        ShowInstalledExtensionsCommand.showInstalledExtensions(qupath);
    }

    public static void showDetectionMeasurementManager(QuPathGUI qupath, ImageData<?> imageData) {
        MeasurementManager.showDetectionMeasurementManager(qupath, imageData);
    }

    public static boolean resetTMAMetadata(ImageData<?> imageData) {
        if (imageData == null || imageData.getHierarchy().getTMAGrid() == null) {
            logger.warn("No TMA grid available!");
            return false;
        }
        QP.resetTMAMetadata((PathObjectHierarchy)imageData.getHierarchy(), (boolean)true);
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Reset TMA metadata", "resetTMAMetadata(true)"));
        return true;
    }

    public static Action createSingleStageAction(Supplier<Stage> supplier) {
        SingleStageCommand command = new SingleStageCommand(supplier);
        return new Action(e -> command.show());
    }

    public static Action createSingleStageAction(Supplier<Stage> supplier, String name) {
        SingleStageCommand command = new SingleStageCommand(supplier);
        return new Action(name, e -> command.show());
    }

    public static Stage createMeasurementMapDialog(QuPathGUI qupath) {
        Stage dialog = new Stage();
        if (qupath != null) {
            dialog.initOwner((javafx.stage.Window)qupath.getStage());
        }
        FXUtils.addCloseWindowShortcuts((Stage)dialog);
        dialog.setTitle("Measurement maps");
        MeasurementMapPane panel = new MeasurementMapPane(qupath);
        BorderPane pane = new BorderPane();
        pane.setCenter((Node)panel.getPane());
        Scene scene = new Scene((Parent)pane, 300.0, 400.0);
        dialog.setScene(scene);
        dialog.setMinWidth(300.0);
        dialog.setMinHeight(400.0);
        dialog.setOnCloseRequest(e -> {
            OverlayOptions overlayOptions = qupath.getOverlayOptions();
            if (overlayOptions != null) {
                overlayOptions.resetMeasurementMapper();
            }
            dialog.hide();
        });
        dialog.setOnShowing(e -> panel.updateMeasurements());
        return dialog;
    }

    public static void showScriptInterpreter(QuPathGUI qupath) {
        ScriptInterpreter scriptInterpreter = new ScriptInterpreter(qupath, QuPathGUI.getExtensionCatalogManager().getExtensionClassLoader());
        scriptInterpreter.getStage().initOwner((javafx.stage.Window)qupath.getStage());
        scriptInterpreter.getStage().show();
    }

    public static Stage createLicensesWindow(QuPathGUI qupath) {
        return ShowLicensesCommand.createLicensesDialog(qupath);
    }

    public static Stage createShowSystemInfoDialog(QuPathGUI qupath) {
        return ShowSystemInfoCommand.createShowSystemInfoDialog(qupath);
    }

    public static Stage createPreferencesDialog(QuPathGUI qupath) {
        Stage dialog = new Stage();
        dialog.initOwner((javafx.stage.Window)qupath.getStage());
        FXUtils.addCloseWindowShortcuts((Stage)dialog);
        dialog.setTitle("Preferences");
        Button btnExport = new Button("Export");
        btnExport.setOnAction(e -> Commands.exportPreferences(dialog));
        btnExport.setMaxWidth(Double.MAX_VALUE);
        Button btnImport = new Button("Import");
        btnImport.setOnAction(e -> Commands.importPreferences(dialog));
        btnImport.setMaxWidth(Double.MAX_VALUE);
        Button btnReset = new Button("Reset");
        btnReset.setOnAction(e -> PathPrefs.resetPreferences());
        btnReset.setMaxWidth(Double.MAX_VALUE);
        GridPane paneImportExport = new GridPane();
        paneImportExport.addRow(0, new Node[]{btnImport, btnExport, btnReset});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{btnImport, btnExport, btnReset});
        paneImportExport.setMaxWidth(Double.MAX_VALUE);
        BorderPane pane = new BorderPane();
        PreferencePane prefPane = qupath.getPreferencePane();
        pane.setCenter((Node)prefPane.getPane());
        pane.setBottom((Node)paneImportExport);
        if (qupath != null && qupath.getStage() != null) {
            pane.setPrefHeight((double)Math.round(Math.max(300.0, qupath.getStage().getHeight() * 0.75)));
        }
        paneImportExport.prefWidthProperty().bind((ObservableValue)pane.widthProperty());
        dialog.setScene(new Scene((Parent)pane));
        dialog.setMinWidth(300.0);
        dialog.setMinHeight(300.0);
        dialog.setOnShowing(e -> prefPane.refreshAllEditors());
        return dialog;
    }

    private static boolean exportPreferences(Stage parent) {
        File file = FileChoosers.promptToSaveFile((javafx.stage.Window)parent, (String)"Export preferences", null, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"Preferences file", (String[])new String[]{"xml"})});
        if (file != null) {
            boolean bl;
            block9: {
                OutputStream stream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                try {
                    logger.info("Exporting preferences to {}", (Object)file.getAbsolutePath());
                    PathPrefs.exportPreferences(stream);
                    bl = true;
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Dialogs.showErrorMessage((String)"Import preferences", (String)e.getLocalizedMessage());
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    private static boolean importPreferences(Stage parent) {
        File file = FileChoosers.promptForFile((javafx.stage.Window)parent, (String)"Import preferences", (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"Preferences file", (String[])new String[]{"xml"})});
        if (file != null) {
            boolean bl;
            block9: {
                InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
                try {
                    logger.info("Importing preferences from {}", (Object)file.getAbsolutePath());
                    PathPrefs.importPreferences(stream);
                    Dialogs.showMessageDialog((String)"Import preferences", (String)"Preferences have been imported - please restart QuPath to see the changes.");
                    bl = true;
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Dialogs.showErrorMessage((String)"Import preferences", (Throwable)e);
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    public static void createRotateImageDialog(QuPathGUI qupath) {
        Stage rotationCommand = new RotateImageCommand(qupath).createDialog();
        rotationCommand.show();
    }

    public static Action createZoomCommand(QuPathGUI qupath, int zoomAmount) {
        ZoomCommand command = new ZoomCommand((ObservableValue<? extends QuPathViewer>)qupath.viewerProperty(), zoomAmount);
        return ActionTools.createAction(command);
    }

    public static Stage createSpecifyAnnotationDialog(QuPathGUI qupath) {
        SpecifyAnnotationCommand pane = new SpecifyAnnotationCommand(qupath);
        Stage stage = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)stage);
        Scene scene = new Scene((Parent)pane.getPane());
        stage.setScene(scene);
        stage.setWidth(300.0);
        stage.setMinHeight(200.0);
        stage.setMinWidth(200.0);
        stage.setTitle("Specify annotation");
        stage.initOwner((javafx.stage.Window)qupath.getStage());
        return stage;
    }

    public static Stage createObjectDescriptionsDialog(QuPathGUI qupath) {
        return ObjectDescriptionPane.createWindow(qupath);
    }

    public static boolean promptToSaveImageData(QuPathGUI qupath, ImageData<BufferedImage> imageData, boolean overwriteExisting) {
        if (imageData == null) {
            GuiTools.showNoImageError("Serialization error");
            return false;
        }
        try {
            ProjectImageEntry entry;
            Project<BufferedImage> project = qupath.getProject();
            ProjectImageEntry projectImageEntry = entry = project == null ? null : project.getEntry(imageData);
            if (entry != null) {
                if (overwriteExisting || Dialogs.showConfirmDialog((String)"Save changes", (String)("Save changes to " + entry.getImageName() + "?"))) {
                    entry.saveImageData(imageData);
                    return true;
                }
                return false;
            }
            String lastSavedPath = imageData.getLastSavedPath();
            File file = null;
            if (lastSavedPath != null) {
                if (overwriteExisting) {
                    file = new File(lastSavedPath);
                }
                if (file == null || !file.isFile()) {
                    File fileDefault = new File(lastSavedPath);
                    file = FileChoosers.promptToSaveFile(null, (File)fileDefault, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"QuPath Serialized Data", (String[])new String[]{PathPrefs.getSerializationExtension()})});
                }
            } else {
                ImageServer server = imageData.getServer();
                String name = ServerTools.getDisplayableImageName((ImageServer)server);
                if (name.contains(".")) {
                    try {
                        name = GeneralTools.getNameWithoutExtension((File)new File(name));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                file = FileChoosers.promptToSaveFile(null, (File)new File(name), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"QuPath Serialized Data", (String[])new String[]{PathPrefs.getSerializationExtension()})});
            }
            if (file == null) {
                return false;
            }
            PathIO.writeImageData((File)file, imageData);
            return true;
        }
        catch (IOException e) {
            Dialogs.showErrorMessage((String)"Save ImageData", (Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static void saveSnapshotWithDelay(QuPathGUI qupath, GuiTools.SnapshotType type, long delayMillis) {
        CompletableFuture.delayedExecutor(delayMillis, TimeUnit.MILLISECONDS, Platform::runLater).execute(() -> Commands.saveSnapshot(qupath, type));
    }

    public static boolean saveSnapshot(QuPathGUI qupath, GuiTools.SnapshotType type) {
        List compatibleWriters;
        FileChooser chooser;
        File fileOutput;
        Path path;
        Project<BufferedImage> project;
        File initialDirectory;
        BufferedImage img = GuiTools.makeSnapshot(qupath, type);
        String defaultExtension = (String)defaultScreenshotExtension.get();
        ArrayList<FileChooser.ExtensionFilter> extensionFilters = new ArrayList<FileChooser.ExtensionFilter>(Arrays.asList(FileChoosers.createExtensionFilter((String)"PNG", (String[])new String[]{"png"}), FileChoosers.createExtensionFilter((String)"JPEG", (String[])new String[]{"jpg", "jpeg"}), FileChoosers.createExtensionFilter((String)"TIFF", (String[])new String[]{"tif", "tiff"})));
        FileChooser.ExtensionFilter selectedFilter = extensionFilters.stream().filter(e -> defaultExtension == null ? false : e.getExtensions().contains(defaultExtension)).findFirst().orElse((FileChooser.ExtensionFilter)extensionFilters.get(0));
        if (!Objects.equals(selectedFilter, extensionFilters.get(0))) {
            extensionFilters.remove(selectedFilter);
            extensionFilters.add(0, selectedFilter);
        }
        if (!((initialDirectory = lastSnapshotDirectory) != null && initialDirectory.exists() || (project = qupath.getProject()) == null || (path = project.getPath()) == null)) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                initialDirectory = path.toFile();
            } else if (Files.isRegularFile(path, new LinkOption[0])) {
                initialDirectory = path.getParent().toFile();
            }
        }
        if ((fileOutput = (chooser = (FileChooser)FileChoosers.buildFileChooser().extensionFilters(extensionFilters).selectedExtensionFilter(selectedFilter).initialDirectory(initialDirectory).build()).showSaveDialog((javafx.stage.Window)qupath.getStage())) == null) {
            return false;
        }
        lastSnapshotDirectory = fileOutput.getParentFile();
        String ext = GeneralTools.getExtension((File)fileOutput).orElse(null);
        List list = compatibleWriters = ext == null ? Collections.emptyList() : ImageWriterTools.getCompatibleWriters(BufferedImage.class, (String)ext);
        if (compatibleWriters.isEmpty()) {
            logger.error("No compatible image writers found for extension: " + ext);
            return false;
        }
        for (ImageWriter writer : compatibleWriters) {
            try {
                writer.writeImage((Object)img, fileOutput.getAbsolutePath());
                String extChosen = (String)chooser.getSelectedExtensionFilter().getExtensions().get(0);
                defaultScreenshotExtension.set((Object)extChosen);
                return true;
            }
            catch (Exception e2) {
                logger.error("Error saving snapshot " + String.valueOf((Object)type) + " to " + fileOutput.getAbsolutePath(), (Throwable)e2);
            }
        }
        return false;
    }

    public static void mergeSelectedAnnotations(ImageData<?> imageData) {
        if (imageData == null) {
            return;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        logger.debug("Merging selected annotations");
        QP.mergeSelectedAnnotations((PathObjectHierarchy)hierarchy);
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Merge selected annotations", "mergeSelectedAnnotations()"));
    }

    public static void duplicateSelectedAnnotations(ImageData<?> imageData) {
        if (imageData == null) {
            GuiTools.showNoImageError("Duplicate annotations");
            return;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        PathObjectTools.duplicateSelectedAnnotations((PathObjectHierarchy)hierarchy);
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Duplicate selected annotations", "duplicateSelectedAnnotations()"));
    }

    public static void copySelectedAnnotationsToCurrentPlane(QuPathViewer viewer) {
        ImageData<BufferedImage> imageData;
        ImageData<BufferedImage> imageData2 = imageData = viewer == null ? null : viewer.getImageData();
        if (imageData == null) {
            GuiTools.showNoImageError("Copy selected annotations to plane");
            return;
        }
        ImagePlane plane = viewer.getImagePlane();
        int z = plane.getZ();
        int t = plane.getT();
        QP.copySelectedAnnotationsToPlane((int)z, (int)t);
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Copy selected annotations to plane", String.format("copySelectedAnnotationsToPlane(%d, %d)", z, t)));
    }

    public static void makeInverseAnnotation(ImageData<?> imageData) {
        if (imageData == null) {
            return;
        }
        logger.debug("Make inverse annotation");
        QP.makeInverseAnnotation(imageData);
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Invert selected annotation", "makeInverseAnnotation()"));
    }

    public static void showViewTracker(QuPathGUI qupath) {
        new ViewTrackerControlPane(qupath).run();
    }

    public static boolean combineSelectedAnnotations(ImageData<?> imageData, RoiTools.CombineOp op) {
        if (imageData == null) {
            GuiTools.showNoImageError("Combine annotations");
            return false;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        ArrayList<PathObject> selected = new ArrayList<PathObject>(hierarchy.getSelectionModel().getSelectedObjects());
        PathObject mainObject = hierarchy.getSelectionModel().getSelectedObject();
        if (mainObject != null && !selected.isEmpty() && !selected.get(0).equals(mainObject)) {
            selected.remove(mainObject);
            selected.add(0, mainObject);
        }
        return Commands.combineAnnotations(hierarchy, selected, op);
    }

    static boolean combineAnnotations(PathObjectHierarchy hierarchy, List<PathObject> pathObjects, RoiTools.CombineOp op) {
        if (hierarchy == null || hierarchy.isEmpty() || pathObjects.isEmpty()) {
            logger.warn("Combine annotations: Cannot combine - no annotations found");
            return false;
        }
        PathObject pathObject = (pathObjects = new ArrayList<PathObject>(pathObjects)).get(0);
        if (!pathObject.isAnnotation()) {
            logger.warn("Combine annotations: No annotation with ROI selected");
            return false;
        }
        ImagePlane plane = pathObject.getROI().getImagePlane();
        pathObjects.removeIf(p -> !p.hasROI() || !p.getROI().getImagePlane().equals((Object)plane));
        if (pathObjects.isEmpty()) {
            logger.warn("Cannot combine annotations - only one suitable annotation found");
            return false;
        }
        ArrayList allROIs = pathObjects.stream().map(p -> p.getROI()).collect(Collectors.toCollection(() -> new ArrayList()));
        ROI newROI = switch (op) {
            case RoiTools.CombineOp.ADD -> RoiTools.union((Collection)allROIs);
            case RoiTools.CombineOp.INTERSECT -> RoiTools.intersection((Collection)allROIs);
            case RoiTools.CombineOp.SUBTRACT -> {
                ROI first = (ROI)allROIs.remove(0);
                yield RoiTools.combineROIs((ROI)first, (ROI)RoiTools.union((Collection)allROIs), (RoiTools.CombineOp)op);
            }
            default -> throw new IllegalArgumentException("Unknown combine op " + String.valueOf(op));
        };
        if (newROI == null) {
            logger.debug("No changes were made");
            return false;
        }
        PathObject newObject = null;
        if (!newROI.isEmpty()) {
            newObject = PathObjects.createAnnotationObject((ROI)newROI, (PathClass)pathObject.getPathClass());
            newObject.setName(pathObject.getName());
            newObject.setColor(pathObject.getColor());
        }
        hierarchy.removeObjects(pathObjects, true);
        if (newObject != null) {
            hierarchy.addObject(newObject);
        }
        return true;
    }

    public static void promptToSelectObjectsByClassification(QuPathGUI qupath, ImageData<?> imageData) {
        if (imageData == null) {
            return;
        }
        PathClass pathClass = (PathClass)Dialogs.showChoiceDialog((String)"Select objects", (String)"", qupath.getAvailablePathClasses(), null);
        if (pathClass == null) {
            return;
        }
        Commands.selectObjectsByClassification(imageData, pathClass);
    }

    public static boolean promptToEditClass(PathClass pathClass) {
        Color color;
        if (pathClass == null || pathClass == PathClass.NULL_CLASS) {
            return false;
        }
        boolean defaultColor = pathClass == null;
        BorderPane panel = new BorderPane();
        BorderPane panelName = new BorderPane();
        if (defaultColor) {
            String name = "Default object color";
            color = ColorToolsFX.getCachedColor(PathPrefs.colorDefaultObjectsProperty().get());
            label = new Label(name);
            label.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
            panelName.setCenter((Node)label);
        } else {
            String name = pathClass.toString();
            if (name == null) {
                name = "";
            }
            color = ColorToolsFX.getPathClassColor(pathClass);
            label = new Label(name);
            label.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
            panelName.setCenter((Node)label);
        }
        panel.setTop((Node)panelName);
        ColorPicker panelColor = new ColorPicker(color);
        panel.setCenter((Node)panelColor);
        if (!Dialogs.showConfirmDialog((String)"Edit class", (Node)panel)) {
            return false;
        }
        Color newColor = (Color)panelColor.getValue();
        Integer colorValue = newColor.isOpaque() ? ColorToolsFX.getRGB(newColor) : ColorToolsFX.getARGB(newColor);
        if (defaultColor) {
            if (newColor.isOpaque()) {
                PathPrefs.colorDefaultObjectsProperty().set(colorValue.intValue());
            } else {
                PathPrefs.colorDefaultObjectsProperty().set(colorValue.intValue());
            }
        } else {
            pathClass.setColor(colorValue);
        }
        return true;
    }

    public static boolean selectObjectsByClassification(ImageData<?> imageData, PathClass ... pathClasses) {
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        if (pathClasses.length == 0) {
            logger.warn("Cannot select objects by classification - no classifications selected!");
            return false;
        }
        QP.selectObjectsByPathClass((PathObjectHierarchy)hierarchy, (PathClass[])pathClasses);
        String s = Arrays.stream(pathClasses).map(p -> p == null || p == PathClass.NULL_CLASS ? "null" : "\"" + p.toString() + "\"").collect(Collectors.joining(", "));
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Select objects by classification", "selectObjectsByClassification(" + s + ");"));
        return true;
    }

    public static void promptToDeleteObjects(ImageData<?> imageData, Class<? extends PathObject> cls) {
        Object message;
        if (imageData == null) {
            return;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        if (cls == null) {
            int n = hierarchy.nObjects();
            if (n == 0) {
                return;
            }
            Object message2 = n == 1 ? "Delete object?" : "Delete all " + n + " objects?";
            if (Dialogs.showYesNoDialog((String)"Delete objects", (String)message2)) {
                hierarchy.clearAll();
                hierarchy.getSelectionModel().setSelectedObject(null);
                imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Delete all objects", "removeAllObjects()"));
            }
            return;
        }
        if (TMACoreObject.class.equals(cls) && hierarchy.getTMAGrid() != null) {
            if (Dialogs.showYesNoDialog((String)"Delete objects", (String)"Remove TMA grid?")) {
                hierarchy.setTMAGrid(null);
                PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
                if (selected instanceof TMACoreObject) {
                    hierarchy.getSelectionModel().setSelectedObject(null);
                }
                imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Remove TMA Grid", "removeTMAGrid()"));
            }
            return;
        }
        Collection pathObjects = hierarchy.getObjects(null, cls);
        if (pathObjects.isEmpty()) {
            return;
        }
        int n = pathObjects.size();
        Object object = message = n == 1 ? "Delete 1 object?" : "Delete " + n + " objects?";
        if (Dialogs.showYesNoDialog((String)"Delete objects", (String)message)) {
            hierarchy.removeObjects(pathObjects, true);
            PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
            if (selected != null && selected.getClass().isAssignableFrom(cls)) {
                hierarchy.getSelectionModel().setSelectedObject(null);
            }
            if (selected != null && selected.getClass().isAssignableFrom(cls)) {
                hierarchy.getSelectionModel().setSelectedObject(null);
            }
            if (cls == PathDetectionObject.class) {
                imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Delete detections", "removeDetections()"));
            } else if (cls == PathAnnotationObject.class) {
                imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Delete annotations", "removeAnnotations()"));
            } else if (cls == TMACoreObject.class) {
                imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Delete TMA grid", "removeTMAGrid()"));
            } else {
                logger.warn("Cannot remove all objects for class {}", cls);
            }
        }
    }

    public static void removeOnImageBounds(ImageData<?> imageData) {
        if (imageData == null) {
            logger.warn("No image available!");
            return;
        }
        QP.removeObjectsTouchingImageBounds(imageData, null);
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Remove objects on image boundary", "removeObjectsTouchingImageBounds()"));
    }

    public static boolean promptToResetPreferences() {
        if (Dialogs.showConfirmDialog((String)"Reset Preferences", (String)"Do you want to reset all custom preferences?\n\nYou may have to restart QuPath to see all changes.")) {
            PathPrefs.resetPreferences();
            return true;
        }
        logger.info("Reset preferences command skipped!");
        return false;
    }

    public static void setViewerDownsample(QuPathViewer viewer, double downsample) {
        if (viewer != null) {
            viewer.setDownsampleFactor(downsample);
        }
    }

    public static void closeProject(QuPathGUI qupath) {
        qupath.setProject(null);
    }

    public static boolean promptToCreateProject(QuPathGUI qupath) {
        File dir = FileChoosers.promptForDirectory((String)"Select empty directory for project", null);
        if (dir == null) {
            return false;
        }
        if (!dir.isDirectory()) {
            logger.error(String.valueOf(dir) + " is not a valid project directory!");
        }
        for (File f : dir.listFiles()) {
            if (f.isHidden()) continue;
            logger.error("Cannot create project for non-empty directory {}", (Object)dir);
            Dialogs.showErrorMessage((String)"Project creator", (String)"Project directory must be empty!");
            return false;
        }
        qupath.setProject((Project<BufferedImage>)Projects.createProject((File)dir, BufferedImage.class));
        return true;
    }

    public static boolean promptToOpenProject(QuPathGUI qupath) {
        File fileProject = FileChoosers.promptForFile((String)"Choose project file", (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"QuPath projects", (String[])new String[]{ProjectIO.getProjectExtension()})});
        if (fileProject != null) {
            try {
                Project project = ProjectIO.loadProject((File)fileProject, BufferedImage.class);
                qupath.setProject((Project<BufferedImage>)project);
                return true;
            }
            catch (Exception e) {
                Dialogs.showErrorMessage((String)"Load project", (String)("Could not read project from " + fileProject.getName()));
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public static void launchTMADataViewer(QuPathGUI qupath) {
        Stage stage = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)stage);
        stage.setMinHeight(200.0);
        stage.setMinWidth(200.0);
        if (qupath != null) {
            stage.initOwner((javafx.stage.Window)qupath.getStage());
        }
        TMASummaryViewer tmaViewer = new TMASummaryViewer(stage);
        ImageData<BufferedImage> imageData = qupath.getImageData();
        if (imageData != null && imageData.getHierarchy().getTMAGrid() != null) {
            tmaViewer.setTMAEntriesFromImageData(imageData);
        }
        try {
            Screen screen = Screen.getPrimary();
            stage.setWidth(screen.getBounds().getWidth() * 0.75);
            stage.setHeight(screen.getBounds().getHeight() * 0.75);
        }
        catch (Exception e) {
            logger.error("Exception setting stage size", (Throwable)e);
        }
        stage.show();
    }

    public static void distanceToAnnotations2D(ImageData<?> imageData, boolean signedDistances) {
        String title;
        String string = title = signedDistances ? "Signed distance to annotations 2D" : "Distance to annotations 2D";
        if (imageData == null) {
            GuiTools.showNoImageError(title);
            return;
        }
        if (imageData.getServer().nZSlices() > 1) {
            logger.debug("Warning user that measurements will be 2D...");
            if (!Dialogs.showConfirmDialog((String)title, (String)"Distance to annotations command works only in 2D - distances will not be calculated for objects on different z-slices or time-points")) {
                logger.debug("Command cancelled");
                return;
            }
        }
        ButtonType result = Dialogs.showYesNoCancelDialog((String)title, (String)"Split multi-part classifications?\nIf yes, each component of classifications such as \"Class1: Class2\" will be treated separately.");
        boolean doSplit = false;
        if (result == ButtonType.YES) {
            doSplit = true;
        } else if (result != ButtonType.NO) {
            return;
        }
        if (signedDistances) {
            DistanceTools.detectionToAnnotationDistancesSigned(imageData, (boolean)doSplit);
            imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Signed distance to annotations 2D", doSplit ? "detectionToAnnotationDistancesSigned(true)" : "detectionToAnnotationDistancesSigned(false)"));
        } else {
            DistanceTools.detectionToAnnotationDistances(imageData, (boolean)doSplit);
            imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Distance to annotations 2D", doSplit ? "detectionToAnnotationDistances(true)" : "detectionToAnnotationDistances(false)"));
        }
    }

    public static void detectionCentroidDistances2D(ImageData<?> imageData) {
        String title = "Detection centroid distances 2D";
        if (imageData == null) {
            GuiTools.showNoImageError(title);
            return;
        }
        if (imageData.getServer().nZSlices() > 1) {
            logger.debug("Warning user that measurements will be 2D...");
            if (!Dialogs.showConfirmDialog((String)title, (String)"Detection centroid distances command works only in 2D - distances will not be calculated for objects on different z-slices or time-points")) {
                logger.debug("Command cancelled");
                return;
            }
        }
        ButtonType result = Dialogs.showYesNoCancelDialog((String)title, (String)"Split multi-part classifications?\nIf yes, each component of classifications such as \"Class1: Class2\" will be treated separately.");
        boolean doSplit = false;
        if (result == ButtonType.YES) {
            doSplit = true;
        } else if (result != ButtonType.NO) {
            return;
        }
        DistanceTools.detectionCentroidDistances(imageData, (boolean)doSplit);
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Detection centroid distances 2D", doSplit ? "detectionCentroidDistances(true)" : "detectionCentroidDistances(false)"));
    }

    public static void promptToSetGridLineSpacing(OverlayOptions options) {
        GridLines gridLines = options.getGridLines();
        ParameterList params = new ParameterList().addDoubleParameter("hSpacing", "Horizontal spacing", gridLines.getSpaceX()).addDoubleParameter("vSpacing", "Vertical spacing", gridLines.getSpaceY()).addBooleanParameter("useMicrons", "Use microns", gridLines.useMicrons());
        if (!GuiTools.showParameterDialog("Set grid spacing", params)) {
            return;
        }
        gridLines = new GridLines();
        gridLines.setSpaceX(params.getDoubleParameterValue("hSpacing"));
        gridLines.setSpaceY(params.getDoubleParameterValue("vSpacing"));
        gridLines.setUseMicrons(params.getBooleanParameterValue("useMicrons"));
        options.gridLinesProperty().set((Object)gridLines);
    }

    public static File requestUserDirectory(boolean promptIfMissing) {
        UserDirectoryManager manager = UserDirectoryManager.getInstance();
        Path pathUser = manager.getUserPath();
        if (pathUser != null && Files.isDirectory(pathUser, new LinkOption[0])) {
            return pathUser.toFile();
        }
        if (!promptIfMissing) {
            return null;
        }
        File dirDefault = PathPrefs.getDefaultQuPathUserDirectory().toFile();
        Object msg = dirDefault.exists() ? dirDefault.getAbsolutePath() + " already exists.\nDo you want to use this default, or specify another directory?" : String.format("Do you want to create a new user directory at\n %s?", dirDefault.getAbsolutePath());
        ButtonType btUseDefault = new ButtonType("Use default", ButtonBar.ButtonData.YES);
        ButtonType btChooseDirectory = new ButtonType("Choose directory", ButtonBar.ButtonData.NO);
        ButtonType btCancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType result = Dialogs.builder().title("Choose user directory").headerText("No user directory set").contentText((String)msg).buttons(new ButtonType[]{btUseDefault, btChooseDirectory, btCancel}).showAndWait().orElse(btCancel);
        if (result == btCancel) {
            logger.info("Dialog cancelled - no user directory set");
            return null;
        }
        if (result == btUseDefault) {
            if (!dirDefault.exists() && !dirDefault.mkdirs()) {
                Dialogs.showErrorMessage((String)"Extension error", (String)("Unable to create directory at \n" + dirDefault.getAbsolutePath()));
                return null;
            }
            pathUser = dirDefault.toPath();
        } else {
            File dirUser = FileChoosers.promptForDirectory((String)"Set user directory", (File)dirDefault);
            if (dirUser == null) {
                logger.info("No QuPath user directory set!");
                return null;
            }
            pathUser = dirUser.toPath();
        }
        manager.setUserPath(pathUser);
        return pathUser.toFile();
    }

    public static void reloadImageData(QuPathGUI qupath, ImageData<BufferedImage> imageData) {
        File savedFile;
        if (imageData == null) {
            GuiTools.showNoImageError("Reload data");
            return;
        }
        QuPathViewer viewer = qupath.getAllViewers().stream().filter(v -> v.getImageData() == imageData).findFirst().orElse(null);
        if (viewer == null) {
            Dialogs.showErrorMessage((String)"Reload data", (String)"Specified image data not found open in any viewer!");
            return;
        }
        File file = savedFile = imageData.getLastSavedPath() == null ? null : new File(imageData.getLastSavedPath());
        if (savedFile == null || !savedFile.isFile()) {
            Dialogs.showErrorMessage((String)"Reload", (String)"No previously saved data found!");
            return;
        }
        if (Dialogs.showConfirmDialog((String)"Reload", (String)"Reload last saved version?\nAny unsaved changes will be lost.")) {
            try {
                ImageData imageDataNew;
                ProjectImageEntry entry;
                Project<BufferedImage> project = qupath.getProject();
                ProjectImageEntry projectImageEntry = entry = project == null ? null : project.getEntry(imageData);
                if (entry != null) {
                    logger.info("Reloading image data from project entry: {}", (Object)entry);
                    imageDataNew = entry.readImageData();
                } else {
                    logger.info("Reverting to last saved version: {}", (Object)savedFile.getAbsolutePath());
                    imageDataNew = PathIO.readImageData((File)savedFile, (ImageServer)imageData.getServer());
                }
                viewer.setImageData((ImageData<BufferedImage>)imageDataNew);
            }
            catch (Exception e) {
                Dialogs.showErrorMessage((String)"Reload", (String)("Error reverting to previously saved file\n\n" + e.getLocalizedMessage()));
            }
        }
    }

    public static void promptToAddShapeFeatures(QuPathGUI qupath) {
        CheckListView listView = new CheckListView();
        listView.getItems().setAll((Object[])ObjectMeasurements.ShapeFeatures.values());
        listView.getCheckModel().checkAll();
        listView.setCellFactory(view -> {
            CheckBoxListCell cell = new CheckBoxListCell(item -> listView.getItemBooleanProperty(item));
            cell.focusedProperty().addListener((o, ov, nv) -> {
                Parent parent;
                if (nv.booleanValue() && (parent = cell.getParent()) != null) {
                    parent.requestFocus();
                }
            });
            return cell;
        });
        listView.setPrefHeight((double)Math.min(listView.getItems().size() * 30, 320));
        BorderPane pane = new BorderPane((Node)listView);
        listView.setTooltip(new Tooltip("Choose shape features"));
        Label label = new Label("Add shape features to selected objects.\nNote that not all measurements are compatible with all objects.");
        label.setTextAlignment(TextAlignment.CENTER);
        label.setPadding(new Insets(10.0));
        pane.setTop((Node)label);
        Button btnSelectAll = new Button("Select all");
        btnSelectAll.setOnAction(e -> listView.getCheckModel().checkAll());
        Button btnSelectNone = new Button("Select none");
        btnSelectNone.setOnAction(e -> listView.getCheckModel().clearChecks());
        btnSelectAll.setMaxWidth(Double.MAX_VALUE);
        btnSelectNone.setMaxWidth(Double.MAX_VALUE);
        pane.setBottom((Node)GridPaneUtils.createColumnGrid((Node[])new Node[]{btnSelectAll, btnSelectNone}));
        Dialog dialog = Dialogs.builder().title("Shape features").content((Node)pane).modality(Modality.NONE).buttons(new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL}).build();
        Button btnApply = (Button)dialog.getDialogPane().lookupButton(ButtonType.APPLY);
        btnApply.disableProperty().bind((ObservableValue)qupath.imageDataProperty().isNull());
        btnApply.setOnAction(e -> Commands.requestShapeFeatures(qupath.getImageData(), (Collection<ObjectMeasurements.ShapeFeatures>)listView.getCheckModel().getCheckedItems()));
        dialog.show();
    }

    private static void requestShapeFeatures(ImageData<?> imageData, Collection<ObjectMeasurements.ShapeFeatures> features) {
        if (imageData == null) {
            return;
        }
        ObjectMeasurements.ShapeFeatures[] featureArray = (ObjectMeasurements.ShapeFeatures[])features.toArray(ObjectMeasurements.ShapeFeatures[]::new);
        if (featureArray.length == 0) {
            return;
        }
        Collection selected = imageData.getHierarchy().getSelectionModel().getSelectedObjects();
        if (selected.isEmpty()) {
            Dialogs.showWarningNotification((String)"Shape features", (String)"No objects selected!");
        } else {
            selected = new ArrayList(selected);
            String featureString = Arrays.stream(featureArray).map(f -> "\"" + f.name() + "\"").collect(Collectors.joining(", "));
            QP.addShapeMeasurements(imageData, (Collection)selected, (ObjectMeasurements.ShapeFeatures[])featureArray);
            imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Add shape measurements", String.format("addShapeMeasurements(%s)", featureString)));
            if (selected.size() == 1) {
                Dialogs.showInfoNotification((String)"Shape features", (String)"Shape features calculated for one object");
            } else {
                Dialogs.showInfoNotification((String)"Shape features", (String)("Shape features calculated for " + selected.size() + " objects"));
            }
        }
    }

    public static void convertDetectionsToPoints(ImageData<?> imageData, boolean preferNucleus) {
        if (imageData == null) {
            GuiTools.showNoImageError("Convert detections to points");
            return;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        Collection pathObjects = hierarchy.getDetectionObjects();
        if (pathObjects.isEmpty()) {
            Dialogs.showErrorMessage((String)"Detections to points", (String)"No detections found!");
            return;
        }
        Iterator iter = pathObjects.iterator();
        while (iter.hasNext()) {
            if (((PathObject)iter.next()).hasROI()) continue;
            iter.remove();
        }
        if (pathObjects.isEmpty()) {
            logger.warn("No detections found with ROIs!");
            return;
        }
        String message = pathObjects.size() == 1 ? "Delete detection after converting to a point?" : String.format("Delete %d detections after converting to points?", pathObjects.size());
        ButtonType button = Dialogs.showYesNoCancelDialog((String)"Detections to points", (String)message);
        if (button == ButtonType.CANCEL) {
            return;
        }
        boolean deleteDetections = button == ButtonType.YES;
        PathObjectTools.convertToPoints((PathObjectHierarchy)hierarchy, (Collection)pathObjects, (boolean)preferNucleus, (boolean)deleteDetections);
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Convert detections to points", "convertDetectionsToPoints()"));
        if (deleteDetections) {
            imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Delete detections", "removeDetections()"));
        }
    }

    public static void promptToSimplifySelectedAnnotations(ImageData<?> imageData, double altitudeThreshold) {
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        List<PathObject> pathObjects = hierarchy.getSelectionModel().getSelectedObjects().stream().filter(p -> p.isAnnotation() && p.hasROI() && p.isEditable() && !p.getROI().isPoint()).toList();
        if (pathObjects.isEmpty()) {
            Dialogs.showErrorMessage((String)"Simplify annotations", (String)"No unlocked shape annotations selected!");
            return;
        }
        String input = Dialogs.showInputDialog((String)"Simplify shape", (String)"Set altitude threshold in pixels.\nHigher values give simpler shapes.", (String)Double.toString(altitudeThreshold));
        if (input == null || !(input instanceof String) || input.trim().length() == 0) {
            return;
        }
        try {
            altitudeThreshold = Double.parseDouble(input.trim());
        }
        catch (NumberFormatException e) {
            logger.error("Could not parse altitude threshold from {}", (Object)input);
            return;
        }
        if (altitudeThreshold <= 0.0) {
            Dialogs.showErrorMessage((String)"Simplify shape", (String)"Amplitude threshold should be greater than zero!");
            return;
        }
        long startTime = System.currentTimeMillis();
        QP.simplifySpecifiedAnnotations(pathObjects, (double)altitudeThreshold);
        long endTime = System.currentTimeMillis();
        logger.debug("Shapes simplified in " + (endTime - startTime) + " ms");
        hierarchy.fireObjectsChangedEvent((Object)hierarchy, pathObjects);
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Simplify selected annotations", "simplifySelectedAnnotations(" + altitudeThreshold + ")"));
    }

    public static void selectObjectsOnCurrentPlane(QuPathViewer viewer) {
        if (viewer == null) {
            return;
        }
        ImageData<BufferedImage> imageData = viewer.getImageData();
        if (imageData == null) {
            return;
        }
        int z = viewer.getZPosition();
        int t = viewer.getTPosition();
        QP.selectObjectsByPlane((int)z, (int)t);
        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Select objects on plane", String.format("selectObjectsByPlane(%d, %d)", z, t)));
    }

    public static void selectAllObjects(ImageData<?> imageData) {
        QP.selectAllObjects((PathObjectHierarchy)imageData.getHierarchy(), (boolean)false);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("includeRootObject", "false");
        DefaultScriptableWorkflowStep newStep = new DefaultScriptableWorkflowStep("Select all objects", map, "selectAllObjects(false)");
        imageData.getHistoryWorkflow().addStep((WorkflowStep)newStep);
    }

    public static void selectObjectsByClass(ImageData<?> imageData, Class<? extends PathObject> cls) {
        if (cls == TMACoreObject.class) {
            QP.selectTMACores((PathObjectHierarchy)imageData.getHierarchy());
        } else {
            QP.selectObjectsByClass((PathObjectHierarchy)imageData.getHierarchy(), cls);
        }
        Map<String, String> params = Collections.singletonMap("Type", PathObjectTools.getSuitableName(cls, (boolean)false));
        Object method = cls == PathAnnotationObject.class ? "selectAnnotations();" : (cls == PathDetectionObject.class ? "selectDetections();" : (cls == TMACoreObject.class ? "selectTMACores();" : (cls == PathCellObject.class ? "selectCells();" : (cls == PathTileObject.class ? "selectTiles();" : "selectObjectsByClass(" + cls.getName() + ");"))));
        DefaultScriptableWorkflowStep newStep = new DefaultScriptableWorkflowStep("Select objects by class", params, (String)method);
        WorkflowStep lastStep = imageData.getHistoryWorkflow().getLastStep();
        if (newStep.equals((Object)lastStep)) {
            imageData.getHistoryWorkflow().replaceLastStep((WorkflowStep)newStep);
        } else {
            imageData.getHistoryWorkflow().addStep((WorkflowStep)newStep);
        }
    }

    public static void resetSelection(ImageData<?> imageData) {
        if (imageData == null) {
            logger.warn("No image available!");
            return;
        }
        imageData.getHierarchy().getSelectionModel().clearSelection();
        String method = "resetSelection()";
        DefaultScriptableWorkflowStep newStep = new DefaultScriptableWorkflowStep("Reset selection", method);
        WorkflowStep lastStep = imageData.getHistoryWorkflow().getLastStep();
        if (newStep.equals((Object)lastStep)) {
            imageData.getHistoryWorkflow().replaceLastStep((WorkflowStep)newStep);
        } else {
            imageData.getHistoryWorkflow().addStep((WorkflowStep)newStep);
        }
    }

    public static void resetClassifications(ImageData<?> imageData, Class<? extends PathObject> cls) {
        if (imageData == null) {
            logger.warn("No classifications to reset!");
            return;
        }
        QP.resetClassifications((PathObjectHierarchy)imageData.getHierarchy(), cls);
        Map<String, String> params = Collections.singletonMap("Type", PathObjectTools.getSuitableName(cls, (boolean)false));
        Object method = cls == PathDetectionObject.class ? "resetDetectionClassifications();" : "resetClassifications(" + cls.getName() + ");";
        DefaultScriptableWorkflowStep newStep = new DefaultScriptableWorkflowStep("Reset classifications", params, (String)method);
        WorkflowStep lastStep = imageData.getHistoryWorkflow().getLastStep();
        if (newStep.equals((Object)lastStep)) {
            imageData.getHistoryWorkflow().replaceLastStep((WorkflowStep)newStep);
        } else {
            imageData.getHistoryWorkflow().addStep((WorkflowStep)newStep);
        }
    }

    public static Stage createWorkflowDisplayDialog(QuPathGUI qupath) {
        WorkflowCommandLogView view = new WorkflowCommandLogView(qupath);
        Stage dialog = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)dialog);
        dialog.setMinHeight(200.0);
        dialog.setMinWidth(200.0);
        dialog.initOwner((javafx.stage.Window)qupath.getStage());
        dialog.setTitle("Workflow viewer");
        Pane pane = view.getPane();
        dialog.setScene(new Scene((Parent)pane, 400.0, 400.0));
        return dialog;
    }

    public static void showWorkflowScript(QuPathGUI qupath, ImageData<?> imageData) {
        if (imageData == null) {
            GuiTools.showNoImageError("Show workflow script");
            return;
        }
        WorkflowCommandLogView.showScript(qupath.getScriptEditor(), imageData.getHistoryWorkflow());
    }

    public static void showScriptEditor(QuPathGUI qupath) {
        ScriptEditor scriptEditor = qupath.getScriptEditor();
        if (scriptEditor == null) {
            Dialogs.showErrorMessage((String)"Script editor", (String)"No script editor found!");
            return;
        }
        if (scriptEditor instanceof Window && ((Window)((Object)scriptEditor)).isShowing()) {
            ((Window)((Object)scriptEditor)).toFront();
        } else {
            scriptEditor.showEditor();
        }
    }

    public static Stage createMemoryMonitorDialog(QuPathGUI qupath) {
        return new MemoryMonitorDialog(qupath).getStage();
    }

    public static void showMiniViewer(QuPathViewer viewer) {
        if (viewer == null) {
            return;
        }
        MiniViewers.createDialog(viewer, false).show();
    }

    public static void showChannelViewer(QuPathViewer viewer) {
        if (viewer == null) {
            return;
        }
        MiniViewers.createDialog(viewer, true).show();
    }

    public static void refreshObjectIDs(ImageData<?> imageData, boolean duplicatesOnly) {
        if (imageData == null) {
            return;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        if (duplicatesOnly) {
            QP.refreshDuplicateIDs((PathObjectHierarchy)hierarchy);
            imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Refresh duplicate IDs", "refreshDuplicateIDs()"));
        } else {
            QP.refreshIDs((PathObjectHierarchy)hierarchy);
            imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Refresh duplicate IDs", "refreshIDs()"));
        }
    }

    public static void runObjectImport(QuPathGUI qupath, ImageData<BufferedImage> imageData) {
        InteractiveObjectImporter.promptToImportObjectsFromFile(imageData, null);
    }

    public static void copySelectedObjectsToClipboard(ImageData<BufferedImage> imageData) {
        Set selected = imageData == null ? null : imageData.getHierarchy().getSelectionModel().getSelectedObjects();
        Commands.copyObjectsToClipboard(selected);
    }

    public static void copyAnnotationsToClipboard(ImageData<BufferedImage> imageData) {
        Collection annotations = imageData == null ? null : imageData.getHierarchy().getAnnotationObjects();
        Commands.copyObjectsToClipboard(annotations);
    }

    private static void copyObjectsToClipboard(Collection<? extends PathObject> pathObjects) {
        String json;
        if (pathObjects == null || pathObjects.isEmpty()) {
            return;
        }
        int max = PathPrefs.maxObjectsToClipboardProperty().get();
        if (max >= 0 && max < pathObjects.size()) {
            Dialogs.showWarningNotification((String)"Copy objects to clipboard", (String)String.format("Number of selected objects (%d) exceeds the maximum that can be copied (%d)!\nEither export the objects to a GeoJSON file, or increase the maximum number of clipboard objects in the preferences.", pathObjects.size(), max));
            return;
        }
        try {
            if (pathObjects.size() == 1) {
                gson = GsonTools.getInstance((boolean)true);
                json = gson.toJson((Object)pathObjects.iterator().next());
            } else {
                gson = GsonTools.getInstance((boolean)false);
                StringWriter writer = new StringWriter();
                JsonWriter jsonWriter = gson.newJsonWriter((Writer)writer);
                jsonWriter.setIndent(" ");
                FeatureCollection features = FeatureCollection.wrap(pathObjects);
                gson.toJson((Object)features, features.getClass(), jsonWriter);
                json = writer.toString();
            }
        }
        catch (Exception e) {
            return;
        }
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(json);
        DataFormat format = InteractiveObjectImporter.getGeoJsonDataFormat();
        if (format != null) {
            content.put((Object)format, (Object)json);
        }
        clipboard.setContent((Map)content);
    }

    public static void pasteFromClipboard(QuPathGUI qupath, boolean addToCurrentPlane) {
        ImageData<BufferedImage> imageData;
        QuPathViewer viewer = qupath.getViewer();
        ImageData<BufferedImage> imageData2 = imageData = viewer == null ? null : viewer.getImageData();
        if (imageData != null) {
            try {
                List<PathObject> pathObjects = InteractiveObjectImporter.readObjectsFromClipboard(imageData);
                if (addToCurrentPlane) {
                    ImagePlane plane = viewer.getImagePlane();
                    pathObjects = pathObjects.stream().map(p -> PathObjectTools.updatePlane((PathObject)p, (ImagePlane)plane, (boolean)false, (boolean)true)).toList();
                }
                if (!pathObjects.isEmpty()) {
                    InteractiveObjectImporter.promptToImportObjects(imageData.getHierarchy(), pathObjects);
                    return;
                }
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        String text = (String)Clipboard.getSystemClipboard().getContent(DataFormat.PLAIN_TEXT);
        if (!addToCurrentPlane && text != null && !text.isEmpty() && qupath.getScriptEditor() != null) {
            qupath.getScriptEditor().showScript("Clipboard text", text);
        }
    }

    public static void runGeoJsonObjectExport(QuPathGUI qupath, ImageData<BufferedImage> imageData) {
        try {
            ExportObjectsCommand.runGeoJsonExport(qupath);
        }
        catch (IOException e) {
            Dialogs.showErrorNotification((String)"Export error", (String)e.getLocalizedMessage());
        }
    }

    private static /* synthetic */ String lambda$promptToExportImageRegion$5(ObservableDoubleValue downsample, Label labelSize, double regionWidth, double regionHeight, ComboBox comboImageType, long maxPixels) throws Exception {
        boolean supportsPyramid;
        if (!Double.isFinite(downsample.get())) {
            labelSize.setStyle("-fx-text-fill: red;");
            return "Invalid downsample value!  Must be >= 1";
        }
        long w = (long)(regionWidth / downsample.get() + 0.5);
        long h = (long)(regionHeight / downsample.get() + 0.5);
        String warning = "";
        ImageWriter writer = (ImageWriter)comboImageType.getSelectionModel().getSelectedItem();
        boolean bl = supportsPyramid = writer == null ? false : writer.supportsPyramidal();
        if (!supportsPyramid && w * h > maxPixels) {
            labelSize.setStyle("-fx-text-fill: red;");
            warning = " (too big!)";
        } else if (w < 5L || h < 5L) {
            labelSize.setStyle("-fx-text-fill: red;");
            warning = " (too small!)";
        } else {
            labelSize.setStyle(null);
        }
        return String.format("Output image size: %d x %d pixels%s", w, h, warning);
    }

    static class SingleStageCommand {
        private Stage stage;
        private Supplier<Stage> supplier;

        SingleStageCommand(Supplier<Stage> supplier) {
            this.supplier = supplier;
        }

        void show() {
            if (this.stage == null) {
                this.stage = this.supplier.get();
            }
            if (this.stage.isShowing()) {
                this.stage.toFront();
            } else {
                this.stage.show();
            }
        }
    }
}

