/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.commands;

import com.google.gson.JsonElement;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.Window;
import jfxtras.scene.layout.HBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.display.ChannelDisplayInfo;
import qupath.lib.display.ImageDisplay;
import qupath.lib.display.settings.DisplaySettingUtils;
import qupath.lib.display.settings.ImageDisplaySettings;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.InfoMessage;
import qupath.lib.gui.commands.display.BrightnessContrastChannelPane;
import qupath.lib.gui.commands.display.BrightnessContrastHistogramPane;
import qupath.lib.gui.commands.display.BrightnessContrastSettingsPane;
import qupath.lib.gui.commands.display.BrightnessContrastSliderPane;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;

public class BrightnessContrastCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(BrightnessContrastCommand.class);
    private static final String WARNING_STYLE_CLASS = "warn-label-text";
    private static final double BUTTON_SPACING = 5.0;
    private final QuPathGUI qupath;
    private final ObjectProperty<QuPathViewer> viewerProperty = new SimpleObjectProperty();
    private final ObjectProperty<ImageData<BufferedImage>> imageDataProperty = new SimpleObjectProperty();
    private final ObjectProperty<ImageDisplay> imageDisplayProperty = new SimpleObjectProperty();
    private final ImageDataPropertyChangeListener imageDataPropertyChangeListener = new ImageDataPropertyChangeListener();
    private final ImageDisplayTimestampListener timestampChangeListener = new ImageDisplayTimestampListener();
    private final ObjectProperty<ChannelDisplayInfo> currentChannelProperty = new SimpleObjectProperty();
    private final Stage dialog;
    private final BrightnessContrastChannelPane table = new BrightnessContrastChannelPane();
    private final BooleanProperty showGrayscale = new SimpleBooleanProperty(false);
    private final BooleanProperty invertBackground = new SimpleBooleanProperty(false);
    private final BooleanBinding blockChannelAdjustment = this.table.currentChannelVisible().not();
    private final BrightnessContrastHistogramPane chartPane = new BrightnessContrastHistogramPane();
    private final BrightnessContrastKeyTypedListener keyListener = new BrightnessContrastKeyTypedListener();
    private BrightnessContrastSliderPane sliderPane;
    private BrightnessContrastSettingsPane settingsPane;
    private ObservableList<String> warningList = FXCollections.observableArrayList();
    private ObjectExpression<InfoMessage> infoMessage = Bindings.createObjectBinding(() -> {
        if (this.warningList.isEmpty()) {
            return null;
        }
        return InfoMessage.warning((ObservableNumberValue)new SimpleIntegerProperty(this.warningList.size()));
    }, (Observable[])new Observable[]{this.warningList});

    public BrightnessContrastCommand(QuPathGUI qupath) {
        this.qupath = qupath;
        this.currentChannelProperty.bind(this.table.currentChannelProperty());
        this.viewerProperty.bind(qupath.viewerProperty());
        this.imageDataProperty.bind(this.viewerProperty.flatMap(QuPathViewer::imageDataProperty));
        this.imageDisplayProperty.bind(this.viewerProperty.map(QuPathViewer::getImageDisplay));
        this.viewerProperty.addListener(this::handleViewerChanged);
        this.imageDataProperty.addListener(this::handleImageDataChange);
        this.imageDisplayProperty.addListener(this::handleImageDisplayChanged);
        this.table.disableToggleMenuItemsProperty().bind((ObservableValue)this.showGrayscale);
        this.currentChannelProperty.addListener((v, o, n) -> this.chartPane.updateHistogram((ImageDisplay)this.imageDisplayProperty.get(), (ChannelDisplayInfo)n));
        this.chartPane.updateHistogram((ImageDisplay)this.imageDisplayProperty.get(), (ChannelDisplayInfo)this.currentChannelProperty.get());
        this.dialog = this.createDialog();
        qupath.getDefaultDragDropListener().addJsonDropHandler(this::handleDisplaySettingsDrop);
    }

    private boolean handleDisplaySettingsDrop(QuPathViewer viewer, List<JsonElement> elements) {
        if (elements.size() != 1 || viewer == null || viewer.getImageDisplay() == null) {
            return false;
        }
        JsonElement element = elements.get(0);
        ImageDisplaySettings settings = DisplaySettingUtils.parseDisplaySettings(element).orElse(null);
        if (settings != null) {
            if (DisplaySettingUtils.applySettingsToDisplay(viewer.getImageDisplay(), settings)) {
                this.maybeSyncSettingsAcrossViewers(viewer.getImageDisplay());
                logger.info("Applied display settings: {}", (Object)settings.getName());
            } else {
                logger.warn("Unable to apply display settings: {}", (Object)settings.getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        ChannelDisplayInfo channel;
        if (!this.dialog.isShowing()) {
            this.dialog.show();
            this.chartPane.updateHistogram((ImageDisplay)this.imageDisplayProperty.get(), (ChannelDisplayInfo)this.currentChannelProperty.get());
        }
        if (this.table.getSelectionModel().isEmpty() && (channel = (ChannelDisplayInfo)this.currentChannelProperty.get()) != null) {
            this.table.getSelectionModel().select((Object)channel);
        }
    }

    private Stage createDialog() {
        if (this.dialog != null) {
            throw new RuntimeException("createDialog() called after initialization!");
        }
        this.table.imageDisplayProperty().bind(this.imageDisplayProperty);
        this.sliderPane = new BrightnessContrastSliderPane();
        this.sliderPane.imageDisplayProperty().bind(this.imageDisplayProperty);
        this.sliderPane.selectedChannelProperty().bind(this.currentChannelProperty);
        this.sliderPane.disableMinMaxAdjustmentProperty().bind((ObservableValue)this.blockChannelAdjustment);
        PathPrefs.keepDisplaySettingsProperty().addListener((v, o, n) -> this.maybeSyncSettingsAcrossViewers());
        this.handleImageDataChange(null, null, this.qupath.getImageData());
        Stage dialog = new Stage();
        dialog.initOwner((Window)this.qupath.getStage());
        FXUtils.addCloseWindowShortcuts((Stage)dialog);
        dialog.setTitle("Brightness & contrast");
        GridPane pane = new GridPane();
        int row = 0;
        pane.add((Node)this.table, 0, row++);
        GridPane.setFillHeight((Node)this.table, (Boolean)Boolean.TRUE);
        GridPane.setVgrow((Node)this.table, (Priority)Priority.ALWAYS);
        this.settingsPane = new BrightnessContrastSettingsPane();
        this.settingsPane.resourceManagerProperty().bind(this.qupath.projectProperty().map(DisplaySettingUtils::getResourcesForProject));
        pane.add((Node)this.settingsPane, 0, row++);
        Pane paneCheck = this.createCheckboxPane();
        paneCheck.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        pane.add((Node)paneCheck, 0, row++);
        pane.add((Node)BrightnessContrastCommand.createSeparator(), 0, row++);
        this.chartPane.minValueProperty().bindBidirectional((Property)this.sliderPane.minValueProperty());
        this.chartPane.maxValueProperty().bindBidirectional((Property)this.sliderPane.maxValueProperty());
        this.chartPane.disableProperty().bind((ObservableValue)this.blockChannelAdjustment);
        pane.add((Node)this.chartPane, 0, row++);
        GridPane paneChannels = new GridPane();
        paneChannels.setHgap(4.0);
        Label labelChannel = new Label();
        labelChannel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            ChannelDisplayInfo selected = (ChannelDisplayInfo)this.table.currentChannelProperty().get();
            return selected == null ? "" : selected.getName();
        }, (Observable[])new Observable[]{this.table.currentChannelProperty()}));
        labelChannel.setStyle("-fx-font-weight: bold;");
        paneChannels.add((Node)labelChannel, 0, 0);
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{labelChannel});
        GridPane.setHgrow((Node)labelChannel, (Priority)Priority.SOMETIMES);
        Label labelChannelHidden = new Label();
        labelChannelHidden.setText("(hidden)");
        labelChannelHidden.visibleProperty().bind((ObservableValue)this.currentChannelProperty.isNotNull().and((ObservableBooleanValue)this.table.currentChannelVisible().not()));
        labelChannelHidden.setStyle("-fx-font-weight: bold; -fx-font-style: italic; -fx-font-size: 90%;");
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{labelChannelHidden});
        paneChannels.add((Node)labelChannelHidden, 1, 0);
        CheckBox cbLogHistogram = new CheckBox("Log histogram");
        cbLogHistogram.selectedProperty().bindBidirectional((Property)this.chartPane.doLogCountsProperty());
        cbLogHistogram.setTooltip(new Tooltip("Show log values of histogram counts.\nThis can help to see differences when the histogram values are low relative to the mode."));
        paneChannels.add((Node)cbLogHistogram, 2, 0);
        pane.add((Node)paneChannels, 0, row++);
        this.sliderPane.prefWidthProperty().bind((ObservableValue)pane.widthProperty());
        pane.add((Node)this.sliderPane, 0, row++);
        Pane paneButtons = this.createAutoResetButtonPane();
        pane.add((Node)paneButtons, 0, row++);
        pane.add((Node)BrightnessContrastCommand.createSeparator(), 0, row++);
        Pane paneKeepSettings = BrightnessContrastCommand.createKeepSettingsPane();
        pane.add((Node)paneKeepSettings, 0, row++);
        Pane paneWarnings = this.createWarningPane();
        pane.add((Node)paneWarnings, 0, row++);
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        pane.setVgap(5.0);
        Scene scene = new Scene((Parent)pane);
        scene.addEventHandler(KeyEvent.KEY_TYPED, (EventHandler)this.keyListener);
        dialog.setScene(scene);
        dialog.setMinWidth(300.0);
        dialog.setMinHeight(600.0);
        FXUtils.addCloseWindowShortcuts((Stage)dialog);
        this.table.updateTable();
        if (!this.table.isEmpty()) {
            this.table.getSelectionModel().select(0);
        }
        this.table.setShowChannel((ChannelDisplayInfo)this.currentChannelProperty.get());
        this.updateSliders();
        dialog.focusedProperty().addListener(this::handleDialogFocusChanged);
        paneWarnings.heightProperty().addListener((v, o, n) -> dialog.setHeight(dialog.getHeight() + n.doubleValue() - o.doubleValue()));
        return dialog;
    }

    private static Separator createSeparator() {
        Separator separator = new Separator();
        return separator;
    }

    private static Pane createKeepSettingsPane() {
        CheckBox cbKeepDisplaySettings = new CheckBox("Apply to similar images");
        cbKeepDisplaySettings.selectedProperty().bindBidirectional((Property)PathPrefs.keepDisplaySettingsProperty());
        cbKeepDisplaySettings.setTooltip(new Tooltip("Retain same display settings where possible when opening similar images"));
        return new BorderPane((Node)cbKeepDisplaySettings);
    }

    private Pane createAutoResetButtonPane() {
        Button btnAuto = new Button("Auto");
        btnAuto.setOnAction(this::handleAutoButtonClicked);
        btnAuto.disableProperty().bind((ObservableValue)this.blockChannelAdjustment);
        Button btnReset = new Button("Reset");
        btnReset.setOnAction(this::handleResetButtonClicked);
        btnReset.disableProperty().bind((ObservableValue)this.blockChannelAdjustment);
        GridPane pane = GridPaneUtils.createColumnGridControls((Node[])new Node[]{btnAuto, btnReset});
        pane.setHgap(5.0);
        return pane;
    }

    private void handleResetButtonClicked(ActionEvent e) {
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty.getValue();
        for (ChannelDisplayInfo info : this.table.getSelectionModel().getSelectedItems()) {
            imageDisplay.setMinMaxDisplay(info, info.getMinAllowed(), info.getMaxAllowed());
        }
        this.sliderPane.resetAllSliders();
    }

    private void handleAutoButtonClicked(ActionEvent e) {
        ImageDisplay imageDisplay = (ImageDisplay)this.imageDisplayProperty.getValue();
        if (imageDisplay == null) {
            return;
        }
        ChannelDisplayInfo channel = (ChannelDisplayInfo)this.currentChannelProperty.get();
        double saturation = PathPrefs.autoBrightnessContrastSaturationPercentProperty().get() / 100.0;
        imageDisplay.autoSetDisplayRange(channel, saturation);
        for (ChannelDisplayInfo info2 : this.table.getSelectionModel().getSelectedItems()) {
            imageDisplay.autoSetDisplayRange(info2, saturation);
        }
        this.updateSliders();
    }

    public ObjectExpression infoMessage() {
        return this.infoMessage;
    }

    private Pane createWarningPane() {
        Label labelWarning = new Label("Inverted background - interpret colors cautiously!");
        labelWarning.setTooltip(new Tooltip("Inverting the background uses processing trickery that reduces the visual information in the image.\nBe careful about interpreting colors, especially for images with multiple channels"));
        labelWarning.getStyleClass().add((Object)WARNING_STYLE_CLASS);
        labelWarning.setAlignment(Pos.CENTER);
        labelWarning.setTextAlignment(TextAlignment.CENTER);
        labelWarning.visibleProperty().bind((ObservableValue)this.invertBackground.and((ObservableBooleanValue)this.showGrayscale.not()));
        labelWarning.setMaxWidth(Double.MAX_VALUE);
        labelWarning.managedProperty().bind((ObservableValue)labelWarning.visibleProperty());
        labelWarning.visibleProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.warningList.add((Object)labelWarning.getText());
            } else {
                this.warningList.remove((Object)labelWarning.getText());
            }
        });
        if (labelWarning.isVisible()) {
            this.warningList.add((Object)labelWarning.getText());
        }
        Label labelWarningGamma = new Label("Gamma is not equal to 1.0 - shift+click to reset");
        labelWarningGamma.setOnMouseClicked(this::handleGammaWarningClicked);
        labelWarningGamma.setTooltip(new Tooltip("Adjusting the gamma results in a nonlinear contrast adjustment -\nin science, such changes should usually be disclosed in any figure legends"));
        labelWarningGamma.getStyleClass().add((Object)WARNING_STYLE_CLASS);
        labelWarningGamma.setAlignment(Pos.CENTER);
        labelWarningGamma.setTextAlignment(TextAlignment.CENTER);
        labelWarningGamma.visibleProperty().bind((ObservableValue)this.sliderPane.gammaValueProperty().isNotEqualTo(1.0, 0.0));
        labelWarningGamma.setMaxWidth(Double.MAX_VALUE);
        labelWarningGamma.managedProperty().bind((ObservableValue)labelWarningGamma.visibleProperty());
        labelWarningGamma.visibleProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.warningList.add((Object)labelWarningGamma.getText());
            } else {
                this.warningList.remove((Object)labelWarningGamma.getText());
            }
        });
        if (labelWarningGamma.isVisible()) {
            this.warningList.add((Object)labelWarningGamma.getText());
        }
        VBox vboxWarnings = new VBox();
        vboxWarnings.getChildren().setAll((Object[])new Node[]{labelWarning, labelWarningGamma});
        return vboxWarnings;
    }

    private Pane createCheckboxPane() {
        CheckBox cbShowGrayscale = new CheckBox("Show grayscale");
        cbShowGrayscale.selectedProperty().bindBidirectional((Property)this.showGrayscale);
        cbShowGrayscale.setTooltip(new Tooltip("Show single channel with grayscale lookup table"));
        CheckBox cbInvertBackground = new CheckBox("Invert background");
        cbInvertBackground.selectedProperty().bindBidirectional((Property)this.invertBackground);
        cbInvertBackground.setTooltip(new Tooltip("Invert the background for display (i.e. switch between white and black).\nUse cautiously to avoid becoming confused about how the 'original' image looks (e.g. brightfield or fluorescence)."));
        HBox paneCheck = new HBox();
        paneCheck.setAlignment(Pos.CENTER);
        paneCheck.getChildren().add((Object)cbShowGrayscale);
        paneCheck.getChildren().add((Object)cbInvertBackground);
        paneCheck.setSpacing(10.0);
        paneCheck.setMaxHeight(Double.MAX_VALUE);
        return paneCheck;
    }

    private void handleGammaWarningClicked(MouseEvent e) {
        if (e.isShiftDown()) {
            this.sliderPane.gammaValueProperty().setValue((Number)1.0);
        }
    }

    private void handleDialogFocusChanged(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            this.updateSliders();
        }
    }

    private void maybeSyncSettingsAcrossViewers() {
        QuPathViewer viewer = (QuPathViewer)this.viewerProperty.get();
        if (viewer != null && viewer.hasServer()) {
            this.maybeSyncSettingsAcrossViewers(viewer.getImageDisplay());
        }
    }

    private void maybeSyncSettingsAcrossViewers(ImageDisplay display) {
        if (display == null || !PathPrefs.keepDisplaySettingsProperty().get()) {
            return;
        }
        for (QuPathViewer otherViewer : this.qupath.getAllViewers()) {
            if (!otherViewer.hasServer() || Objects.equals(display, otherViewer.getImageDisplay())) continue;
            otherViewer.getImageDisplay().updateFromDisplay(display);
        }
    }

    private void updateSliders() {
        this.sliderPane.refreshSliders();
    }

    private void handleViewerChanged(ObservableValue<? extends QuPathViewer> source, QuPathViewer oldValue, QuPathViewer newValue) {
        if (oldValue != null) {
            oldValue.getView().removeEventHandler(KeyEvent.KEY_TYPED, (EventHandler)this.keyListener);
        }
        if (newValue != null) {
            newValue.getView().addEventHandler(KeyEvent.KEY_TYPED, (EventHandler)this.keyListener);
        }
    }

    private void handleImageDisplayChanged(ObservableValue<? extends ImageDisplay> source, ImageDisplay oldValue, ImageDisplay newValue) {
        if (oldValue != null) {
            this.showGrayscale.unbindBidirectional((Property)oldValue.useGrayscaleLutProperty());
            oldValue.useGrayscaleLutProperty().unbindBidirectional((Property)this.showGrayscale);
            this.invertBackground.unbindBidirectional((Property)oldValue.useInvertedBackgroundProperty());
            oldValue.useInvertedBackgroundProperty().unbindBidirectional((Property)this.invertBackground);
            oldValue.switchToGrayscaleChannelProperty().unbind();
            oldValue.eventCountProperty().removeListener((InvalidationListener)this.timestampChangeListener);
        }
        if (newValue != null) {
            this.showGrayscale.bindBidirectional((Property)newValue.useGrayscaleLutProperty());
            this.invertBackground.bindBidirectional((Property)newValue.useInvertedBackgroundProperty());
            newValue.switchToGrayscaleChannelProperty().bind(this.currentChannelProperty);
            newValue.eventCountProperty().addListener((InvalidationListener)this.timestampChangeListener);
        }
        this.settingsPane.imageDisplayObjectProperty().set((Object)newValue);
    }

    private void handleImageDataChange(ObservableValue<? extends ImageData<BufferedImage>> source, ImageData<BufferedImage> oldValue, ImageData<BufferedImage> newValue) {
        if (oldValue != null) {
            oldValue.removePropertyChangeListener((PropertyChangeListener)this.imageDataPropertyChangeListener);
        }
        if (newValue != null) {
            newValue.addPropertyChangeListener((PropertyChangeListener)this.imageDataPropertyChangeListener);
        }
        this.updateSliders();
        Platform.runLater(() -> this.chartPane.updateHistogram((ImageDisplay)this.imageDisplayProperty.get(), (ChannelDisplayInfo)this.currentChannelProperty.get()));
    }

    private class ImageDataPropertyChangeListener
    implements PropertyChangeListener {
        private ImageDataPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("qupath.lib.display.ImageDisplay")) {
                return;
            }
            if (!Platform.isFxApplicationThread()) {
                Platform.runLater(() -> this.propertyChange(evt));
                return;
            }
            logger.trace("Property change: {}", (Object)evt);
            ImageDisplay imageDisplay = (ImageDisplay)BrightnessContrastCommand.this.imageDisplayProperty.getValue();
            if (imageDisplay != null && (evt.getPropertyName().equals("serverMetadata") || evt.getSource() instanceof ImageData && evt.getPropertyName().equals("imageType"))) {
                List<ChannelDisplayInfo> available = List.copyOf(imageDisplay.availableChannels());
                imageDisplay.refreshChannelOptions();
                if (!available.equals(imageDisplay.availableChannels())) {
                    imageDisplay.saveChannelColorProperties();
                }
            }
            BrightnessContrastCommand.this.table.updateTable();
            BrightnessContrastCommand.this.updateSliders();
        }
    }

    class ImageDisplayTimestampListener
    implements InvalidationListener {
        ImageDisplayTimestampListener() {
        }

        public void invalidated(Observable observable) {
            Platform.runLater(() -> BrightnessContrastCommand.this.maybeSyncSettingsAcrossViewers());
        }
    }

    private class BrightnessContrastKeyTypedListener
    implements EventHandler<KeyEvent> {
        private BrightnessContrastKeyTypedListener() {
        }

        public void handle(KeyEvent event) {
            int c;
            ImageDisplay imageDisplay = (ImageDisplay)BrightnessContrastCommand.this.imageDisplayProperty.getValue();
            if (imageDisplay == null || event.getEventType() != KeyEvent.KEY_TYPED) {
                return;
            }
            String character = event.getCharacter();
            if (character != null && !character.isEmpty() && (c = event.getCharacter().charAt(0) - 48) >= 1 && c <= Math.min(9, imageDisplay.availableChannels().size())) {
                if (BrightnessContrastCommand.this.table != null) {
                    BrightnessContrastCommand.this.table.getSelectionModel().clearAndSelect(c - 1);
                }
                BrightnessContrastCommand.this.table.toggleShowHideChannel((ChannelDisplayInfo)imageDisplay.availableChannels().get(c - 1));
                event.consume();
            }
        }
    }
}

