/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.charts;

import java.util.Map;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;

class SnapshotTools {
    SnapshotTools() {
    }

    public static WritableImage makeSnapshot(Scene scene) {
        return scene.snapshot(null);
    }

    public static WritableImage makeSnapshot(Node node) {
        return SnapshotTools.makeScaledSnapshot(node, 1.0);
    }

    public static WritableImage makeScaledSnapshot(Node node, double scale) throws IllegalArgumentException {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale for snapshot must be > 0");
        }
        SnapshotParameters params = new SnapshotParameters();
        if (scale > 0.0 && scale != 1.0) {
            params.setTransform((Transform)new Scale(scale, scale));
        }
        return node.snapshot(params, null);
    }

    public static void copySnapshotToClipboard(Scene scene) {
        WritableImage image = SnapshotTools.makeSnapshot(scene);
        SnapshotTools.copyToClipboard((Image)image);
    }

    public static void copySnapshotToClipboard(Node node) {
        SnapshotTools.copyScaledSnapshotToClipboard(node, 1.0);
    }

    public static void copyScaledSnapshotToClipboard(Node node, double scale) {
        WritableImage image = SnapshotTools.makeScaledSnapshot(node, scale);
        SnapshotTools.copyToClipboard((Image)image);
    }

    public static void copyToClipboard(Image image) throws NullPointerException {
        Objects.requireNonNull(image, "Image must not be null!");
        Clipboard.getSystemClipboard().setContent(Map.of(DataFormat.IMAGE, image));
    }
}

