/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.charts;

import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import org.controlsfx.control.SearchableComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.charts.PathObjectScatterChart;
import qupath.lib.gui.charts.SnapshotTools;
import qupath.lib.gui.measure.PathTableData;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.objects.PathObject;

public class ScatterPlotDisplay {
    private static final Logger logger = LoggerFactory.getLogger(ScatterPlotDisplay.class);
    private static final String KEY = "scatter.plot.";
    private static final IntegerProperty PROP_MAX_POINTS = PathPrefs.createPersistentPreference("scatter.plot.maxPoints", 10000);
    private static final IntegerProperty PROP_SEED = PathPrefs.createPersistentPreference("scatter.plot.seed", 42);
    private static final DoubleProperty PROP_POINT_OPACITY = PathPrefs.createPersistentPreference("scatter.plot.pointOpacity", 1.0);
    private static final DoubleProperty PROP_POINT_RADIUS = PathPrefs.createPersistentPreference("scatter.plot.pointRadius", 1.0);
    private static final BooleanProperty SHOW_AXES = PathPrefs.createPersistentPreference("scatter.plot.showAxes", true);
    private static final BooleanProperty SHOW_GRID = PathPrefs.createPersistentPreference("scatter.plot.showGrid", true);
    private static final BooleanProperty SHOW_LEGEND = PathPrefs.createPersistentPreference("scatter.plot.showLegend", true);
    private static final BooleanProperty AUTORANGE_FULL_DATA = PathPrefs.createPersistentPreference("scatter.plot.autorangeFullData", true);
    private boolean isUpdating = false;
    private final ObjectProperty<PathTableData<PathObject>> model = new SimpleObjectProperty();
    private final SearchableComboBox<String> comboNameX = new SearchableComboBox();
    private final SearchableComboBox<String> comboNameY = new SearchableComboBox();
    private final BorderPane pane = new BorderPane();
    private final PathObjectScatterChart scatter;
    private final ObjectProperty<Double> pointRadius = ScatterPlotDisplay.createWeakBoundProperty(PROP_POINT_RADIUS).asObject();
    private final ObjectProperty<Double> pointOpacity = ScatterPlotDisplay.createWeakBoundProperty(PROP_POINT_OPACITY).asObject();
    private final BooleanProperty showAxes = ScatterPlotDisplay.createWeakBoundProperty(SHOW_AXES);
    private final BooleanProperty showGrid = ScatterPlotDisplay.createWeakBoundProperty(SHOW_GRID);
    private final BooleanProperty showLegend = ScatterPlotDisplay.createWeakBoundProperty(SHOW_LEGEND);
    private final BooleanProperty autorangeFullData = ScatterPlotDisplay.createWeakBoundProperty(AUTORANGE_FULL_DATA);
    private final IntegerProperty maxPoints = ScatterPlotDisplay.createWeakBoundProperty(PROP_MAX_POINTS);
    private final IntegerProperty seed = ScatterPlotDisplay.createWeakBoundProperty(PROP_SEED);
    private final IntegerProperty totalPoints = new SimpleIntegerProperty();

    public ScatterPlotDisplay() {
        this.model.addListener(this::handleModelChange);
        BorderPane panelMain = new BorderPane();
        this.scatter = new PathObjectScatterChart(QuPathGUI.getInstance().getViewer());
        this.scatter.setPointRadius((Double)this.pointRadius.get());
        this.scatter.setPointOpacity((Double)this.pointOpacity.get());
        this.scatter.setRngSeed(this.seed.get());
        this.scatter.setMaxPoints(this.maxPoints.get());
        ContextMenu popup = new ContextMenu();
        MenuItem miCopy = new MenuItem("Copy to clipboard");
        miCopy.setOnAction(e -> SnapshotTools.copyScaledSnapshotToClipboard((Node)this.scatter, 4.0));
        popup.getItems().add((Object)miCopy);
        this.scatter.setOnContextMenuRequested(e -> popup.show(this.scatter.getScene().getWindow(), e.getScreenX(), e.getScreenY()));
        panelMain.setCenter((Node)this.scatter);
        this.initProperties();
        this.comboNameX.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.refreshScatterPlot());
        this.comboNameY.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.refreshScatterPlot());
        GridPane topPane = new GridPane();
        Label labelX = new Label("X");
        this.comboNameX.setTooltip(new Tooltip("X-axis measurement"));
        labelX.setLabelFor(this.comboNameX);
        topPane.addRow(0, new Node[]{labelX, this.comboNameX});
        Label labelY = new Label("Y");
        this.comboNameY.setTooltip(new Tooltip("Y-axis measurement"));
        labelY.setLabelFor(this.comboNameY);
        topPane.addRow(1, new Node[]{labelY, this.comboNameY});
        topPane.setHgap(5.0);
        this.pane.setTop((Node)topPane);
        this.comboNameX.prefWidthProperty().bind((ObservableValue)this.pane.widthProperty());
        this.comboNameY.prefWidthProperty().bind((ObservableValue)this.pane.widthProperty());
        panelMain.setMinSize(200.0, 200.0);
        panelMain.setPrefSize(400.0, 300.0);
        this.pane.setCenter((Node)panelMain);
        this.pane.setBottom((Node)this.createMainOptionsPane());
        this.pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
    }

    private void initProperties() {
        this.pointOpacity.addListener((v, o, n) -> this.scatter.setPointOpacity((double)n));
        this.pointRadius.addListener((v, o, n) -> this.scatter.setPointRadius((double)n));
        this.scatter.verticalGridLinesVisibleProperty().bindBidirectional((Property)this.showGrid);
        this.scatter.horizontalGridLinesVisibleProperty().bindBidirectional((Property)this.showGrid);
        this.scatter.getXAxis().tickLabelsVisibleProperty().bindBidirectional((Property)this.showAxes);
        this.scatter.getYAxis().tickLabelsVisibleProperty().bindBidirectional((Property)this.showAxes);
        this.scatter.legendVisibleProperty().bindBidirectional((Property)this.showLegend);
        this.scatter.autorangeToFullDataProperty().bindBidirectional((Property)this.autorangeFullData);
        this.maxPoints.addListener((v, o, n) -> this.scatter.setMaxPoints(n.intValue()));
        this.seed.addListener((v, o, n) -> this.scatter.setRngSeed(n.intValue()));
    }

    public void setModel(PathTableData<PathObject> model) {
        this.model.set(model);
    }

    public PathTableData<PathObject> getModel() {
        return (PathTableData)this.model.get();
    }

    public ObjectProperty<PathTableData<PathObject>> modelProperty() {
        return this.model;
    }

    private void handleModelChange(ObservableValue<? extends PathTableData<PathObject>> observable, PathTableData<PathObject> oldValue, PathTableData<PathObject> newValue) {
        this.isUpdating = true;
        if (newValue != null) {
            this.updateForModel(newValue);
        }
        this.isUpdating = false;
        this.refreshScatterPlot();
    }

    private void updateForModel(PathTableData<PathObject> newValue) {
        this.comboNameX.getItems().setAll(newValue.getMeasurementNames());
        this.comboNameY.getItems().setAll(newValue.getMeasurementNames());
        String selectColumnX = null;
        String selectColumnY = null;
        String defaultX = null;
        String defaultY = null;
        for (String name : newValue.getMeasurementNames()) {
            if (!name.toLowerCase().startsWith("centroid")) {
                if (selectColumnX == null) {
                    selectColumnX = name;
                    continue;
                }
                if (selectColumnY != null) break;
                selectColumnY = name;
                continue;
            }
            if (defaultX == null) {
                defaultX = name;
                continue;
            }
            if (defaultY != null) continue;
            defaultY = name;
        }
        if (selectColumnX != null) {
            this.comboNameX.getSelectionModel().select(selectColumnX);
        }
        if (selectColumnY != null) {
            this.comboNameY.getSelectionModel().select(selectColumnY);
        }
    }

    private Pane createMainOptionsPane() {
        return new VBox(new Node[]{this.createDisplayOptionsPane(), this.createSamplingOptionPane()});
    }

    private TitledPane createDisplayOptionsPane() {
        Spinner spinPointOpacity = new Spinner(0.05, 1.0, ((Double)this.pointOpacity.get()).doubleValue(), 0.05);
        spinPointOpacity.getValueFactory().valueProperty().bindBidirectional(this.pointOpacity);
        spinPointOpacity.setEditable(true);
        spinPointOpacity.setMinWidth(80.0);
        FXUtils.resetSpinnerNullToPrevious((Spinner)spinPointOpacity);
        Spinner spinPointRadius = new Spinner(0.5, 20.0, ((Double)this.pointRadius.get()).doubleValue(), 0.25);
        spinPointRadius.getValueFactory().valueProperty().bindBidirectional(this.pointRadius);
        spinPointRadius.setEditable(true);
        spinPointRadius.setMinWidth(80.0);
        FXUtils.resetSpinnerNullToPrevious((Spinner)spinPointRadius);
        CheckBox cbDrawGrid = new CheckBox("Show grid");
        cbDrawGrid.setTooltip(new Tooltip("Draw a grid on the scatterplot"));
        cbDrawGrid.selectedProperty().bindBidirectional((Property)this.showGrid);
        cbDrawGrid.setMinWidth(Double.NEGATIVE_INFINITY);
        CheckBox cbDrawAxes = new CheckBox("Show axes");
        cbDrawAxes.setTooltip(new Tooltip("Draw axes ticks on the scatterplot"));
        cbDrawAxes.selectedProperty().bindBidirectional((Property)this.showAxes);
        cbDrawAxes.setMinWidth(Double.NEGATIVE_INFINITY);
        CheckBox cbShowLegend = new CheckBox("Show legend");
        cbShowLegend.setTooltip(new Tooltip("Show a legend with class names"));
        cbShowLegend.selectedProperty().bindBidirectional((Property)this.showLegend);
        cbShowLegend.setMinWidth(Double.NEGATIVE_INFINITY);
        CheckBox cbAutorange = new CheckBox("Set axes from all points");
        cbAutorange.setTooltip(new Tooltip("Set axes ranges using full data, even with subsampling points"));
        cbAutorange.selectedProperty().bindBidirectional((Property)this.autorangeFullData);
        cbAutorange.setMinWidth(Double.NEGATIVE_INFINITY);
        GridPane pane = new GridPane();
        int row = 0;
        pane.addRow(row++, new Node[]{ScatterPlotDisplay.createLabelFor((Node)spinPointOpacity, "Point opacity", "Opacity of points to display (between 0 and 1)"), spinPointOpacity});
        pane.addRow(row++, new Node[]{ScatterPlotDisplay.createLabelFor((Node)spinPointRadius, "Point radius", "Radius of points to display (in pixels)"), spinPointRadius});
        pane.setHgap(5.0);
        pane.setVgap(5.0);
        pane.setAlignment(Pos.CENTER);
        pane.setMaxHeight(Double.MAX_VALUE);
        VBox boxCheckboxes = new VBox(new Node[]{cbShowLegend, cbDrawGrid, cbDrawAxes, cbAutorange});
        boxCheckboxes.setAlignment(Pos.CENTER_LEFT);
        boxCheckboxes.setSpacing(5.0);
        HBox hbox = new HBox(new Node[]{pane, new Separator(Orientation.VERTICAL), boxCheckboxes});
        hbox.setSpacing(10.0);
        return new TitledPane("Display", (Node)hbox);
    }

    private TitledPane createSamplingOptionPane() {
        GridPane pane = new GridPane();
        int row = 0;
        TextField tfMaxPoints = ScatterPlotDisplay.createIntTextField(this.maxPoints, Integer.toString(this.maxPoints.get()), "Type an integer > 0");
        TextField tfSeed = ScatterPlotDisplay.createIntTextField(this.seed, Integer.toString(this.seed.get()), "Type an integer");
        pane.addRow(row++, new Node[]{ScatterPlotDisplay.createLabelFor((Node)tfMaxPoints, "Max points", "Maximum number of points to display.\nPlotting very large numbers of points can be slow, \nso this helps improve performance."), tfMaxPoints});
        pane.addRow(row++, new Node[]{ScatterPlotDisplay.createLabelFor((Node)tfSeed, "RNG seed", "Seed for the random number generator (RNG) to use when sampling.\nChanging this value will result in different points being displayed \nwhenever 'Max points' is less than the total number of points."), tfSeed});
        pane.setHgap(5.0);
        pane.setVgap(5.0);
        Label labelWarning = new Label("Showing lots of points can be slow!");
        labelWarning.setWrapText(true);
        labelWarning.setAlignment(Pos.CENTER);
        labelWarning.setTextAlignment(TextAlignment.CENTER);
        labelWarning.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        labelWarning.getStyleClass().add((Object)"warn-label-text");
        Label labelPoints = new Label();
        labelPoints.textProperty().bind((ObservableValue)Bindings.createStringBinding(this::getNumPointsString, (Observable[])new Observable[]{tfMaxPoints.textProperty(), this.maxPoints, this.totalPoints}));
        labelPoints.setWrapText(true);
        labelPoints.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        labelPoints.setAlignment(Pos.CENTER);
        labelPoints.setTextAlignment(TextAlignment.CENTER);
        VBox vBoxLabels = new VBox();
        vBoxLabels.setSpacing(2.0);
        int nWarningPoints = 40000;
        vBoxLabels.getChildren().add((Object)labelPoints);
        vBoxLabels.setAlignment(Pos.CENTER_LEFT);
        VBox.setVgrow((Node)labelPoints, (Priority)Priority.SOMETIMES);
        VBox.setVgrow((Node)labelWarning, (Priority)Priority.SOMETIMES);
        if (this.maxPoints.get() > nWarningPoints) {
            vBoxLabels.getChildren().addFirst((Object)labelWarning);
        }
        this.maxPoints.addListener((v, o, n) -> {
            if (n.intValue() > nWarningPoints && !vBoxLabels.getChildren().contains((Object)labelWarning)) {
                vBoxLabels.getChildren().addFirst((Object)labelWarning);
            } else {
                vBoxLabels.getChildren().remove((Object)labelWarning);
            }
        });
        HBox hBox = new HBox(new Node[]{pane, vBoxLabels});
        hBox.setSpacing(10.0);
        HBox.setHgrow((Node)labelWarning, (Priority)Priority.SOMETIMES);
        HBox.setHgrow((Node)labelPoints, (Priority)Priority.SOMETIMES);
        return new TitledPane("Sampling", (Node)hBox);
    }

    private static TextField createIntTextField(IntegerProperty prop, String defaultText, String prompt) {
        TextField textField = new TextField();
        textField.setText(defaultText);
        textField.setPromptText(prompt);
        textField.setOnAction(e -> ScatterPlotDisplay.setIntegerPropertyFromText(prop, textField.getText()));
        textField.focusedProperty().addListener((v, o, n) -> {
            if (!n.booleanValue()) {
                ScatterPlotDisplay.setIntegerPropertyFromText(prop, textField.getText());
            }
        });
        return textField;
    }

    private static void setIntegerPropertyFromText(IntegerProperty prop, String text) {
        if (text == null || text.isBlank()) {
            return;
        }
        try {
            int val = Integer.parseInt(text);
            if (val < 1) {
                prop.set(0);
            } else {
                prop.set(val);
            }
        }
        catch (NumberFormatException ex) {
            logger.warn("Can't parse integer from {}: {}", (Object)text, (Object)ex.getMessage());
        }
    }

    private String getNumPointsString() {
        int currentPoints = this.totalPoints.get();
        int displayedPoints = GeneralTools.clipValue((int)this.maxPoints.getValue(), (int)0, (int)currentPoints);
        if (displayedPoints == currentPoints) {
            if (displayedPoints == 0) {
                return "No points to show";
            }
            if (displayedPoints == 1) {
                return "Showing 1 point";
            }
            return "Showing all points";
        }
        return "Showing " + displayedPoints + "/" + currentPoints + "\n(" + GeneralTools.formatNumber((double)((double)displayedPoints * 100.0 / (double)currentPoints), (int)1) + " %)";
    }

    private static Label createLabelFor(Node node, String text, String tooltip) {
        Label label = new Label(text);
        label.setLabelFor(node);
        label.setMinWidth(Double.NEGATIVE_INFINITY);
        if (tooltip != null) {
            Tooltip tt = new Tooltip(tooltip);
            if (node instanceof Control) {
                Control control = (Control)node;
                control.setTooltip(tt);
            } else {
                Tooltip.install((Node)node, (Tooltip)tt);
            }
            label.setTooltip(tt);
        }
        return label;
    }

    private static BooleanProperty createWeakBoundProperty(BooleanProperty prop) {
        SimpleBooleanProperty prop2 = new SimpleBooleanProperty(prop.getValue().booleanValue());
        prop.bind((ObservableValue)prop2);
        return prop2;
    }

    private static IntegerProperty createWeakBoundProperty(IntegerProperty prop) {
        SimpleIntegerProperty prop2 = new SimpleIntegerProperty(prop.getValue().intValue());
        prop.bind((ObservableValue)prop2);
        return prop2;
    }

    private static DoubleProperty createWeakBoundProperty(DoubleProperty prop) {
        SimpleDoubleProperty prop2 = new SimpleDoubleProperty(prop.getValue().doubleValue());
        prop.bind((ObservableValue)prop2);
        return prop2;
    }

    public Pane getPane() {
        return this.pane;
    }

    public void refreshScatterPlot() {
        PathTableData model = (PathTableData)this.model.get();
        if (model == null || this.isUpdating) {
            this.resetScatterplot();
            return;
        }
        String x = (String)this.comboNameX.getValue();
        String y = (String)this.comboNameY.getValue();
        if (x != null && y != null) {
            List items = model.getItems();
            this.scatter.setDataFromTable(items, model, x, y);
            this.totalPoints.set(items.size());
        }
    }

    private void resetScatterplot() {
        this.scatter.setData(Collections.emptyList(), p -> Double.NaN, p -> Double.NaN);
    }
}

