/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.charts;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ScatterChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.TilePane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.charts.Charts;
import qupath.lib.gui.measure.PathTableData;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionModel;

public class PathObjectScatterChart
extends ScatterChart<Number, Number> {
    private static final Logger logger = LoggerFactory.getLogger(PathObjectScatterChart.class);
    public static final int NO_SHUFFLE_SEED = -1;
    private final WeakReference<QuPathViewer> viewer;
    private final PathObjectSelectionModel selectionModel;
    private final Set<PathObject> selectedObjects = new HashSet<PathObject>();
    private final IntegerProperty rngSeed = new SimpleIntegerProperty(-1);
    private final DoubleProperty pointOpacity = new SimpleDoubleProperty(1.0);
    private final DoubleProperty pointRadius = new SimpleDoubleProperty(5.0);
    private final IntegerProperty maxPoints = new SimpleIntegerProperty(10000);
    private final BooleanProperty autorangeToFullData = new SimpleBooleanProperty(true);
    private final ObservableList<PathObject> allData = FXCollections.observableArrayList();
    private final ObservableList<PathObject> shuffledData = FXCollections.observableArrayList();
    private final List<PathClass> pathClasses = new ArrayList<PathClass>();
    private Function<PathObject, Number> xFun;
    private Function<PathObject, Number> yFun;
    private double xMin = Double.POSITIVE_INFINITY;
    private double xMax = Double.NEGATIVE_INFINITY;
    private double yMin = Double.POSITIVE_INFINITY;
    private double yMax = Double.NEGATIVE_INFINITY;
    private final XYChart.Series<Number, Number> series = new XYChart.Series("All objects", FXCollections.observableArrayList());
    private final Effect pointHoverEffect = new DropShadow(BlurType.THREE_PASS_BOX, new Color(0.0, 0.0, 0.0, 0.5), 4.0, 0.0, 1.0, 1.0);
    private final EventHandler<MouseEvent> pointEventHandler = this::handleMouseEvent;

    public PathObjectScatterChart(QuPathViewer viewer) {
        super((Axis)new NumberAxis(), (Axis)new NumberAxis());
        if (viewer == null) {
            this.viewer = null;
            this.selectionModel = null;
        } else {
            this.viewer = new WeakReference<QuPathViewer>(viewer);
            PathObjectHierarchy hierarchy = viewer.getHierarchy();
            if (hierarchy != null) {
                this.selectionModel = hierarchy.getSelectionModel();
                this.selectionModel.addPathObjectSelectionListener(this::handleObjectSelectionChanged);
                PathPrefs.useSelectedColorProperty().addListener((v, o, n) -> {
                    if (!this.selectedObjects.isEmpty()) {
                        this.refreshData();
                    }
                });
            } else {
                this.selectionModel = null;
            }
        }
        this.maxPoints.addListener(o -> this.ensureMaxPoints());
        this.pointOpacity.addListener(o -> this.updateOpacity());
        this.pointRadius.addListener(o -> this.updateRadius());
        this.rngSeed.addListener(this::handleRngSeedChange);
        this.autorangeToFullData.addListener((v, o, n) -> {
            this.resampleAndUpdate();
            this.updateAxisRange();
        });
        this.setAnimated(false);
        this.getData().add(this.series);
        this.resampleAndUpdate();
    }

    private void handleObjectSelectionChanged(PathObject pathObjectSelected, PathObject previousObject, Collection<PathObject> allSelected) {
        if (this.selectedObjects.equals(allSelected)) {
            return;
        }
        this.selectedObjects.clear();
        this.selectedObjects.addAll(allSelected);
        this.refreshData();
    }

    private void handleRngSeedChange(ObservableValue<? extends Number> val, Number oldValue, Number newValue) {
        this.shuffleData();
        this.resampleAndUpdate();
    }

    private void updateOpacity() {
        double opacity = this.pointOpacity.get();
        for (XYChart.Data item : this.series.getData()) {
            Node node = item.getNode();
            if (!(node instanceof Circle)) continue;
            Circle circle = (Circle)node;
            if (this.isSelected(item)) continue;
            circle.setOpacity(opacity);
        }
    }

    private boolean isSelected(XYChart.Data<?, ?> item) {
        PathObject pathObject = PathObjectScatterChart.getPathObject(item);
        return pathObject != null && this.isSelected(pathObject);
    }

    private boolean isSelected(PathObject pathObject) {
        return this.selectedObjects.contains(pathObject);
    }

    private static PathObject getPathObject(XYChart.Data<?, ?> item) {
        Object object;
        if (item != null && (object = item.getExtraValue()) instanceof PathObject) {
            PathObject pathObject = (PathObject)object;
            return pathObject;
        }
        return null;
    }

    private void updateRadius() {
        double radius = this.pointRadius.get();
        for (XYChart.Data item : this.series.getData()) {
            Node node = item.getNode();
            if (!(node instanceof Circle)) continue;
            Circle circle = (Circle)node;
            circle.setRadius(radius);
        }
    }

    private void ensureMaxPoints() {
        int n;
        int max = GeneralTools.clipValue((int)this.maxPoints.get(), (int)0, (int)this.shuffledData.size());
        if (max == (n = this.series.getData().size())) {
            return;
        }
        if (n > max) {
            long startTime = System.currentTimeMillis();
            this.series.getData().remove(0, n - max);
            this.refreshData();
            long endTime = System.currentTimeMillis();
            logger.trace("Removal time: {} ms", (Object)(endTime - startTime));
        } else {
            List<XYChart.Data> toAdd = this.shuffledData.subList(n, max).stream().map(this::createDataItem).toList();
            this.series.getData().addAll(toAdd);
        }
    }

    private XYChart.Data<Number, Number> createDataItem(PathObject pathObject) {
        XYChart.Data item = new XYChart.Data();
        this.updateDataItem((XYChart.Data<Number, Number>)item, pathObject);
        return item;
    }

    private void updateDataItem(XYChart.Data<Number, Number> item, PathObject pathObject) {
        Circle circle;
        Node node;
        if (pathObject != item.getExtraValue()) {
            item.setExtraValue((Object)pathObject);
        }
        if ((node = item.getNode()) instanceof Circle) {
            Circle c;
            circle = c = (Circle)node;
        } else {
            circle = this.createSymbol();
            item.setNode((Node)circle);
        }
        circle.setRadius(this.pointRadius.get());
        circle.setOpacity(this.pointOpacity.get());
        circle.setFill((Paint)ColorToolsFX.getDisplayedColor(pathObject));
        if (this.isSelected(pathObject)) {
            circle.setOpacity(1.0);
            if (PathPrefs.useSelectedColorProperty().get()) {
                circle.setFill((Paint)ColorToolsFX.getCachedColor(PathPrefs.colorSelectedObjectProperty().getValue()));
            }
        }
        Number x = this.xFun.apply(pathObject);
        if (!Objects.equals(item.getXValue(), x)) {
            item.setXValue((Object)x);
        }
        Number y = this.yFun.apply(pathObject);
        if (!Objects.equals(item.getYValue(), y)) {
            item.setYValue((Object)y);
        }
        circle.setVisible(x != null && y != null && Double.isFinite(x.doubleValue()) && Double.isFinite(y.doubleValue()));
    }

    public void setAutorangeToFullData(boolean useFullData) {
        this.autorangeToFullData.set(useFullData);
    }

    public BooleanProperty autorangeToFullDataProperty() {
        return this.autorangeToFullData;
    }

    public boolean getAutorangeToFullData() {
        return this.autorangeToFullData.get();
    }

    public void setMaxPoints(int maxPoints) {
        this.maxPoints.set(maxPoints);
    }

    public IntegerProperty maxPointsProperty() {
        return this.maxPoints;
    }

    public int getMaxPoints() {
        return this.maxPoints.get();
    }

    public void setRngSeed(int rngSeed) {
        this.rngSeed.set(rngSeed);
    }

    public IntegerProperty rngSeedProperty() {
        return this.rngSeed;
    }

    public int getRngSeed() {
        return this.rngSeed.get();
    }

    public void setPointOpacity(double pointOpacity) {
        this.pointOpacity.set(pointOpacity);
    }

    public DoubleProperty pointOpacityProperty() {
        return this.pointOpacity;
    }

    public double getPointOpacity() {
        return this.pointOpacity.get();
    }

    public void setPointRadius(double radius) {
        this.pointRadius.set(radius);
    }

    public DoubleProperty pointRadiusProperty() {
        return this.pointRadius;
    }

    public double getPointRadius() {
        return this.pointRadius.get();
    }

    protected void updateLegend() {
        ArrayList<Label> legendList = new ArrayList<Label>();
        for (PathClass pathClass : this.pathClasses) {
            Circle circle = new Circle();
            circle.setRadius(5.0);
            Integer rgb = pathClass == null ? Integer.valueOf(PathPrefs.colorDefaultObjectsProperty().get()) : pathClass.getColor();
            circle.setFill((Paint)ColorToolsFX.getCachedColor(rgb));
            Label item = new Label(pathClass == null ? "Unclassified" : pathClass.toString(), (Node)circle);
            item.setAlignment(Pos.CENTER_LEFT);
            item.setContentDisplay(ContentDisplay.LEFT);
            legendList.add(item);
        }
        if (!legendList.isEmpty()) {
            TilePane legend = new TilePane();
            legend.getChildren().setAll(legendList);
            this.setLegend((Node)legend);
        } else {
            this.setLegend(null);
        }
    }

    private void shuffleData() {
        int seed = this.rngSeed.get();
        if (seed == -1) {
            this.shuffledData.setAll(this.allData);
        } else {
            ArrayList<PathObject> toShuffle = new ArrayList<PathObject>((Collection<PathObject>)this.allData);
            Collections.shuffle(toShuffle, new Random(seed));
            this.shuffledData.setAll(toShuffle);
        }
    }

    private void resampleAndUpdate() {
        long startTime = System.currentTimeMillis();
        int max = this.maxPoints.get();
        int n = GeneralTools.clipValue((int)this.shuffledData.size(), (int)0, (int)max);
        ArrayList<XYChart.Data<Number, Number>> toAdd = new ArrayList<XYChart.Data<Number, Number>>();
        ObservableList items = this.series.getData();
        int nItems = items.size();
        if (n < nItems) {
            items.remove(0, nItems - n);
            nItems = items.size();
        }
        for (int i = 0; i < n; ++i) {
            PathObject pathObject = (PathObject)this.shuffledData.get(i);
            if (i < nItems) {
                this.updateDataItem((XYChart.Data<Number, Number>)((XYChart.Data)items.get(i)), pathObject);
                continue;
            }
            toAdd.add(this.createDataItem(pathObject));
        }
        if (!toAdd.isEmpty()) {
            items.addAll(toAdd);
        } else if (n < nItems) {
            items.remove(n, nItems);
        }
        long endTime = System.currentTimeMillis();
        logger.trace("Resample & update time: {} ms", (Object)(endTime - startTime));
        this.recalculateExtrema();
        this.ensureSingleSeries();
        this.requestChartLayout();
    }

    private void recalculateExtrema() {
        this.resetExtrema();
        if (!this.autorangeToFullData.get()) {
            return;
        }
        ObservableList data = this.series.getData();
        int nItems = data.size();
        for (int i = 0; i < this.shuffledData.size(); ++i) {
            double y;
            double x;
            if (i < nItems) {
                XYChart.Data item = (XYChart.Data)data.get(i);
                x = ((Number)item.getXValue()).doubleValue();
                y = ((Number)item.getYValue()).doubleValue();
            } else {
                PathObject pathObject = (PathObject)this.shuffledData.get(i);
                x = this.xFun.apply(pathObject).doubleValue();
                y = this.yFun.apply(pathObject).doubleValue();
            }
            if (x < this.xMin) {
                this.xMin = x;
            }
            if (x > this.xMax) {
                this.xMax = x;
            }
            if (y < this.yMin) {
                this.yMin = y;
            }
            if (!(y > this.yMax)) continue;
            this.yMax = y;
        }
    }

    private void resetExtrema() {
        this.xMin = Double.POSITIVE_INFINITY;
        this.xMax = Double.NEGATIVE_INFINITY;
        this.yMin = Double.POSITIVE_INFINITY;
        this.yMax = Double.NEGATIVE_INFINITY;
    }

    private void ensureSingleSeries() {
        if (this.getData().size() != 1 || this.getData().getFirst() != this.series) {
            logger.debug("Resetting series!");
            this.getData().setAll(List.of(this.series));
        }
    }

    public void refreshData() {
        if (this.xFun == null || this.yFun == null) {
            this.series.getData().clear();
            return;
        }
        for (XYChart.Data item : this.series.getData()) {
            Object object = item.getExtraValue();
            if (!(object instanceof PathObject)) continue;
            PathObject pathObject = (PathObject)object;
            this.updateDataItem((XYChart.Data<Number, Number>)item, pathObject);
        }
    }

    public void setData(Collection<? extends PathObject> pathObjects, Function<PathObject, Number> xFun, Function<PathObject, Number> yFun) {
        this.xFun = xFun;
        this.yFun = yFun;
        List<PathClass> pathClasses = pathObjects.stream().map(PathObject::getPathClass).distinct().sorted(Comparator.nullsFirst(PathClass::compareTo)).toList();
        this.pathClasses.clear();
        this.pathClasses.addAll(pathClasses);
        this.updateLegend();
        this.allData.setAll(pathObjects);
        this.shuffleData();
        this.resampleAndUpdate();
    }

    public void setDataFromTable(Collection<? extends PathObject> pathObjects, PathTableData<PathObject> model, String xMeasurement, String yMeasurement) {
        this.setData(pathObjects, p -> model.getNumericValue((PathObject)p, xMeasurement), p -> model.getNumericValue((PathObject)p, yMeasurement));
        this.getXAxis().setLabel(xMeasurement);
        this.getYAxis().setLabel(yMeasurement);
    }

    private Circle createSymbol() {
        Circle circle = new Circle();
        circle.addEventHandler(MouseEvent.ANY, this.pointEventHandler);
        return circle;
    }

    protected void dataItemAdded(XYChart.Series<Number, Number> series, int itemIndex, XYChart.Data<Number, Number> item) {
        Node node = item.getNode();
        if (node == null) {
            item.setNode((Node)this.createSymbol());
        }
        super.dataItemAdded(series, itemIndex, item);
    }

    protected void dataItemRemoved(XYChart.Data<Number, Number> item, XYChart.Series<Number, Number> series) {
        super.dataItemRemoved(item, series);
    }

    protected void updateAxisRange() {
        if (!(this.autorangeToFullData.get() && this.xMax > this.xMin && this.yMax > this.yMin)) {
            super.updateAxisRange();
        } else {
            Axis yAxis;
            Axis xAxis = this.getXAxis();
            if (xAxis.isAutoRanging()) {
                xAxis.invalidateRange(List.of(Double.valueOf(this.xMin), Double.valueOf(this.xMax)));
            }
            if ((yAxis = this.getYAxis()).isAutoRanging()) {
                yAxis.invalidateRange(List.of(Double.valueOf(this.yMin), Double.valueOf(this.yMax)));
            }
        }
    }

    private void handleMouseEvent(MouseEvent event) {
        Object object = event.getSource();
        if (object instanceof Circle) {
            Circle circle = (Circle)object;
            if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
                circle.setEffect(this.pointHoverEffect);
            } else if (event.getEventType() == MouseEvent.MOUSE_EXITED) {
                circle.setEffect(null);
            } else if (event.getEventType() == MouseEvent.MOUSE_CLICKED && this.viewer != null && event.getButton() == MouseButton.PRIMARY) {
                PathObjectHierarchy hierarchy;
                QuPathViewer viewer = (QuPathViewer)this.viewer.get();
                PathObjectHierarchy pathObjectHierarchy = hierarchy = viewer == null ? null : viewer.getHierarchy();
                if (hierarchy == null) {
                    return;
                }
                PathObject pathObject = this.series.getData().stream().filter(d -> d.getNode() == circle && d.getExtraValue() instanceof PathObject).map(d -> (PathObject)d.getExtraValue()).findFirst().orElse(null);
                if (pathObject != null && PathObjectTools.hierarchyContainsObject((PathObjectHierarchy)hierarchy, (PathObject)pathObject)) {
                    Charts.ScatterChartBuilder.tryToSelect(pathObject, viewer, viewer.getImageData(), event.isShiftDown(), event.getClickCount() == 2);
                }
                event.consume();
            }
        }
    }
}

