/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.charts;

import java.util.ArrayList;
import java.util.Arrays;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import org.controlsfx.control.SearchableComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.stats.Histogram;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.charts.HistogramChart;
import qupath.lib.gui.dialogs.ParameterPanelFX;
import qupath.lib.gui.measure.PathTableData;
import qupath.lib.plugins.parameters.IntParameter;
import qupath.lib.plugins.parameters.ParameterChangeListener;
import qupath.lib.plugins.parameters.ParameterList;

public class HistogramDisplay
implements ParameterChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(HistogramDisplay.class);
    private PathTableData<?> model;
    private final BorderPane pane = new BorderPane();
    private final SearchableComboBox<String> comboName = new SearchableComboBox();
    private final HistogramChart histogramChart = new HistogramChart();
    private final ParameterPanelFX panelParams;
    private final StringProperty selectedColumn = new SimpleStringProperty();
    private int currentBins;
    private double[] currentValues;
    private String currentColumn = null;
    private final ParameterList paramsHistogram = new ParameterList().addChoiceParameter("countsTransform", "Counts", (Object)HistogramChart.CountsTransformMode.RAW, Arrays.asList(HistogramChart.CountsTransformMode.values()), "Normalize counts (probability distribution)").addIntParameter("nBins", "Number of bins", 32, null, "Number of histogram bins (>= 2 and <= 1000)").addBooleanParameter("drawGrid", "Draw grid", true, "Draw grid").addBooleanParameter("drawAxes", "Draw axes", true, "Draw axes").addBooleanParameter("animate", "Animate changes", false, "Animate changes");
    private final TableView<Property<Number>> table = new TableView();

    public HistogramDisplay(PathTableData<?> model, boolean showTable) {
        String selectColumn = null;
        this.model = model;
        this.comboName.getItems().setAll(model.getMeasurementNames());
        if (this.comboName.getItems().isEmpty()) {
            logger.debug("No items to display!");
        }
        for (String name : model.getMeasurementNames()) {
            if (!name.toLowerCase().startsWith("centroid")) {
                selectColumn = name;
                break;
            }
            if (selectColumn != null) continue;
            selectColumn = name;
        }
        if (selectColumn != null) {
            this.comboName.getSelectionModel().select(selectColumn);
        }
        TableColumn colName = new TableColumn("Measurement");
        colName.setCellValueFactory(p -> new SimpleStringProperty(((Property)p.getValue()).getName()));
        TableColumn colValue = new TableColumn("Value");
        colValue.setCellValueFactory(TableColumn.CellDataFeatures::getValue);
        colValue.setCellFactory(column -> new TableCell<Property<Number>, Number>(this){

            protected void updateItem(Number item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setStyle("");
                } else if (Double.isNaN(item.doubleValue())) {
                    this.setText("-");
                } else {
                    this.setText(GeneralTools.createFormatter((int)3).format(item));
                }
            }
        });
        this.table.getColumns().add((Object)colName);
        this.table.getColumns().add((Object)colValue);
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.table.maxHeightProperty().bind((ObservableValue)this.table.prefHeightProperty());
        this.table.setPrefHeight(180.0);
        this.table.setMinWidth(100.0);
        this.table.setStyle("-fx-font-size: 0.8em");
        BorderPane panelMain = new BorderPane();
        panelMain.setCenter((Node)this.histogramChart);
        this.selectedColumn.bindBidirectional((Property)this.comboName.valueProperty());
        this.selectedColumn.addListener((v, o, n) -> this.setHistogram(model, (String)n));
        this.histogramChart.setShowTickLabels(this.paramsHistogram.getBooleanParameterValue("drawAxes"));
        this.panelParams = new ParameterPanelFX(this.paramsHistogram);
        this.panelParams.addParameterChangeListener(this);
        this.panelParams.getPane().setPadding(new Insets(20.0, 5.0, 5.0, 5.0));
        this.panelParams.getPane().setMinWidth(Double.NEGATIVE_INFINITY);
        this.updateTable(null);
        GridPane panelSouth = new GridPane();
        panelSouth.add((Node)this.panelParams.getPane(), 0, 0);
        if (showTable) {
            panelSouth.add(this.table, 1, 0);
        }
        GridPane.setHgrow((Node)this.panelParams.getPane(), (Priority)Priority.NEVER);
        GridPane.setHgrow(this.table, (Priority)Priority.ALWAYS);
        this.pane.setTop(this.comboName);
        this.comboName.prefWidthProperty().bind((ObservableValue)this.pane.widthProperty());
        panelMain.setMinSize(200.0, 200.0);
        panelMain.setPrefSize(600.0, 400.0);
        this.pane.setCenter((Node)panelMain);
        this.pane.setBottom((Node)panelSouth);
        this.pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.setHistogram(model, (String)this.comboName.getSelectionModel().getSelectedItem());
    }

    public void refreshCombo() {
        String selected = (String)this.comboName.getSelectionModel().getSelectedItem();
        if (!this.model.getAllNames().equals(this.comboName.getItems())) {
            this.comboName.getItems().setAll(this.model.getAllNames());
            this.comboName.getSelectionModel().select((Object)selected);
        }
    }

    public void setNumBins(int nBins) {
        if ((double)nBins > 100000.0) {
            logger.warn("nBins set to strange value {}; resetting to 32.", (Object)nBins);
            nBins = 32;
        }
        if (this.panelParams != null) {
            this.panelParams.setNumericParameterValue("nBins", nBins);
        } else {
            ((IntParameter)this.paramsHistogram.getParameters().get("nBins")).setValue(Integer.valueOf(nBins));
        }
    }

    public int getNumBins() {
        return this.paramsHistogram.getIntParameterValue("nBins");
    }

    public Pane getPane() {
        return this.pane;
    }

    void setHistogram(PathTableData<?> model, String columnName) {
        if (model != null && model.getMeasurementNames().contains(columnName)) {
            double[] values = model.getDoubleValues(columnName);
            int nBins = this.paramsHistogram.getIntParameterValue("nBins");
            if (nBins < 2) {
                nBins = 2;
            } else if (nBins > 1000) {
                nBins = 1000;
            }
            Arrays.sort(values);
            if (nBins == this.currentBins && this.currentValues != null && Arrays.equals(this.currentValues, values)) {
                return;
            }
            Histogram histogram = new Histogram(values, nBins);
            HistogramChart.HistogramData histogramData = HistogramChart.createHistogramData(histogram, (Integer)null);
            HistogramDisplay.updateCountsTransform(this.histogramChart, this.paramsHistogram);
            this.histogramChart.getHistogramData().setAll((Object[])new HistogramChart.HistogramData[]{histogramData});
            this.histogramChart.setVerticalGridLinesVisible(true);
            this.histogramChart.setHorizontalGridLinesVisible(true);
            this.histogramChart.setLegendVisible(false);
            this.histogramChart.setCreateSymbols(false);
            this.histogramChart.getXAxis().setLabel("Values");
            this.histogramChart.getYAxis().setLabel("Counts");
            this.histogramChart.getYAxis().setTickLabelsVisible(true);
            this.histogramChart.getYAxis().setTickMarkVisible(true);
            this.histogramChart.getXAxis().setTickLabelsVisible(true);
            this.histogramChart.getXAxis().setTickMarkVisible(true);
            this.histogramChart.setAnimated(this.paramsHistogram.getBooleanParameterValue("animate"));
            this.updateTable(histogram);
            this.currentColumn = columnName;
            this.currentBins = nBins;
            this.currentValues = values;
            this.model = model;
        } else {
            this.histogramChart.getHistogramData().clear();
            this.currentValues = null;
        }
    }

    private static void updateCountsTransform(HistogramChart histogramChart, ParameterList params) {
        Object transform = params.getChoiceParameterValue("countsTransform");
        if (transform instanceof HistogramChart.CountsTransformMode) {
            HistogramChart.CountsTransformMode mode = (HistogramChart.CountsTransformMode)((Object)transform);
            histogramChart.setCountsTransform(mode);
            if (transform == HistogramChart.CountsTransformMode.RAW) {
                histogramChart.getYAxis().setLabel("Counts");
            } else {
                histogramChart.getYAxis().setLabel("Counts (" + String.valueOf(transform) + ")");
            }
        } else {
            logger.warn("Histogram counts transform not supported: {}", transform);
        }
    }

    public void refreshHistogram() {
        this.setHistogram(this.model, this.currentColumn);
    }

    public void showHistogram(String column) {
        if (this.comboName.getItems().contains((Object)column)) {
            this.comboName.getSelectionModel().select((Object)column);
        } else {
            logger.debug("Unknown column requested: {}", (Object)column);
        }
    }

    public void parameterChanged(ParameterList parameterList, String key, boolean isAdjusting) {
        if ("countsTransform".equals(key)) {
            HistogramDisplay.updateCountsTransform(this.histogramChart, parameterList);
        } else if ("drawGrid".equals(key)) {
            this.histogramChart.setHorizontalGridLinesVisible(this.paramsHistogram.getBooleanParameterValue("drawGrid"));
            this.histogramChart.setVerticalGridLinesVisible(this.paramsHistogram.getBooleanParameterValue("drawGrid"));
        } else if ("drawAxes".equals(key)) {
            this.histogramChart.setShowTickLabels(this.paramsHistogram.getBooleanParameterValue("drawAxes"));
        } else if ("nBins".equals(key)) {
            this.setHistogram(this.model, (String)this.comboName.getSelectionModel().getSelectedItem());
        } else if ("animate".equals(key)) {
            this.histogramChart.setAnimated(this.paramsHistogram.getBooleanParameterValue("animate"));
        }
    }

    void updateTable(Histogram histogram) {
        if (histogram == null) {
            ArrayList<SimpleDoubleProperty> stats = new ArrayList<SimpleDoubleProperty>();
            stats.add(new SimpleDoubleProperty(null, "Count", Double.NaN));
            stats.add(new SimpleDoubleProperty(null, "Missing", Double.NaN));
            stats.add(new SimpleDoubleProperty(null, "Mean", Double.NaN));
            stats.add(new SimpleDoubleProperty(null, "Std.Dev", Double.NaN));
            stats.add(new SimpleDoubleProperty(null, "Min", Double.NaN));
            stats.add(new SimpleDoubleProperty(null, "Max", Double.NaN));
            this.table.getItems().setAll(stats);
            return;
        }
        ArrayList<Object> stats = new ArrayList<Object>();
        stats.add(new SimpleLongProperty(null, "Count", histogram.nValues()));
        stats.add(new SimpleLongProperty(null, "Missing", histogram.nMissingValues()));
        stats.add(new SimpleDoubleProperty(null, "Mean", histogram.getMeanValue()));
        stats.add(new SimpleDoubleProperty(null, "Std.Dev", histogram.getStdDev()));
        stats.add(new SimpleDoubleProperty(null, "Min", histogram.getMinValue()));
        stats.add(new SimpleDoubleProperty(null, "Max", histogram.getMaxValue()));
        this.table.getItems().setAll(stats);
    }
}

