/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.charts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.stats.Histogram;
import qupath.lib.gui.tools.ColorToolsFX;

public class HistogramChart
extends AreaChart<Number, Number> {
    private static final Logger logger = LoggerFactory.getLogger(HistogramChart.class);
    private final Map<HistogramData, XYChart.Series<Number, Number>> seriesCache = new HashMap<HistogramData, XYChart.Series<Number, Number>>();
    private final ObservableList<HistogramData> histogramData = FXCollections.observableArrayList();
    private final ObjectProperty<CountsTransformMode> countsAxisMode = new SimpleObjectProperty((Object)CountsTransformMode.RAW);
    private final ObjectProperty<DisplayMode> displayModeObjectProperty = new SimpleObjectProperty((Object)DisplayMode.BAR);
    private final BooleanProperty hideIfEmptyProperty = new SimpleBooleanProperty(false);

    public HistogramChart() {
        super((Axis)new NumberAxis(), (Axis)new NumberAxis());
        this.setHorizontalZeroLineVisible(false);
        this.setVerticalZeroLineVisible(false);
        Axis xAxis = this.getXAxis();
        Axis yAxis = this.getYAxis();
        xAxis.setLabel(null);
        yAxis.setLabel(null);
        xAxis.setTickLabelsVisible(true);
        xAxis.setTickMarkVisible(false);
        yAxis.setTickLabelsVisible(true);
        yAxis.setTickMarkVisible(false);
        this.setVerticalGridLinesVisible(false);
        this.setHorizontalGridLinesVisible(false);
        this.setLegendVisible(false);
        this.setCreateSymbols(false);
        this.displayModeObjectProperty.addListener((obs, was, is) -> this.updateSeries());
        this.countsAxisMode.addListener((obs, was, is) -> this.updateSeries());
        this.hideIfEmptyProperty.addListener((obs, was, is) -> this.updateVisibility());
        this.dataProperty().addListener((obs, was, is) -> this.updateVisibility());
        this.updateVisibility();
        this.histogramData.addListener(this::handleHistogramDataChange);
    }

    private void handleHistogramDataChange(ListChangeListener.Change<? extends HistogramData> c) {
        while (c.next()) {
            XYChart.Series series;
            if (c.wasPermutated() || c.wasUpdated()) continue;
            for (HistogramData removedItem : c.getRemoved()) {
                series = this.seriesCache.remove(removedItem);
                if (series != null) {
                    this.getData().remove(series);
                    continue;
                }
                logger.warn("Series not found for removed histogram data: {}", (Object)removedItem);
            }
            for (HistogramData addedItem : c.getAddedSubList()) {
                series = this.seriesCache.computeIfAbsent(addedItem, this::createNewSeries);
                addedItem.updateSeries((XYChart.Series<Number, Number>)series, (DisplayMode)((Object)this.displayModeObjectProperty.get()), (CountsTransformMode)((Object)this.countsAxisMode.get()));
                this.getData().add((Object)series);
            }
        }
        this.updateVisibility();
    }

    private XYChart.Series<Number, Number> createNewSeries(HistogramData histogramData) {
        XYChart.Series series = new XYChart.Series();
        series.nodeProperty().addListener((v, o, n) -> histogramData.updateNodeColors((XYChart.Series<Number, Number>)series));
        return series;
    }

    private void updateSeries() {
        for (Map.Entry<HistogramData, XYChart.Series<Number, Number>> entry : this.seriesCache.entrySet()) {
            entry.getKey().updateSeries(entry.getValue(), (DisplayMode)((Object)this.displayModeObjectProperty.get()), (CountsTransformMode)((Object)this.countsAxisMode.get()));
        }
    }

    private void updateVisibility() {
        if (this.hideIfEmptyProperty.get()) {
            this.setVisible(!this.getData().isEmpty());
        }
    }

    public BooleanProperty hideIfEmptyProperty() {
        return this.hideIfEmptyProperty;
    }

    public void setHideIfEmpty(boolean doHide) {
        this.hideIfEmptyProperty().set(doHide);
    }

    public boolean getHideIfEmpty() {
        return this.hideIfEmptyProperty().get();
    }

    public ObjectProperty<CountsTransformMode> countsTransformProperty() {
        return this.countsAxisMode;
    }

    public CountsTransformMode getCountsTransform() {
        return (CountsTransformMode)((Object)this.countsAxisMode.get());
    }

    public void setCountsTransform(CountsTransformMode mode) {
        Objects.requireNonNull(mode, "CountsTransformMode cannot be null");
        this.countsAxisMode.set((Object)mode);
    }

    public ObjectProperty<DisplayMode> displayModeProperty() {
        return this.displayModeObjectProperty;
    }

    public DisplayMode getDisplayMode() {
        return (DisplayMode)((Object)this.displayModeObjectProperty.get());
    }

    public void setDisplayMode(DisplayMode mode) {
        Objects.requireNonNull(mode, "DisplayMode cannot be null");
        this.displayModeObjectProperty.set((Object)mode);
    }

    public ObservableList<HistogramData> getHistogramData() {
        return this.histogramData;
    }

    public static HistogramData createHistogramData(Histogram histogram, Color color) {
        return new HistogramData(histogram, color);
    }

    public static HistogramData createHistogramData(Histogram histogram, Integer color) {
        return new HistogramData(histogram, color == null ? null : ColorToolsFX.getCachedColor(color));
    }

    public void setShowTickLabels(boolean showTickLabels) {
        this.getXAxis().setTickLabelsVisible(showTickLabels);
        this.getYAxis().setTickLabelsVisible(showTickLabels);
    }

    public static enum CountsTransformMode {
        RAW,
        NORMALIZED,
        LOGARITHM;


        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "Raw";
                }
                case 1: {
                    return "Normalized";
                }
                case 2: {
                    return "Log10";
                }
            }
            throw new IllegalArgumentException("Unknown count transform mode: " + String.valueOf((Object)this));
        }
    }

    public static enum DisplayMode {
        BAR,
        AREA;

    }

    public static class HistogramData {
        private Histogram histogram;
        private Color colorStroke;
        private Color colorFill;

        public HistogramData(Histogram histogram, Color color) {
            this.histogram = histogram;
            this.setColor(color);
        }

        private void setColor(Color color) {
            this.colorStroke = color;
            this.colorFill = color == null ? null : Color.color((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), (double)(color.getOpacity() / 4.0));
        }

        public Color getStroke() {
            return this.colorStroke;
        }

        public Color getFill() {
            return this.colorFill;
        }

        private void updateSeries(XYChart.Series<Number, Number> series, DisplayMode displayMode, CountsTransformMode countsDisplay) {
            List<Object> data = this.histogram == null || this.histogram.nBins() == 0 ? Collections.emptyList() : (displayMode == DisplayMode.AREA ? HistogramData.createDataForAreaPlot(this.histogram, (h, i) -> HistogramData.getCount(countsDisplay, h, i)) : HistogramData.createDataForBarPlot(this.histogram, (h, i) -> HistogramData.getCount(countsDisplay, h, i)));
            series.getData().setAll(data);
            this.updateNodeColors(series);
        }

        private static double getCount(CountsTransformMode mode, Histogram histogram, int bin) {
            switch (mode.ordinal()) {
                case 0: {
                    return histogram.getCountsForBin(bin);
                }
                case 1: {
                    return histogram.getNormalizedCountsForBin(bin);
                }
                case 2: {
                    double count = histogram.getCountsForBin(bin);
                    return count == 0.0 ? 0.0 : Math.log10(count);
                }
            }
            throw new IllegalStateException("Unknown mode: " + String.valueOf((Object)mode));
        }

        private static List<XYChart.Data<Number, Number>> createDataForAreaPlot(Histogram histogram, BiFunction<Histogram, Integer, Double> countFun) {
            ArrayList<XYChart.Data<Number, Number>> data = new ArrayList<XYChart.Data<Number, Number>>();
            data.add(new XYChart.Data((Object)histogram.getBinLeftEdge(0), (Object)0));
            for (int i = 0; i < histogram.nBins(); ++i) {
                XYChart.Data dataElement = new XYChart.Data((Object)(histogram.getBinLeftEdge(i) / 2.0 + histogram.getBinRightEdge(i) / 2.0), (Object)countFun.apply(histogram, i));
                data.add((XYChart.Data<Number, Number>)dataElement);
            }
            data.add(new XYChart.Data((Object)histogram.getBinRightEdge(histogram.nBins() - 1), (Object)0));
            return data;
        }

        private static List<XYChart.Data<Number, Number>> createDataForBarPlot(Histogram histogram, BiFunction<Histogram, Integer, Double> countFun) {
            ArrayList<XYChart.Data<Number, Number>> data = new ArrayList<XYChart.Data<Number, Number>>();
            data.add(new XYChart.Data((Object)histogram.getBinLeftEdge(0), (Object)0));
            for (int i = 0; i < histogram.nBins(); ++i) {
                XYChart.Data dataElement = new XYChart.Data((Object)histogram.getBinLeftEdge(i), (Object)0);
                data.add(dataElement);
                double val = countFun.apply(histogram, i);
                dataElement = new XYChart.Data((Object)histogram.getBinLeftEdge(i), (Object)val);
                data.add((XYChart.Data<Number, Number>)dataElement);
                dataElement = new XYChart.Data((Object)histogram.getBinRightEdge(i), (Object)val);
                data.add((XYChart.Data<Number, Number>)dataElement);
                dataElement = new XYChart.Data((Object)histogram.getBinRightEdge(i), (Object)0);
                data.add((XYChart.Data<Number, Number>)dataElement);
            }
            data.add(new XYChart.Data((Object)histogram.getBinRightEdge(histogram.nBins() - 1), (Object)0));
            return data;
        }

        void updateNodeColors(XYChart.Series<Number, Number> series) {
            if (series.getNode() != null) {
                try {
                    Group group = (Group)series.getNode();
                    Path seriesLine = (Path)group.getChildren().get(1);
                    Path fillPath = (Path)group.getChildren().get(0);
                    if (this.colorStroke != null || this.colorFill != null) {
                        seriesLine.setStroke((Paint)this.colorStroke);
                        seriesLine.setStyle(null);
                        fillPath.setFill((Paint)this.colorFill);
                        fillPath.setStyle(null);
                    } else {
                        seriesLine.setStyle("-fx-stroke: -fx-text-base-color; -fx-opacity: 0.4;");
                        fillPath.setStyle("-fx-fill: -fx-text-base-color; -fx-opacity: 0.15;");
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to set colors for series {}", series);
                }
            }
        }

        public Histogram getHistogram() {
            return this.histogram;
        }
    }
}

