/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.charts;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.chart.Axis;
import javafx.scene.chart.Chart;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.transform.Transform;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import org.controlsfx.control.PropertySheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.prefs.controlsfx.PropertyItemBuilder;
import qupath.fx.prefs.controlsfx.PropertySheetUtils;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.charts.ChartTools;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.io.GsonTools;

class ExportChartPane {
    private static final Logger logger = LoggerFactory.getLogger(ExportChartPane.class);
    private static ObjectProperty<PropertySheet.Mode> persistentModeProperty = new SimpleObjectProperty((Object)PropertySheet.Mode.NAME);
    private static BooleanProperty persistentSolidLinesProperty = new SimpleBooleanProperty(false);
    private static ObjectProperty<ChartStyle> persistentChartStyleProperty = new SimpleObjectProperty((Object)ChartStyle.COLOR);
    private static ObjectProperty<ChartStrokeWidth> persistentStrokeWidthProperty = new SimpleObjectProperty((Object)ChartStrokeWidth.MODERATE);
    private static IntegerProperty requestedWidthProperty = new SimpleIntegerProperty();
    private static IntegerProperty requestedHeightProperty = new SimpleIntegerProperty();
    private static ObservableList<String> storedPrefs = FXCollections.observableArrayList();
    private ObjectProperty<ChartStrokeWidth> strokeWidthProperty = new SimpleObjectProperty((Object)ChartStrokeWidth.MODERATE);
    private ObjectProperty<ChartStyle> chartStyleProperty = new SimpleObjectProperty((Object)((ChartStyle)((Object)persistentChartStyleProperty.get())));
    private ObjectProperty<ExportResolution> exportResolutionProperty = new SimpleObjectProperty((Object)ExportResolution.LOW);
    private BorderPane pane = new BorderPane();
    private ScrollPane scrollPane;
    private Chart chart;
    PropertySheet sheet = PropertySheetUtils.createDefaultPropertySheet();
    private IntegerProperty requestedWidth = new SimpleIntegerProperty(requestedWidthProperty.get());
    private IntegerProperty requestedHeight = new SimpleIntegerProperty(requestedHeightProperty.get());
    private static BooleanProperty useSolidLines = new SimpleBooleanProperty(persistentSolidLinesProperty.get());
    private static String EXPORT_CHART_PREFS_KEY = "chart.export.";

    public ExportChartPane(Chart chart) {
        this.chart = chart;
        Button btnCopy = new Button("Copy");
        btnCopy.setOnAction(e -> {
            Image img = this.getChartImage();
            ClipboardContent content = new ClipboardContent();
            content.putImage(img);
            Clipboard.getSystemClipboard().setContent((Map)content);
        });
        Button btnSave = new Button("Save");
        btnSave.setOnAction(e -> {
            Image img = this.getChartImage();
            String title = chart.getTitle() == null || chart.getTitle().isEmpty() ? null : chart.getTitle();
            Window owner = chart.getScene() == null ? null : chart.getScene().getWindow();
            File fileOutput = FileChoosers.promptToSaveFile((Window)owner, (String)"Save chart", (File)(title == null ? null : new File(title)), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"PNG", (String[])new String[]{".png"})});
            if (fileOutput != null) {
                try {
                    ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)img, null), "png", fileOutput);
                }
                catch (Exception e1) {
                    Dialogs.showErrorMessage((String)"Save chart error", (Throwable)e1);
                    logger.error(e1.getMessage(), (Throwable)e1);
                }
            }
        });
        GridPane paneButtons = GridPaneUtils.createColumnGridControls((Node[])new Node[]{btnCopy, btnSave});
        paneButtons.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        useSolidLines.addListener(v -> this.updateChartStyles());
        this.scrollPane = new ScrollPane((Node)chart);
        this.scrollPane.setStyle("-fx-background: white;");
        BorderPane paneMain = new BorderPane();
        paneMain.setCenter((Node)this.scrollPane);
        paneMain.setBottom((Node)paneButtons);
        this.pane.setCenter((Node)paneMain);
        this.updateChartStyles();
        this.requestedWidth.addListener(v -> this.refreshChartDisplay());
        this.requestedHeight.addListener(v -> this.refreshChartDisplay());
        this.sheet.modeProperty().addListener((v, o, n) -> persistentModeProperty.set(n));
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{new PropertyItemBuilder(this.chartStyleProperty, ChartStyle.class).name("Style").description("Color style for chart display").category("Display").build(), new PropertyItemBuilder((Property)chart.titleProperty(), String.class).name("Title").description("Chart title").category("Title").build(), new PropertyItemBuilder((Property)chart.titleSideProperty(), Side.class).name("Title side").description("Location of title").category("Title").build(), new PropertyItemBuilder((Property)chart.legendVisibleProperty(), Boolean.class).name("Show legend").description("Show chart legend").category("Legend").build(), new PropertyItemBuilder((Property)chart.legendSideProperty(), Side.class).name("Legend position").description("Position to display legend, relative to the chart").category("Legend").build()});
        if (chart instanceof LineChart) {
            LineChart lineChart = (LineChart)chart;
            this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{new PropertyItemBuilder(this.strokeWidthProperty, ChartStrokeWidth.class).name("Line width").description("Thickness of lines used to draw on the chart").category("Display").build(), new PropertyItemBuilder((Property)useSolidLines, Boolean.class).name("Solid lines").description("Use solid (rather than dashed) lines for all series").category("Display").build(), new PropertyItemBuilder((Property)lineChart.createSymbolsProperty(), Boolean.class).name("Use markers").description("Use markers to indicate each data point").category("Display").build()});
        }
        if (chart instanceof XYChart) {
            NumberAxis axis;
            XYChart xyChart = (XYChart)chart;
            this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{new PropertyItemBuilder((Property)xyChart.horizontalGridLinesVisibleProperty(), Boolean.class).name("Horizontal grid lines").description("Display horizontal grid lines").category("Grid").build(), new PropertyItemBuilder((Property)xyChart.horizontalZeroLineVisibleProperty(), Boolean.class).name("Horizontal zero line").description("Display horizontal zero line").category("Grid").build(), new PropertyItemBuilder((Property)xyChart.verticalGridLinesVisibleProperty(), Boolean.class).name("Vertical grid lines").description("Display vertical grid lines").category("Grid").build(), new PropertyItemBuilder((Property)xyChart.verticalZeroLineVisibleProperty(), Boolean.class).name("Vertical zero line").description("Display vertical zero line").category("Grid").build()});
            if (xyChart.getXAxis() instanceof NumberAxis) {
                axis = (NumberAxis)xyChart.getXAxis();
                this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{new PropertyItemBuilder((Property)axis.labelProperty(), String.class).name("X axis label").description("X axis label").category("X axis").build(), new PropertyItemBuilder((Property)axis.autoRangingProperty(), Boolean.class).name("X axis autorange").description("Set X axis range automatically").category("X axis").build(), new PropertyItemBuilder((Property)axis.lowerBoundProperty(), Double.class).name("X lower bound").description("X lower bound").category("X axis").build(), new PropertyItemBuilder((Property)axis.upperBoundProperty(), Double.class).name("X upper bound").description("X upper bound").category("X axis").build(), new PropertyItemBuilder((Property)axis.tickUnitProperty(), Double.class).name("X tick unit").description("Spacing between ticks on x axis").category("X axis").build()});
                int counter = 0;
                for (XYChart.Series series : xyChart.getData()) {
                    ++counter;
                    if (series.nameProperty().isBound()) continue;
                    this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{new PropertyItemBuilder((Property)series.nameProperty(), String.class).name("Series name " + counter + ":").description("Name of the data in the chart (will be used for legend)").category("Series").build()});
                }
            } else {
                this.sheet.getItems().add((Object)new PropertyItemBuilder((Property)xyChart.getXAxis().labelProperty(), String.class).name("X axis label").description("X axis label").category("X axis").build());
            }
            if (xyChart.getYAxis() instanceof NumberAxis) {
                axis = (NumberAxis)xyChart.getYAxis();
                this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{new PropertyItemBuilder((Property)axis.labelProperty(), String.class).name("Y axis label").description("Y axis label").category("Y axis").build(), new PropertyItemBuilder((Property)axis.autoRangingProperty(), Boolean.class).name("Y axis autorange").description("Set Y axis range automatically").category("Y axis").build(), new PropertyItemBuilder((Property)axis.lowerBoundProperty(), Double.class).name("Y lower bound").description("Y lower bound").category("Y axis").build(), new PropertyItemBuilder((Property)axis.upperBoundProperty(), Double.class).name("Y upper bound").description("Y upper bound").category("Y axis").build(), new PropertyItemBuilder((Property)axis.tickUnitProperty(), Double.class).name("Y tick unit").description("Spacing between ticks on y axis").category("Y axis").build()});
            } else {
                this.sheet.getItems().add((Object)new PropertyItemBuilder((Property)xyChart.getYAxis().labelProperty(), String.class).name("Y axis label").description("Y axis label").category("Y axis").build());
            }
        }
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{new PropertyItemBuilder(this.exportResolutionProperty, ExportResolution.class).name("Export resolution").description("Resolution at which to copy/save the chart").category("Export").build(), new PropertyItemBuilder((Property)this.requestedWidth, Integer.class).name("Width").description("Requested chart width").category("Export").build(), new PropertyItemBuilder((Property)this.requestedHeight, Integer.class).name("Height").description("Requested chart height").category("Export").build()});
        this.chartStyleProperty.addListener(o -> this.updateChartStyles());
        this.strokeWidthProperty.addListener(o -> this.updateChartStyles());
        BorderPane paneLeft = new BorderPane();
        paneLeft.setTop(this.initializePrefsManager());
        paneLeft.setCenter((Node)this.sheet);
        this.pane.setLeft((Node)paneLeft);
        this.refreshChartDisplay();
        ExportChartPane.updateStoredPrefs();
    }

    public Image getChartImage() {
        double scale = ((ExportResolution)((Object)this.exportResolutionProperty.get())).getScale();
        int w = (int)(this.chart.getWidth() * scale + 0.5);
        int h = (int)(this.chart.getHeight() * scale + 0.5);
        SnapshotParameters params = new SnapshotParameters();
        params.setTransform((Transform)Transform.scale((double)scale, (double)scale));
        return this.chart.snapshot(params, new WritableImage(w, h));
    }

    public static ExportChartPane showExportChartDialog(Chart chart, Callback<Chart, Chart> duplicator) {
        ExportChartPane panel = new ExportChartPane(duplicator == null ? chart : (Chart)duplicator.call((Object)chart));
        Scene scene = new Scene((Parent)panel.getPane());
        Stage stage = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)stage);
        stage.setTitle("Export chart");
        stage.setScene(scene);
        stage.show();
        panel.refreshChartDisplay();
        return panel;
    }

    public static void showExportChartDialog(XYChart<Number, Number> chart) {
        try {
            XYChart<Number, Number> chart2 = ExportChartPane.copyChart(chart);
            ExportChartPane.showExportChartDialog(chart2, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Dialogs.showErrorNotification((String)"Export chart display error", (String)"Unable to duplicate chart");
            logger.error("Error duplicating chart", (Throwable)e);
        }
    }

    public void refreshChartDisplay() {
        if (this.chart == null || this.chart.getScene() == null || this.chart.getScene().getWindow() == null) {
            if (this.chart != null) {
                this.chart.autosize();
            }
            return;
        }
        int w = GeneralTools.clipValue((int)this.requestedWidth.get(), (int)5, (int)5000);
        int h = GeneralTools.clipValue((int)this.requestedHeight.get(), (int)5, (int)5000);
        if (this.requestedWidth.get() <= 0) {
            this.scrollPane.setFitToWidth(true);
        } else {
            this.scrollPane.setFitToWidth(false);
            this.chart.setPrefWidth((double)w);
        }
        if (this.requestedHeight.get() <= 0) {
            this.scrollPane.setFitToHeight(true);
        } else {
            this.scrollPane.setFitToHeight(false);
            this.chart.setPrefHeight((double)h);
        }
        this.chart.autosize();
        this.chart.requestLayout();
        requestedWidthProperty.set(this.requestedWidth.get());
        requestedHeightProperty.set(this.requestedHeight.get());
        this.updateChartStyles();
    }

    private void updateChartStyles() {
        int n = this.chart instanceof XYChart ? ((XYChart)this.chart).getData().size() : 1;
        ArrayList<String> stylesheets = new ArrayList<String>();
        stylesheets.add(this.getClass().getClassLoader().getResource("css/charts/chart_base.css").toExternalForm());
        stylesheets.add(((ChartStyle)((Object)this.chartStyleProperty.get())).getStylesheet(n));
        stylesheets.add(((ChartStrokeWidth)((Object)this.strokeWidthProperty.get())).getStylesheet(n));
        if (!useSolidLines.get()) {
            stylesheets.add(this.getClass().getClassLoader().getResource("css/charts/chart_strokes_dashed.css").toExternalForm());
        }
        this.chart.getStylesheets().setAll(stylesheets);
        if (this.chart instanceof LineChart && this.chart.isLegendVisible()) {
            ChartTools.setLineChartLegendLines(this.chart, 25.0);
        }
        persistentStrokeWidthProperty.set((Object)((ChartStrokeWidth)((Object)this.strokeWidthProperty.get())));
        persistentChartStyleProperty.set((Object)((ChartStyle)((Object)this.chartStyleProperty.get())));
        persistentSolidLinesProperty.set(useSolidLines.get());
    }

    public Pane getPane() {
        return this.pane;
    }

    private static synchronized void updateStoredPrefs() {
        ArrayList<String> prefs = new ArrayList<String>();
        try {
            PathPrefs.getUserPreferences().sync();
            for (String pref : PathPrefs.getUserPreferences().keys()) {
                if (!pref.startsWith(EXPORT_CHART_PREFS_KEY)) continue;
                prefs.add(pref.substring(EXPORT_CHART_PREFS_KEY.length()));
            }
        }
        catch (Exception e) {
            logger.error("Problem reading preferences", (Throwable)e);
        }
        if (!storedPrefs.equals(prefs)) {
            storedPrefs.setAll(prefs);
        }
    }

    public static XYChart<Number, Number> copyChart(XYChart<Number, Number> chart) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        XYChart chart2 = (XYChart)chart.getClass().getConstructor(Axis.class, Axis.class).newInstance(new NumberAxis(), new NumberAxis());
        ExportChartPane.setAxisProperties((Axis<Number>)chart.getXAxis(), (Axis<Number>)chart2.getXAxis());
        ExportChartPane.setAxisProperties((Axis<Number>)chart.getYAxis(), (Axis<Number>)chart2.getYAxis());
        for (XYChart.Series series : chart.getData()) {
            XYChart.Series series2 = new XYChart.Series();
            series2.setName(series.getName());
            for (XYChart.Data data : series.getData()) {
                series2.getData().add((Object)new XYChart.Data((Object)((Number)data.getXValue()), (Object)((Number)data.getYValue()), data.getExtraValue()));
            }
            chart2.getData().add((Object)series2);
        }
        chart2.setTitle(chart.getTitle());
        chart2.setStyle(chart.getStyle());
        return chart2;
    }

    private static void setAxisProperties(Axis<Number> axisOrig, Axis<Number> axisNew) {
        if (axisOrig instanceof NumberAxis && axisNew instanceof NumberAxis) {
            NumberAxis nAxisOrig = (NumberAxis)axisOrig;
            NumberAxis nAxisNew = (NumberAxis)axisNew;
            nAxisNew.setLowerBound(nAxisOrig.getLowerBound());
            nAxisNew.setUpperBound(nAxisOrig.getUpperBound());
            nAxisNew.setTickUnit(nAxisOrig.getTickUnit());
        }
        axisNew.setAutoRanging(axisOrig.isAutoRanging());
        axisNew.setLabel(axisOrig.getLabel());
    }

    static void saveExportPreferences(List<PropertySheet.Item> items, String name) throws IOException {
        Map<String, Serializable> map = ExportChartPane.getPreferenceMap(items);
        String json = GsonTools.getInstance((boolean)false).toJson(map);
        PathPrefs.getUserPreferences().put(EXPORT_CHART_PREFS_KEY + name, json);
    }

    static boolean loadExportPreferences(List<PropertySheet.Item> items, String name) throws IOException, ClassNotFoundException {
        String json = PathPrefs.getUserPreferences().get(EXPORT_CHART_PREFS_KEY + name, null);
        if (json == null) {
            return false;
        }
        Map map = (Map)GsonTools.getInstance((boolean)false).fromJson(json, Map.class);
        if (map == null) {
            return false;
        }
        int count = 0;
        for (PropertySheet.Item item : items) {
            Object value;
            if ("Series".equals(item.getCategory()) || (value = map.getOrDefault(item.getName(), null)) == null) continue;
            try {
                Class cls = item.getType();
                if (cls.isInstance(value)) {
                    item.setValue(value);
                } else if (cls.isEnum() && value instanceof String) {
                    item.setValue(Enum.valueOf(cls, value));
                }
            }
            catch (Exception e) {
                logger.warn(e.getLocalizedMessage(), (Throwable)e);
            }
            ++count;
        }
        logger.debug("{} preferences set", (Object)count);
        return true;
    }

    static Map<String, Serializable> getPreferenceMap(List<PropertySheet.Item> items) {
        LinkedHashMap<String, Serializable> prefsMap = new LinkedHashMap<String, Serializable>();
        for (PropertySheet.Item item : items) {
            String name = item.getName();
            Object value = item.getValue();
            if (!(value instanceof Serializable)) continue;
            prefsMap.put(name, (Serializable)value);
        }
        return prefsMap;
    }

    Node initializePrefsManager() {
        ComboBox combo = new ComboBox(storedPrefs);
        combo.setTooltip(new Tooltip("Previously stored preferences to use for export"));
        combo.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> {
            if (n != null) {
                try {
                    ExportChartPane.loadExportPreferences((List<PropertySheet.Item>)this.sheet.getItems(), n);
                }
                catch (Exception e) {
                    Dialogs.showErrorMessage((String)"Error loading prefs", (String)("Sorry, unable to load preferences for " + n));
                    logger.error("Error loading prefs", (Throwable)e);
                }
            }
        });
        Button btnAdd = new Button("Add");
        btnAdd.setTooltip(new Tooltip("Add current preferences to stored list"));
        btnAdd.setOnAction(e -> {
            String name = Dialogs.showInputDialog((String)"Export chart", (String)"Enter name for stored preferences", (String)this.chart.getTitle());
            if (name != null && !name.trim().isEmpty()) {
                try {
                    ExportChartPane.saveExportPreferences((List<PropertySheet.Item>)this.sheet.getItems(), name);
                    ExportChartPane.updateStoredPrefs();
                    combo.getSelectionModel().select((Object)name);
                }
                catch (Exception e1) {
                    Dialogs.showErrorMessage((String)"Error loading prefs", (String)("Sorry, unable to save preferences " + name));
                    logger.error("Error saving prefs", (Throwable)e1);
                }
            }
        });
        Button btnRemove = new Button("Remove");
        btnRemove.setTooltip(new Tooltip("Remove current preferences from stored list"));
        btnRemove.setOnAction(e -> {
            String selected = (String)combo.getSelectionModel().getSelectedItem();
            if (selected != null && !selected.trim().isEmpty() && Dialogs.showConfirmDialog((String)"Remove export prefs", (String)("Remove \"" + selected + "\"?"))) {
                PathPrefs.getUserPreferences().remove(EXPORT_CHART_PREFS_KEY + selected);
                ExportChartPane.updateStoredPrefs();
            }
        });
        BorderPane pane = new BorderPane();
        combo.setMaxWidth(Double.MAX_VALUE);
        pane.setCenter((Node)combo);
        pane.setBottom((Node)GridPaneUtils.createColumnGridControls((Node[])new Node[]{btnAdd, btnRemove}));
        TitledPane titledPane = new TitledPane("Presets", (Node)pane);
        titledPane.setCollapsible(false);
        return titledPane;
    }

    public static enum ChartStrokeWidth {
        NONE("None"),
        THINNEST("Thinnest"),
        THIN("Thin"),
        MODERATE("Moderate"),
        THICK("Thick"),
        THICKEST("Thickest");

        private String name;

        private ChartStrokeWidth(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getStylesheet() {
            switch (this.ordinal()) {
                case 3: {
                    return ((Object)((Object)this)).getClass().getClassLoader().getResource("css/charts/chart_stroke_moderate.css").toExternalForm();
                }
                case 0: {
                    return ((Object)((Object)this)).getClass().getClassLoader().getResource("css/charts/chart_stroke_none.css").toExternalForm();
                }
                case 4: {
                    return ((Object)((Object)this)).getClass().getClassLoader().getResource("css/charts/chart_stroke_thick.css").toExternalForm();
                }
                case 5: {
                    return ((Object)((Object)this)).getClass().getClassLoader().getResource("css/charts/chart_stroke_thickest.css").toExternalForm();
                }
                case 2: {
                    return ((Object)((Object)this)).getClass().getClassLoader().getResource("css/charts/chart_stroke_thin.css").toExternalForm();
                }
                case 1: {
                    return ((Object)((Object)this)).getClass().getClassLoader().getResource("css/charts/chart_stroke_thinnest.css").toExternalForm();
                }
            }
            return null;
        }

        public String getStylesheet(int nSeries) {
            return this.getStylesheet();
        }
    }

    public static enum ChartStyle {
        COLOR("Color"),
        GRAY("Gray"),
        BLACK("Black");

        private String name;

        private ChartStyle(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private String getResourceName() {
            switch (this.ordinal()) {
                case 2: {
                    return "css/charts/chart_style_black.css";
                }
                case 0: {
                    return "css/charts/chart_style_color.css";
                }
                case 1: {
                    return "css/charts/chart_style_gray.css";
                }
            }
            return null;
        }

        public String getStylesheet() {
            return ((Object)((Object)this)).getClass().getClassLoader().getResource(this.getResourceName()).toExternalForm();
        }

        public String getStylesheet(int nSeries) {
            String resourceName = this.getResourceName();
            String alternative = resourceName.replace(".css", nSeries + ".css");
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(alternative);
            if (url == null) {
                return this.getStylesheet();
            }
            return url.toExternalForm();
        }
    }

    public static enum ExportResolution {
        LOW("Low", 1.0),
        MEDIUM("Medium", 2.0),
        HIGH("High", 4.0),
        HIGHEST("Highest", 8.0);

        private String name;
        private double scale;

        private ExportResolution(String name, double scale) {
            this.name = name;
            this.scale = scale;
        }

        public String getName() {
            return this.name;
        }

        public double getScale() {
            return this.scale;
        }
    }
}

