/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.charts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.Chart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.ScatterChart;
import javafx.scene.chart.XYChart;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.charts.ChartTools;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.roi.interfaces.ROI;

public class Charts {
    public static ScatterChartBuilder scatterChart() {
        return new ScatterChartBuilder();
    }

    public static PieChartBuilder pieChart() {
        return new PieChartBuilder();
    }

    public static BarChartBuilder barChart() {
        return new BarChartBuilder();
    }

    public static class ScatterChartBuilder
    extends XYNumberChartBuilder<ScatterChartBuilder, ScatterChart<Number, Number>> {
        private static final Logger logger = LoggerFactory.getLogger(ScatterChartBuilder.class);
        private ObservableList<XYChart.Series<Number, Number>> series = FXCollections.observableArrayList();
        private Integer DEFAULT_MAX_DATAPOINTS = 10000;
        private Integer maxDatapoints;
        private Random rnd = new Random();

        private ScatterChartBuilder() {
        }

        public ScatterChartBuilder limitDatapoints(int max) {
            this.maxDatapoints = max;
            return this;
        }

        public ScatterChartBuilder unlimitedDatapoints() {
            this.maxDatapoints = -1;
            return this;
        }

        @Override
        protected String getDefaultWindowTitle() {
            return "Scatter Chart";
        }

        public ScatterChartBuilder random(Random rnd) {
            this.rnd = rnd;
            return this;
        }

        public <T> ScatterChartBuilder centroids(Collection<? extends PathObject> pathObjects, PixelCalibration cal) {
            this.xLabel("x (" + cal.getPixelWidthUnit() + ")");
            this.yLabel("y (" + cal.getPixelHeightUnit() + ")");
            return this.addSeries(null, pathObjects, p -> PathObjectTools.getROI((PathObject)p, (boolean)true).getCentroidX() * cal.getPixelWidth().doubleValue(), (T p) -> -PathObjectTools.getROI((PathObject)p, (boolean)true).getCentroidY() * cal.getPixelHeight().doubleValue());
        }

        public ScatterChartBuilder centroids(Collection<? extends PathObject> pathObjects) {
            PixelCalibration cal = this.imageData == null ? PixelCalibration.getDefaultInstance() : this.imageData.getServer().getPixelCalibration();
            return this.centroids(pathObjects, cal);
        }

        public ScatterChartBuilder measurements(Collection<? extends PathObject> pathObjects, String xMeasurement, String yMeasurement) {
            this.xLabel(xMeasurement);
            this.yLabel(yMeasurement);
            return this.addSeries(null, pathObjects, p -> p.getMeasurementList().get(xMeasurement), (T p) -> p.getMeasurementList().get(yMeasurement));
        }

        public <T> ScatterChartBuilder addSeries(String name, Collection<? extends T> collection, Function<T, Number> xFun, Function<T, Number> yFun) {
            return this.addSeries(name, collection.stream().map(p -> new XYChart.Data((Object)((Number)xFun.apply(p)), (Object)((Number)yFun.apply(p)), p)).toList());
        }

        public ScatterChartBuilder addSeries(String name, Collection<? extends Number> x, Collection<? extends Number> y) {
            return this.addSeries(name, x.stream().mapToDouble(Number::doubleValue).toArray(), y.stream().mapToDouble(Number::doubleValue).toArray());
        }

        public ScatterChartBuilder addSeries(String name, double[] x, double[] y) {
            return this.addSeries(name, x, y, (List)null);
        }

        public <T> ScatterChartBuilder addSeries(String name, double[] x, double[] y, T[] extra) {
            return this.addSeries(name, x, y, extra == null ? null : Arrays.asList(extra));
        }

        public <T> ScatterChartBuilder addSeries(String name, double[] x, double[] y, List<T> extra) {
            return this.addSeries(ScatterChartBuilder.createSeries(name, x, y, extra));
        }

        public ScatterChartBuilder addSeries(String name, Collection<XYChart.Data<Number, Number>> data) {
            if (data instanceof ObservableList) {
                this.series.add((Object)new XYChart.Series(name, (ObservableList)data));
            } else {
                this.series.add((Object)new XYChart.Series(name, FXCollections.observableArrayList(data)));
            }
            return this;
        }

        public ScatterChartBuilder addSeries(XYChart.Series<Number, Number> series) {
            this.series.add(series);
            return this;
        }

        public static XYChart.Series<Number, Number> createSeriesFromMeasurements(Collection<? extends PathObject> pathObjects, String xMeasurement, String yMeasurement) {
            return ScatterChartBuilder.createSeries(null, pathObjects, p -> p.getMeasurementList().get(xMeasurement), (T p) -> p.getMeasurementList().get(yMeasurement));
        }

        public static <T> XYChart.Series<Number, Number> createSeries(String name, Collection<? extends T> collection, Function<T, Number> xFun, Function<T, Number> yFun) {
            return ScatterChartBuilder.createSeries(name, collection.stream().map(p -> new XYChart.Data((Object)((Number)xFun.apply(p)), (Object)((Number)yFun.apply(p)), p)).toList());
        }

        public static XYChart.Series<Number, Number> createSeries(String name, Collection<? extends Number> x, Collection<? extends Number> y) {
            return ScatterChartBuilder.createSeries(name, x.stream().mapToDouble(Number::doubleValue).toArray(), y.stream().mapToDouble(Number::doubleValue).toArray());
        }

        public static XYChart.Series<Number, Number> createSeries(String name, double[] x, double[] y) {
            return ScatterChartBuilder.createSeries(name, x, y, (List)null);
        }

        public static <T> XYChart.Series<Number, Number> createSeries(String name, double[] x, double[] y, T[] extra) {
            return ScatterChartBuilder.createSeries(name, x, y, extra == null ? null : Arrays.asList(extra));
        }

        public static <T> XYChart.Series<Number, Number> createSeries(String name, double[] x, double[] y, List<T> extra) {
            ArrayList<XYChart.Data<Number, Number>> data = new ArrayList<XYChart.Data<Number, Number>>();
            for (int i = 0; i < x.length; ++i) {
                if (extra != null && i < extra.size()) {
                    data.add((XYChart.Data<Number, Number>)new XYChart.Data((Object)x[i], (Object)y[i], extra.get(i)));
                    continue;
                }
                data.add((XYChart.Data<Number, Number>)new XYChart.Data((Object)x[i], (Object)y[i]));
            }
            return ScatterChartBuilder.createSeries(name, data);
        }

        private static XYChart.Series<Number, Number> createSeries(String name, Collection<XYChart.Data<Number, Number>> data) {
            return new XYChart.Series(name, FXCollections.observableArrayList(data));
        }

        @Override
        protected void updateChart(ScatterChart<Number, Number> chart) {
            super.updateChart(chart);
            chart.getData().setAll(this.series);
            for (XYChart.Series s : this.series) {
                for (XYChart.Data d : s.getData()) {
                    Object extra = d.getExtraValue();
                    Node node = d.getNode();
                    if (!(extra instanceof PathObject) || node == null) continue;
                    PathObject pathObject = (PathObject)extra;
                    Integer color = ColorToolsFX.getDisplayedColorARGB(pathObject);
                    String style = String.format("-fx-background-color: rgb(%d,%d,%d,%.2f);", ColorTools.red((int)color), ColorTools.green((int)color), ColorTools.blue((int)color), this.markerOpacity);
                    node.setStyle(style);
                    node.addEventHandler(MouseEvent.ANY, e -> {
                        if (e.getEventType() == MouseEvent.MOUSE_CLICKED) {
                            this.tryToSelect((PathObject)extra, e.isShiftDown(), e.getClickCount() == 2);
                        } else if (e.getEventType() == MouseEvent.MOUSE_ENTERED) {
                            node.setStyle(style + ";-fx-effect: dropshadow(three-pass-box, rgba(0,0,0,0.5), 4, 0, 1, 1);");
                        } else if (e.getEventType() == MouseEvent.MOUSE_EXITED) {
                            node.setStyle(style);
                        }
                    });
                }
            }
        }

        @Override
        protected ScatterChart<Number, Number> createNewChart(Axis<Number> xAxis, Axis<Number> yAxis) {
            return new ScatterChart(xAxis, yAxis);
        }

        private void tryToSelect(PathObject pathObject, boolean addToSelection, boolean centerObject) {
            ScatterChartBuilder.tryToSelect(pathObject, this.viewer, this.imageData, addToSelection, centerObject);
        }

        public static void tryToSelect(PathObject pathObject, QuPathViewer viewer, ImageData<?> imageData, boolean addToSelection, boolean centerObject) {
            PathObjectHierarchy hierarchy = null;
            if (imageData != null) {
                hierarchy = imageData.getHierarchy();
            } else if (viewer != null) {
                hierarchy = viewer.getHierarchy();
            }
            if (hierarchy == null) {
                return;
            }
            if (addToSelection) {
                hierarchy.getSelectionModel().selectObjects(Collections.singletonList(pathObject));
            } else {
                hierarchy.getSelectionModel().setSelectedObject(pathObject);
            }
            if (centerObject && viewer != null) {
                ROI roi = pathObject.getROI();
                viewer.setCenterPixelLocation(roi.getCentroidX(), roi.getCentroidY());
            }
        }

        @Override
        protected ScatterChartBuilder getThis() {
            return this;
        }

        @Override
        public ScatterChart<Number, Number> build() {
            this.subsampleSeries();
            return (ScatterChart)super.build();
        }

        private void subsampleSeries() {
            int n = this.maxDatapoints == null ? this.DEFAULT_MAX_DATAPOINTS : this.maxDatapoints;
            for (XYChart.Series series : this.series) {
                Object data = series.getData();
                if (data.size() > n) {
                    logger.warn("Subsampling {} data points to {}", (Object)data.size(), (Object)n);
                    ArrayList list = new ArrayList(data);
                    Collections.shuffle(list, this.rnd);
                    data = list.subList(0, n);
                }
                series.getData().setAll((Collection)data);
            }
        }
    }

    public static class PieChartBuilder
    extends ChartBuilder<PieChartBuilder, PieChart> {
        private Map<Object, Number> data = new LinkedHashMap<Object, Number>();
        private Function<Object, String> stringFun = null;
        private boolean tooltips = true;
        private boolean convertToPercentages = false;

        private PieChartBuilder() {
            this.legendVisible = true;
        }

        @Override
        protected PieChartBuilder getThis() {
            return this;
        }

        @Override
        protected PieChart createNewChart() {
            PieChart pieChart = new PieChart();
            pieChart.setAnimated(false);
            return pieChart;
        }

        @Override
        protected String getDefaultWindowTitle() {
            return "Pie Chart";
        }

        public PieChartBuilder data(Map<?, ? extends Number> data) {
            for (Map.Entry<?, Number> entry : data.entrySet()) {
                this.addSlice(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public PieChartBuilder convertToPercentages(boolean doConvert) {
            this.convertToPercentages = doConvert;
            return this;
        }

        public PieChartBuilder tooltips(boolean showTooltips) {
            this.tooltips = showTooltips;
            return this;
        }

        public PieChartBuilder addSlice(Object name, Number value) {
            this.data.put(name, value);
            return this;
        }

        @Override
        protected void updateChart(PieChart chart) {
            super.updateChart(chart);
            ChartTools.setPieChartData(chart, this.data, this.stringFun, PieChartBuilder::colorExtractor, this.convertToPercentages, this.tooltips);
        }

        static Color colorExtractor(Object key) {
            Integer rgb = null;
            if (key instanceof PathClass) {
                rgb = ((PathClass)key).getColor();
            } else if (key instanceof PathObject) {
                rgb = ColorToolsFX.getDisplayedColorARGB((PathObject)key);
            }
            return rgb == null ? null : ColorToolsFX.getCachedColor(rgb);
        }
    }

    public static class BarChartBuilder
    extends XYCategoryChartBuilder<BarChartBuilder, BarChart<String, Number>> {
        private final ObservableList<XYChart.Series<String, Number>> series = FXCollections.observableArrayList();
        private final ObservableList<PathObject> pathObjects = FXCollections.observableArrayList();

        private BarChartBuilder() {
        }

        @Override
        protected String getDefaultWindowTitle() {
            return "Bar Chart";
        }

        public <T> BarChartBuilder series(String name, Collection<? extends T> collection, Function<T, PathClass> xFun) {
            Map classAndCount = collection.stream().map(xFun).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            return this.series(name, classAndCount.entrySet().stream().map(e -> {
                if (e.getKey() == null) {
                    return new XYChart.Data((Object)PathClass.NULL_CLASS.toString(), (Object)((Number)e.getValue()), (Object)PathClass.NULL_CLASS);
                }
                return new XYChart.Data((Object)((PathClass)e.getKey()).toString(), (Object)((Number)e.getValue()), e.getKey());
            }).sorted(Comparator.comparing(XYChart.Data::getXValue)).toList());
        }

        public <T extends Number> BarChartBuilder series(String name, Collection<? extends String> x, Collection<T> y) {
            return this.series(name, (String[])x.stream().map(String::valueOf).toArray(String[]::new), y.stream().mapToDouble(Number::doubleValue).toArray());
        }

        public <T extends Number> BarChartBuilder series(String name, Map<String, T> data) {
            return this.series(name, (String[])data.keySet().toArray(String[]::new), data.values().stream().mapToDouble(Number::doubleValue).toArray(), (List)null);
        }

        public BarChartBuilder series(String name, String[] x, double[] y) {
            return this.series(name, x, y, (List)null);
        }

        public <T> BarChartBuilder series(String name, String[] x, double[] y, T[] extra) {
            return this.series(name, x, y, extra == null ? null : Arrays.asList(extra));
        }

        public <T> BarChartBuilder series(String name, String[] x, double[] y, List<T> extra) {
            ArrayList<XYChart.Data<String, Number>> data = new ArrayList<XYChart.Data<String, Number>>();
            for (int i = 0; i < x.length; ++i) {
                if (extra != null && i < extra.size()) {
                    data.add((XYChart.Data<String, Number>)new XYChart.Data((Object)x[i], (Object)y[i], extra.get(i)));
                    continue;
                }
                data.add((XYChart.Data<String, Number>)new XYChart.Data((Object)x[i], (Object)y[i]));
            }
            return this.series(name, data);
        }

        public BarChartBuilder series(String name, Collection<XYChart.Data<String, Number>> data) {
            if (data instanceof ObservableList) {
                this.series.add((Object)new XYChart.Series(name, (ObservableList)data));
            } else {
                this.series.add((Object)new XYChart.Series(name, FXCollections.observableArrayList(data)));
            }
            return this;
        }

        @Override
        protected void updateChart(BarChart<String, Number> chart) {
            super.updateChart(chart);
            chart.getData().setAll(this.series);
            for (XYChart.Series s : this.series) {
                for (XYChart.Data d : s.getData()) {
                    Object extra = d.getExtraValue();
                    Node node = d.getNode();
                    if (!(extra instanceof PathClass) || node == null) continue;
                    PathClass pathClass = (PathClass)extra;
                    Integer color = pathClass.getColor();
                    if (color == null) {
                        color = ColorTools.packRGB((int)127, (int)127, (int)127);
                    }
                    String style = String.format("-fx-background-color: rgb(%d,%d,%d,%.2f);", ColorTools.red((int)color), ColorTools.green((int)color), ColorTools.blue((int)color), this.markerOpacity);
                    node.setStyle(style);
                    node.addEventHandler(MouseEvent.ANY, e -> {
                        if (e.getEventType() == MouseEvent.MOUSE_CLICKED) {
                            this.tryToSelect(pathClass, e.isShiftDown(), e.getClickCount() == 2);
                        } else if (e.getEventType() == MouseEvent.MOUSE_ENTERED) {
                            node.setStyle(style + ";-fx-effect: dropshadow(three-pass-box, rgba(0,0,0,0.5), 4, 0, 1, 1);");
                        } else if (e.getEventType() == MouseEvent.MOUSE_EXITED) {
                            node.setStyle(style);
                        }
                    });
                }
            }
        }

        public BarChartBuilder classifications(Collection<? extends PathObject> pathObjects) {
            this.xLabel("Classification");
            this.yLabel("Count");
            this.pathObjects.addAll(pathObjects);
            return this.series(null, pathObjects, BarChartBuilder::getPathClassOrNullClass);
        }

        private static PathClass getPathClassOrNullClass(PathObject p) {
            return p.getPathClass() == null ? PathClass.NULL_CLASS : p.getPathClass();
        }

        @Override
        protected BarChart<String, Number> createNewChart(Axis<String> xAxis, Axis<Number> yAxis) {
            return new BarChart(xAxis, yAxis);
        }

        private void tryToSelect(PathClass pathClass, boolean addToSelection, boolean centerObject) {
            PathObjectHierarchy hierarchy = null;
            if (this.imageData != null) {
                hierarchy = this.imageData.getHierarchy();
            } else if (this.viewer != null) {
                hierarchy = this.viewer.getHierarchy();
            }
            if (hierarchy == null) {
                return;
            }
            PathClass comparePathClass = pathClass == PathClass.NULL_CLASS ? null : pathClass;
            List<PathObject> objects = this.pathObjects.stream().filter(p -> Objects.equals(comparePathClass, p.getPathClass())).toList();
            if (addToSelection) {
                hierarchy.getSelectionModel().selectObjects(objects);
            } else if (!objects.isEmpty()) {
                hierarchy.getSelectionModel().setSelectedObjects(objects, objects.get(0).getParent());
            }
        }

        @Override
        protected BarChartBuilder getThis() {
            return this;
        }
    }

    static abstract class XYCategoryChartBuilder<T extends XYCategoryChartBuilder<T, S>, S extends XYChart<String, Number>>
    extends XYChartBuilder<T, S, String, Number> {
        private Double yLower;
        private Double yUpper;

        XYCategoryChartBuilder() {
        }

        protected abstract S createNewChart(Axis<String> var1, Axis<Number> var2);

        public T yAxisMin(double lowerBound) {
            this.yLower = lowerBound;
            return (T)((XYCategoryChartBuilder)this.getThis());
        }

        public T yAxisMax(double upperBound) {
            return (T)((XYCategoryChartBuilder)this.getThis());
        }

        public T yAxisRange(double lowerBound, double upperBound) {
            this.yLower = lowerBound;
            this.yUpper = upperBound;
            return (T)((XYCategoryChartBuilder)this.getThis());
        }

        @Override
        protected S createNewChart() {
            CategoryAxis xAxis = new CategoryAxis();
            NumberAxis yAxis = new NumberAxis();
            XYCategoryChartBuilder.setBoundIfValid(yAxis.lowerBoundProperty(), this.yLower);
            XYCategoryChartBuilder.setBoundIfValid(yAxis.upperBoundProperty(), this.yUpper);
            if (this.xLabel != null) {
                xAxis.setLabel(this.xLabel);
            }
            if (this.yLabel != null) {
                yAxis.setLabel(this.yLabel);
            }
            return this.createNewChart((Axis<String>)xAxis, (Axis<Number>)yAxis);
        }

        private static void setBoundIfValid(DoubleProperty prop, Double val) {
            if (val != null && Double.isFinite(val)) {
                prop.set(val.doubleValue());
            }
        }
    }

    static abstract class XYNumberChartBuilder<T extends XYNumberChartBuilder<T, S>, S extends XYChart<Number, Number>>
    extends XYChartBuilder<T, S, Number, Number> {
        private static final Logger logger = LoggerFactory.getLogger(XYNumberChartBuilder.class);
        private Double xLower;
        private Double xUpper;
        private Double yLower;
        private Double yUpper;

        XYNumberChartBuilder() {
        }

        protected abstract S createNewChart(Axis<Number> var1, Axis<Number> var2);

        public T xAxisMin(double lowerBound) {
            this.xLower = lowerBound;
            return (T)((XYNumberChartBuilder)this.getThis());
        }

        public T yAxisMin(double lowerBound) {
            this.yLower = lowerBound;
            return (T)((XYNumberChartBuilder)this.getThis());
        }

        public T xAxisMax(double upperBound) {
            this.xUpper = upperBound;
            return (T)((XYNumberChartBuilder)this.getThis());
        }

        public T yAxisMax(double upperBound) {
            this.xUpper = upperBound;
            return (T)((XYNumberChartBuilder)this.getThis());
        }

        public T xAxisRange(double lowerBound, double upperBound) {
            this.xLower = lowerBound;
            this.xUpper = upperBound;
            return (T)((XYNumberChartBuilder)this.getThis());
        }

        public T yAxisRange(double lowerBound, double upperBound) {
            this.yLower = lowerBound;
            this.yUpper = upperBound;
            return (T)((XYNumberChartBuilder)this.getThis());
        }

        @Override
        protected S createNewChart() {
            NumberAxis xAxis = new NumberAxis();
            NumberAxis yAxis = new NumberAxis();
            XYNumberChartBuilder.setBoundIfValid(xAxis.lowerBoundProperty(), this.xLower);
            XYNumberChartBuilder.setBoundIfValid(xAxis.upperBoundProperty(), this.xUpper);
            XYNumberChartBuilder.setBoundIfValid(yAxis.lowerBoundProperty(), this.yLower);
            XYNumberChartBuilder.setBoundIfValid(yAxis.upperBoundProperty(), this.yUpper);
            if (this.xLabel != null) {
                xAxis.setLabel(this.xLabel);
            }
            if (this.yLabel != null) {
                yAxis.setLabel(this.yLabel);
            }
            return this.createNewChart((Axis<Number>)xAxis, (Axis<Number>)yAxis);
        }

        private static void setBoundIfValid(DoubleProperty prop, Double val) {
            if (val != null && Double.isFinite(val)) {
                prop.set(val.doubleValue());
            }
        }
    }

    static abstract class XYChartBuilder<T extends XYChartBuilder<T, S, X, Y>, S extends XYChart<X, Y>, X, Y>
    extends ChartBuilder<T, S> {
        protected String xLabel;
        protected String yLabel;

        XYChartBuilder() {
        }

        public T xLabel(String label) {
            this.xLabel = label;
            return (T)((XYChartBuilder)this.getThis());
        }

        public T yLabel(String label) {
            this.yLabel = label;
            return (T)((XYChartBuilder)this.getThis());
        }
    }

    static abstract class ChartBuilder<T extends ChartBuilder<T, S>, S extends Chart> {
        protected QuPathViewer viewer;
        protected ImageData<?> imageData;
        protected String title;
        protected boolean legendVisible = false;
        protected Side legendSide;
        protected double markerOpacity = 1.0;
        protected double width = -1.0;
        protected double height = -1.0;
        private String windowTitle;
        private Window parent;

        ChartBuilder() {
        }

        protected abstract T getThis();

        public T title(String title) {
            this.title = title;
            return this.getThis();
        }

        public T legend(boolean show) {
            this.legendVisible = true;
            return this.getThis();
        }

        public T legend(String side) {
            if (side == null) {
                return this.legend(false);
            }
            switch (side.toLowerCase()) {
                case "top": {
                    return this.legend(Side.TOP);
                }
                case "bottom": {
                    return this.legend(Side.BOTTOM);
                }
                case "left": {
                    return this.legend(Side.LEFT);
                }
                case "right": {
                    return this.legend(Side.RIGHT);
                }
            }
            return this.legend(false);
        }

        public T legend(Side side) {
            this.legendSide = side;
            this.legendVisible = this.legendSide != null;
            return this.getThis();
        }

        public T markerOpacity(double opacity) {
            this.markerOpacity = GeneralTools.clipValue((double)opacity, (double)0.0, (double)1.0);
            return this.getThis();
        }

        public T imageData(ImageData<?> imageData) {
            this.imageData = imageData;
            return this.getThis();
        }

        public T viewer(QuPathViewer viewer) {
            this.viewer = viewer;
            return this.getThis();
        }

        public T width(double width) {
            this.width = width;
            return this.getThis();
        }

        public T height(double height) {
            this.height = height;
            return this.getThis();
        }

        public T size(double width, double height) {
            this.width = width;
            this.height = height;
            return this.getThis();
        }

        public T parent(Window parent) {
            this.parent = parent;
            return this.getThis();
        }

        public T windowTitle(String title) {
            this.windowTitle = title;
            return this.getThis();
        }

        protected void updateChart(S chart) {
            chart.setTitle(this.title);
            if (this.legendSide != null) {
                chart.setLegendSide(this.legendSide);
            }
            chart.setLegendVisible(this.legendVisible);
            if (this.width > 0.0) {
                chart.setPrefWidth(this.width);
            }
            if (this.height > 0.0) {
                chart.setPrefHeight(this.height);
            }
        }

        protected abstract S createNewChart();

        public S build() {
            S chart = this.createNewChart();
            this.updateChart(chart);
            return chart;
        }

        protected String getDefaultWindowTitle() {
            return "Chart";
        }

        public Stage toStage() {
            if (!Platform.isFxApplicationThread()) {
                return (Stage)FXUtils.callOnApplicationThread(() -> this.toStage());
            }
            Stage stage = new Stage();
            if (this.parent == null) {
                if (this.viewer != null && this.viewer.getView() != null) {
                    this.parent = this.viewer.getView().getScene().getWindow();
                } else {
                    QuPathGUI qupath = QuPathGUI.getInstance();
                    if (qupath != null) {
                        this.parent = qupath.getStage();
                    }
                }
            }
            if (this.parent != null) {
                stage.initOwner(this.parent);
            }
            if (this.windowTitle != null) {
                stage.setTitle(this.windowTitle);
            } else {
                stage.setTitle(GeneralTools.generateDistinctName((String)this.getDefaultWindowTitle(), (Collection)Window.getWindows().stream().filter(w -> w instanceof Stage).map(w -> ((Stage)w).getTitle()).collect(Collectors.toSet())));
            }
            stage.setScene(new Scene(this.build()));
            return stage;
        }

        public Stage show() {
            if (!Platform.isFxApplicationThread()) {
                return (Stage)FXUtils.callOnApplicationThread(() -> this.show());
            }
            Stage stage = this.toStage();
            stage.show();
            return stage;
        }
    }
}

