/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.charts;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Chart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.charts.ExportChartPane;

public class ChartTools {
    private static final Logger logger = LoggerFactory.getLogger(ChartTools.class);
    private static Map<String, String> piechartStyleSheets = new HashMap<String, String>();

    public static String getChartDataAsString(XYChart<Number, Number> chart) {
        StringBuilder sb = new StringBuilder();
        String delim = "\t";
        int maxLength = 0;
        int count = 0;
        for (XYChart.Series series : chart.getData()) {
            maxLength = Math.max(maxLength, series.getData().size());
            ++count;
            if (series.getName() != null) {
                sb.append(series.getName()).append(delim).append(delim);
                continue;
            }
            sb.append("Series " + count).append(delim).append(delim);
        }
        sb.append("\n");
        for (int i = 0; i < chart.getData().size(); ++i) {
            sb.append(chart.getXAxis().getLabel()).append(delim);
            sb.append(chart.getYAxis().getLabel()).append(delim);
        }
        sb.append("\n");
        for (int row = 0; row < maxLength; ++row) {
            for (XYChart.Series series : chart.getData()) {
                if (row < series.getData().size()) {
                    XYChart.Data d = (XYChart.Data)series.getData().get(row);
                    sb.append(d.getXValue()).append(delim);
                    sb.append(d.getYValue()).append(delim);
                    continue;
                }
                sb.append(delim).append(delim);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void makeChartInteractive(Chart chart, final NumberAxis xAxis, final NumberAxis yAxis) {
        Function<MouseEvent, Point2D> convertChartPoint = new Function<MouseEvent, Point2D>(){

            @Override
            public Point2D apply(MouseEvent event) {
                Point2D mouseScenePoint = new Point2D(event.getSceneX(), event.getSceneY());
                double x = xAxis.getValueForDisplay(xAxis.sceneToLocal(mouseScenePoint).getX()).doubleValue();
                double y = yAxis.getValueForDisplay(yAxis.sceneToLocal(mouseScenePoint).getY()).doubleValue();
                return new Point2D(x, y);
            }
        };
        Rectangle rect = new Rectangle();
        chart.setOnMouseClicked(e -> {
            if (e.getClickCount() > 1) {
                xAxis.setAutoRanging(true);
                yAxis.setAutoRanging(true);
            }
        });
        chart.setOnMousePressed(e -> {
            Point2D p = (Point2D)convertChartPoint.apply((MouseEvent)e);
            rect.setX(p.getX());
            rect.setY(p.getY());
            rect.setWidth(0.0);
            rect.setHeight(0.0);
        });
        chart.setOnMouseDragged(e -> {
            Point2D p = (Point2D)convertChartPoint.apply((MouseEvent)e);
            rect.setWidth(p.getX() - rect.getX());
            rect.setHeight(p.getY() - rect.getY());
        });
        chart.setOnMouseReleased(e -> {
            if (!e.isShiftDown()) {
                rect.setWidth(0.0);
                rect.setHeight(0.0);
                return;
            }
            Point2D p = (Point2D)convertChartPoint.apply((MouseEvent)e);
            rect.setWidth(p.getX() - rect.getX());
            rect.setHeight(p.getY() - rect.getY());
            logger.debug("Rectangle drawn on chart: {}", (Object)rect);
            if (rect.getWidth() != 0.0 && rect.getHeight() != 0.0) {
                double x1 = rect.getX();
                double y1 = rect.getY();
                double x2 = rect.getX() + rect.getWidth();
                double y2 = rect.getY() + rect.getHeight();
                xAxis.setAutoRanging(false);
                yAxis.setAutoRanging(false);
                xAxis.setLowerBound(Math.min(x1, x2));
                xAxis.setUpperBound(Math.max(x1, x2));
                yAxis.setLowerBound(Math.min(y1, y2));
                yAxis.setUpperBound(Math.max(y1, y2));
            }
        });
        chart.setOnScroll(e -> {
            if (xAxis.isAutoRanging() || yAxis.isAutoRanging()) {
                return;
            }
            double xDiff = -e.getDeltaX() / xAxis.getScale();
            double yDiff = -e.getDeltaY() / yAxis.getScale();
            xAxis.setLowerBound(xAxis.getLowerBound() + xDiff);
            xAxis.setUpperBound(xAxis.getUpperBound() + xDiff);
            yAxis.setLowerBound(yAxis.getLowerBound() + yDiff);
            yAxis.setUpperBound(yAxis.getUpperBound() + yDiff);
        });
    }

    public static void addChartExportMenu(XYChart<Number, Number> chart, ContextMenu menu) {
        MenuItem menuItem = new MenuItem("Export chart");
        menuItem.setOnAction(e -> ExportChartPane.showExportChartDialog(chart));
        if (menu == null) {
            ContextMenu menu2 = new ContextMenu();
            menu2.getItems().add((Object)menuItem);
            chart.setOnContextMenuRequested(e -> menu2.show((Node)chart, e.getScreenX(), e.getScreenY()));
        } else {
            menu.getItems().add((Object)menuItem);
        }
    }

    public static void setLineChartLegendLines(Chart chart, double length) {
        Region legend = (Region)chart.lookup(".chart-legend");
        int count = 0;
        for (Node legendItem : legend.getChildrenUnmodifiable()) {
            XYChart xyChart;
            if (!(legendItem instanceof Label)) continue;
            Label label = (Label)legendItem;
            Line line = new Line(0.0, 4.0, 25.0, 4.0);
            if (chart instanceof XYChart && ((XYChart.Series)(xyChart = (XYChart)chart).getData().get(count)).getData().isEmpty()) {
                label.setGraphic(null);
                ++count;
                continue;
            }
            line.getStyleClass().setAll((Object[])new String[]{"chart-series-line", "default-color" + count});
            label.setGraphic((Node)line);
            ++count;
        }
    }

    public static void expandChartClip(Chart chart, double pad) {
        Region chartContent = (Region)chart.lookup(".chart-content");
        for (Node node : chartContent.getChildrenUnmodifiable()) {
            if (!(node instanceof Group)) continue;
            Group plotArea = (Group)node;
            if (pad < 0.0) {
                plotArea.setClip(null);
                continue;
            }
            if (!(plotArea.getClip() instanceof Rectangle)) continue;
            Rectangle previousClip = (Rectangle)plotArea.getClip();
            Rectangle newClip = new Rectangle();
            newClip.xProperty().bind((ObservableValue)previousClip.xProperty().subtract(pad));
            newClip.yProperty().bind((ObservableValue)previousClip.yProperty().subtract(pad));
            newClip.widthProperty().bind((ObservableValue)previousClip.widthProperty().add(pad * 2.0));
            newClip.heightProperty().bind((ObservableValue)previousClip.heightProperty().add(pad * 2.0));
            plotArea.setClip((Node)newClip);
        }
    }

    public static <T> void setPieChartData(PieChart chart, Map<T, ? extends Number> counts, Function<T, String> stringFun, Function<T, Color> colorFun, boolean convertToPercentages, boolean includeTooltips) {
        double sum = counts.values().stream().mapToDouble(i -> i.doubleValue()).sum();
        LinkedHashMap<String, String> legendStyleMap = new LinkedHashMap<String, String>();
        LinkedHashSet previousData = new LinkedHashSet(chart.getData());
        for (Map.Entry<T, Number> entry : counts.entrySet()) {
            String previousStyle;
            T item = entry.getKey();
            String name = stringFun != null ? stringFun.apply(item) : Objects.toString(item);
            double value = entry.getValue().doubleValue();
            if (convertToPercentages) {
                value = value / sum * 100.0;
            }
            PieChart.Data datum = new PieChart.Data(name, value);
            chart.getData().add((Object)datum);
            Node node = datum.getNode();
            String styleString = "";
            Color color = colorFun.apply(item);
            if (color != null) {
                String colorString = String.format("rgb(%d, %d, %d)", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
                styleString = String.format("-fx-pie-color: %s", colorString);
                datum.getNode().setStyle(styleString);
            }
            if ((previousStyle = legendStyleMap.put(name, styleString)) != null && !Objects.equals(styleString, previousStyle)) {
                logger.warn("Multiple slices with the label '{}' but different colors - legend colors may be inconsistent!", (Object)name);
            }
            if (!includeTooltips) continue;
            String text = convertToPercentages ? String.format("%s: %.1f%%", name, value) : String.format("%s: %.1f", name, value);
            Tooltip.install((Node)node, (Tooltip)new Tooltip(text));
        }
        if (!previousData.isEmpty()) {
            chart.getData().removeAll(previousData);
        }
        for (Node item : chart.lookupAll(".chart-legend-item")) {
            Labeled label;
            String style;
            if (!(item instanceof Labeled) || (style = (String)legendStyleMap.getOrDefault((label = (Labeled)item).getText(), null)) == null) continue;
            label.getGraphic().setStyle(style);
        }
    }
}

