/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.charts;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableNumberValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartThresholdPane
extends BorderPane {
    private static final Logger logger = LoggerFactory.getLogger(ChartThresholdPane.class);
    private XYChart<Number, Number> chart;
    private NumberAxis xAxis;
    private NumberAxis yAxis;
    private DoubleProperty lineWidth = new SimpleDoubleProperty(2.0);
    private BooleanProperty isInteractive = new SimpleBooleanProperty(false);
    private ObservableList<ObservableNumberValue> thresholds = FXCollections.observableArrayList();
    private Map<ObservableNumberValue, Line> vLines = new HashMap<ObservableNumberValue, Line>();

    public ChartThresholdPane(XYChart<Number, Number> chart) {
        this.chart = chart;
        this.xAxis = (NumberAxis)chart.getXAxis();
        this.yAxis = (NumberAxis)chart.getYAxis();
        this.setCenter((Node)chart);
        this.thresholds.addListener(this::handleLineListChange);
    }

    private void handleLineListChange(ListChangeListener.Change<? extends ObservableNumberValue> c) {
        while (c.next()) {
            if (c.wasPermutated()) continue;
            for (ObservableNumberValue removedItem : c.getRemoved()) {
                this.getChildren().remove((Object)this.vLines.remove(removedItem));
            }
            for (ObservableNumberValue addedItem : c.getAddedSubList()) {
                this.addThreshold(addedItem);
            }
        }
    }

    public void setThresholds(Color color, double ... thresholds) {
        this.clearThresholds();
        for (double xx : thresholds) {
            this.addThreshold(xx, color);
        }
    }

    public ObservableList<ObservableNumberValue> getThresholds() {
        return this.thresholds;
    }

    public void clearThresholds() {
        this.thresholds.clear();
    }

    public void setThresholdColor(ObservableNumberValue val, Color color) {
        Line line = this.vLines.get(val);
        if (line == null) {
            logger.warn("No threshold line found for {}", (Object)val);
            return;
        }
        line.setStroke((Paint)color);
    }

    public ObservableNumberValue addThreshold(double x) {
        return this.addThreshold(x, null);
    }

    public ObservableNumberValue addThreshold(double x, Color color) {
        return this.addThreshold((ObservableNumberValue)new SimpleDoubleProperty(x), color);
    }

    public ObservableNumberValue addThreshold(ObservableNumberValue d) {
        return this.addThreshold(d, null);
    }

    private ObservableNumberValue addThreshold(ObservableNumberValue d, Color color) {
        Line line = new Line();
        line.getStyleClass().add((Object)"qupath-histogram-line");
        if (color != null) {
            line.setStroke((Paint)color);
        } else {
            line.setStyle("-fx-stroke: -fx-text-base-color; -fx-opacity: 0.5;");
        }
        line.strokeWidthProperty().bind((ObservableValue)this.lineWidth);
        line.startXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            double xAxisPosition = this.xAxis.getDisplayPosition((Number)d.doubleValue());
            Point2D positionInScene = this.xAxis.localToScene(xAxisPosition, 0.0);
            return this.sceneToLocal(positionInScene).getX();
        }, (Observable[])new Observable[]{d, this.chart.widthProperty(), this.chart.heightProperty(), this.chart.boundsInParentProperty(), this.xAxis.lowerBoundProperty(), this.xAxis.upperBoundProperty(), this.xAxis.autoRangingProperty(), this.yAxis.autoRangingProperty(), this.yAxis.lowerBoundProperty(), this.yAxis.upperBoundProperty(), this.yAxis.scaleProperty()}));
        line.endXProperty().bind((ObservableValue)line.startXProperty());
        line.startYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            double yAxisPosition = this.yAxis.getDisplayPosition((Number)this.yAxis.getLowerBound());
            Point2D positionInScene = this.yAxis.localToScene(0.0, yAxisPosition);
            return this.sceneToLocal(positionInScene).getY();
        }, (Observable[])new Observable[]{this.chart.widthProperty(), this.chart.heightProperty(), this.chart.boundsInParentProperty(), this.xAxis.lowerBoundProperty(), this.xAxis.upperBoundProperty(), this.xAxis.autoRangingProperty(), this.yAxis.autoRangingProperty(), this.yAxis.lowerBoundProperty(), this.yAxis.upperBoundProperty(), this.yAxis.scaleProperty()}));
        line.endYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            double yAxisPosition = this.yAxis.getDisplayPosition((Number)this.yAxis.getUpperBound());
            Point2D positionInScene = this.yAxis.localToScene(0.0, yAxisPosition);
            return this.sceneToLocal(positionInScene).getY();
        }, (Observable[])new Observable[]{this.chart.widthProperty(), this.chart.heightProperty(), this.chart.boundsInParentProperty(), this.xAxis.lowerBoundProperty(), this.xAxis.upperBoundProperty(), this.xAxis.autoRangingProperty(), this.yAxis.autoRangingProperty(), this.yAxis.lowerBoundProperty(), this.yAxis.upperBoundProperty(), this.yAxis.scaleProperty()}));
        line.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (Double.isNaN(d.doubleValue())) {
                return false;
            }
            return this.chart.isVisible();
        }, (Observable[])new Observable[]{d, this.chart.visibleProperty()}));
        if (d instanceof WritableNumberValue) {
            WritableNumberValue writableNumberValue = (WritableNumberValue)d;
            line.setOnMouseDragged(e -> {
                if (this.isInteractive()) {
                    double xNew = this.xAxis.getValueForDisplay(this.xAxis.sceneToLocal(e.getSceneX(), e.getSceneY()).getX()).doubleValue();
                    xNew = Math.max(xNew, this.xAxis.getLowerBound());
                    xNew = Math.min(xNew, this.xAxis.getUpperBound());
                    writableNumberValue.setValue((Object)xNew);
                }
            });
            line.setOnMouseEntered(e -> {
                if (this.isInteractive()) {
                    line.setCursor(Cursor.H_RESIZE);
                }
            });
            line.setOnMouseExited(e -> {
                if (this.isInteractive()) {
                    line.setCursor(Cursor.DEFAULT);
                }
            });
        }
        if (!this.thresholds.contains((Object)d)) {
            this.thresholds.add((Object)d);
        }
        this.vLines.put(d, line);
        this.getChildren().add((Object)line);
        return d;
    }

    public DoubleProperty lineWidthProperty() {
        return this.lineWidth;
    }

    public double getLineWidth() {
        return this.lineWidth.get();
    }

    public void setLineWidth(double width) {
        this.lineWidth.set(width);
    }

    public BooleanProperty isInteractiveProperty() {
        return this.isInteractive;
    }

    public boolean isInteractive() {
        return this.isInteractive.get();
    }

    public void setIsInteractive(boolean isInteractive) {
        this.isInteractive.set(isInteractive);
    }
}

