/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions.menus;

import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.stage.Screen;
import javafx.stage.Window;
import org.controlsfx.control.action.Action;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.actions.menus.MenuActions;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.prefs.SystemMenuBar;

public class WindowMenuActions
implements MenuActions {
    private QuPathGUI qupath;
    private Actions actions;

    WindowMenuActions(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public List<Action> getActions() {
        if (this.actions == null) {
            this.actions = new Actions(this);
        }
        return ActionTools.getAnnotatedActions(this.actions);
    }

    @Override
    public String getName() {
        return QuPathResources.getString("Menu.Window");
    }

    @ActionMenu(value={"Menu.Window"})
    public class Actions {
        @ActionConfig(value="Action.Window.centerWindows")
        public final Action CENTER_ALL = ActionTools.createAction(this::centerAllWindows);
        @ActionConfig(value="Action.Window.centerOffscreen")
        public final Action CENTER_OFFSCREEN = ActionTools.createAction(this::centerOffscreen);
        public final Action SEP = ActionTools.createSeparator();
        @ActionConfig(value="Action.Window.systemMenubar")
        public final Action SYSTEM_MENUBAR = this.createSystemMenuAction();
        @ActionConfig(value="Action.Window.imageName")
        public final Action IMAGE_NAME = ActionTools.createSelectableAction((ObservableValue<Boolean>)PathPrefs.showImageNameInTitleProperty());

        public Actions(WindowMenuActions this$0) {
        }

        private void centerOffscreen() {
            for (Window window : Window.getWindows()) {
                if (!Actions.isOffscreenWindow(window)) continue;
                window.centerOnScreen();
            }
        }

        private static boolean isOffscreenWindow(Window window) {
            ObservableList screens = Screen.getScreensForRectangle((double)window.getX(), (double)window.getY(), (double)window.getWidth(), (double)window.getHeight());
            if (screens.size() != 1) {
                return false;
            }
            Screen screen = (Screen)screens.getFirst();
            return !screen.getVisualBounds().contains(window.getX(), window.getY(), window.getWidth(), window.getHeight());
        }

        private void centerAllWindows() {
            Window.getWindows().forEach(Window::centerOnScreen);
        }

        private Action createSystemMenuAction() {
            if (!SystemMenuBar.supportsSystemMenubar()) {
                return null;
            }
            Action action = new Action("Use system menubar", e -> this.toggleSystemMenubar());
            ObjectProperty<SystemMenuBar.SystemMenuBarOption> prop = SystemMenuBar.systemMenubarProperty();
            action.setSelected(prop.get() == SystemMenuBar.SystemMenuBarOption.ALL_WINDOWS);
            prop.addListener((v, o, n) -> action.setSelected(n == SystemMenuBar.SystemMenuBarOption.ALL_WINDOWS));
            ActionTools.setSelectable(action, true);
            return action;
        }

        private void toggleSystemMenubar() {
            switch ((SystemMenuBar.SystemMenuBarOption)((Object)SystemMenuBar.systemMenubarProperty().get())) {
                case ALL_WINDOWS: {
                    SystemMenuBar.systemMenubarProperty().set((Object)SystemMenuBar.SystemMenuBarOption.NEVER);
                    break;
                }
                case NEVER: {
                    SystemMenuBar.systemMenubarProperty().set((Object)SystemMenuBar.SystemMenuBarOption.ALL_WINDOWS);
                }
            }
        }
    }
}

