/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions.menus;

import java.util.List;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import org.controlsfx.control.action.Action;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.CommonActions;
import qupath.lib.gui.actions.OverlayActions;
import qupath.lib.gui.actions.ViewerActions;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionIcon;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.actions.menus.MenuActions;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.panes.SlideLabelView;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.CommandFinderTools;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.viewer.QuPathViewer;

public class ViewMenuActions
implements MenuActions {
    private QuPathGUI qupath;
    private CommonActions commonActions;
    private ViewerActions viewerActions;
    private OverlayActions overlayActions;
    private Actions actions;

    ViewMenuActions(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public List<Action> getActions() {
        if (this.actions == null) {
            this.commonActions = this.qupath.getCommonActions();
            this.viewerActions = this.qupath.getViewerActions();
            this.overlayActions = this.qupath.getOverlayActions();
            this.actions = new Actions();
        }
        return ActionTools.getAnnotatedActions(this.actions);
    }

    @Override
    public String getName() {
        return QuPathResources.getString("Menu.View");
    }

    @ActionMenu(value={"Menu.View"})
    public class Actions {
        public final Action SHOW_ANALYSIS_PANEL;
        @ActionConfig(value="Action.View.commandList")
        @ActionAccelerator(value="shortcut+l")
        @ActionIcon(value=IconFactory.PathIcons.COMMAND_LIST)
        public final Action COMMAND_LIST;
        @ActionConfig(value="Action.View.recentCommands")
        @ActionAccelerator(value="shortcut+p")
        @ActionIcon(value=IconFactory.PathIcons.RECENT_COMMANDS)
        public final Action RECENT_COMMAND_LIST;
        public final Action SEP_0;
        public final Action BRIGHTNESS_CONTRAST;
        public final Action SEP_1;
        @ActionMenu(value={"Menu.View.Multiview"})
        public final MultiviewActions multiviewActions;
        @ActionConfig(value="Action.View.channelViewer")
        public final Action CHANNEL_VIEWER;
        @ActionConfig(value="Action.View.miniViewer")
        public final Action MINI_VIEWER;
        public final Action SEP_2;
        @ActionMenu(value={"Menu.View.Zoom"})
        public final Object zoomActions;
        @ActionConfig(value="Action.View.rotate")
        public final Action ROTATE_IMAGE;
        public final Action SEP_4;
        @ActionMenu(value={"Menu.View.CellDisplay"})
        public final CellDisplayActions cellDisplayActions;
        public final Action SHOW_ANNOTATIONS;
        public final Action FILL_ANNOTATIONS;
        public final Action SHOW_NAMES;
        public final Action SHOW_TMA_GRID;
        public final Action SHOW_TMA_GRID_LABELS;
        public final Action SHOW_DETECTIONS;
        public final Action FILL_DETECTIONS;
        public final Action SHOW_CONNECTIONS;
        public final Action SHOW_PIXEL_CLASSIFICATION;
        public final Action SEP_5;
        public final Action SHOW_OVERVIEW;
        public final Action SHOW_LOCATION;
        public final Action SHOW_SCALEBAR;
        public final Action SHOW_Z_PROJECT;
        public final Action SHOW_GRID;
        public final Action GRID_SPACING;
        public final Action SEP_6;
        @ActionConfig(value="Action.View.viewTracker")
        public final Action VIEW_TRACKER;
        @ActionConfig(value="Action.View.slideLabel")
        public final Action SLIDE_LABEL;
        public final Action SEP_7;
        @ActionConfig(value="Action.View.inputDisplay")
        @ActionIcon(value=IconFactory.PathIcons.KEYBOARD)
        public final Action INPUT_DISPLAY;
        @ActionConfig(value="Action.View.memoryMonitor")
        public final Action MEMORY_MONITOR;
        public final Action SHOW_LOG;
        public final Action SEP_8;
        @ActionMenu(value={"Menu.View.Multitouch"})
        public final MultitouchActions multitouchActions;

        public Actions() {
            this.SHOW_ANALYSIS_PANEL = ViewMenuActions.this.commonActions.SHOW_ANALYSIS_PANE;
            this.COMMAND_LIST = Commands.createSingleStageAction(() -> CommandFinderTools.createCommandFinderDialog(ViewMenuActions.this.qupath));
            this.RECENT_COMMAND_LIST = Commands.createSingleStageAction(() -> CommandFinderTools.createRecentCommandsDialog(ViewMenuActions.this.qupath));
            this.SEP_0 = ActionTools.createSeparator();
            this.BRIGHTNESS_CONTRAST = ViewMenuActions.this.commonActions.BRIGHTNESS_CONTRAST;
            this.SEP_1 = ActionTools.createSeparator();
            this.multiviewActions = new MultiviewActions();
            this.CHANNEL_VIEWER = ViewMenuActions.this.qupath.createViewerAction(viewer -> Commands.showChannelViewer(viewer));
            this.MINI_VIEWER = ViewMenuActions.this.qupath.createViewerAction(viewer -> Commands.showMiniViewer(viewer));
            this.SEP_2 = ActionTools.createSeparator();
            this.zoomActions = new ZoomActions();
            this.ROTATE_IMAGE = ViewMenuActions.this.qupath.createImageDataAction(imageData -> Commands.createRotateImageDialog(ViewMenuActions.this.qupath));
            this.SEP_4 = ActionTools.createSeparator();
            this.cellDisplayActions = new CellDisplayActions();
            this.SHOW_ANNOTATIONS = ViewMenuActions.this.overlayActions.SHOW_ANNOTATIONS;
            this.FILL_ANNOTATIONS = ViewMenuActions.this.overlayActions.FILL_ANNOTATIONS;
            this.SHOW_NAMES = ViewMenuActions.this.overlayActions.SHOW_NAMES;
            this.SHOW_TMA_GRID = ViewMenuActions.this.overlayActions.SHOW_TMA_GRID;
            this.SHOW_TMA_GRID_LABELS = ViewMenuActions.this.overlayActions.SHOW_TMA_GRID_LABELS;
            this.SHOW_DETECTIONS = ViewMenuActions.this.overlayActions.SHOW_DETECTIONS;
            this.FILL_DETECTIONS = ViewMenuActions.this.overlayActions.FILL_DETECTIONS;
            this.SHOW_CONNECTIONS = ViewMenuActions.this.overlayActions.SHOW_CONNECTIONS;
            this.SHOW_PIXEL_CLASSIFICATION = ViewMenuActions.this.overlayActions.SHOW_PIXEL_CLASSIFICATION;
            this.SEP_5 = ActionTools.createSeparator();
            this.SHOW_OVERVIEW = ViewMenuActions.this.viewerActions.SHOW_OVERVIEW;
            this.SHOW_LOCATION = ViewMenuActions.this.viewerActions.SHOW_LOCATION;
            this.SHOW_SCALEBAR = ViewMenuActions.this.viewerActions.SHOW_SCALEBAR;
            this.SHOW_Z_PROJECT = ViewMenuActions.this.viewerActions.SHOW_Z_PROJECT;
            this.SHOW_GRID = ViewMenuActions.this.overlayActions.SHOW_GRID;
            this.GRID_SPACING = ViewMenuActions.this.overlayActions.GRID_SPACING;
            this.SEP_6 = ActionTools.createSeparator();
            this.VIEW_TRACKER = ViewMenuActions.this.qupath.createImageDataAction(imageData -> Commands.showViewTracker(ViewMenuActions.this.qupath));
            this.SLIDE_LABEL = ActionTools.createSelectableCommandAction((ObservableBooleanValue)new SlideLabelView(ViewMenuActions.this.qupath).showingProperty());
            this.SEP_7 = ActionTools.createSeparator();
            this.INPUT_DISPLAY = ViewMenuActions.this.commonActions.INPUT_DISPLAY;
            this.MEMORY_MONITOR = ViewMenuActions.this.commonActions.MEMORY_MONITOR;
            this.SHOW_LOG = ViewMenuActions.this.commonActions.SHOW_LOG;
            this.SEP_8 = ActionTools.createSeparator();
            this.multitouchActions = new MultitouchActions(ViewMenuActions.this);
        }
    }

    public class MultitouchActions {
        @ActionConfig(value="Action.View.Multitouch.allOn")
        public final Action GESTURES_ALL = ActionTools.createAction(() -> {
            PathPrefs.useScrollGesturesProperty().set(true);
            PathPrefs.useZoomGesturesProperty().set(true);
            PathPrefs.useRotateGesturesProperty().set(true);
        });
        @ActionConfig(value="Action.View.Multitouch.allOff")
        public final Action GESTURES_NONE = ActionTools.createAction(() -> {
            PathPrefs.useScrollGesturesProperty().set(false);
            PathPrefs.useZoomGesturesProperty().set(false);
            PathPrefs.useRotateGesturesProperty().set(false);
        });
        public final Action SEP_9 = ActionTools.createSeparator();
        @ActionConfig(value="Action.View.Multitouch.scroll")
        public final Action GESTURES_SCROLL = ActionTools.createSelectableCommandAction((ObservableBooleanValue)PathPrefs.useScrollGesturesProperty());
        @ActionConfig(value="Action.View.Multitouch.zoom")
        public final Action GESTURES_ZOOM = ActionTools.createSelectableCommandAction((ObservableBooleanValue)PathPrefs.useZoomGesturesProperty());
        @ActionConfig(value="Action.View.Multitouch.rotate")
        public final Action GESTURES_ROTATE = ActionTools.createSelectableCommandAction((ObservableBooleanValue)PathPrefs.useRotateGesturesProperty());

        public MultitouchActions(ViewMenuActions this$0) {
        }
    }

    public class CellDisplayActions {
        public final Action SHOW_CELL_BOUNDARIES;
        public final Action SHOW_CELL_NUCLEI;
        public final Action SHOW_CELL_BOUNDARIES_AND_NUCLEI;
        public final Action SHOW_CELL_CENTROIDS;

        public CellDisplayActions() {
            this.SHOW_CELL_BOUNDARIES = ViewMenuActions.this.overlayActions.SHOW_CELL_BOUNDARIES;
            this.SHOW_CELL_NUCLEI = ViewMenuActions.this.overlayActions.SHOW_CELL_NUCLEI;
            this.SHOW_CELL_BOUNDARIES_AND_NUCLEI = ViewMenuActions.this.overlayActions.SHOW_CELL_BOUNDARIES_AND_NUCLEI;
            this.SHOW_CELL_CENTROIDS = ViewMenuActions.this.overlayActions.SHOW_CELL_CENTROIDS;
        }
    }

    public class ZoomActions {
        @ActionConfig(value="Action.View.Zoom.400")
        public final Action ZOOM_400;
        @ActionConfig(value="Action.View.Zoom.100")
        public final Action ZOOM_100;
        @ActionConfig(value="Action.View.Zoom.10")
        public final Action ZOOM_10;
        @ActionConfig(value="Action.View.Zoom.1")
        public final Action ZOOM_1;
        public final Action SEP_3;
        @ActionConfig(value="Action.View.Zoom.zoomIn")
        @ActionIcon(value=IconFactory.PathIcons.ZOOM_IN)
        public final Action ZOOM_IN;
        @ActionConfig(value="Action.View.Zoom.zoomOut")
        @ActionIcon(value=IconFactory.PathIcons.ZOOM_OUT)
        @ActionAccelerator(value="-")
        public final Action ZOOM_OUT;
        @ActionConfig(value="Action.View.Zoom.zoomToFit")
        public final Action ZOOM_TO_FIT;

        private ZoomActions() {
            this.ZOOM_400 = ViewMenuActions.this.qupath.createViewerAction(viewer -> Commands.setViewerDownsample(viewer, 0.25));
            this.ZOOM_100 = ViewMenuActions.this.qupath.createViewerAction(viewer -> Commands.setViewerDownsample(viewer, 1.0));
            this.ZOOM_10 = ViewMenuActions.this.qupath.createViewerAction(viewer -> Commands.setViewerDownsample(viewer, 10.0));
            this.ZOOM_1 = ViewMenuActions.this.qupath.createViewerAction(viewer -> Commands.setViewerDownsample(viewer, 100.0));
            this.SEP_3 = ActionTools.createSeparator();
            this.ZOOM_IN = Commands.createZoomCommand(ViewMenuActions.this.qupath, 10);
            this.ZOOM_OUT = Commands.createZoomCommand(ViewMenuActions.this.qupath, -10);
            this.ZOOM_TO_FIT = ViewMenuActions.this.viewerActions.ZOOM_TO_FIT;
            this.ZOOM_IN.setAccelerator((KeyCombination)new KeyCharacterCombination("+", new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY}));
            KeyCombination combo = new KeyCombination(this, new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY, KeyCombination.SHORTCUT_ANY}){

                public boolean match(KeyEvent event) {
                    return event.getCode() != KeyCode.UNDEFINED && "+".equals(event.getText()) && super.match(event);
                }
            };
            this.ZOOM_IN.setAccelerator(combo);
        }
    }

    public class MultiviewActions {
        @ActionMenu(value={"Action.View.Multiview.gridMenu"})
        public final MultiviewGridActions MULTIVIEW_GRID_ACTIONS;
        public final Action SEP_00;
        public final Action MULTIVIEW_SYNCHRONIZE_VIEWERS;
        public final Action MULTIVIEW_MATCH_RESOLUTIONS;
        public final Action SEP_01;
        @ActionConfig(value="Action.View.Multiview.closeViewer")
        public final Action MULTIVIEW_CLOSE_VIEWER;
        public final Action SEP_02;
        @ActionConfig(value="ViewerActions.detachViewer")
        public final Action DETACH_VIEWER;
        @ActionConfig(value="ViewerActions.attachViewer")
        public final Action ATTACH_VIEWER;

        public MultiviewActions() {
            this.MULTIVIEW_GRID_ACTIONS = new MultiviewGridActions();
            this.SEP_00 = ActionTools.createSeparator();
            this.MULTIVIEW_SYNCHRONIZE_VIEWERS = ViewMenuActions.this.viewerActions.TOGGLE_SYNCHRONIZE_VIEWERS;
            this.MULTIVIEW_MATCH_RESOLUTIONS = ViewMenuActions.this.viewerActions.MATCH_VIEWER_RESOLUTIONS;
            this.SEP_01 = ActionTools.createSeparator();
            this.MULTIVIEW_CLOSE_VIEWER = ViewMenuActions.this.qupath.createViewerAction(viewer -> ViewMenuActions.this.qupath.closeViewer((QuPathViewer)viewer));
            this.SEP_02 = ActionTools.createSeparator();
            this.DETACH_VIEWER = ViewMenuActions.this.qupath.createViewerAction(viewer -> ViewMenuActions.this.qupath.getViewerManager().detachViewerFromGrid((QuPathViewer)viewer));
            this.ATTACH_VIEWER = ViewMenuActions.this.qupath.createViewerAction(viewer -> ViewMenuActions.this.qupath.getViewerManager().attachViewerToGrid((QuPathViewer)viewer));
        }
    }

    public class MultiviewGridActions {
        public final Action MULTIVIEW_GRID_1x1;
        public final Action MULTIVIEW_GRID_1x2;
        public final Action MULTIVIEW_GRID_2x1;
        public final Action MULTIVIEW_GRID_2x2;
        public final Action MULTIVIEW_GRID_3x3;
        public final Action SEP_00;
        @ActionConfig(value="Action.View.Multiview.addRow")
        public final Action MULTIVIEW_ADD_ROW;
        @ActionConfig(value="Action.View.Multiview.addColumn")
        public final Action MULTIVIEW_ADD_COLUMN;
        public final Action SEP_01;
        @ActionConfig(value="Action.View.Multiview.removeRow")
        public final Action MULTIVIEW_REMOVE_ROW;
        @ActionConfig(value="Action.View.Multiview.removeColumn")
        public final Action MULTIVIEW_REMOVE_COLUMN;
        public final Action SEP_02;
        @ActionConfig(value="Action.View.Multiview.resetGridSize")
        public final Action MULTIVIEW_RESET_GRID;

        public MultiviewGridActions() {
            this.MULTIVIEW_GRID_1x1 = ViewMenuActions.this.viewerActions.VIEWER_GRID_1x1;
            this.MULTIVIEW_GRID_1x2 = ViewMenuActions.this.viewerActions.VIEWER_GRID_1x2;
            this.MULTIVIEW_GRID_2x1 = ViewMenuActions.this.viewerActions.VIEWER_GRID_2x1;
            this.MULTIVIEW_GRID_2x2 = ViewMenuActions.this.viewerActions.VIEWER_GRID_2x2;
            this.MULTIVIEW_GRID_3x3 = ViewMenuActions.this.viewerActions.VIEWER_GRID_3x3;
            this.SEP_00 = ActionTools.createSeparator();
            this.MULTIVIEW_ADD_ROW = ViewMenuActions.this.qupath.createViewerAction(viewer -> ViewMenuActions.this.qupath.getViewerManager().addRow((QuPathViewer)viewer));
            this.MULTIVIEW_ADD_COLUMN = ViewMenuActions.this.qupath.createViewerAction(viewer -> ViewMenuActions.this.qupath.getViewerManager().addColumn((QuPathViewer)viewer));
            this.SEP_01 = ActionTools.createSeparator();
            this.MULTIVIEW_REMOVE_ROW = ViewMenuActions.this.qupath.createViewerAction(viewer -> ViewMenuActions.this.qupath.getViewerManager().removeRow((QuPathViewer)viewer));
            this.MULTIVIEW_REMOVE_COLUMN = ViewMenuActions.this.qupath.createViewerAction(viewer -> ViewMenuActions.this.qupath.getViewerManager().removeColumn((QuPathViewer)viewer));
            this.SEP_02 = ActionTools.createSeparator();
            this.MULTIVIEW_RESET_GRID = ViewMenuActions.this.qupath.createViewerAction(viewer -> ViewMenuActions.this.qupath.getViewerManager().resetGridSize());
        }
    }
}

