/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions.menus;

import java.util.List;
import org.controlsfx.control.action.Action;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.actions.menus.MenuActions;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.commands.TMACommands;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.plugins.objects.FindConvexHullDetectionsPlugin;

public class TMAMenuActions
implements MenuActions {
    private QuPathGUI qupath;
    private Actions actions;

    TMAMenuActions(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public List<Action> getActions() {
        if (this.actions == null) {
            this.actions = new Actions();
        }
        return ActionTools.getAnnotatedActions(this.actions);
    }

    @Override
    public String getName() {
        return QuPathResources.getString("Menu.TMA.name");
    }

    @ActionMenu(value={"Menu.TMA"})
    public class Actions {
        @ActionConfig(value="Action.TMA.specifyGrid")
        public final Action CREATE_MANUAL;
        public final Action SEP_0;
        @ActionMenu(value={"Menu.TMA.add"})
        public final AddActions addActions;
        @ActionMenu(value={"Menu.TMA.remove"})
        public final RemoveActions removeActions;
        @ActionConfig(value="Action.TMA.relabel")
        public final Action RELABEL;
        @ActionConfig(value="Action.TMA.resetMetadata")
        public final Action RESET_METADATA;
        @ActionConfig(value="Action.TMA.deleteGrid")
        public final Action CLEAR_CORES;
        public final Action SEP_1;
        @ActionConfig(value="Action.TMA.findHull")
        public final Action CONVEX_HULL;

        public Actions() {
            this.CREATE_MANUAL = TMAMenuActions.this.qupath.createImageDataAction(imageData -> TMACommands.promptToCreateTMAGrid(imageData));
            this.SEP_0 = ActionTools.createSeparator();
            this.addActions = new AddActions();
            this.removeActions = new RemoveActions();
            this.RELABEL = TMAMenuActions.this.qupath.createImageDataAction(imageData -> TMACommands.promptToRelabelTMAGrid(imageData));
            this.RESET_METADATA = TMAMenuActions.this.qupath.createImageDataAction(imageData -> Commands.resetTMAMetadata(imageData));
            this.CLEAR_CORES = TMAMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToDeleteObjects(imageData, TMACoreObject.class));
            this.SEP_1 = ActionTools.createSeparator();
            this.CONVEX_HULL = TMAMenuActions.this.qupath.createPluginAction("Find convex hull detections (TMA)", FindConvexHullDetectionsPlugin.class, null);
        }

        public class AddActions {
            @ActionConfig(value="Action.TMA.addRowAbove")
            public final Action ADD_ROW_BEFORE;
            @ActionConfig(value="Action.TMA.addRowBelow")
            public final Action ADD_ROW_AFTER;
            @ActionConfig(value="Action.TMA.addColumnBefore")
            public final Action ADD_COLUMN_BEFORE;
            @ActionConfig(value="Action.TMA.addColumnAfter")
            public final Action ADD_COLUMN_AFTER;

            public AddActions() {
                this.ADD_ROW_BEFORE = TMAMenuActions.this.qupath.createImageDataAction(imageData -> TMACommands.promptToAddRowBeforeSelected(imageData));
                this.ADD_ROW_AFTER = TMAMenuActions.this.qupath.createImageDataAction(imageData -> TMACommands.promptToAddRowAfterSelected(imageData));
                this.ADD_COLUMN_BEFORE = TMAMenuActions.this.qupath.createImageDataAction(imageData -> TMACommands.promptToAddColumnBeforeSelected(imageData));
                this.ADD_COLUMN_AFTER = TMAMenuActions.this.qupath.createImageDataAction(imageData -> TMACommands.promptToAddColumnAfterSelected(imageData));
            }
        }

        public class RemoveActions {
            @ActionConfig(value="Action.TMA.removeRow")
            public final Action REMOVE_ROW;
            @ActionConfig(value="Action.TMA.removeColumn")
            public final Action REMOVE_COLUMN;

            public RemoveActions() {
                this.REMOVE_ROW = TMAMenuActions.this.qupath.createImageDataAction(imageData -> TMACommands.promptToDeleteTMAGridRow(imageData));
                this.REMOVE_COLUMN = TMAMenuActions.this.qupath.createImageDataAction(imageData -> TMACommands.promptToDeleteTMAGridColumn(imageData));
            }
        }
    }
}

