/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions.menus;

import java.util.List;
import org.controlsfx.control.action.Action;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.CommonActions;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.actions.menus.MenuActions;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.commands.DeleteObjectsOnBoundsCommand;
import qupath.lib.gui.commands.objects.SplitAnnotationsByLineCommand;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.objects.DilateAnnotationPlugin;
import qupath.lib.plugins.objects.FillAnnotationHolesPlugin;
import qupath.lib.plugins.objects.RefineAnnotationsPlugin;
import qupath.lib.plugins.objects.SplitAnnotationsPlugin;

public class ObjectsMenuActions
implements MenuActions {
    private QuPathGUI qupath;
    private CommonActions commonActions;
    private Actions actions;

    ObjectsMenuActions(QuPathGUI qupath) {
        this.qupath = qupath;
        this.commonActions = qupath.getCommonActions();
    }

    @Override
    public List<Action> getActions() {
        if (this.actions == null) {
            this.actions = new Actions();
        }
        return ActionTools.getAnnotatedActions(this.actions);
    }

    @Override
    public String getName() {
        return QuPathResources.getString("Menu.Objects");
    }

    @ActionMenu(value={"Menu.Objects"})
    public class Actions {
        @ActionMenu(value={"Menu.Objects.Delete"})
        public final DeleteActions deleteActions;
        @ActionMenu(value={"Menu.Objects.Select"})
        public final SelectActions selectActions;
        @ActionMenu(value={"Menu.Objects.Lock"})
        public final LockActions lockActions;
        public final Action SHOW_OBJECT_DESCRIPTIONS;
        public final Action SEP_4;
        @ActionMenu(value={"Menu.Objects.Annotations"})
        public final AnnotationActions annotationActions;
        @ActionConfig(value="Action.Objects.refreshIds")
        public final Action REFRESH_OBJECT_IDS;
        @ActionConfig(value="Action.Objects.refreshDuplicateIds")
        public final Action REFRESH_DUPLICATE_OBJECT_IDS;

        public Actions() {
            this.deleteActions = new DeleteActions();
            this.selectActions = new SelectActions();
            this.lockActions = new LockActions();
            this.SHOW_OBJECT_DESCRIPTIONS = ObjectsMenuActions.this.commonActions.SHOW_OBJECT_DESCRIPTIONS;
            this.SEP_4 = ActionTools.createSeparator();
            this.annotationActions = new AnnotationActions();
            this.REFRESH_OBJECT_IDS = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.refreshObjectIDs(imageData, false));
            this.REFRESH_DUPLICATE_OBJECT_IDS = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.refreshObjectIDs(imageData, true));
        }
    }

    public class AnnotationActions {
        @ActionConfig(value="Action.Objects.Annotation.specify")
        public final Action SPECIFY_ANNOTATION = Commands.createSingleStageAction(() -> Commands.createSpecifyAnnotationDialog(ObjectsMenuActions.this.qupath));
        @ActionAccelerator(value="shortcut+shift+a")
        @ActionConfig(value="Action.Objects.Annotation.fullImage")
        public final Action SELECT_ALL_ANNOTATION;
        public final Action SEP_5;
        @ActionAccelerator(value="shortcut+shift+i")
        @ActionConfig(value="Action.Objects.Annotation.hierarchyInsert")
        public final Action INSERT_INTO_HIERARCHY;
        @ActionAccelerator(value="shortcut+shift+r")
        @ActionConfig(value="Action.Objects.Annotation.hierarchyResolve")
        public final Action RESOLVE_HIERARCHY;
        public final Action SEP_6;
        @ActionAccelerator(value="shortcut+shift+t")
        @ActionConfig(value="Action.Objects.Annotation.transform")
        public final Action RIGID_OBJECT_EDITOR;
        @ActionAccelerator(value="shift+d")
        @ActionConfig(value="Action.Objects.Annotation.duplicate")
        public final Action ANNOTATION_DUPLICATE;
        @ActionAccelerator(value="shortcut+shift+v")
        @ActionConfig(value="Action.Objects.Annotation.copyToCurrentPlane")
        public final Action ANNOTATION_COPY_TO_PLANE;
        @ActionAccelerator(value="shift+e")
        @ActionConfig(value="Action.Objects.Annotation.transferLast")
        public final Action TRANSFER_ANNOTATION;
        public final Action SEP_7;
        @ActionConfig(value="Action.Objects.Annotation.expand")
        public final Action EXPAND_ANNOTATIONS;
        @ActionConfig(value="Action.Objects.Annotation.split")
        public final Action SPLIT_ANNOTATIONS;
        private final SplitAnnotationsByLineCommand splitAnnotationsByLineCommand;
        @ActionConfig(value="Action.Objects.Annotation.splitByLines")
        public final Action SPLIT_ANNOTATIONS_BY_LINES;
        @ActionConfig(value="Action.Objects.Annotation.removeFragmentsFillHoles")
        public final Action REMOVE_FRAGMENTS;
        @ActionConfig(value="Action.Objects.Annotation.fillHoles")
        public final Action FILL_HOLES;
        public final Action SEP_8;
        @ActionConfig(value="Action.Objects.Annotation.makeInverse")
        public final Action MAKE_INVERSE;
        @ActionConfig(value="Action.Objects.Annotation.mergeSelected")
        public final Action MERGE_SELECTED;
        @ActionConfig(value="Action.Objects.Annotation.simplify")
        public final Action SIMPLIFY_SHAPE;

        public AnnotationActions() {
            this.SELECT_ALL_ANNOTATION = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.createFullImageAnnotation(ObjectsMenuActions.this.qupath.getViewer()));
            this.SEP_5 = ActionTools.createSeparator();
            this.INSERT_INTO_HIERARCHY = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.insertSelectedObjectsInHierarchy(imageData));
            this.RESOLVE_HIERARCHY = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToResolveHierarchy(imageData));
            this.SEP_6 = ActionTools.createSeparator();
            this.RIGID_OBJECT_EDITOR = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.editSelectedAnnotation(ObjectsMenuActions.this.qupath));
            this.ANNOTATION_DUPLICATE = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.duplicateSelectedAnnotations(imageData));
            this.ANNOTATION_COPY_TO_PLANE = ObjectsMenuActions.this.qupath.createViewerAction(viewer -> Commands.copySelectedAnnotationsToCurrentPlane(viewer));
            this.TRANSFER_ANNOTATION = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> ObjectsMenuActions.this.qupath.getViewerManager().applyLastAnnotationToActiveViewer());
            this.SEP_7 = ActionTools.createSeparator();
            this.EXPAND_ANNOTATIONS = ObjectsMenuActions.this.qupath.createPluginAction("Expand annotations", DilateAnnotationPlugin.class, null);
            this.SPLIT_ANNOTATIONS = ObjectsMenuActions.this.qupath.createPluginAction("Split annotations", SplitAnnotationsPlugin.class, null);
            this.splitAnnotationsByLineCommand = new SplitAnnotationsByLineCommand();
            this.SPLIT_ANNOTATIONS_BY_LINES = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> this.splitAnnotationsByLineCommand.run((ImageData<?>)imageData));
            this.REMOVE_FRAGMENTS = ObjectsMenuActions.this.qupath.createPluginAction("Remove fragments & holes", RefineAnnotationsPlugin.class, null);
            this.FILL_HOLES = ObjectsMenuActions.this.qupath.createPluginAction("Fill holes", FillAnnotationHolesPlugin.class, null);
            this.SEP_8 = ActionTools.createSeparator();
            this.MAKE_INVERSE = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.makeInverseAnnotation(imageData));
            this.MERGE_SELECTED = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.mergeSelectedAnnotations(imageData));
            this.SIMPLIFY_SHAPE = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToSimplifySelectedAnnotations(imageData, 1.0));
        }
    }

    public class LockActions {
        @ActionConfig(value="Action.Objects.Lock.lockSelected")
        @ActionAccelerator(value="shortcut+shift+k")
        public final Action LOCK_SELECTED_OBJECTS;
        @ActionConfig(value="Action.Objects.Lock.unlockSelected")
        @ActionAccelerator(value="shortcut+alt+k")
        public final Action UNLOCK_SELECTED_OBJECTS;
        @ActionConfig(value="Action.Objects.Lock.toggleSelected")
        @ActionAccelerator(value="shortcut+k")
        public final Action TOGGLE_SELECTED_OBJECTS_LOCKED;

        public LockActions() {
            this.LOCK_SELECTED_OBJECTS = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> PathObjectTools.lockSelectedObjects((PathObjectHierarchy)imageData.getHierarchy()));
            this.UNLOCK_SELECTED_OBJECTS = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> PathObjectTools.unlockSelectedObjects((PathObjectHierarchy)imageData.getHierarchy()));
            this.TOGGLE_SELECTED_OBJECTS_LOCKED = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> PathObjectTools.toggleSelectedObjectsLocked((PathObjectHierarchy)imageData.getHierarchy()));
        }
    }

    public class SelectActions {
        @ActionConfig(value="Action.Objects.Select.reset")
        @ActionAccelerator(value="shortcut+alt+r")
        public final Action RESET_SELECTION;
        public final Action SEP_2;
        @ActionConfig(value="Action.Objects.Select.tmaCores")
        @ActionAccelerator(value="shortcut+alt+t")
        public final Action SELECT_TMA_CORES;
        @ActionConfig(value="Action.Objects.Select.annotations")
        @ActionAccelerator(value="shortcut+alt+a")
        public final Action SELECT_ANNOTATIONS;
        @ActionMenu(value={"Menu.Objects.Select.Detections"})
        @ActionConfig(value="Action.Objects.Select.detections")
        @ActionAccelerator(value="shortcut+alt+d")
        public final Action SELECT_ALL_DETECTIONS;
        @ActionMenu(value={"Menu.Objects.Select.Detections"})
        @ActionConfig(value="Action.Objects.Select.cells")
        @ActionAccelerator(value="shortcut+alt+c")
        public final Action SELECT_CELLS;
        @ActionMenu(value={"Menu.Objects.Select.Detections"})
        @ActionConfig(value="Action.Objects.Select.tiles")
        public final Action SELECT_TILES;
        public final Action SEP_3;
        @ActionConfig(value="Action.Objects.Select.selectByClassification")
        public final Action SELECT_BY_CLASSIFICATION;
        @ActionConfig(value="Action.Objects.Select.selectOnCurrentPlane")
        public final Action SELECT_BY_PLANE;

        public SelectActions() {
            this.RESET_SELECTION = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.resetSelection(imageData));
            this.SEP_2 = ActionTools.createSeparator();
            this.SELECT_TMA_CORES = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.selectObjectsByClass(imageData, TMACoreObject.class));
            this.SELECT_ANNOTATIONS = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.selectObjectsByClass(imageData, PathAnnotationObject.class));
            this.SELECT_ALL_DETECTIONS = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.selectObjectsByClass(imageData, PathDetectionObject.class));
            this.SELECT_CELLS = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.selectObjectsByClass(imageData, PathCellObject.class));
            this.SELECT_TILES = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.selectObjectsByClass(imageData, PathTileObject.class));
            this.SEP_3 = ActionTools.createSeparator();
            this.SELECT_BY_CLASSIFICATION = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToSelectObjectsByClassification(ObjectsMenuActions.this.qupath, imageData));
            this.SELECT_BY_PLANE = ObjectsMenuActions.this.qupath.createViewerAction(viewer -> Commands.selectObjectsOnCurrentPlane(viewer));
        }
    }

    public class DeleteActions {
        @ActionConfig(value="Action.Objects.Delete.selected")
        public final Action DELETE_SELECTED_OBJECTS;
        public final Action SEP_1;
        @ActionConfig(value="Action.Objects.Delete.all")
        public final Action DELETE_ALL;
        @ActionConfig(value="Action.Objects.Delete.annotations")
        public final Action DELETE_ANNOTATION;
        @ActionConfig(value="Action.Objects.Delete.detections")
        public final Action DELETE_DETECTIONS;
        public final Action SEP_2;
        @ActionConfig(value="Action.Objects.Delete.imageBoundary")
        public final Action DELETE_IMAGE_BOUNDARY;
        private final DeleteObjectsOnBoundsCommand deleteOnBoundsCommand;
        @ActionConfig(value="Action.Objects.Delete.selectedBoundary")
        public final Action DELETE_SELECTED_BOUNDARY;

        public DeleteActions() {
            this.DELETE_SELECTED_OBJECTS = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> GuiTools.promptToClearAllSelectedObjects(imageData));
            this.SEP_1 = ActionTools.createSeparator();
            this.DELETE_ALL = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToDeleteObjects(imageData, null));
            this.DELETE_ANNOTATION = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToDeleteObjects(imageData, PathAnnotationObject.class));
            this.DELETE_DETECTIONS = ObjectsMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToDeleteObjects(imageData, PathDetectionObject.class));
            this.SEP_2 = ActionTools.createSeparator();
            this.DELETE_IMAGE_BOUNDARY = ObjectsMenuActions.this.qupath.createImageDataAction(Commands::removeOnImageBounds);
            this.deleteOnBoundsCommand = new DeleteObjectsOnBoundsCommand(ObjectsMenuActions.this.qupath);
            this.DELETE_SELECTED_BOUNDARY = ObjectsMenuActions.this.qupath.createImageDataAction(this.deleteOnBoundsCommand::runForImage);
        }
    }
}

