/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions.menus;

import java.util.List;
import org.controlsfx.control.action.Action;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.CommonActions;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.actions.menus.MenuActions;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.commands.MeasurementExportCommand;
import qupath.lib.gui.localization.QuPathResources;

public class MeasureMenuActions
implements MenuActions {
    private QuPathGUI qupath;
    private CommonActions commonActions;
    private Actions actions;

    MeasureMenuActions(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public String getName() {
        return QuPathResources.getString("Menu.Measure");
    }

    @Override
    public List<Action> getActions() {
        if (this.actions == null) {
            this.commonActions = this.qupath.getCommonActions();
            this.actions = new Actions();
        }
        return ActionTools.getAnnotatedActions(this.actions);
    }

    @ActionMenu(value={"Menu.Measure"})
    public class Actions {
        @ActionAccelerator(value="shortcut+shift+m")
        @ActionConfig(value="Action.Measure.maps")
        public final Action MAPS = Commands.createSingleStageAction(() -> Commands.createMeasurementMapDialog(MeasureMenuActions.this.qupath));
        @ActionConfig(value="Action.Measure.manager")
        public final Action MANAGER;
        public final Action SEP_1;
        public final Action TMA;
        public final Action ANNOTATIONS;
        public final Action DETECTIONS;
        @ActionMenu(value={"Menu.Measure.GridViews"})
        public final Action GRID_ANNOTATIONS;
        @ActionMenu(value={"Menu.Measure.GridViews"})
        public final Action GRID_TMA;
        public final Action SEP_2;
        @ActionConfig(value="Action.Measure.export")
        public final Action EXPORT;

        private Actions() {
            this.MANAGER = MeasureMenuActions.this.qupath.createImageDataAction(imageData -> Commands.showDetectionMeasurementManager(MeasureMenuActions.this.qupath, imageData));
            this.SEP_1 = ActionTools.createSeparator();
            this.TMA = MeasureMenuActions.this.commonActions.MEASURE_TMA;
            this.ANNOTATIONS = MeasureMenuActions.this.commonActions.MEASURE_ANNOTATIONS;
            this.DETECTIONS = MeasureMenuActions.this.commonActions.MEASURE_DETECTIONS;
            this.GRID_ANNOTATIONS = MeasureMenuActions.this.commonActions.MEASURE_GRID_ANNOTATIONS;
            this.GRID_TMA = MeasureMenuActions.this.commonActions.MEASURE_GRID_TMA_CORES;
            this.SEP_2 = ActionTools.createSeparator();
            MeasurementExportCommand measureCommand = new MeasurementExportCommand(MeasureMenuActions.this.qupath);
            this.EXPORT = MeasureMenuActions.this.qupath.createProjectAction(project -> measureCommand.run());
        }
    }
}

