/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions.menus;

import java.util.List;
import org.controlsfx.control.action.Action;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.Urls;
import qupath.lib.gui.WelcomeStage;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.CommonActions;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.actions.menus.MenuActions;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.localization.QuPathResources;

public class HelpMenuActions
implements MenuActions {
    private QuPathGUI qupath;
    private CommonActions commonActions;
    private Actions actions;

    HelpMenuActions(QuPathGUI qupath) {
        this.qupath = qupath;
        this.commonActions = qupath.getCommonActions();
    }

    @Override
    public List<Action> getActions() {
        if (this.actions == null) {
            this.actions = new Actions();
        }
        return ActionTools.getAnnotatedActions(this.actions);
    }

    @Override
    public String getName() {
        return QuPathResources.getString("Menu.Help");
    }

    @ActionMenu(value={"Menu.Help"})
    public class Actions {
        @ActionConfig(value="Action.Help.welcome")
        public final Action QUPATH_STARTUP = ActionTools.createAction(() -> WelcomeStage.getInstance(HelpMenuActions.this.qupath).show());
        public final Action HELP_VIEWER;
        public final Action SEP_1;
        @ActionConfig(value="Action.Help.docs")
        public final Action DOCS;
        @ActionConfig(value="Action.Help.video")
        public final Action DEMOS;
        @ActionConfig(value="Action.Help.updates")
        public final Action UPDATE;
        public final Action SEP_2;
        @ActionConfig(value="Action.Help.cite")
        public final Action CITE;
        @ActionConfig(value="Action.Help.issues")
        public final Action BUGS;
        @ActionConfig(value="Action.Help.forum")
        public final Action FORUM;
        @ActionConfig(value="Action.Help.source")
        public final Action SOURCE;
        public final Action SEP_3;
        @ActionConfig(value="Action.Help.license")
        public final Action LICENSE;
        @ActionConfig(value="Action.Help.systemInfo")
        public final Action INFO;

        public Actions() {
            this.HELP_VIEWER = HelpMenuActions.this.commonActions.HELP_VIEWER;
            this.SEP_1 = ActionTools.createSeparator();
            this.DOCS = ActionTools.createAction(() -> QuPathGUI.openInBrowser(Urls.getVersionedDocsUrl()));
            this.DEMOS = ActionTools.createAction(() -> QuPathGUI.openInBrowser(Urls.getYouTubeUrl()));
            this.UPDATE = ActionTools.createAction(() -> HelpMenuActions.this.qupath.requestFullUpdateCheck());
            this.SEP_2 = ActionTools.createSeparator();
            this.CITE = ActionTools.createAction(() -> QuPathGUI.openInBrowser(Urls.getCitationUrl()));
            this.BUGS = ActionTools.createAction(() -> QuPathGUI.openInBrowser(Urls.getGitHubIssuesUrl()));
            this.FORUM = ActionTools.createAction(() -> QuPathGUI.openInBrowser(Urls.getUserForumUrl()));
            this.SOURCE = ActionTools.createAction(() -> QuPathGUI.openInBrowser(Urls.getGitHubRepoUrl()));
            this.SEP_3 = ActionTools.createSeparator();
            this.LICENSE = HelpMenuActions.this.qupath.getCommonActions().SHOW_LICENSE;
            this.INFO = Commands.createSingleStageAction(() -> Commands.createShowSystemInfoDialog(HelpMenuActions.this.qupath));
        }
    }
}

