/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions.menus;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.actions.menus.MenuActions;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.commands.ProjectCommands;
import qupath.lib.gui.commands.TMACommands;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;

public class FileMenuActions
implements MenuActions {
    private QuPathGUI qupath;
    private Actions actions;

    public FileMenuActions(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public List<Action> getActions() {
        if (this.actions == null) {
            this.actions = new Actions();
        }
        return ActionTools.getAnnotatedActions(this.actions);
    }

    @Override
    public String getName() {
        return QuPathResources.getString("Menu.File");
    }

    @ActionMenu(value={"Menu.File"})
    public class Actions {
        @ActionMenu(value={"Menu.File.Project"})
        public final ProjectActions projectActions;
        public final Action SEP_3;
        @ActionConfig(value="Action.File.open")
        @ActionAccelerator(value="shortcut+o")
        public final Action OPEN_IMAGE;
        @ActionConfig(value="Action.File.openUri")
        @ActionAccelerator(value="shortcut+shift+o")
        public final Action OPEN_IMAGE_OR_URL;
        @ActionConfig(value="Action.File.reloadData")
        @ActionAccelerator(value="shortcut+r")
        public final Action RELOAD_DATA;
        public final Action SEP_4;
        @ActionConfig(value="Action.File.saveAs")
        @ActionAccelerator(value="shortcut+shift+s")
        public final Action SAVE_DATA_AS;
        @ActionConfig(value="Action.File.save")
        @ActionAccelerator(value="shortcut+s")
        public final Action SAVE_DATA;
        public final Action SEP_5;
        @ActionMenu(value={"Menu.File.ExportImage"})
        public final ExportImageActions exportImageActions;
        @ActionMenu(value={"Menu.File.ExportSnapshot"})
        public final ExportSnapshotActions exportSnapshotActions;
        public final Action SEP_6;
        @ActionConfig(value="Action.File.importObjects")
        public final Action OBJECT_IMPORT;
        @ActionConfig(value="Action.File.exportGeoJSON")
        public final Action EXPORT_GEOJSON;
        public final Action SEP_7;
        @ActionMenu(value={"Menu.File.TMA"})
        public final TmaActions tmaActions;
        public final Action SEP_8;
        @ActionConfig(value="Action.File.quit")
        public final Action QUIT;

        public Actions() {
            this.projectActions = new ProjectActions();
            this.SEP_3 = ActionTools.createSeparator();
            this.OPEN_IMAGE = ActionTools.createAction(() -> FileMenuActions.this.qupath.promptToOpenImageFile());
            this.OPEN_IMAGE_OR_URL = ActionTools.createAction(() -> FileMenuActions.this.qupath.promptToOpenImageFileOrUri());
            this.RELOAD_DATA = FileMenuActions.this.qupath.createImageDataAction(imageData -> Commands.reloadImageData(FileMenuActions.this.qupath, (ImageData<BufferedImage>)imageData));
            this.SEP_4 = ActionTools.createSeparator();
            this.SAVE_DATA_AS = FileMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToSaveImageData(FileMenuActions.this.qupath, (ImageData<BufferedImage>)imageData, false));
            this.SAVE_DATA = FileMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToSaveImageData(FileMenuActions.this.qupath, (ImageData<BufferedImage>)imageData, true));
            this.SEP_5 = ActionTools.createSeparator();
            this.exportImageActions = new ExportImageActions();
            this.exportSnapshotActions = new ExportSnapshotActions();
            this.SEP_6 = ActionTools.createSeparator();
            this.OBJECT_IMPORT = FileMenuActions.this.qupath.createImageDataAction(imageData -> Commands.runObjectImport(FileMenuActions.this.qupath, (ImageData<BufferedImage>)imageData));
            this.EXPORT_GEOJSON = FileMenuActions.this.qupath.createImageDataAction(imageData -> Commands.runGeoJsonObjectExport(FileMenuActions.this.qupath, (ImageData<BufferedImage>)imageData));
            this.SEP_7 = ActionTools.createSeparator();
            this.tmaActions = new TmaActions();
            this.SEP_8 = ActionTools.createSeparator();
            this.QUIT = new Action(e -> FileMenuActions.this.qupath.sendQuitRequest());
        }
    }

    public class TmaActions {
        @ActionConfig(value="Action.File.TMA.importMap")
        public final Action TMA_IMPORT;
        @ActionConfig(value="Action.File.TMA.exportData")
        public final Action TMA_EXPORT;
        @ActionConfig(value="Action.File.TMA.dataViewer")
        public final Action TMA_VIEWER;

        public TmaActions() {
            this.TMA_IMPORT = FileMenuActions.this.qupath.createImageDataAction(imageData -> TMACommands.promptToImportTMAData(imageData));
            this.TMA_EXPORT = FileMenuActions.this.qupath.createImageDataAction(imageData -> TMACommands.promptToExportTMAData(FileMenuActions.this.qupath, (ImageData<BufferedImage>)imageData));
            this.TMA_VIEWER = ActionTools.createAction(() -> Commands.launchTMADataViewer(FileMenuActions.this.qupath));
        }
    }

    public class ExportSnapshotActions {
        @ActionConfig(value="Action.File.ExportSnapshot.windowScreenshot")
        public final Action SNAPSHOT_WINDOW = ActionTools.createAction(() -> Commands.saveSnapshotWithDelay(FileMenuActions.this.qupath, GuiTools.SnapshotType.MAIN_WINDOW_SCREENSHOT, 100L));
        @ActionConfig(value="Action.File.ExportSnapshot.windowContent")
        public final Action SNAPSHOT_WINDOW_CONTENT = ActionTools.createAction(() -> Commands.saveSnapshot(FileMenuActions.this.qupath, GuiTools.SnapshotType.MAIN_SCENE));
        @ActionConfig(value="Action.File.ExportSnapshot.viewerContent")
        public final Action SNAPSHOT_VIEWER_CONTENT = ActionTools.createAction(() -> Commands.saveSnapshot(FileMenuActions.this.qupath, GuiTools.SnapshotType.VIEWER));
    }

    public class ExportImageActions {
        @ActionConfig(value="Action.File.ExportImage.original")
        public final Action EXPORT_ORIGINAL;
        @ActionConfig(value="Action.File.ExportImage.rendered")
        public final Action EXPORT_RENDERED;

        public ExportImageActions() {
            this.EXPORT_ORIGINAL = FileMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToExportImageRegion(FileMenuActions.this.qupath.getViewer(), false));
            this.EXPORT_RENDERED = FileMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToExportImageRegion(FileMenuActions.this.qupath.getViewer(), true));
        }
    }

    public class ProjectActions {
        private static final Logger logger = LoggerFactory.getLogger(ProjectActions.class);
        @ActionConfig(value="Action.File.Project.createProject")
        public final Action PROJECT_NEW;
        @ActionConfig(value="Action.File.Project.openProject")
        public final Action PROJECT_OPEN;
        @ActionConfig(value="Action.File.Project.closeProject")
        public final Action PROJECT_CLOSE;
        public final Action SEP_1;
        @ActionConfig(value="Action.File.Project.addImages")
        public final Action IMPORT_IMAGES;
        @ActionConfig(value="Action.File.Project.exportImageList")
        public final Action EXPORT_IMAGE_LIST;
        public final Action SEP_2;
        @ActionConfig(value="Action.File.Project.editMetadata")
        public final Action METADATA;
        @ActionConfig(value="Action.File.Project.checkUris")
        public final Action CHECK_URIS;
        public final Action SEP_22;
        @ActionConfig(value="Action.File.Project.importLegacy")
        public final Action IMPORT_IMAGES_LEGACY;

        public ProjectActions() {
            this.PROJECT_NEW = FileMenuActions.this.qupath.getCommonActions().PROJECT_NEW;
            this.PROJECT_OPEN = FileMenuActions.this.qupath.getCommonActions().PROJECT_OPEN;
            this.PROJECT_CLOSE = FileMenuActions.this.qupath.createProjectAction(project -> Commands.closeProject(FileMenuActions.this.qupath));
            this.SEP_1 = ActionTools.createSeparator();
            this.IMPORT_IMAGES = FileMenuActions.this.qupath.getCommonActions().PROJECT_ADD_IMAGES;
            this.EXPORT_IMAGE_LIST = FileMenuActions.this.qupath.createProjectAction(project -> ProjectCommands.promptToExportImageList(project));
            this.SEP_2 = ActionTools.createSeparator();
            this.METADATA = FileMenuActions.this.qupath.createProjectAction(project -> ProjectCommands.showProjectMetadataEditor(project));
            this.CHECK_URIS = FileMenuActions.this.qupath.createProjectAction(project -> {
                try {
                    ProjectCommands.promptToCheckURIs(project, false);
                }
                catch (IOException e) {
                    Dialogs.showErrorMessage((String)"Check project URIs", (Throwable)e);
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
            this.SEP_22 = ActionTools.createSeparator();
            this.IMPORT_IMAGES_LEGACY = FileMenuActions.this.qupath.createProjectAction(project -> ProjectCommands.promptToImportLegacyProject(FileMenuActions.this.qupath));
        }
    }
}

