/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions.menus;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import org.controlsfx.control.action.Action;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.UndoRedoManager;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.CommonActions;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.actions.menus.MenuActions;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;

public class EditMenuActions
implements MenuActions {
    private QuPathGUI qupath;
    private CommonActions commonActions;
    private Actions actions;

    EditMenuActions(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public List<Action> getActions() {
        if (this.actions == null) {
            this.commonActions = this.qupath.getCommonActions();
            this.actions = new Actions();
        }
        return ActionTools.getAnnotatedActions(this.actions);
    }

    @Override
    public String getName() {
        return QuPathResources.getString("Menu.Edit");
    }

    @ActionMenu(value={"Menu.Edit"})
    public class Actions {
        @ActionAccelerator(value="shortcut+z")
        @ActionConfig(value="Action.Edit.undo")
        public final Action UNDO;
        @ActionAccelerator(value="shortcut+shift+z")
        @ActionConfig(value="Action.Edit.redo")
        public final Action REDO;
        public final Action SEP_0 = ActionTools.createSeparator();
        @ActionMenu(value={"Menu.Edit.Copy"})
        public final CopyActions copyActions = new CopyActions();
        @ActionConfig(value="Action.Edit.paste")
        public final Action PASTE = ActionTools.createAction(() -> Commands.pasteFromClipboard(EditMenuActions.this.qupath, false));
        @ActionConfig(value="Action.Edit.pasteToCurrentPlane")
        public final Action PASTE_TO_PLANE = ActionTools.createAction(() -> Commands.pasteFromClipboard(EditMenuActions.this.qupath, true));
        public final Action SEP_1 = ActionTools.createSeparator();
        public final Action PREFERENCES;
        @ActionConfig(value="Action.Edit.resetPreferences")
        public final Action RESET_PREFERENCES;

        private Actions() {
            this.PREFERENCES = EditMenuActions.this.commonActions.PREFERENCES;
            this.RESET_PREFERENCES = ActionTools.createAction(() -> Commands.promptToResetPreferences());
            UndoRedoManager undoRedo = EditMenuActions.this.qupath.getUndoRedoManager();
            this.UNDO = Actions.createUndoAction(undoRedo);
            this.REDO = Actions.createRedoAction(undoRedo);
        }

        private static Action createUndoAction(UndoRedoManager undoRedoManager) {
            Action actionUndo = new Action("Undo", e -> undoRedoManager.undoOnce());
            actionUndo.disabledProperty().bind((ObservableValue)undoRedoManager.canUndo().not());
            return actionUndo;
        }

        private static Action createRedoAction(UndoRedoManager undoRedoManager) {
            Action actionRedo = new Action("Redo", e -> undoRedoManager.redoOnce());
            actionRedo.disabledProperty().bind((ObservableValue)undoRedoManager.canRedo().not());
            return actionRedo;
        }
    }

    public class CopyActions {
        @ActionConfig(value="Action.Edit.Copy.selectedObjects")
        public final Action COPY_SELECTED_OBJECTS;
        @ActionConfig(value="Action.Edit.Copy.annotationObjects")
        public final Action COPY_ANNOTATION_OBJECTS;
        public final Action SEP_00;
        @ActionConfig(value="Action.Edit.Copy.currentViewer")
        public final Action COPY_VIEW;
        @ActionConfig(value="Action.Edit.Copy.mainWindowContent")
        public final Action COPY_WINDOW;
        @ActionConfig(value="Action.Edit.Copy.mainWindowScreenshot")
        public final Action COPY_WINDOW_SCREENSHOT;
        @ActionConfig(value="Action.Edit.Copy.fullScreenshot")
        public final Action COPY_FULL_SCREENSHOT;

        public CopyActions() {
            this.COPY_SELECTED_OBJECTS = EditMenuActions.this.qupath.createImageDataAction(imageData -> Commands.copySelectedObjectsToClipboard((ImageData<BufferedImage>)imageData));
            this.COPY_ANNOTATION_OBJECTS = EditMenuActions.this.qupath.createImageDataAction(imageData -> Commands.copyAnnotationsToClipboard((ImageData<BufferedImage>)imageData));
            this.SEP_00 = ActionTools.createSeparator();
            this.COPY_VIEW = ActionTools.createAction(() -> CopyActions.copyViewToClipboard(EditMenuActions.this.qupath, GuiTools.SnapshotType.VIEWER));
            this.COPY_WINDOW = ActionTools.createAction(() -> CopyActions.copyViewToClipboard(EditMenuActions.this.qupath, GuiTools.SnapshotType.MAIN_SCENE));
            this.COPY_WINDOW_SCREENSHOT = ActionTools.createAction(() -> CopyActions.copyViewToClipboard(EditMenuActions.this.qupath, GuiTools.SnapshotType.MAIN_WINDOW_SCREENSHOT));
            this.COPY_FULL_SCREENSHOT = ActionTools.createAction(() -> CopyActions.copyViewToClipboard(EditMenuActions.this.qupath, GuiTools.SnapshotType.FULL_SCREENSHOT));
        }

        private static void copyViewToClipboard(QuPathGUI qupath, GuiTools.SnapshotType type) {
            CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS, Platform::runLater).execute(() -> {
                WritableImage img = GuiTools.makeSnapshotFX(qupath, qupath.getViewer(), type);
                Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.IMAGE, img));
            });
        }
    }
}

