/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions.menus;

import java.util.List;
import org.controlsfx.control.action.Action;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.actions.menus.MenuActions;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.objects.PathDetectionObject;

public class ClassifyMenuActions
implements MenuActions {
    private QuPathGUI qupath;
    private Actions actions;

    ClassifyMenuActions(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public List<Action> getActions() {
        if (this.actions == null) {
            this.actions = new Actions();
        }
        return ActionTools.getAnnotatedActions(this.actions);
    }

    @Override
    public String getName() {
        return QuPathResources.getString("Menu.Classify");
    }

    @ActionMenu(value={"Menu.Classify"})
    public class Actions {
        @ActionMenu(value={"Menu.Classify.ObjectClassification"})
        public final Action SEP_1 = ActionTools.createSeparator();
        @ActionMenu(value={"Menu.Classify.ObjectClassification"})
        @ActionConfig(value="Action.Classify.Objects.resetDetectionClassifications")
        public final Action RESET_DETECTION_CLASSIFICATIONS;
        @ActionMenu(value={"Menu.Classify.PixelClassification"})
        public final Action SEP_3;
        public final Action SEP_4;

        public Actions() {
            this.RESET_DETECTION_CLASSIFICATIONS = ClassifyMenuActions.this.qupath.createImageDataAction(imageData -> Commands.resetClassifications(imageData, PathDetectionObject.class));
            this.SEP_3 = ActionTools.createSeparator();
            this.SEP_4 = ActionTools.createSeparator();
        }
    }
}

