/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions.menus;

import java.awt.image.BufferedImage;
import java.util.List;
import org.controlsfx.control.action.Action;
import qupath.lib.algorithms.IntensityFeaturesPlugin;
import qupath.lib.algorithms.TilerPlugin;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.actions.menus.MenuActions;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.images.ImageData;
import qupath.lib.plugins.objects.SmoothFeaturesPlugin;

public class AnalyzeMenuActions
implements MenuActions {
    private QuPathGUI qupath;
    private Actions actions;

    AnalyzeMenuActions(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public List<Action> getActions() {
        if (this.actions == null) {
            this.actions = new Actions();
        }
        return ActionTools.getAnnotatedActions(this.actions);
    }

    @Override
    public String getName() {
        return QuPathResources.getString("Menu.Analyze");
    }

    @ActionMenu(value={"Menu.Analyze"})
    public class Actions {
        @ActionConfig(value="Action.Analyze.Preprocessing.estimateStainVectors")
        public final Action COLOR_DECONVOLUTION_REFINE;
        @ActionMenu(value={"Menu.Analyze.Tiles"})
        @ActionConfig(value="Action.Analyze.Tiles.createTiles")
        public final Action CREATE_TILES;
        @ActionMenu(value={"Menu.Analyze.CellDetection"})
        public final Action SEP_0;
        @ActionMenu(value={"Menu.Analyze.Features"})
        @ActionConfig(value="Action.Analyze.Features.smoothedFeatures")
        public final Action SMOOTHED_FEATURES;
        @ActionMenu(value={"Menu.Analyze.Features"})
        @ActionConfig(value="Action.Analyze.Features.intensityFeatures")
        public final Action INTENSITY_FEATURES;
        @ActionMenu(value={"Menu.Analyze.Features"})
        @ActionConfig(value="Action.Analyze.Features.shapeFeatures")
        public final Action SHAPE_FEATURES;
        @ActionMenu(value={"Menu.Analyze.Spatial"})
        @ActionConfig(value="Action.Analyze.Spatial.distanceToAnnotations2D")
        public final Action DISTANCE_TO_ANNOTATIONS;
        @ActionMenu(value={"Menu.Analyze.Spatial"})
        @ActionConfig(value="Action.Analyze.Spatial.signedDistanceToAnnotations2D")
        public final Action SIGNED_DISTANCE_TO_ANNOTATIONS;
        @ActionMenu(value={"Menu.Analyze.Spatial"})
        @ActionConfig(value="Action.Analyze.Spatial.detectionCentroidDistances2D")
        public final Action DISTANCE_CENTROIDS;

        public Actions() {
            this.COLOR_DECONVOLUTION_REFINE = AnalyzeMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToEstimateStainVectors((ImageData<BufferedImage>)imageData));
            this.CREATE_TILES = AnalyzeMenuActions.this.qupath.createPluginAction("Create tiles", TilerPlugin.class, null);
            this.SEP_0 = ActionTools.createSeparator();
            this.SMOOTHED_FEATURES = AnalyzeMenuActions.this.qupath.createPluginAction("Add Smoothed features", SmoothFeaturesPlugin.class, null);
            this.INTENSITY_FEATURES = AnalyzeMenuActions.this.qupath.createPluginAction("Add intensity features", IntensityFeaturesPlugin.class, null);
            this.SHAPE_FEATURES = AnalyzeMenuActions.this.qupath.createImageDataAction(imageData -> Commands.promptToAddShapeFeatures(AnalyzeMenuActions.this.qupath));
            this.DISTANCE_TO_ANNOTATIONS = AnalyzeMenuActions.this.qupath.createImageDataAction(imageData -> Commands.distanceToAnnotations2D(imageData, false));
            this.SIGNED_DISTANCE_TO_ANNOTATIONS = AnalyzeMenuActions.this.qupath.createImageDataAction(imageData -> Commands.distanceToAnnotations2D(imageData, true));
            this.DISTANCE_CENTROIDS = AnalyzeMenuActions.this.qupath.createImageDataAction(imageData -> Commands.detectionCentroidDistances2D(imageData));
        }
    }
}

