/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions;

import javafx.beans.value.ObservableValue;
import org.controlsfx.control.action.Action;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionIcon;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.viewer.ViewerManager;

public class ViewerActions {
    @ActionIcon(value=IconFactory.PathIcons.ZOOM_TO_FIT)
    @ActionConfig(value="ViewerActions.zoomToFit")
    public final Action ZOOM_TO_FIT;
    @ActionIcon(value=IconFactory.PathIcons.OVERVIEW)
    @ActionConfig(value="ViewerActions.overview")
    public final Action SHOW_OVERVIEW;
    @ActionIcon(value=IconFactory.PathIcons.LOCATION)
    @ActionConfig(value="ViewerActions.location")
    public final Action SHOW_LOCATION;
    @ActionIcon(value=IconFactory.PathIcons.SHOW_SCALEBAR)
    @ActionConfig(value="ViewerActions.scalebar")
    public final Action SHOW_SCALEBAR;
    @ActionConfig(value="ViewerActions.zProject")
    @ActionIcon(value=IconFactory.PathIcons.Z_PROJECT)
    public final Action SHOW_Z_PROJECT;
    @ActionAccelerator(value="shortcut+alt+s")
    @ActionConfig(value="ViewerActions.synchronize")
    public final Action TOGGLE_SYNCHRONIZE_VIEWERS;
    @ActionConfig(value="ViewerActions.grid1x1")
    @ActionIcon(value=IconFactory.PathIcons.VIEWER_GRID_1x1)
    public final Action VIEWER_GRID_1x1;
    @ActionConfig(value="ViewerActions.grid1x2")
    @ActionIcon(value=IconFactory.PathIcons.VIEWER_GRID_1x2)
    public final Action VIEWER_GRID_1x2;
    @ActionConfig(value="ViewerActions.grid2x1")
    @ActionIcon(value=IconFactory.PathIcons.VIEWER_GRID_2x1)
    public final Action VIEWER_GRID_2x1;
    @ActionConfig(value="ViewerActions.grid2x2")
    @ActionIcon(value=IconFactory.PathIcons.VIEWER_GRID_2x2)
    public final Action VIEWER_GRID_2x2;
    @ActionConfig(value="ViewerActions.grid3x3")
    @ActionIcon(value=IconFactory.PathIcons.VIEWER_GRID_3x3)
    public final Action VIEWER_GRID_3x3;
    @ActionConfig(value="ViewerActions.matchResolutions")
    public final Action MATCH_VIEWER_RESOLUTIONS;
    @ActionConfig(value="ViewerActions.detachViewer")
    public final Action DETACH_VIEWER;
    @ActionConfig(value="ViewerActions.attachViewer")
    public final Action ATTACH_VIEWER;
    private ViewerManager viewerManager;

    public ViewerActions(ViewerManager viewerManager) {
        this.viewerManager = viewerManager;
        this.SHOW_OVERVIEW = ActionTools.createSelectableAction((ObservableValue<Boolean>)viewerManager.showOverviewProperty());
        this.SHOW_LOCATION = ActionTools.createSelectableAction((ObservableValue<Boolean>)viewerManager.showLocationProperty());
        this.SHOW_SCALEBAR = ActionTools.createSelectableAction((ObservableValue<Boolean>)viewerManager.showScalebarProperty());
        this.SHOW_Z_PROJECT = ActionTools.createSelectableAction((ObservableValue<Boolean>)viewerManager.showZProjectControlsProperty());
        this.TOGGLE_SYNCHRONIZE_VIEWERS = ActionTools.createSelectableAction((ObservableValue<Boolean>)viewerManager.synchronizeViewersProperty());
        this.MATCH_VIEWER_RESOLUTIONS = new Action(e -> viewerManager.matchResolutions());
        this.ZOOM_TO_FIT = ActionTools.createAction(() -> viewerManager.getActiveViewer().zoomToFit());
        this.ZOOM_TO_FIT.disabledProperty().bind((ObservableValue)viewerManager.activeViewerProperty().isNull());
        this.VIEWER_GRID_1x1 = ActionTools.createAction(() -> viewerManager.setGridSize(1, 1));
        this.VIEWER_GRID_2x1 = ActionTools.createAction(() -> viewerManager.setGridSize(2, 1));
        this.VIEWER_GRID_1x2 = ActionTools.createAction(() -> viewerManager.setGridSize(1, 2));
        this.VIEWER_GRID_2x2 = ActionTools.createAction(() -> viewerManager.setGridSize(2, 2));
        this.VIEWER_GRID_3x3 = ActionTools.createAction(() -> viewerManager.setGridSize(3, 3));
        this.DETACH_VIEWER = ActionTools.createAction(() -> viewerManager.detachActiveViewerFromGrid());
        this.ATTACH_VIEWER = ActionTools.createAction(() -> viewerManager.attachActiveViewerToGrid());
        ActionTools.getAnnotatedActions(this);
    }

    public ViewerManager getViewerManager() {
        return this.viewerManager;
    }
}

