/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions;

import javafx.beans.value.ObservableValue;
import org.controlsfx.control.action.Action;
import qupath.lib.gui.SelectableItem;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionIcon;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.viewer.OverlayOptions;

public class OverlayActions {
    @ActionIcon(value=IconFactory.PathIcons.GRID)
    @ActionAccelerator(value="shift+g")
    @ActionConfig(value="OverlayActions.showCountingGrid")
    public final Action SHOW_GRID;
    @ActionIcon(value=IconFactory.PathIcons.GRID_SPACING)
    @ActionConfig(value="OverlayActions.setCountingGridSpacing")
    public final Action GRID_SPACING;
    @ActionIcon(value=IconFactory.PathIcons.PIXEL_CLASSIFICATION)
    @ActionAccelerator(value="c")
    @ActionConfig(value="OverlayActions.showPixelOverlay")
    public final Action SHOW_PIXEL_CLASSIFICATION;
    @ActionIcon(value=IconFactory.PathIcons.CELL_ONLY)
    @ActionConfig(value="OverlayActions.showCellBoundaries")
    public final Action SHOW_CELL_BOUNDARIES;
    @ActionIcon(value=IconFactory.PathIcons.NUCLEI_ONLY)
    @ActionConfig(value="OverlayActions.showCellNuclei")
    public final Action SHOW_CELL_NUCLEI;
    @ActionIcon(value=IconFactory.PathIcons.CELL_NUCLEI_BOTH)
    @ActionConfig(value="OverlayActions.showCellBoth")
    public final Action SHOW_CELL_BOUNDARIES_AND_NUCLEI;
    @ActionIcon(value=IconFactory.PathIcons.CENTROIDS_ONLY)
    @ActionConfig(value="OverlayActions.showCellCentroids")
    public final Action SHOW_CELL_CENTROIDS;
    @ActionIcon(value=IconFactory.PathIcons.ANNOTATIONS)
    @ActionAccelerator(value="a")
    @ActionConfig(value="OverlayActions.showAnnotations")
    public final Action SHOW_ANNOTATIONS;
    @ActionIcon(value=IconFactory.PathIcons.SHOW_NAMES)
    @ActionAccelerator(value="n")
    @ActionConfig(value="OverlayActions.showAnnotationNames")
    public final Action SHOW_NAMES;
    @ActionIcon(value=IconFactory.PathIcons.ANNOTATIONS_FILL)
    @ActionAccelerator(value="shift+f")
    @ActionConfig(value="OverlayActions.fillAnnotations")
    public final Action FILL_ANNOTATIONS;
    @ActionIcon(value=IconFactory.PathIcons.TMA_GRID)
    @ActionAccelerator(value="g")
    @ActionConfig(value="OverlayActions.showTMAGrid")
    public final Action SHOW_TMA_GRID;
    @ActionConfig(value="OverlayActions.showTMALabels")
    public final Action SHOW_TMA_GRID_LABELS;
    @ActionIcon(value=IconFactory.PathIcons.DETECTIONS)
    @ActionAccelerator(value="d")
    @ActionConfig(value="OverlayActions.showDetections")
    public final Action SHOW_DETECTIONS;
    @ActionIcon(value=IconFactory.PathIcons.DETECTIONS_FILL)
    @ActionAccelerator(value="f")
    @ActionConfig(value="OverlayActions.fillDetections")
    public final Action FILL_DETECTIONS;
    @ActionIcon(value=IconFactory.PathIcons.SHOW_CONNECTIONS)
    @ActionConfig(value="OverlayActions.showConnections")
    public final Action SHOW_CONNECTIONS;
    private OverlayOptions overlayOptions;

    public OverlayActions(OverlayOptions overlayOptions) {
        this.overlayOptions = overlayOptions;
        this.SHOW_GRID = ActionTools.createSelectableAction((ObservableValue<Boolean>)overlayOptions.showGridProperty());
        this.GRID_SPACING = ActionTools.createAction(() -> Commands.promptToSetGridLineSpacing(overlayOptions));
        this.SHOW_PIXEL_CLASSIFICATION = ActionTools.createSelectableAction((ObservableValue<Boolean>)overlayOptions.showPixelClassificationProperty());
        this.SHOW_ANNOTATIONS = ActionTools.createSelectableAction((ObservableValue<Boolean>)overlayOptions.showAnnotationsProperty());
        this.SHOW_NAMES = ActionTools.createSelectableAction((ObservableValue<Boolean>)overlayOptions.showNamesProperty());
        this.FILL_ANNOTATIONS = ActionTools.createSelectableAction((ObservableValue<Boolean>)overlayOptions.fillAnnotationsProperty());
        this.SHOW_DETECTIONS = ActionTools.createSelectableAction((ObservableValue<Boolean>)overlayOptions.showDetectionsProperty());
        this.FILL_DETECTIONS = ActionTools.createSelectableAction((ObservableValue<Boolean>)overlayOptions.fillDetectionsProperty());
        this.SHOW_TMA_GRID = ActionTools.createSelectableAction((ObservableValue<Boolean>)overlayOptions.showTMAGridProperty());
        this.SHOW_TMA_GRID_LABELS = ActionTools.createSelectableAction((ObservableValue<Boolean>)overlayOptions.showTMACoreLabelsProperty());
        this.SHOW_CELL_BOUNDARIES = ActionTools.createSelectableCommandAction(new SelectableItem<OverlayOptions.DetectionDisplayMode>(overlayOptions.detectionDisplayModeProperty(), OverlayOptions.DetectionDisplayMode.BOUNDARIES_ONLY));
        this.SHOW_CELL_NUCLEI = ActionTools.createSelectableCommandAction(new SelectableItem<OverlayOptions.DetectionDisplayMode>(overlayOptions.detectionDisplayModeProperty(), OverlayOptions.DetectionDisplayMode.NUCLEI_ONLY));
        this.SHOW_CELL_BOUNDARIES_AND_NUCLEI = ActionTools.createSelectableCommandAction(new SelectableItem<OverlayOptions.DetectionDisplayMode>(overlayOptions.detectionDisplayModeProperty(), OverlayOptions.DetectionDisplayMode.NUCLEI_AND_BOUNDARIES));
        this.SHOW_CELL_CENTROIDS = ActionTools.createSelectableCommandAction(new SelectableItem<OverlayOptions.DetectionDisplayMode>(overlayOptions.detectionDisplayModeProperty(), OverlayOptions.DetectionDisplayMode.CENTROIDS));
        this.SHOW_CONNECTIONS = ActionTools.createSelectableAction((ObservableValue<Boolean>)overlayOptions.showConnectionsProperty());
        ActionTools.getAnnotatedActions(this);
    }

    public OverlayOptions getOverlayOptions() {
        return this.overlayOptions;
    }
}

