/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;

public class InfoMessage {
    private MessageType badgeType;
    private ReadOnlyStringWrapper text = new ReadOnlyStringWrapper();
    private ReadOnlyObjectWrapper<Number> count = new ReadOnlyObjectWrapper();

    private InfoMessage(MessageType badgeType, ObservableValue<String> observableText, ObservableNumberValue observableCount) {
        this.badgeType = badgeType;
        this.text.bind(observableText);
        this.count.bind((ObservableValue)Bindings.createObjectBinding(() -> observableCount != null && observableCount.intValue() < 0 ? null : Integer.valueOf(observableCount.intValue()), (Observable[])new Observable[]{observableCount}));
    }

    public static InfoMessage info(ObservableValue<String> text) {
        return InfoMessage.info(text, (ObservableNumberValue)new SimpleIntegerProperty(-1));
    }

    public static InfoMessage info(String text) {
        return InfoMessage.info(text, -1);
    }

    public static InfoMessage info(ObservableValue<String> text, ObservableNumberValue count) {
        return new InfoMessage(MessageType.INFO, text, count);
    }

    public static InfoMessage info(String text, int count) {
        return InfoMessage.info((ObservableValue<String>)new SimpleStringProperty(text), (ObservableNumberValue)new SimpleIntegerProperty(count));
    }

    public static InfoMessage info(ObservableNumberValue count) {
        ObservableValue text = count.map(val -> {
            int value = val.intValue();
            if (value == 1) {
                return "1 message";
            }
            return value + " messages";
        });
        return InfoMessage.info((ObservableValue<String>)text, count);
    }

    public static InfoMessage warning(ObservableValue<String> text) {
        return InfoMessage.warning(text, (ObservableNumberValue)new SimpleIntegerProperty(-1));
    }

    public static InfoMessage warning(String text) {
        return InfoMessage.warning(text, -1);
    }

    public static InfoMessage warning(ObservableValue<String> text, ObservableNumberValue count) {
        return new InfoMessage(MessageType.WARN, text, count);
    }

    public static InfoMessage warning(ObservableNumberValue count) {
        ObservableValue text = count.map(val -> {
            int value = val.intValue();
            if (value == 1) {
                return "1 warning";
            }
            return value + " warnings";
        });
        return new InfoMessage(MessageType.WARN, (ObservableValue<String>)text, count);
    }

    public static InfoMessage warning(String text, int count) {
        return InfoMessage.warning((ObservableValue<String>)new SimpleStringProperty(text), (ObservableNumberValue)new SimpleIntegerProperty(count));
    }

    public static InfoMessage error(ObservableValue<String> text) {
        return InfoMessage.error(text, (ObservableNumberValue)new SimpleIntegerProperty(-1));
    }

    public static InfoMessage error(String text) {
        return InfoMessage.error(text, -1);
    }

    public static InfoMessage error(ObservableValue<String> text, ObservableNumberValue count) {
        return new InfoMessage(MessageType.ERROR, text, count);
    }

    public static InfoMessage error(String text, int count) {
        return InfoMessage.error((ObservableValue<String>)new SimpleStringProperty(text), (ObservableNumberValue)new SimpleIntegerProperty(count));
    }

    public static InfoMessage error(ObservableNumberValue count) {
        ObservableValue text = count.map(val -> {
            int value = val.intValue();
            if (value == 1) {
                return "1 error";
            }
            return value + " errors";
        });
        return InfoMessage.error((ObservableValue<String>)text, count);
    }

    public ReadOnlyStringProperty textProperty() {
        return this.text.getReadOnlyProperty();
    }

    public String getText() {
        return this.text.get();
    }

    public ReadOnlyObjectProperty<Number> countProperty() {
        return this.count.getReadOnlyProperty();
    }

    public int getCount() {
        Number val = (Number)this.count.getValue();
        return val == null ? -1 : val.intValue();
    }

    public MessageType getMessageType() {
        return this.badgeType;
    }

    public static enum MessageType {
        INFO,
        WARN,
        ERROR;

    }
}

