/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions;

import java.awt.image.BufferedImage;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.InfoMessage;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionIcon;
import qupath.lib.gui.commands.BrightnessContrastCommand;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.commands.ContextHelpViewer;
import qupath.lib.gui.commands.CountingDialogCommand;
import qupath.lib.gui.commands.LogViewerCommand;
import qupath.lib.gui.commands.ProjectCommands;
import qupath.lib.gui.commands.TMACommands;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.images.ImageData;
import qupath.ui.logviewer.ui.main.LogMessageCounts;

public class CommonActions {
    private static final Logger logger = LoggerFactory.getLogger(CommonActions.class);
    @ActionConfig(value="Action.File.Project.createProject")
    public final Action PROJECT_NEW;
    @ActionConfig(value="Action.File.Project.openProject")
    public final Action PROJECT_OPEN;
    @ActionConfig(value="Action.File.Project.openProject")
    public final Action PROJECT_ADD_IMAGES;
    @ActionIcon(value=IconFactory.PathIcons.CONTRAST)
    @ActionAccelerator(value="shift+c")
    @ActionConfig(value="CommonActions.showBrightnessContrast")
    public final Action BRIGHTNESS_CONTRAST;
    @ActionIcon(value=IconFactory.PathIcons.POINTS_TOOL)
    @ActionConfig(value="CommonActions.showCountingTool")
    public final Action SHOW_POINTS_DIALOG;
    @ActionConfig(value="CommonActions.addTMANote")
    public final Action TMA_ADD_NOTE;
    @ActionConfig(value="CommonActions.showPointConvexHull")
    public final Action CONVEX_POINTS;
    @ActionConfig(value="Action.View.inputDisplay")
    @ActionIcon(value=IconFactory.PathIcons.KEYBOARD)
    public final Action INPUT_DISPLAY;
    @ActionConfig(value="Action.View.memoryMonitor")
    @ActionIcon(value=IconFactory.PathIcons.MEMORY_MONITOR)
    public final Action MEMORY_MONITOR;
    @ActionIcon(value=IconFactory.PathIcons.LOG_VIEWER)
    @ActionAccelerator(value="shortcut+shift+l")
    @ActionConfig(value="CommonActions.showLog")
    public final Action SHOW_LOG;
    @ActionIcon(value=IconFactory.PathIcons.MEASURE)
    @ActionAccelerator(value="shift+a")
    @ActionConfig(value="CommonActions.showAnalysisPane")
    public final Action SHOW_ANALYSIS_PANE;
    @ActionIcon(value=IconFactory.PathIcons.COG)
    @ActionAccelerator(value="shortcut+,")
    @ActionConfig(value="CommonActions.showPrefPane")
    public final Action PREFERENCES;
    @ActionConfig(value="CommonActions.objectDescriptions")
    public final Action SHOW_OBJECT_DESCRIPTIONS;
    @ActionConfig(value="CommonActions.measureAnnotations")
    public final Action MEASURE_ANNOTATIONS;
    @ActionConfig(value="CommonActions.measureDetections")
    public final Action MEASURE_DETECTIONS;
    @ActionConfig(value="CommonActions.measureTMA")
    public final Action MEASURE_TMA;
    @ActionConfig(value="CommonActions.gridViewAnnotations")
    public final Action MEASURE_GRID_ANNOTATIONS;
    @ActionConfig(value="CommonActions.gridViewTMA")
    public final Action MEASURE_GRID_TMA_CORES;
    @ActionIcon(value=IconFactory.PathIcons.HELP)
    @ActionConfig(value="CommonActions.showHelp")
    public final Action HELP_VIEWER;
    @ActionConfig(value="Action.Help.license")
    public final Action SHOW_LICENSE;
    private QuPathGUI qupath;

    public CommonActions(QuPathGUI qupath) {
        this.qupath = qupath;
        this.PROJECT_NEW = ActionTools.createAction(() -> Commands.promptToCreateProject(qupath));
        this.PROJECT_OPEN = ActionTools.createAction(() -> Commands.promptToOpenProject(qupath));
        this.PROJECT_ADD_IMAGES = ActionTools.createAction(() -> ProjectCommands.promptToImportImages(qupath, new String[0]));
        BrightnessContrastCommand brightnessCommand = new BrightnessContrastCommand(qupath);
        this.BRIGHTNESS_CONTRAST = ActionTools.createAction(brightnessCommand);
        ActionTools.installInfoMessage(this.BRIGHTNESS_CONTRAST, (ObjectExpression<InfoMessage>)brightnessCommand.infoMessage());
        this.SHOW_POINTS_DIALOG = ActionTools.createAction(new CountingDialogCommand(qupath));
        this.TMA_ADD_NOTE = qupath.createImageDataAction(imageData -> TMACommands.promptToAddNoteToSelectedCores(imageData));
        this.CONVEX_POINTS = ActionTools.createSelectableAction((ObservableValue<Boolean>)PathPrefs.showPointHullsProperty());
        LogViewerCommand logviewer = qupath.getLogViewerCommand();
        if (logviewer == null) {
            logger.warn("Log viewer not available! Will attempt to load lazily.");
            this.SHOW_LOG = ActionTools.createAction(() -> qupath.getLogViewerCommand().show());
        } else {
            this.SHOW_LOG = ActionTools.createAction(() -> logviewer.show());
            LogMessageCounts counts = logviewer.getLogMessageCounts();
            if (counts != null) {
                ActionTools.installInfoMessage(this.SHOW_LOG, logviewer.getInfoMessage());
            }
        }
        this.SHOW_ANALYSIS_PANE = ActionTools.createSelectableAction((ObservableValue<Boolean>)qupath.showAnalysisPaneProperty());
        this.PREFERENCES = Commands.createSingleStageAction(() -> Commands.createPreferencesDialog(qupath));
        this.SHOW_OBJECT_DESCRIPTIONS = Commands.createSingleStageAction(() -> Commands.createObjectDescriptionsDialog(qupath));
        this.MEASURE_TMA = qupath.createImageDataAction(imageData -> Commands.showTMAMeasurementTable(qupath, (ImageData<BufferedImage>)imageData));
        this.MEASURE_ANNOTATIONS = qupath.createImageDataAction(imageData -> Commands.showAnnotationMeasurementTable(qupath, (ImageData<BufferedImage>)imageData));
        this.MEASURE_DETECTIONS = qupath.createImageDataAction(imageData -> Commands.showDetectionMeasurementTable(qupath, (ImageData<BufferedImage>)imageData));
        this.MEASURE_GRID_ANNOTATIONS = qupath.createImageDataAction(imageData -> Commands.showAnnotationGridView(qupath));
        this.MEASURE_GRID_TMA_CORES = qupath.createImageDataAction(imageData -> Commands.showTMACoreGridView(qupath));
        ContextHelpViewer contextHelp = ContextHelpViewer.getInstance(qupath);
        this.HELP_VIEWER = Commands.createSingleStageAction(() -> contextHelp.getStage());
        ActionTools.installInfoMessage(this.HELP_VIEWER, contextHelp.getInfoMessage());
        this.INPUT_DISPLAY = ActionTools.createSelectableCommandAction((ObservableBooleanValue)qupath.showInputDisplayProperty());
        this.MEMORY_MONITOR = Commands.createSingleStageAction(() -> Commands.createMemoryMonitorDialog(qupath));
        this.SHOW_LICENSE = Commands.createSingleStageAction(() -> Commands.createLicensesWindow(qupath));
        ActionTools.getAnnotatedActions(this);
    }

    private void handleBrightnessContrastWarnings(ListChangeListener.Change<? extends String> change) {
        if (change.getList().isEmpty()) {
            this.BRIGHTNESS_CONTRAST.getProperties().remove((Object)"WARNINGS");
        } else {
            this.BRIGHTNESS_CONTRAST.getProperties().put((Object)"WARNINGS", (Object)change.getList().size());
        }
    }

    public QuPathGUI getQuPath() {
        return this.qupath;
    }
}

