/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions;

import org.controlsfx.control.action.Action;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionIcon;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.tools.IconFactory;

public class AutomateActions {
    @ActionAccelerator(value="shortcut+[")
    @ActionConfig(value="Action.Automate.scriptEditor")
    @ActionIcon(value=IconFactory.PathIcons.SCRIPT_EDITOR)
    public final Action SCRIPT_EDITOR;
    @ActionConfig(value="Action.Automate.scriptInterpreter")
    public final Action SCRIPT_INTERPRETER;
    @ActionAccelerator(value="shortcut+shift+w")
    @ActionConfig(value="Action.Automate.commandWorkflow")
    public final Action HISTORY_SHOW;
    @ActionConfig(value="Action.Automate.commandScript")
    public final Action HISTORY_SCRIPT;
    private QuPathGUI qupath;

    public AutomateActions(QuPathGUI qupath) {
        this.qupath = qupath;
        this.SCRIPT_EDITOR = ActionTools.createAction(() -> Commands.showScriptEditor(qupath));
        this.SCRIPT_INTERPRETER = ActionTools.createAction(() -> Commands.showScriptInterpreter(qupath));
        this.HISTORY_SHOW = Commands.createSingleStageAction(() -> Commands.createWorkflowDisplayDialog(qupath));
        this.HISTORY_SCRIPT = qupath.createImageDataAction(imageData -> Commands.showWorkflowScript(qupath, imageData));
        ActionTools.getAnnotatedActions(this);
    }
}

