/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.actions;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Duration;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.decoration.Decorator;
import org.controlsfx.control.decoration.GraphicDecoration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.lib.gui.SelectableItem;
import qupath.lib.gui.actions.InfoMessage;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionIcon;
import qupath.lib.gui.actions.annotations.ActionMenu;
import qupath.lib.gui.actions.annotations.ActionMethod;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.IconFactory;

public class ActionTools {
    private static final Logger logger = LoggerFactory.getLogger(ActionTools.class);
    private static final String ACTION_KEY = ActionTools.class.getName();
    private static final String INFO_MESSAGE_KEY = ACTION_KEY + ":INFO_MESSAGE";

    private static String getMenuString(String[] text) {
        return Arrays.stream(text).collect(Collectors.joining(">")) + ">";
    }

    private static String getStringOrReadResource(String text) {
        if (text.startsWith("KEY:")) {
            return QuPathResources.getString(text.substring(4));
        }
        if (QuPathResources.hasString(text)) {
            return QuPathResources.getString(text);
        }
        return text;
    }

    public static List<Action> getAnnotatedActions(Object obj) {
        return ActionTools.getAnnotatedActions(obj, "");
    }

    private static List<Action> getAnnotatedActions(Object obj, String baseMenu) {
        ArrayList<Action> actions = new ArrayList<Action>();
        Class<?> cls = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        ActionMenu menuAnnotation = cls.getAnnotation(ActionMenu.class);
        if (menuAnnotation != null) {
            baseMenu = baseMenu == null || baseMenu.isEmpty() ? ActionTools.getMenuString(menuAnnotation.value()) : ActionTools.joinMenuPaths(baseMenu, ActionTools.getMenuString(menuAnnotation.value()));
        }
        for (Field field : cls.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object value;
                if (!field.canAccess(obj)) {
                    field.setAccessible(true);
                }
                if ((value = field.get(obj)) instanceof Action) {
                    Action action = (Action)value;
                    ActionTools.parseAnnotations(action, field, baseMenu);
                    actions.add(action);
                    continue;
                }
                if (value instanceof Action[]) {
                    for (Action temp : (Action[])value) {
                        ActionTools.parseAnnotations(temp, field, baseMenu);
                        actions.add(temp);
                    }
                    continue;
                }
                if (!field.isAnnotationPresent(ActionMenu.class)) continue;
                String baseSubMenu = ActionTools.joinMenuPaths(baseMenu, ActionTools.getMenuString(field.getAnnotation(ActionMenu.class).value()));
                List<Action> subActions = ActionTools.getAnnotatedActions(value, baseSubMenu);
                actions.addAll(subActions);
            }
            catch (Exception e) {
                logger.error("Error setting up action: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(ActionMethod.class) || !accessibleObject.canAccess(obj)) continue;
            try {
                Action action = null;
                if (((Method)accessibleObject).getParameterCount() == 0) {
                    action = new Action(arg_0 -> ActionTools.lambda$getAnnotatedActions$0((Method)accessibleObject, obj, arg_0));
                } else {
                    logger.warn("Only methods with 0 parameters can currently be converted to actions by annotation only!");
                }
                if (action == null) continue;
                ActionTools.parseAnnotations(action, accessibleObject, baseMenu);
                actions.add(action);
            }
            catch (Exception e) {
                logger.error("Error setting up action: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
        }
        return actions;
    }

    private static String joinMenuPaths(String baseMenu, String submenu) {
        if (baseMenu.isEmpty()) {
            return submenu;
        }
        if (baseMenu.endsWith(">")) {
            return baseMenu + submenu;
        }
        return baseMenu + ">" + submenu;
    }

    public static void parseAnnotations(Action action, AnnotatedElement element) {
        ActionTools.parseAnnotations(action, element, "");
    }

    public static void parseAnnotations(Action action, AnnotatedElement element, String baseMenu) {
        ActionTools.parseMenu(action, element.getAnnotation(ActionMenu.class), baseMenu);
        ActionTools.parseAccelerator(action, element.getAnnotation(ActionAccelerator.class));
        ActionTools.parseIcon(action, element.getAnnotation(ActionIcon.class));
        ActionTools.parseDeprecated(action, element.getAnnotation(Deprecated.class));
        ActionTools.parseConfig(action, element.getAnnotation(ActionConfig.class), QuPathResources.getLocalizedResourceManager());
    }

    private static void parseDeprecated(Action action, Deprecated annotation) {
        if (annotation != null) {
            action.getProperties().put((Object)"DEPRECATED", (Object)Boolean.TRUE);
            String text = action.getText();
            if (!(text == null || text.isEmpty() || text.contains("(") || action.textProperty().isBound())) {
                action.setText(action.getText() + " (deprecated)");
            }
        }
    }

    private static void parseConfig(Action action, ActionConfig annotation, LocalizedResourceManager localizedResourceManager) {
        if (annotation != null) {
            String bundle;
            String key = annotation.value();
            String string = bundle = annotation.bundle() != null && annotation.bundle().isEmpty() ? null : annotation.bundle();
            if (annotation.bindLocale()) {
                localizedResourceManager.registerProperty(action.textProperty(), bundle, key);
            } else {
                action.setText(QuPathResources.getString(bundle, key));
            }
            String descriptionKey = key + ".description";
            if (QuPathResources.hasString(bundle, descriptionKey)) {
                if (annotation.bindLocale()) {
                    SimpleStringProperty resourceLongTextProperty = new SimpleStringProperty();
                    resourceLongTextProperty.addListener((p, o, n) -> action.setLongText(ActionTools.getActionText(action.getAccelerator(), n)));
                    localizedResourceManager.registerProperty((StringProperty)resourceLongTextProperty, bundle, descriptionKey);
                    action.acceleratorProperty().addListener((arg_0, arg_1, arg_2) -> ActionTools.lambda$parseConfig$2(action, (StringProperty)resourceLongTextProperty, arg_0, arg_1, arg_2));
                } else {
                    action.setLongText(ActionTools.getActionText(action.getAccelerator(), QuPathResources.getString(bundle, descriptionKey)));
                    action.acceleratorProperty().addListener((p, o, n) -> action.setLongText(ActionTools.getActionText(n, QuPathResources.getString(bundle, descriptionKey))));
                }
            }
        }
    }

    private static String getActionText(KeyCombination accelerator, String description) {
        return accelerator == null || accelerator.getDisplayText().isBlank() ? description : "(" + accelerator.getDisplayText() + ") " + description;
    }

    private static void parseMenu(Action action, ActionMenu annotation, String baseMenu) {
        Object menuString;
        Object object = menuString = baseMenu == null || baseMenu.isBlank() ? "" : baseMenu;
        if (!((String)menuString).isEmpty() && !((String)menuString).endsWith(">")) {
            menuString = (String)menuString + ">";
        }
        if (annotation != null) {
            menuString = (String)menuString + ActionTools.getMenuString(annotation.value());
        }
        if (((String)menuString).isEmpty()) {
            return;
        }
        int ind = ((String)menuString).lastIndexOf(">");
        if (ind <= 0) {
            logger.warn("Invalid menu string {}, will skip {}", menuString, (Object)action);
            return;
        }
        String name = ActionTools.getStringOrReadResource(((String)menuString).substring(ind + 1));
        String menu = ((String)menuString).substring(0, ind);
        if (!name.isEmpty()) {
            action.setText(name);
        }
        action.getProperties().put((Object)"MENU", (Object)menu);
    }

    private static void parseIcon(Action action, ActionIcon annotation) {
        if (annotation == null) {
            return;
        }
        IconFactory.PathIcons icon = annotation.value();
        action.setGraphic(IconFactory.createNode(16, 16, icon));
    }

    private static void parseAccelerator(Action action, ActionAccelerator annotation) {
        if (annotation == null) {
            return;
        }
        String accelerator = annotation.value();
        if (!accelerator.isBlank()) {
            try {
                action.setAccelerator(KeyCombination.keyCombination((String)accelerator));
            }
            catch (Exception e) {
                logger.warn("Unable to parse key combination '{}', cannot create accelerator for {}", (Object)accelerator, (Object)action);
            }
        }
    }

    private static <T extends Node> T includeAction(T node, Action action) {
        node.getProperties().put((Object)ACTION_KEY, (Object)action);
        Object object = action.getProperties().getOrDefault((Object)INFO_MESSAGE_KEY, null);
        if (object instanceof ObjectExpression) {
            ObjectExpression prop = (ObjectExpression)object;
            ActionTools.addInfoMessageDecoration(node, (ObjectExpression<InfoMessage>)prop);
        }
        return node;
    }

    private static <T extends MenuItem> T includeAction(T item, Action action) {
        item.getProperties().put((Object)ACTION_KEY, (Object)action);
        return item;
    }

    public static void putActionProperty(Node node, Action action) {
        node.getProperties().put((Object)ACTION_KEY, (Object)action);
    }

    public static void putActionProperty(MenuItem node, Action action) {
        node.getProperties().put((Object)ACTION_KEY, (Object)action);
    }

    public static Action getActionProperty(Node node) {
        return node.hasProperties() ? (Action)node.getProperties().get((Object)ACTION_KEY) : null;
    }

    public static Action getActionProperty(MenuItem item) {
        return (Action)item.getProperties().get((Object)ACTION_KEY);
    }

    public static boolean isSelectable(Action action) {
        return Boolean.TRUE.equals(action.getProperties().get((Object)ActionBuilder.Keys.SELECTABLE));
    }

    public static void setSelectable(Action action, boolean selectable) {
        action.getProperties().put((Object)ActionBuilder.Keys.SELECTABLE, (Object)selectable);
    }

    public static Action createSeparator() {
        return new Action(null, null);
    }

    public static ActionBuilder actionBuilder(String text, Consumer<ActionEvent> handler) {
        return new ActionBuilder(text, handler);
    }

    public static ActionBuilder actionBuilder() {
        return new ActionBuilder();
    }

    public static ActionBuilder actionBuilder(Consumer<ActionEvent> handler) {
        return new ActionBuilder(handler);
    }

    public static MenuItem createMenuItem(Action action) {
        if (action.getText() == null || action == ActionUtils.ACTION_SEPARATOR) {
            return new SeparatorMenuItem();
        }
        Object item = ActionTools.isSelectable(action) ? ActionUtils.createCheckMenuItem((Action)action) : ActionUtils.createMenuItem((Action)action);
        return ActionTools.includeAction(item, action);
    }

    public static MenuItem createCheckMenuItem(Action action, ToggleGroup group) {
        CheckMenuItem item;
        if (group != null) {
            RadioMenuItem menuItem = ActionUtils.createRadioMenuItem((Action)action);
            menuItem.setToggleGroup(group);
            item = menuItem;
        } else {
            item = ActionUtils.createCheckMenuItem((Action)action);
        }
        return ActionTools.includeAction(item, action);
    }

    public static MenuItem createCheckMenuItem(Action action) {
        return ActionTools.createCheckMenuItem(action, null);
    }

    public static CheckBox createCheckBox(Action action) {
        CheckBox button = ActionUtils.createCheckBox((Action)action);
        button.selectedProperty().bindBidirectional((Property)action.selectedProperty());
        return ActionTools.includeAction(button, action);
    }

    private static ToggleButton getActionToggleButton(Action action, boolean hideActionText, ToggleGroup group) {
        ToggleButton button = ActionUtils.createToggleButton((Action)action, (ActionUtils.ActionTextBehavior)(hideActionText ? ActionUtils.ActionTextBehavior.HIDE : ActionUtils.ActionTextBehavior.SHOW));
        button.getStyleClass().remove((Object)"action");
        if (hideActionText && action.getText() != null && button.getTooltip() == null) {
            Tooltip tooltip = new Tooltip();
            tooltip.textProperty().bind((ObservableValue)action.textProperty());
            Tooltip.install((Node)button, (Tooltip)tooltip);
        }
        if (group != null) {
            button.setToggleGroup(group);
        }
        return ActionTools.includeAction(button, action);
    }

    private static ToggleButton createToggleButton(Action action, boolean hideActionText) {
        return ActionTools.getActionToggleButton(action, hideActionText, null);
    }

    public static ToggleButton createToggleButtonWithGraphicOnly(Action action) {
        return ActionTools.createToggleButton(action, true);
    }

    public static ToggleButton createToggleButton(Action action) {
        return ActionTools.createToggleButton(action, false);
    }

    private static Button createButton(Action action, boolean hideActionText) {
        Button button = ActionUtils.createButton((Action)action, (ActionUtils.ActionTextBehavior)(hideActionText ? ActionUtils.ActionTextBehavior.HIDE : ActionUtils.ActionTextBehavior.SHOW));
        return ActionTools.includeAction(button, action);
    }

    public static Button createButton(Action action) {
        return ActionTools.createButton(action, false);
    }

    public static Button createButtonWithGraphicOnly(Action action) {
        return ActionTools.createButton(action, true);
    }

    public static Action createSelectableAction(ObservableValue<Boolean> property, String name, Node icon, KeyCombination accelerator) {
        Action action = ActionTools.actionBuilder().text(name).selected(property).selectable(true).accelerator(accelerator).graphic(icon).build();
        return action;
    }

    public static Action createSelectableAction(ObservableValue<Boolean> property) {
        return ActionTools.createSelectableAction(property, null);
    }

    public static Action createSelectableAction(ObservableValue<Boolean> property, String name) {
        return ActionTools.createSelectableAction(property, name, null, null);
    }

    private static Action createAction(Runnable command, String name, Node icon, KeyCombination accelerator) {
        Action action = ActionTools.actionBuilder(name, e -> command.run()).accelerator(accelerator).graphic(icon).build();
        return action;
    }

    public static Action createAction(Runnable command, String name) {
        return ActionTools.createAction(command, name, null, null);
    }

    public static Action createAction(Runnable command) {
        return ActionTools.createAction(command, null, null, null);
    }

    public static <T> Action createSelectableCommandAction(SelectableItem<T> command, String name, Node icon, KeyCombination accelerator) {
        return ActionTools.createSelectableCommandAction(command, (ObservableValue<String>)new SimpleStringProperty(name), (ObservableValue<Node>)new SimpleObjectProperty((Object)icon), accelerator);
    }

    public static <T> Action createSelectableCommandAction(SelectableItem<T> command, ObservableValue<String> name, ObservableValue<Node> icon, KeyCombination accelerator) {
        Action action = ActionTools.actionBuilder(e -> command.setSelected(true)).text(name).accelerator(accelerator).selectable(true).selected((ObservableValue<Boolean>)command.selectedProperty()).graphic(icon).build();
        return action;
    }

    static <T> Action createSelectableCommandAction(SelectableItem<T> command, ObservableValue<String> name) {
        return ActionTools.createSelectableCommandAction(command, name, null, null);
    }

    public static <T> Action createSelectableCommandAction(SelectableItem<T> command, String name) {
        return ActionTools.createSelectableCommandAction(command, name, null, null);
    }

    public static <T> Action createSelectableCommandAction(SelectableItem<T> command) {
        return ActionTools.createSelectableCommandAction(command, (String)null, null, null);
    }

    public static Action createSelectableCommandAction(ObservableBooleanValue value) {
        return ActionTools.createSelectableAction((ObservableValue<Boolean>)value, null);
    }

    public static void installInfoMessage(Action action, ObjectExpression<InfoMessage> message) {
        action.getProperties().put((Object)INFO_MESSAGE_KEY, message);
    }

    private static void addInfoMessageDecoration(Node node, ObjectExpression<InfoMessage> message) {
        Control control;
        logger.trace("Installing info message decoration for {}", (Object)node);
        double radius = 5.0;
        if (node instanceof Control && (control = (Control)node).getWidth() > 0.0 && control.getHeight() > 0.0) {
            radius = Math.min(control.getWidth(), control.getHeight()) / 8.0;
        }
        Circle circle = new Circle(radius);
        circle.relocate(0.0, 0.0);
        Text text = new Text();
        text.textProperty().bind(message.flatMap(InfoMessage::countProperty).map(ActionTools::countToString));
        text.getStyleClass().add((Object)"badge-text");
        StackPane stack = new StackPane();
        stack.getChildren().addAll((Object[])new Node[]{circle, text});
        ActionTools.updateInfoMessageStyleClasses((Node)circle, (InfoMessage)message.get());
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind(message.flatMap(InfoMessage::textProperty));
        Tooltip.install((Node)stack, (Tooltip)tooltip);
        tooltip.setShowDelay(Duration.ZERO);
        message.addListener((v, o, n) -> ActionTools.updateInfoMessageStyleClasses((Node)circle, n));
        stack.getStyleClass().add((Object)"toolbar-badge");
        GraphicDecoration decoration = new GraphicDecoration((Node)stack, Pos.TOP_RIGHT, -0.5 * circle.getRadius(), 0.5 * circle.getRadius());
        stack.visibleProperty().bind((ObservableValue)PathPrefs.showToolBarBadgesProperty().and((ObservableBooleanValue)message.isNotNull()));
        Platform.runLater(() -> Decorator.addDecoration((Node)node, (Decoration)decoration));
    }

    private static String countToString(Number n) {
        if (n == null || n.intValue() <= 1) {
            return null;
        }
        if (n.intValue() > 99) {
            return "99";
        }
        return Integer.toString(n.intValue());
    }

    private static void updateInfoMessageStyleClasses(Node node, InfoMessage message) {
        String style;
        String string = style = message == null ? null : message.getMessageType().toString().toLowerCase();
        if (style == null) {
            node.getStyleClass().clear();
        } else {
            node.getStyleClass().setAll((Object[])new String[]{"info-message", style});
        }
    }

    private static /* synthetic */ void lambda$parseConfig$2(Action action, StringProperty resourceLongTextProperty, ObservableValue p, KeyCombination o, KeyCombination n) {
        action.setLongText(ActionTools.getActionText(n, (String)resourceLongTextProperty.get()));
    }

    private static /* synthetic */ void lambda$getAnnotatedActions$0(Method m, Object obj, ActionEvent e) {
        try {
            m.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
            logger.error("Error invoking method: " + e1.getLocalizedMessage(), (Throwable)e1);
        }
    }

    public static class ActionBuilder {
        private Consumer<ActionEvent> handler;
        private Map<Keys, Object> properties = new HashMap<Keys, Object>();

        ActionBuilder() {
        }

        ActionBuilder(String text, Consumer<ActionEvent> handler) {
            this.handler = handler;
            this.text(text);
        }

        ActionBuilder(Consumer<ActionEvent> handler) {
            this.handler = handler;
        }

        private ActionBuilder property(Keys key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public ActionBuilder text(String value) {
            return this.property(Keys.TEXT, value);
        }

        public ActionBuilder selectable(boolean isSelectable) {
            return this.property(Keys.SELECTABLE, isSelectable);
        }

        public ActionBuilder longText(String value) {
            return this.property(Keys.LONG_TEXT, value);
        }

        public ActionBuilder graphic(Node value) {
            return this.property(Keys.GRAPHIC, value);
        }

        public ActionBuilder accelerator(KeyCombination value) {
            return this.property(Keys.ACCELERATOR, value);
        }

        public ActionBuilder selected(boolean value) {
            return this.property(Keys.SELECTED, value);
        }

        public ActionBuilder disabled(boolean value) {
            return this.property(Keys.DISABLED, value);
        }

        public ActionBuilder text(ObservableValue<String> value) {
            return this.property(Keys.TEXT, value);
        }

        public ActionBuilder longText(ObservableValue<String> value) {
            return this.property(Keys.LONG_TEXT, value);
        }

        public ActionBuilder graphic(ObservableValue<Node> value) {
            return this.property(Keys.GRAPHIC, value);
        }

        public ActionBuilder accelerator(ObservableValue<KeyCombination> value) {
            return this.property(Keys.ACCELERATOR, value);
        }

        public ActionBuilder selected(ObservableValue<Boolean> value) {
            return this.property(Keys.SELECTED, value);
        }

        public ActionBuilder disabled(ObservableValue<Boolean> value) {
            return this.property(Keys.DISABLED, value);
        }

        private static <T> void updateProperty(Property<T> property, Object value) {
            if (value instanceof ObservableValue) {
                ActionBuilder.bindProperty(property, (ObservableValue)value);
            } else {
                ActionBuilder.setProperty(property, value);
            }
        }

        private static <T> void setProperty(Property<T> property, T value) {
            property.setValue(value);
        }

        private static <T> void bindProperty(Property<T> property, ObservableValue<? extends T> value) {
            if (value instanceof Property) {
                property.bindBidirectional((Property)value);
            } else {
                property.bind(value);
            }
        }

        public Action build() {
            Action action = new Action(this.handler);
            for (Map.Entry<Keys, Object> entry : this.properties.entrySet()) {
                Object value = entry.getValue();
                switch (entry.getKey().ordinal()) {
                    case 5: {
                        ActionBuilder.updateProperty(action.acceleratorProperty(), value);
                        break;
                    }
                    case 4: {
                        ActionBuilder.updateProperty(action.disabledProperty(), value);
                        break;
                    }
                    case 3: {
                        ActionBuilder.updateProperty(action.graphicProperty(), value);
                        break;
                    }
                    case 1: {
                        ActionBuilder.updateProperty(action.longTextProperty(), value);
                        break;
                    }
                    case 6: {
                        ActionTools.setSelectable(action, (Boolean)value);
                        break;
                    }
                    case 2: {
                        ActionBuilder.updateProperty(action.selectedProperty(), value);
                        break;
                    }
                    case 0: {
                        ActionBuilder.updateProperty(action.textProperty(), value);
                        break;
                    }
                }
            }
            return action;
        }

        private static enum Keys {
            TEXT,
            LONG_TEXT,
            SELECTED,
            GRAPHIC,
            DISABLED,
            ACCELERATOR,
            SELECTABLE;

        }
    }
}

