/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.Version;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.Urls;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.prefs.QuPathStyleManager;

public class WelcomeStage {
    private static final Logger logger = LoggerFactory.getLogger(WelcomeStage.class);
    private static Stage INSTANCE;
    private static final StringProperty TITLE;

    public static Stage getInstance(QuPathGUI qupath) {
        if (INSTANCE == null) {
            INSTANCE = WelcomeStage.buildStage(qupath);
        }
        return INSTANCE;
    }

    private static Stage buildStage(QuPathGUI qupath) {
        LocalizedResourceManager localeListener = QuPathResources.getLocalizedResourceManager();
        Stage stage = new Stage();
        if (qupath != null) {
            stage.initOwner((Window)qupath.getStage());
        }
        Button btnCode = WelcomeStage.createGlyphButton("Welcome.develop", FontAwesome.Glyph.CODE, Urls.getGitHubRepoUrl());
        Button btnDocs = WelcomeStage.createGlyphButton("Welcome.docs", FontAwesome.Glyph.FILE_TEXT_ALT, Urls.getVersionedDocsUrl());
        Button btnForum = WelcomeStage.createGlyphButton("Welcome.discuss", FontAwesome.Glyph.COMMENTS_ALT, Urls.getUserForumUrl());
        GridPane paneButtons = GridPaneUtils.createColumnGrid((Node[])new Node[]{btnDocs, btnForum, btnCode});
        BorderPane pane = new BorderPane((Node)paneButtons);
        ImageView imageView = new ImageView(WelcomeStage.class.getResource("/images/qupath-welcome.png").toExternalForm());
        imageView.setFitWidth(440.0);
        imageView.setOpacity(0.9);
        imageView.setPreserveRatio(true);
        Text textTitle = new Text();
        QuPathResources.getLocalizedResourceManager().registerProperty(textTitle.textProperty(), "Welcome.welcomeMessage");
        textTitle.setStyle("-fx-font-weight: bold; -fx-font-size: 150%; -fx-fill: -fx-text-base-color;");
        VBox topPane = new VBox();
        topPane.setAlignment(Pos.CENTER);
        topPane.getChildren().add((Object)textTitle);
        Version version = QuPathGUI.getVersion();
        if (version != null) {
            Object versionString = version.toString();
            if (!((String)versionString).startsWith("v")) {
                versionString = "v" + (String)versionString;
            }
            Text textVersion = new Text((String)versionString);
            textVersion.setStyle("-fx-fill: -fx-text-base-color; -fx-opacity: 0.6;");
            Pane spacer = new Pane();
            spacer.setPrefHeight(2.0);
            topPane.getChildren().add((Object)spacer);
            topPane.getChildren().add((Object)textVersion);
        }
        topPane.getChildren().add((Object)imageView);
        BorderPane.setAlignment((Node)topPane, (Pos)Pos.CENTER);
        pane.setTop((Node)topPane);
        Label labelExplanation = new Label(QuPathResources.getString("Welcome.defaultMessage"));
        labelExplanation.setAlignment(Pos.CENTER);
        labelExplanation.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (btnCode.isHover()) {
                return QuPathResources.getString("Welcome.developMessage");
            }
            if (btnDocs.isHover()) {
                return QuPathResources.getString("Welcome.docsMessage");
            }
            if (btnForum.isHover()) {
                return QuPathResources.getString("Welcome.discussMessage");
            }
            return QuPathResources.getString("Welcome.defaultMessage");
        }, (Observable[])new Observable[]{btnCode.hoverProperty(), btnDocs.hoverProperty(), btnForum.hoverProperty(), PathPrefs.defaultLocaleDisplayProperty()}));
        labelExplanation.setTextAlignment(TextAlignment.CENTER);
        labelExplanation.setAlignment(Pos.CENTER);
        labelExplanation.setMinHeight(40.0);
        labelExplanation.setOpacity(0.8);
        ComboBox comboThemes = new ComboBox(QuPathStyleManager.availableStylesProperty());
        comboThemes.getSelectionModel().select((Object)((QuPathStyleManager.StyleOption)QuPathStyleManager.selectedStyleProperty().get()));
        comboThemes.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> QuPathStyleManager.selectedStyleProperty().set(n));
        Label labelThemes = new Label();
        localeListener.registerProperty(labelThemes.textProperty(), "Welcome.chooseTheme");
        labelThemes.setLabelFor((Node)comboThemes);
        labelThemes.setAlignment(Pos.CENTER_RIGHT);
        ComboBox comboUpdates = new ComboBox();
        comboUpdates.getItems().setAll((Object[])PathPrefs.AutoUpdateType.values());
        comboUpdates.getSelectionModel().select((Object)((PathPrefs.AutoUpdateType)((Object)PathPrefs.autoUpdateCheckProperty().get())));
        comboUpdates.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> PathPrefs.autoUpdateCheckProperty().set((Object)n));
        Label labelUpdates = new Label();
        localeListener.registerProperty(labelUpdates.textProperty(), "Welcome.checkUpdates");
        labelUpdates.setLabelFor((Node)comboUpdates);
        labelUpdates.setAlignment(Pos.CENTER_RIGHT);
        CheckBox cbShowStartup = new CheckBox();
        localeListener.registerProperty(cbShowStartup.textProperty(), "Welcome.showOnStartup");
        cbShowStartup.selectedProperty().bindBidirectional((Property)PathPrefs.showStartupMessageProperty());
        cbShowStartup.setAlignment(Pos.CENTER_RIGHT);
        GridPane paneOptions = new GridPane();
        paneOptions.setHgap(5.0);
        paneOptions.setVgap(5.0);
        paneOptions.setPadding(new Insets(5.0, 5.0, 0.0, 5.0));
        int row = 0;
        paneOptions.add((Node)labelExplanation, 0, row++, Integer.MAX_VALUE, 1);
        Separator separator = new Separator(Orientation.HORIZONTAL);
        separator.setPadding(new Insets(5.0));
        paneOptions.add((Node)separator, 0, row++, Integer.MAX_VALUE, 1);
        paneOptions.add((Node)labelThemes, 0, row);
        paneOptions.add((Node)comboThemes, 1, row, 1, 1);
        paneOptions.add((Node)labelUpdates, 0, ++row);
        paneOptions.add((Node)comboUpdates, 1, row, 1, 1);
        Separator separator2 = new Separator(Orientation.HORIZONTAL);
        separator2.setPadding(new Insets(5.0));
        int n2 = ++row;
        ++row;
        paneOptions.add((Node)separator2, 0, n2, Integer.MAX_VALUE, 1);
        Hyperlink linkCiting = new Hyperlink();
        localeListener.registerProperty(linkCiting.textProperty(), "Welcome.clickForDetails");
        linkCiting.setOnAction(e -> QuPathGUI.openInBrowser(Urls.getCitationUrl()));
        Text textCitingStart = new Text();
        localeListener.registerProperty(textCitingStart.textProperty(), "Welcome.cite");
        TextFlow textCiting = new TextFlow(new Node[]{textCitingStart, new Text(System.lineSeparator()), linkCiting});
        textCiting.setTextAlignment(TextAlignment.CENTER);
        for (Node n3 : textCiting.getChildren()) {
            n3.setStyle("-fx-fill: -fx-text-base-color;");
        }
        paneOptions.add((Node)textCiting, 0, row, Integer.MAX_VALUE, 1);
        ++row;
        Button btnStarted = new Button();
        localeListener.registerProperty(btnStarted.textProperty(), "Welcome.getStarted");
        btnStarted.setStyle("-fx-font-weight: bold; -fx-font-size: 110%;");
        btnStarted.setPadding(new Insets(10.0));
        btnStarted.setOnAction(e -> stage.close());
        paneOptions.add((Node)btnStarted, 0, row, Integer.MAX_VALUE, 1);
        paneOptions.add((Node)cbShowStartup, 0, ++row, Integer.MAX_VALUE, 1);
        ++row;
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{comboThemes, comboUpdates, cbShowStartup, btnStarted, labelExplanation});
        if (GeneralTools.isAppleSilicon()) {
            TextFlow textSilicon = WelcomeStage.makeMacAarch64Message();
            textSilicon.setTextAlignment(TextAlignment.CENTER);
            textSilicon.setOpacity(0.9);
            Separator sepSilicon = new Separator(Orientation.HORIZONTAL);
            sepSilicon.setPadding(new Insets(5.0, 5.0, 0.0, 5.0));
            GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{sepSilicon, textSilicon});
            paneOptions.add((Node)sepSilicon, 0, row++, Integer.MAX_VALUE, 1);
            paneOptions.add((Node)textSilicon, 0, row++, Integer.MAX_VALUE, 1);
            ++row;
        }
        pane.setBottom((Node)paneOptions);
        pane.setPadding(new Insets(10.0));
        stage.setScene(new Scene((Parent)pane));
        stage.titleProperty().bind((ObservableValue)TITLE);
        FXUtils.makeDraggableStage((Stage)stage);
        stage.getScene().setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                logger.info("Startup stage closed by double-click");
                stage.close();
            }
        });
        stage.getScene().setOnKeyPressed(e -> {
            if (!e.isConsumed() && e.getCode() == KeyCode.ESCAPE) {
                logger.info("Startup stage closed by pressing escape");
                stage.close();
            }
        });
        btnStarted.requestFocus();
        stage.setMinWidth(450.0);
        stage.setMinHeight(600.0);
        return stage;
    }

    private static TextFlow makeMacAarch64Message() {
        StringProperty textProperty = QuPathResources.getLocalizedResourceManager().createProperty("Welcome.macOsAarch64");
        Text textSiliconExperimental = new Text();
        textSiliconExperimental.setStyle("-fx-font-weight: bold; -fx-fill: -qp-script-error-color;");
        Hyperlink linkSilicon = new Hyperlink();
        Text textSiliconExperimental2 = new Text();
        textSiliconExperimental2.setStyle("-fx-fill: -fx-text-base-color;");
        linkSilicon.setOnAction(e -> QuPathGUI.openInBrowser(Urls.getInstallationUrl()));
        WelcomeStage.updateMessageTextFlow((String)textProperty.get(), textSiliconExperimental, linkSilicon, textSiliconExperimental2);
        textProperty.addListener((v, o, n) -> WelcomeStage.updateMessageTextFlow(n, textSiliconExperimental, linkSilicon, textSiliconExperimental2));
        return new TextFlow(new Node[]{textSiliconExperimental, linkSilicon, textSiliconExperimental2});
    }

    private static void updateMessageTextFlow(String text, Text textSiliconExperimental, Hyperlink linkSilicon, Text textSiliconExperimental2) {
        int ind1 = text.indexOf("{{");
        int ind2 = text.lastIndexOf("}}");
        String startText = text.substring(0, ind1);
        String linkText = text.substring(ind1 + 2, ind2).strip();
        String endText = text.substring(ind2 + 2).strip();
        textSiliconExperimental.setText(startText);
        linkSilicon.setText(linkText);
        textSiliconExperimental2.setText(endText);
    }

    private static Button createGlyphButton(String key, FontAwesome.Glyph glyph, String url) {
        Button button = new Button();
        button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        button.setPrefSize(100.0, 100.0);
        if (key == null) {
            button.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        } else {
            QuPathResources.getLocalizedResourceManager().registerProperty(button.textProperty(), key);
            button.setContentDisplay(ContentDisplay.TOP);
        }
        if (url != null) {
            button.setOnAction(e -> QuPathGUI.openInBrowser(url));
            button.setTooltip(new Tooltip(url));
        }
        GlyphFont fontAwesome = GlyphFontRegistry.font((String)"FontAwesome");
        Glyph icon = fontAwesome.create((Enum)glyph);
        icon.size((double)((int)(button.getPrefWidth() * 0.5)));
        button.setGraphic((Node)icon);
        return button;
    }

    static {
        TITLE = QuPathResources.getLocalizedResourceManager().createProperty("Welcome.title");
    }
}

