/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.prefs.PathPrefs;

public class UserDirectoryManager {
    private static final Logger logger = LoggerFactory.getLogger(UserDirectoryManager.class);
    public static final String DIR_EXTENSIONS = "extensions";
    public static final String DIR_CSS = "css";
    public static final String DIR_SCRIPTS = "scripts";
    public static final String DIR_COLORMAPS = "colormaps";
    public static final String DIR_LOGS = "logs";
    public static final String DIR_LOCALIZATION = "localization";
    private static UserDirectoryManager INSTANCE;
    private ObjectProperty<Path> userDirectoryProperty = new SimpleObjectProperty();
    private ReadOnlyObjectProperty<Path> extensionsDirectoryProperty = this.createRelativePathProperty((ObservableValue<Path>)this.userDirectoryProperty, "extensions");
    private ReadOnlyObjectProperty<Path> colormapsDirectoryProperty = this.createRelativePathProperty((ObservableValue<Path>)this.userDirectoryProperty, "colormaps");
    private ReadOnlyObjectProperty<Path> cssDirectoryProperty = this.createRelativePathProperty((ObservableValue<Path>)this.userDirectoryProperty, "css");
    private ReadOnlyObjectProperty<Path> logDirectoryProperty = this.createRelativePathProperty((ObservableValue<Path>)this.userDirectoryProperty, "logs");
    private ReadOnlyObjectProperty<Path> localizationDirectoryProperty = this.createRelativePathProperty((ObservableValue<Path>)this.userDirectoryProperty, "localization");
    private ReadOnlyObjectProperty<Path> scriptsDirectoryProperty = this.createRelativePathProperty((ObservableValue<Path>)this.userDirectoryProperty, "scripts");

    private UserDirectoryManager() {
        PathPrefs.userPathProperty().addListener((v, o, n) -> this.syncPathPropertyToPrefs((String)n));
        this.userDirectoryProperty.addListener((v, o, n) -> this.syncPrefsToPathProperty((Path)n));
        this.syncPathPropertyToPrefs((String)PathPrefs.userPathProperty().get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserDirectoryManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<UserDirectoryManager> clazz = UserDirectoryManager.class;
        synchronized (UserDirectoryManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new UserDirectoryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private void syncPathPropertyToPrefs(String path) {
        if (path == null) {
            this.userDirectoryProperty.set(null);
        } else {
            try {
                Path newPath = Paths.get(path, new String[0]);
                if (Files.isDirectory(newPath, new LinkOption[0])) {
                    this.userDirectoryProperty.set((Object)newPath);
                } else {
                    logger.error("Cannot set user directory - {} does note exist", (Object)newPath);
                    Path currentPath = (Path)this.userDirectoryProperty.get();
                    if (currentPath == null || Files.isDirectory(currentPath, new LinkOption[0])) {
                        this.syncPrefsToPathProperty(currentPath);
                    } else {
                        this.userDirectoryProperty.set(null);
                    }
                }
            }
            catch (InvalidPathException e) {
                logger.error("Cannot set user path to {} ({})", (Object)path, (Object)e.getLocalizedMessage());
                logger.debug(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void syncPrefsToPathProperty(Path path) {
        if (path == null) {
            PathPrefs.userPathProperty().set(null);
        } else {
            PathPrefs.userPathProperty().set((Object)path.toString());
        }
    }

    public ReadOnlyObjectProperty<Path> createRelativePathProperty(String other) {
        return this.createRelativePathProperty((ObservableValue<Path>)this.userDirectoryProperty(), other);
    }

    private ReadOnlyObjectProperty<Path> createRelativePathProperty(ObservableValue<Path> path, String other) {
        ReadOnlyObjectWrapper wrapper = new ReadOnlyObjectWrapper();
        path.addListener((v, o, n) -> wrapper.set((Object)UserDirectoryManager.resolvePathOrNull(n, other)));
        return wrapper.getReadOnlyProperty();
    }

    private static Path resolvePathOrNull(Path path, String other) {
        if (path == null) {
            return null;
        }
        return path.resolve(other);
    }

    public ObjectProperty<Path> userDirectoryProperty() {
        return this.userDirectoryProperty;
    }

    public ReadOnlyObjectProperty<Path> extensionsDirectoryProperty() {
        return this.extensionsDirectoryProperty;
    }

    public ReadOnlyObjectProperty<Path> cssDirectoryProperty() {
        return this.cssDirectoryProperty;
    }

    public ReadOnlyObjectProperty<Path> localizationDirectoryProperty() {
        return this.localizationDirectoryProperty;
    }

    public ReadOnlyObjectProperty<Path> logDirectoryProperty() {
        return this.logDirectoryProperty;
    }

    public ReadOnlyObjectProperty<Path> scriptsDirectoryProperty() {
        return this.scriptsDirectoryProperty;
    }

    public ReadOnlyObjectProperty<Path> colormapsDirectoryProperty() {
        return this.colormapsDirectoryProperty;
    }

    public Path getUserPath() {
        return (Path)this.userDirectoryProperty().get();
    }

    public Path getRelativePathOrNull(String other) {
        Path userPath = this.getUserPath();
        if (userPath == null) {
            return null;
        }
        return userPath.resolve(other);
    }

    public void setUserPath(Path path) throws IllegalArgumentException {
        if (path != null && Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("User path " + String.valueOf(path) + " exists, but is not a directory!");
        }
        this.userDirectoryProperty.set((Object)path);
    }

    public Path getExtensionsPath() {
        return (Path)this.extensionsDirectoryProperty.get();
    }

    public Path getCssStylesPath() {
        return (Path)this.cssDirectoryProperty().get();
    }

    public Path getLogDirectoryPath() {
        return (Path)this.logDirectoryProperty().get();
    }

    public Path getLocalizationDirectoryPath() {
        return (Path)this.localizationDirectoryProperty().get();
    }

    public Path getColormapsDirectoryPath() {
        return (Path)this.colormapsDirectoryProperty().get();
    }

    public Path getScriptsDirectoryPath() {
        return (Path)this.scriptsDirectoryProperty().get();
    }
}

