/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.Version;
import qupath.lib.gui.QuPathGUI;

public final class Urls {
    private static final Logger logger = LoggerFactory.getLogger(Urls.class);
    private static final String DOCS_VERSION = "0.6";

    public static String getDocsUrl() {
        return "https://qupath.readthedocs.io";
    }

    public static String getVersionedDocsUrl() {
        return "https://qupath.readthedocs.io/en/0.6";
    }

    public static String getVersionedDocsUrl(String relative) {
        return "https://qupath.readthedocs.io/en/0.6/docs/" + relative;
    }

    public static String getCitationUrl() {
        return Urls.getVersionedDocsUrl("intro/citing.html");
    }

    public static String getInstallationUrl() {
        return Urls.getVersionedDocsUrl("intro/installation.html");
    }

    public static String getExtensionsDocsUrl() {
        return Urls.getVersionedDocsUrl("intro/extensions.html");
    }

    public static String getYouTubeUrl() {
        return "https://www.youtube.com/c/QuPath";
    }

    public static String getGitHubRepoUrl() {
        return "https://github.com/qupath/qupath";
    }

    public static String getGitHubIssuesUrl() {
        return "https://github.com/qupath/qupath/issues";
    }

    public static String getUserForumUrl() {
        return "https://forum.image.sc/tags/qupath";
    }

    static {
        Version version = QuPathGUI.getVersion();
        if (version == null || version == Version.UNKNOWN) {
            logger.warn("Docs version is '{}' but QuPath version is unknown", (Object)DOCS_VERSION);
        } else if (!DOCS_VERSION.equals(version.getMajor() + "." + version.getMinor())) {
            logger.warn("Docs version is '{}' but QuPath version is '{}'", (Object)DOCS_VERSION, (Object)version);
        } else {
            logger.debug("Docs version is '{}', QuPath version is '{}'", (Object)DOCS_VERSION, (Object)version);
        }
    }
}

