/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;
import qupath.lib.gui.prefs.PathPrefs;

class UpdateManagerContainer
extends VBox {
    @FXML
    private TableView<UpdateEntry> updateEntries;
    @FXML
    private TableColumn<UpdateEntry, String> nameColumn;
    @FXML
    private TableColumn<UpdateEntry, String> currentVersionColumn;
    @FXML
    private TableColumn<UpdateEntry, String> newVersionColumn;
    @FXML
    private ComboBox<PathPrefs.AutoUpdateType> updateType;

    public UpdateManagerContainer(List<UpdateEntry> updateEntries) throws IOException {
        FXMLLoader loader = new FXMLLoader(UpdateManagerContainer.class.getResource("update-manager-container.fxml"), ResourceBundle.getBundle("qupath/lib/gui/localization/qupath-gui-strings"));
        loader.setRoot((Object)this);
        loader.setController((Object)this);
        loader.load();
        this.setTable(updateEntries);
        this.setColumns();
        this.setUpdateType();
    }

    public PathPrefs.AutoUpdateType getSelectedUpdateType() {
        return (PathPrefs.AutoUpdateType)((Object)this.updateType.getSelectionModel().getSelectedItem());
    }

    private void setTable(List<UpdateEntry> updateEntries) {
        this.updateEntries.getItems().setAll(updateEntries);
        this.updateEntries.setRowFactory(ignored -> {
            TableRow row = new TableRow();
            row.itemProperty().addListener((v, o, n) -> {
                if (n == null) {
                    row.setTooltip(null);
                    row.setOnMouseClicked(null);
                } else {
                    row.setTooltip(new Tooltip(n.onClickDescription()));
                    row.setOnMouseClicked(mouseEvent -> {
                        if (mouseEvent.getClickCount() > 1) {
                            n.onClick.run();
                        }
                    });
                }
            });
            return row;
        });
    }

    private void setColumns() {
        this.nameColumn.setCellValueFactory(cell -> new SimpleStringProperty(((UpdateEntry)cell.getValue()).name()));
        this.currentVersionColumn.setCellValueFactory(cell -> new SimpleStringProperty(((UpdateEntry)cell.getValue()).currentVersion()));
        this.newVersionColumn.setCellValueFactory(cell -> new SimpleStringProperty(((UpdateEntry)cell.getValue()).newVersion()));
    }

    private void setUpdateType() {
        this.updateType.getItems().setAll((Object[])PathPrefs.AutoUpdateType.values());
        this.updateType.getSelectionModel().select((Object)((PathPrefs.AutoUpdateType)((Object)PathPrefs.autoUpdateCheckProperty().get())));
    }

    public record UpdateEntry(String name, String currentVersion, String newVersion, Runnable onClick, String onClickDescription) {
    }
}

