/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.QuPathViewerListener;
import qupath.lib.images.ImageData;
import qupath.lib.io.PathIO;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.plugins.ParallelTileObject;

public class UndoRedoManager
implements ChangeListener<QuPathViewer>,
QuPathViewerListener,
PathObjectHierarchyListener {
    private static Logger logger = LoggerFactory.getLogger(UndoRedoManager.class);
    private ObservableValue<? extends QuPathViewer> viewerProperty;
    private IntegerProperty maxUndoHierarchySize = PathPrefs.maxUndoHierarchySizeProperty();
    private IntegerProperty maxUndoLevels = PathPrefs.maxUndoLevelsProperty();
    private SimpleBooleanProperty canUndo = new SimpleBooleanProperty(false);
    private SimpleBooleanProperty canRedo = new SimpleBooleanProperty(false);
    private boolean undoingOrRedoing = false;
    private Map<QuPathViewer, SerializableUndoRedoStack<PathObjectHierarchy>> map = new WeakHashMap<QuPathViewer, SerializableUndoRedoStack<PathObjectHierarchy>>();

    private UndoRedoManager(ObservableValue<? extends QuPathViewer> viewerProperty) {
        this.viewerProperty = viewerProperty;
        this.viewerProperty.addListener((ChangeListener)this);
        this.changed(this.viewerProperty, null, (QuPathViewer)this.viewerProperty.getValue());
    }

    public static UndoRedoManager createForObservableViewer(ObservableValue<? extends QuPathViewer> viewerProperty) {
        return new UndoRedoManager(viewerProperty);
    }

    private void refreshProperties() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.refreshProperties());
            return;
        }
        SerializableUndoRedoStack<PathObjectHierarchy> undoRedo = this.map.get(this.viewerProperty.getValue());
        if (undoRedo == null) {
            this.canUndo.set(false);
            this.canRedo.set(false);
        } else {
            this.canUndo.set(undoRedo.canUndo());
            this.canRedo.set(undoRedo.canRedo());
        }
    }

    public boolean undoOnce() {
        return this.undoOnce((QuPathViewer)this.viewerProperty.getValue());
    }

    public long totalBytes() {
        long total = 0L;
        for (SerializableUndoRedoStack<PathObjectHierarchy> manager : this.map.values()) {
            if (manager == null) continue;
            total += manager.totalBytes();
        }
        return total;
    }

    public void clear() {
        for (SerializableUndoRedoStack<PathObjectHierarchy> manager : this.map.values()) {
            manager.clear();
        }
        this.refreshProperties();
    }

    public boolean redoOnce() {
        return this.redoOnce((QuPathViewer)this.viewerProperty.getValue());
    }

    boolean undoOnce(QuPathViewer viewer) {
        if (viewer == null) {
            logger.warn("Undo requested, but no viewer specified.");
            return false;
        }
        SerializableUndoRedoStack<PathObjectHierarchy> undoRedo = this.map.get(viewer);
        if (undoRedo == null) {
            logger.warn("Undo requested, but undo stack available.");
            return false;
        }
        PathObjectHierarchy hierarchy = undoRedo.undoOnce();
        if (hierarchy == null) {
            logger.warn("Unable to call 'undo' for {}", (Object)viewer);
            return false;
        }
        this.undoingOrRedoing = true;
        logger.debug("Called 'undo' for {}", (Object)viewer);
        viewer.getImageData().getHierarchy().getSelectionModel().clearSelection();
        viewer.getImageData().getHierarchy().setHierarchy(hierarchy);
        this.undoingOrRedoing = false;
        this.refreshProperties();
        return true;
    }

    boolean redoOnce(QuPathViewer viewer) {
        if (viewer == null) {
            logger.warn("Redo requested, but no viewer specified.");
            return false;
        }
        SerializableUndoRedoStack<PathObjectHierarchy> undoRedo = this.map.get(viewer);
        if (undoRedo == null) {
            logger.warn("Redo requested, but redo stack available.");
            return false;
        }
        PathObjectHierarchy hierarchy = undoRedo.redoOnce();
        if (hierarchy == null) {
            logger.warn("Unable to call 'redo' for {}", (Object)viewer);
            return false;
        }
        this.undoingOrRedoing = true;
        logger.debug("Called 'redo' for {}", (Object)viewer);
        viewer.getImageData().getHierarchy().getSelectionModel().clearSelection();
        viewer.getImageData().getHierarchy().setHierarchy(hierarchy);
        this.undoingOrRedoing = false;
        this.refreshProperties();
        return true;
    }

    public ReadOnlyBooleanProperty canUndo() {
        return this.canUndo;
    }

    public ReadOnlyBooleanProperty canRedo() {
        return this.canRedo;
    }

    public void changed(ObservableValue<? extends QuPathViewer> observable, QuPathViewer oldValue, QuPathViewer newValue) {
        if (newValue == null) {
            return;
        }
        if (!this.map.containsKey(newValue)) {
            newValue.addViewerListener(this);
            this.imageDataChanged(newValue, null, newValue.getImageData());
        }
        this.refreshProperties();
    }

    @Override
    public void imageDataChanged(QuPathViewer viewer, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
        PathObjectHierarchy hierarchy;
        if (imageDataOld != null) {
            imageDataOld.getHierarchy().removeListener((PathObjectHierarchyListener)this);
        }
        PathObjectHierarchy pathObjectHierarchy = hierarchy = imageDataNew == null ? null : imageDataNew.getHierarchy();
        if (hierarchy == null) {
            this.map.put(viewer, null);
        } else {
            int maxSize = this.maxUndoHierarchySize.get();
            if (maxSize >= hierarchy.nObjects()) {
                this.map.put(viewer, new SerializableUndoRedoStack<PathObjectHierarchy>(hierarchy));
            } else {
                this.map.put(viewer, new SerializableUndoRedoStack<Object>(null));
            }
            hierarchy.addListener((PathObjectHierarchyListener)this);
        }
        this.refreshProperties();
    }

    @Override
    public void visibleRegionChanged(QuPathViewer viewer, Shape shape) {
    }

    @Override
    public void selectedObjectChanged(QuPathViewer viewer, PathObject pathObjectSelected) {
    }

    @Override
    public void viewerClosed(QuPathViewer viewer) {
        this.map.remove(viewer);
        viewer.removeViewerListener(this);
    }

    public void hierarchyChanged(PathObjectHierarchyEvent event) {
        if (this.undoingOrRedoing || event.isChanging() || this.maxUndoHierarchySize.get() <= 0) {
            return;
        }
        if (!event.getChangedObjects().isEmpty() && event.getChangedObjects().stream().allMatch(p -> p instanceof ParallelTileObject)) {
            return;
        }
        QuPathViewer[] viewers = this.map.keySet().toArray(new QuPathViewer[this.map.size()]);
        PathObjectHierarchy hierarchy = event.getHierarchy();
        int maxSize = this.maxUndoHierarchySize.get();
        boolean sizeOK = hierarchy.nObjects() <= maxSize;
        for (QuPathViewer viewer : viewers) {
            if (viewer.getHierarchy() != hierarchy) continue;
            SerializableUndoRedoStack<PathObjectHierarchy> undoRedo = this.map.get(viewer);
            if (sizeOK) {
                if (undoRedo == null) {
                    this.map.put(viewer, new SerializableUndoRedoStack<PathObjectHierarchy>(hierarchy));
                    continue;
                }
                undoRedo.addLatest(hierarchy, this.maxUndoLevels.get());
                continue;
            }
            this.map.put(viewer, null);
        }
        this.refreshProperties();
    }

    static class SerializableUndoRedoStack<T> {
        private byte[] current = null;
        private Deque<byte[]> undoStack = new ArrayDeque<byte[]>();
        private Deque<byte[]> redoStack = new ArrayDeque<byte[]>();

        SerializableUndoRedoStack(T object) {
            if (object != null) {
                this.current = this.serialize(object, 1024);
            }
        }

        public boolean canUndo() {
            return !this.undoStack.isEmpty();
        }

        public boolean canRedo() {
            return !this.redoStack.isEmpty();
        }

        public synchronized long totalBytes() {
            long total = 0L;
            if (this.current != null) {
                total = this.current.length;
            }
            for (byte[] bytes : this.undoStack) {
                total += (long)bytes.length;
            }
            for (byte[] bytes : this.redoStack) {
                total += (long)bytes.length;
            }
            return total;
        }

        public synchronized void clear() {
            this.current = null;
            this.undoStack.clear();
            this.redoStack.clear();
        }

        public synchronized T redoOnce() {
            if (this.redoStack.isEmpty()) {
                logger.debug("Cannot redo! Stack is empty.");
                return null;
            }
            if (this.current != null) {
                this.undoStack.push(this.current);
            }
            this.current = this.redoStack.pop();
            return this.deserialize(this.current);
        }

        public synchronized T undoOnce() {
            if (this.undoStack.isEmpty()) {
                logger.debug("Cannot undo! Stack is empty.");
                return null;
            }
            if (this.current != null) {
                this.redoStack.push(this.current);
            }
            this.current = this.undoStack.pop();
            return this.deserialize(this.current);
        }

        public synchronized void addLatest(T object, int historySize) {
            int initialSize = 1024;
            if (this.current != null) {
                long remainingMemory = GeneralTools.estimateAvailableMemory();
                if ((double)remainingMemory < (double)this.current.length * 1.5) {
                    this.undoStack.clear();
                } else {
                    initialSize = Math.min(0x7FFFFFBF, (int)((double)this.current.length * 1.1));
                    this.undoStack.push(this.current);
                }
            }
            this.current = this.serialize(object, initialSize);
            this.redoStack.clear();
            if (historySize > 0) {
                while (this.undoStack.size() > historySize) {
                    this.undoStack.pollLast();
                }
            }
        }

        private byte[] serialize(T object, int initialSize) {
            byte[] byArray;
            ByteArrayOutputStream stream = new ByteArrayOutputStream(initialSize);
            try {
                ObjectOutputStream out = new ObjectOutputStream(stream);
                out.writeObject(object);
                out.flush();
                byArray = stream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Error serializing " + String.valueOf(object), (Throwable)e);
                    return null;
                }
            }
            stream.close();
            return byArray;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private T deserialize(byte[] bytes) {
            try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
                ObjectInputStream in = PathIO.createObjectInputStream((InputStream)stream);
                Object object = in.readObject();
                return (T)object;
            }
            catch (IOException | ClassNotFoundException e) {
                logger.error("Error deserializing object", (Throwable)e);
                return null;
            }
        }
    }
}

