/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.SelectableItem;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.annotations.ActionAccelerator;
import qupath.lib.gui.actions.annotations.ActionConfig;
import qupath.lib.gui.actions.annotations.ActionIcon;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.viewer.tools.PathTool;
import qupath.lib.gui.viewer.tools.PathTools;

public class ToolManager {
    private static final Logger logger = LoggerFactory.getLogger(ToolManager.class);
    private ObjectProperty<PathTool> selectedToolProperty = new SimpleObjectProperty((Object)PathTools.MOVE);
    private ObservableList<PathTool> tools = FXCollections.observableArrayList((Object[])new PathTool[]{PathTools.MOVE, PathTools.RECTANGLE, PathTools.ELLIPSE, PathTools.LINE_OR_ARROW, PathTools.POLYGON, PathTools.POLYLINE, PathTools.BRUSH, PathTools.POINTS});
    private ObservableList<PathTool> unmodifiableTools = FXCollections.unmodifiableObservableList(this.tools);
    private BooleanProperty lockSelectedToolProperty = new SimpleBooleanProperty(false);
    private Map<PathTool, Action> toolActions = new HashMap<PathTool, Action>();
    private ObjectProperty<PathTool> previousSelectedToolProperty = new SimpleObjectProperty((Object)PathTools.MOVE);
    @ActionAccelerator(value="m")
    @ActionConfig(value="Tools.move")
    public final Action MOVE_TOOL = this.getToolAction(PathTools.MOVE);
    @ActionAccelerator(value="r")
    @ActionConfig(value="Tools.rectangle")
    public final Action RECTANGLE_TOOL = this.getToolAction(PathTools.RECTANGLE);
    @ActionAccelerator(value="o")
    @ActionConfig(value="Tools.ellipse")
    public final Action ELLIPSE_TOOL = this.getToolAction(PathTools.ELLIPSE);
    @ActionAccelerator(value="p")
    @ActionConfig(value="Tools.polygon")
    public final Action POLYGON_TOOL = this.getToolAction(PathTools.POLYGON);
    @ActionAccelerator(value="v")
    @ActionConfig(value="Tools.polyline")
    public final Action POLYLINE_TOOL = this.getToolAction(PathTools.POLYLINE);
    @ActionAccelerator(value="b")
    @ActionConfig(value="Tools.brush")
    public final Action BRUSH_TOOL = this.getToolAction(PathTools.BRUSH);
    @ActionAccelerator(value="l")
    @ActionConfig(value="Tools.line", bindLocale=false)
    public final Action LINE_TOOL = this.getToolAction(PathTools.LINE_OR_ARROW);
    @ActionAccelerator(value=".")
    @ActionConfig(value="Tools.points")
    public final Action POINTS_TOOL = this.getToolAction(PathTools.POINTS);
    @ActionAccelerator(value="shift+s")
    @ActionIcon(value=IconFactory.PathIcons.SELECTION_MODE)
    @ActionConfig(value="Tools.selectionMode")
    public final Action SELECTION_MODE = ActionTools.createSelectableAction((ObservableValue<Boolean>)PathPrefs.selectionModeProperty());

    private ToolManager() {
        ActionTools.getAnnotatedActions(this);
    }

    public static ToolManager create() {
        return new ToolManager();
    }

    public ObservableList<PathTool> getTools() {
        return this.unmodifiableTools;
    }

    public ReadOnlyObjectProperty<PathTool> selectedToolProperty() {
        return this.selectedToolProperty;
    }

    public BooleanProperty lockSelectedToolProperty() {
        return this.lockSelectedToolProperty;
    }

    public boolean installTool(PathTool tool, KeyCodeCombination accelerator) {
        int ind;
        if (tool == null || this.tools.contains((Object)tool)) {
            return false;
        }
        if (accelerator != null) {
            Action action = this.getToolAction(tool);
            action.setAccelerator((KeyCombination)accelerator);
        }
        if ((ind = this.tools.indexOf((Object)PathTools.POINTS)) < 0) {
            this.tools.add((Object)tool);
        } else {
            this.tools.add(ind, (Object)tool);
        }
        return true;
    }

    public void setSelectedTool(PathTool tool) {
        if (!this.isToolSwitchingEnabled()) {
            logger.warn("Mode switching currently disabled - cannot change to {}", (Object)tool);
            return;
        }
        if (this.getSelectedTool() != PathTools.MOVE) {
            this.previousSelectedToolProperty.set((Object)this.getSelectedTool());
        }
        this.selectedToolProperty.set((Object)tool);
    }

    public PathTool getSelectedTool() {
        return (PathTool)this.selectedToolProperty().get();
    }

    public PathTool getPreviousSelectedTool() {
        return (PathTool)this.previousSelectedToolProperty.get();
    }

    public ReadOnlyObjectProperty<PathTool> previousSelectedToolProperty() {
        return this.previousSelectedToolProperty;
    }

    public void setToolSwitchingEnabled(boolean enabled) {
        this.lockSelectedToolProperty().set(!enabled);
    }

    public boolean isToolSwitchingEnabled() {
        return !this.lockSelectedToolProperty().get();
    }

    public Action getToolAction(PathTool tool) {
        Action action = this.toolActions.get(tool);
        if (action == null) {
            action = this.createToolAction(tool);
            this.toolActions.put(tool, action);
        }
        return action;
    }

    public Action getSelectionModeAction() {
        return this.SELECTION_MODE;
    }

    private Action createToolAction(PathTool tool) {
        Action action = ActionTools.createSelectableCommandAction(new SelectableItem<PathTool>(this.selectedToolProperty, tool), (ObservableValue<String>)tool.nameProperty(), tool.iconProperty(), null);
        action.disabledProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.tools.contains((Object)tool) || this.lockSelectedToolProperty.get(), (Observable[])new Observable[]{this.lockSelectedToolProperty, this.tools}));
        return action;
    }
}

