/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.TextAlignment;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.decoration.Decoration;
import org.controlsfx.control.decoration.Decorator;
import org.controlsfx.control.decoration.GraphicDecoration;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.gui.ToolManager;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.actions.AutomateActions;
import qupath.lib.gui.actions.CommonActions;
import qupath.lib.gui.actions.OverlayActions;
import qupath.lib.gui.actions.ViewerActions;
import qupath.lib.gui.localization.QuPathResources;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.IconFactory;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.QuPathViewerListener;
import qupath.lib.gui.viewer.tools.ExtendedPathTool;
import qupath.lib.gui.viewer.tools.PathTool;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;

class ToolBarComponent {
    private static final Logger logger = LoggerFactory.getLogger(ToolBarComponent.class);
    private final ObservableList<PathTool> availableTools;
    private final Map<PathTool, Node> toolMap = new WeakHashMap<PathTool, Node>();
    private final ToolManager toolManager;
    private final int toolIdx;
    private final ObservableValue<? extends QuPathViewer> viewerProperty;
    private final ToolBar toolbar = new ToolBar();
    private ToggleGroup toolGroup;

    ToolBarComponent(ToolManager toolManager, ViewerActions viewerManagerActions, CommonActions commonActions, AutomateActions automateActions, OverlayActions overlayActions) {
        this.toolManager = toolManager;
        this.viewerProperty = viewerManagerActions.getViewerManager().activeViewerProperty();
        logger.trace("Initializing toolbar");
        ViewerMagnificationLabel magLabel = new ViewerMagnificationLabel();
        this.viewerProperty.addListener((v, o, n) -> magLabel.setViewer((QuPathViewer)n));
        magLabel.setViewer((QuPathViewer)this.viewerProperty.getValue());
        this.availableTools = toolManager.getTools();
        this.availableTools.addListener(v -> this.updateToolbar());
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add((Node)this.createToggleButton(commonActions.SHOW_ANALYSIS_PANE));
        nodes.add((Node)ToolBarComponent.createSeparator());
        this.toolIdx = nodes.size();
        this.addToolButtons((List<Node>)nodes, (List<PathTool>)this.availableTools);
        nodes.add((Node)ToolBarComponent.createSeparator());
        nodes.add((Node)this.createToggleButton(toolManager.getSelectionModeAction()));
        nodes.add((Node)ToolBarComponent.createSeparator());
        nodes.add((Node)this.createButton(commonActions.BRIGHTNESS_CONTRAST));
        nodes.add((Node)ToolBarComponent.createSeparator());
        nodes.add((Node)magLabel);
        nodes.add((Node)this.createButton(viewerManagerActions.ZOOM_TO_FIT));
        nodes.add((Node)ToolBarComponent.createSeparator());
        nodes.add((Node)this.createToggleButton(overlayActions.SHOW_ANNOTATIONS));
        nodes.add((Node)this.createToggleButton(overlayActions.FILL_ANNOTATIONS));
        nodes.add((Node)this.createToggleButton(overlayActions.SHOW_NAMES));
        nodes.add((Node)this.createToggleButton(overlayActions.SHOW_TMA_GRID));
        nodes.add((Node)this.createToggleButton(overlayActions.SHOW_DETECTIONS));
        nodes.add((Node)this.createToggleButton(overlayActions.FILL_DETECTIONS));
        nodes.add((Node)this.createToggleButton(overlayActions.SHOW_CONNECTIONS));
        nodes.add((Node)this.createToggleButton(overlayActions.SHOW_PIXEL_CLASSIFICATION));
        Slider sliderOpacity = new Slider(0.0, 1.0, 1.0);
        sliderOpacity.setId("opacitySlider");
        OverlayOptions overlayOptions = overlayActions.getOverlayOptions();
        sliderOpacity.valueProperty().bindBidirectional((Property)overlayOptions.opacityProperty());
        sliderOpacity.setTooltip(new Tooltip(ToolBarComponent.getDescription("overlayOpacity")));
        nodes.add((Node)sliderOpacity);
        nodes.add((Node)ToolBarComponent.createSeparator());
        MenuButton btnMeasure = new MenuButton();
        btnMeasure.setId("measurementTablesMenuButton");
        btnMeasure.setGraphic(IconFactory.createNode(16, 16, IconFactory.PathIcons.TABLE));
        btnMeasure.setTooltip(new Tooltip(ToolBarComponent.getDescription("showMeasurementsTable")));
        btnMeasure.getItems().addAll((Object[])new MenuItem[]{ActionTools.createMenuItem(commonActions.MEASURE_ANNOTATIONS), ActionTools.createMenuItem(commonActions.MEASURE_DETECTIONS), ActionTools.createMenuItem(commonActions.MEASURE_TMA)});
        nodes.add((Node)btnMeasure);
        nodes.add((Node)this.createButton(automateActions.SCRIPT_EDITOR));
        nodes.add((Node)ToolBarComponent.createSeparator());
        MenuButton btnOverlay = new MenuButton();
        btnOverlay.setId("viewerMenuButton");
        btnOverlay.setGraphic(IconFactory.createNode(FontAwesome.Glyph.DESKTOP));
        btnOverlay.setTooltip(new Tooltip(ToolBarComponent.getDescription("viewerMenu")));
        btnOverlay.getItems().addAll((Object[])new MenuItem[]{ActionTools.createMenuItem(viewerManagerActions.SHOW_OVERVIEW), ActionTools.createMenuItem(viewerManagerActions.SHOW_LOCATION), ActionTools.createMenuItem(viewerManagerActions.SHOW_SCALEBAR), ActionTools.createMenuItem(viewerManagerActions.SHOW_Z_PROJECT), new SeparatorMenuItem(), ActionTools.createMenuItem(overlayActions.SHOW_GRID), ActionTools.createMenuItem(overlayActions.GRID_SPACING), new SeparatorMenuItem(), ActionTools.createMenuItem(commonActions.INPUT_DISPLAY)});
        nodes.add((Node)btnOverlay);
        nodes.add((Node)ToolBarComponent.createSeparator());
        nodes.add((Node)this.createButton(commonActions.HELP_VIEWER));
        nodes.add((Node)this.createButton(commonActions.SHOW_LOG));
        nodes.add((Node)this.createButton(commonActions.PREFERENCES));
        this.toolbar.getItems().addListener(this::handleItemsChanged);
        this.toolbar.getItems().setAll(nodes);
    }

    private void handleItemsChanged(ListChangeListener.Change<? extends Node> change) {
        List<ButtonBase> buttons = change.getList().stream().filter(p -> p instanceof ButtonBase).map(ButtonBase.class::cast).toList();
        if (buttons.isEmpty()) {
            return;
        }
        double maxPrefHeight = buttons.stream().mapToDouble(Region::getHeight).max().orElse(-1.0);
        buttons.forEach(b -> b.setPrefHeight(maxPrefHeight));
    }

    private static Separator createSeparator() {
        Separator separator = new Separator(Orientation.VERTICAL);
        separator.setHalignment(HPos.CENTER);
        separator.setValignment(VPos.CENTER);
        return separator;
    }

    private Button createButton(Action action) {
        Button button = action.getGraphic() == null ? ActionTools.createButton(action) : ActionTools.createButtonWithGraphicOnly(action);
        return button;
    }

    private ToggleButton createToggleButton(Action action) {
        ToggleButton button = action.getGraphic() == null ? ActionTools.createToggleButton(action) : ActionTools.createToggleButtonWithGraphicOnly(action);
        return button;
    }

    private static String getDescription(String key) {
        return QuPathResources.getString("Toolbar." + key + ".description");
    }

    private static String getName(String key) {
        return QuPathResources.getString("Toolbar." + key);
    }

    private static String getMessage(String key) {
        return QuPathResources.getString("Toolbar.message." + key);
    }

    void updateToolbar() {
        ArrayList<Node> nodes = new ArrayList<Node>((Collection<Node>)this.toolbar.getItems());
        nodes.removeAll(this.toolMap.values());
        this.addToolButtons((List<Node>)nodes, (List<PathTool>)this.availableTools);
        this.toolbar.getItems().setAll(nodes);
    }

    private ToggleGroup getToolToggleGroup() {
        if (this.toolGroup == null) {
            this.toolGroup = new ToggleGroup();
            this.toolGroup.selectedToggleProperty().addListener((v, o, n) -> {
                if (n == null) {
                    o.setSelected(true);
                }
            });
        }
        return this.toolGroup;
    }

    private void addToolButtons(List<Node> nodes, List<PathTool> tools) {
        int ind = this.toolIdx;
        ToggleGroup group = this.getToolToggleGroup();
        for (PathTool tool : tools) {
            Action action = this.toolManager.getToolAction(tool);
            Node btnTool = this.toolMap.get(tool);
            if (btnTool == null) {
                ToggleButton toggleButton = this.createToggleButton(action);
                btnTool = toggleButton;
                toggleButton.setToggleGroup(group);
                if (tool instanceof ExtendedPathTool) {
                    ExtendedPathTool extendedTool = (ExtendedPathTool)tool;
                    ContextMenu popup = this.createContextMenu(extendedTool, (Toggle)toggleButton);
                    btnTool.setOnContextMenuRequested(e -> popup.show((Node)toggleButton, e.getScreenX(), e.getScreenY()));
                    ToolBarComponent.addContextMenuDecoration(toggleButton, popup);
                }
                this.toolMap.put(tool, btnTool);
            }
            nodes.add(ind++, btnTool);
        }
    }

    private static void addContextMenuDecoration(ToggleButton btn, ContextMenu popup) {
        Path triangle = new Path();
        double width = 6.0;
        triangle.getElements().setAll((Object[])new PathElement[]{new MoveTo(0.0, 0.0), new LineTo(width, 0.0), new LineTo(width / 2.0, Math.sqrt(width * width / 2.0)), new ClosePath()});
        triangle.setTranslateX(-width);
        triangle.setTranslateY(-width);
        triangle.setRotate(-90.0);
        triangle.fillProperty().bind((ObservableValue)btn.textFillProperty());
        triangle.setStroke(null);
        triangle.setOpacity(0.5);
        GraphicDecoration decoration = new GraphicDecoration((Node)triangle, Pos.BOTTOM_RIGHT);
        btn.sceneProperty().addListener((v, o, n) -> Platform.runLater(() -> {
            if (n != null) {
                Decorator.addDecoration((Node)btn, (Decoration)decoration);
            } else {
                Decorator.removeDecoration((Node)btn, (Decoration)decoration);
            }
        }));
        Platform.runLater(() -> Decorator.addDecoration((Node)btn, (Decoration)decoration));
        btn.graphicProperty().addListener((v, o, n) -> {
            Decorator.removeAllDecorations((Node)btn);
            Platform.runLater(() -> Decorator.addDecoration((Node)btn, (Decoration)decoration));
        });
        triangle.setOnMouseClicked(e -> popup.show((Node)btn, e.getScreenX(), e.getScreenY()));
    }

    private ContextMenu createContextMenu(ExtendedPathTool tool, Toggle toolToggle) {
        ContextMenu menu = new ContextMenu();
        ToggleGroup toggle = new ToggleGroup();
        for (PathTool subtool : tool.getAvailableTools()) {
            RadioMenuItem mi = new RadioMenuItem();
            mi.textProperty().bind((ObservableValue)subtool.nameProperty());
            mi.graphicProperty().bind(subtool.iconProperty());
            mi.setToggleGroup(toggle);
            menu.getItems().add((Object)mi);
            mi.selectedProperty().addListener((v, o, n) -> {
                if (n.booleanValue()) {
                    tool.selectedTool().set((Object)subtool);
                    toolToggle.setSelected(true);
                }
            });
        }
        return menu;
    }

    ToolBar getToolBar() {
        return this.toolbar;
    }

    private static class ViewerMagnificationLabel
    extends Label
    implements QuPathViewerListener {
        private QuPathViewer viewer;
        private static final String defaultText = "1x";
        private final Tooltip tooltipMag = new Tooltip(ToolBarComponent.getDescription("magnification"));

        private ViewerMagnificationLabel() {
            this.setTooltip(this.tooltipMag);
            this.setPrefWidth(60.0);
            this.setMinWidth(60.0);
            this.setMaxWidth(60.0);
            this.setTextAlignment(TextAlignment.CENTER);
            this.setOnMouseEntered(e -> this.refreshMagnificationTooltip());
            this.setOnMouseClicked(e -> {
                if (e.getClickCount() == 2) {
                    this.promptToUpdateMagnification();
                }
            });
        }

        private void setViewer(QuPathViewer viewer) {
            if (this.viewer == viewer) {
                return;
            }
            if (this.viewer != null) {
                this.viewer.removeViewerListener(this);
            }
            this.viewer = viewer;
            if (this.viewer != null) {
                this.viewer.addViewerListener(this);
            }
            this.updateMagnificationString();
        }

        private void updateMagnificationString() {
            if (!Platform.isFxApplicationThread()) {
                Platform.runLater(this::updateMagnificationString);
                return;
            }
            if (this.viewer == null || this.viewer.getImageData() == null) {
                this.setText(defaultText);
                return;
            }
            this.setText(GuiTools.getMagnificationString(this.viewer));
        }

        private void refreshMagnificationTooltip() {
            if (this.tooltipMag == null || this.viewer == null) {
                return;
            }
            ImageData<BufferedImage> imageData = this.viewer.getImageData();
            if (imageData == null) {
                this.tooltipMag.setText(ToolBarComponent.getName("magnification"));
            } else {
                double mag = imageData.getServerMetadata().getMagnification();
                if (!Double.isNaN(mag)) {
                    this.tooltipMag.setText(ToolBarComponent.getDescription("magnification"));
                } else {
                    this.tooltipMag.setText(ToolBarComponent.getDescription("magnificationScale"));
                }
            }
        }

        private void promptToUpdateMagnification() {
            boolean hasMagnification;
            if (this.viewer == null || !this.viewer.hasServer()) {
                return;
            }
            double fullMagnification = this.viewer.getServer().getMetadata().getMagnification();
            boolean bl = hasMagnification = !Double.isNaN(fullMagnification);
            if (hasMagnification) {
                double defaultValue = Math.rint(this.viewer.getMagnification() * 1000.0) / 1000.0;
                Double value = Dialogs.showInputDialog((String)ToolBarComponent.getName("setMagnification"), (String)ToolBarComponent.getMessage("promptMagnification"), (Double)defaultValue);
                if (value == null) {
                    return;
                }
                if (Double.isFinite(value) && value > 0.0) {
                    this.viewer.setMagnification(value);
                } else {
                    Dialogs.showErrorMessage((String)ToolBarComponent.getName("setMagnification"), (String)String.format(ToolBarComponent.getMessage("invalidMagnification"), value));
                }
            } else {
                double defaultValue = Math.rint(this.viewer.getDownsampleFactor() * 1000.0) / 1000.0;
                Double value = Dialogs.showInputDialog((String)ToolBarComponent.getName("setDownsample"), (String)ToolBarComponent.getMessage("promptDownsample"), (Double)defaultValue);
                if (value == null) {
                    return;
                }
                if (Double.isFinite(value) && value > 0.0) {
                    this.viewer.setDownsampleFactor(value);
                } else {
                    Dialogs.showErrorMessage((String)ToolBarComponent.getName("setDownsample"), (String)String.format(ToolBarComponent.getMessage("invalidDownsample"), value));
                }
            }
        }

        @Override
        public void imageDataChanged(QuPathViewer viewer, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
            this.updateMagnificationString();
        }

        @Override
        public void visibleRegionChanged(QuPathViewer viewer, Shape shape) {
            this.updateMagnificationString();
        }

        @Override
        public void selectedObjectChanged(QuPathViewer viewer, PathObject pathObjectSelected) {
        }

        @Override
        public void viewerClosed(QuPathViewer viewer) {
            this.updateMagnificationString();
        }
    }
}

