/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.plugins.AbstractTaskRunner;
import qupath.lib.plugins.CommandLineTaskRunner;
import qupath.lib.plugins.PathTask;
import qupath.lib.plugins.SimpleProgressMonitor;
import qupath.lib.regions.ImageRegion;

public class TaskRunnerFX
extends AbstractTaskRunner {
    private static final Logger logger = LoggerFactory.getLogger(TaskRunnerFX.class);
    private static long repaintDelayMillis = 1000L;
    private QuPathGUI qupath;

    public TaskRunnerFX(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    public TaskRunnerFX(QuPathGUI qupath, int nThreads) {
        super(nThreads);
        this.qupath = qupath;
    }

    public SimpleProgressMonitor makeProgressMonitor() {
        if (Platform.isFxApplicationThread()) {
            logger.warn("Progress monitor cannot be created from JavaFX application thread - will default to command line monitor");
            return new CommandLineTaskRunner.CommandLineProgressMonitor();
        }
        return new PluginProgressMonitorFX(this.qupath.getStage());
    }

    public synchronized void runTasks(String message, Collection<? extends Runnable> tasks) {
        QuPathViewer viewer;
        QuPathViewer quPathViewer = viewer = this.qupath == null || repaintDelayMillis <= 0L ? null : this.qupath.getViewer();
        if (viewer != null) {
            viewer.setMinimumRepaintSpacingMillis(repaintDelayMillis);
        }
        try {
            super.runTasks(message, tasks);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (viewer != null) {
                viewer.resetMinimumRepaintSpacingMillis();
            }
        }
    }

    protected void postProcess(Collection<? extends PathTask> tasks) {
        if (!Platform.isFxApplicationThread()) {
            FutureTask<Boolean> postProcessTask = new FutureTask<Boolean>(() -> super.postProcess(tasks), Boolean.TRUE);
            Platform.runLater(postProcessTask);
            try {
                postProcessTask.get();
            }
            catch (InterruptedException e) {
                logger.error("Interruption during post-processing", (Throwable)e);
            }
            catch (ExecutionException e) {
                logger.error("Exception during post-processing", (Throwable)e);
            }
            return;
        }
        super.postProcess(tasks);
    }

    static class PluginProgressMonitorFX
    implements SimpleProgressMonitor {
        private static final Logger logger = LoggerFactory.getLogger(PluginProgressMonitorFX.class);
        private static String STARTING_MESSAGE = "Starting...";
        private static String RUNNING_MESSAGE = "Running...";
        private static String CANCEL_MESSAGE = "Cancelling...";
        private static String COMPLETED_MESSAGE = "Completed!";
        private Stage owner;
        private Timeline timeline;
        private Dialog<Void> progressDialog;
        private Label progressLabel;
        private ProgressBar progressBar;
        private String lastMessage;
        private AtomicInteger progress = new AtomicInteger(0);
        private int maxProgress;
        private int millisToDisplay;
        private boolean taskComplete = false;
        private boolean permitClose = false;
        private long startTimeMS = 0L;
        private boolean cancelPressed = false;

        public PluginProgressMonitorFX(Stage owner) {
            this(owner, 500);
        }

        public PluginProgressMonitorFX(Stage owner, int millisToDisplay) {
            this.owner = owner;
            this.millisToDisplay = millisToDisplay;
        }

        public void startMonitoring(String message, int maxProgress, boolean mayCancel) {
            if (this.progressDialog != null) {
                throw new UnsupportedOperationException("Unsupported attempt to reuse a plugin progress monitor!");
            }
            this.startTimeMS = System.currentTimeMillis();
            this.maxProgress = maxProgress;
            this.progress.set(0);
            this.createProgressDialog(message, mayCancel);
        }

        void createProgressDialog(String message, boolean mayCancel) {
            Duration duration;
            GridPane panel;
            if (!Platform.isFxApplicationThread()) {
                Platform.runLater(() -> this.createProgressDialog(message, mayCancel));
                return;
            }
            this.taskComplete = false;
            this.progressLabel = this.maxProgress > 1 ? new Label("Starting " + this.maxProgress + " tasks...") : new Label("");
            this.progressDialog = new Dialog();
            this.progressDialog.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
            ((Button)this.progressDialog.getDialogPane().lookupButton(ButtonType.CANCEL)).setVisible(false);
            this.progressDialog.initOwner((Window)this.owner);
            this.progressDialog.getDialogPane().getScene().getWindow().setOnCloseRequest(e -> {
                if (!this.permitClose) {
                    e.consume();
                }
            });
            if (message == null) {
                this.progressDialog.getDialogPane().setHeaderText(STARTING_MESSAGE);
            } else {
                this.progressDialog.getDialogPane().setHeaderText(message);
            }
            BorderPane pane = new BorderPane();
            this.progressDialog.setTitle("Progress");
            int nRows = 2;
            if (this.maxProgress > 1) {
                ++nRows;
            }
            if (mayCancel) {
                ++nRows;
            }
            if (this.maxProgress > 1) {
                this.progressBar = new ProgressBar();
                panel = GridPaneUtils.createRowGridControls((Node[])new Node[]{this.progressLabel, this.progressBar});
            } else {
                this.progressLabel.setTextAlignment(TextAlignment.CENTER);
                panel = GridPaneUtils.createRowGridControls((Node[])new Node[]{this.progressLabel});
            }
            if (mayCancel) {
                Button btnCancel = new Button("Cancel");
                panel.add((Node)btnCancel, 0, nRows - 1);
                btnCancel.prefWidthProperty().bind((ObservableValue)panel.widthProperty());
                btnCancel.setOnAction(e -> {
                    this.progressDialog.getDialogPane().setHeaderText(CANCEL_MESSAGE);
                    this.cancelPressed = true;
                });
            }
            pane.setCenter((Node)panel);
            this.progressDialog.initModality(Modality.APPLICATION_MODAL);
            pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.progressDialog.getDialogPane().setContent((Node)pane);
            Duration duration2 = duration = this.millisToDisplay > 0 ? Duration.millis((double)this.millisToDisplay) : Duration.millis((double)500.0);
            if (this.timeline == null) {
                this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(duration, e -> this.updateDialog(), new KeyValue[0])});
            }
            if (this.millisToDisplay > 0) {
                this.timeline.setDelay(duration);
            }
            this.timeline.setCycleCount(-1);
            if (!this.taskComplete) {
                this.timeline.playFromStart();
            }
        }

        public boolean cancelled() {
            return this.cancelPressed;
        }

        public void updateProgress(int progressIncrement, String message, ImageRegion region) {
            this.progress.addAndGet(progressIncrement);
            this.lastMessage = message;
        }

        public void pluginCompleted(String message) {
            this.stopMonitoring(message);
        }

        void stopMonitoring(String message) {
            if (!Platform.isFxApplicationThread()) {
                Platform.runLater(() -> this.stopMonitoring(message));
                return;
            }
            if (this.timeline != null) {
                this.timeline.stop();
            }
            if (this.taskComplete && (this.progressDialog == null || !this.progressDialog.isShowing())) {
                return;
            }
            this.taskComplete = true;
            if (this.progressDialog != null) {
                this.doDialogClose();
            }
            long endTime = System.currentTimeMillis();
            logger.info(String.format("Processing complete in %.2f seconds", (double)(endTime - this.startTimeMS) / 1000.0));
            if (message != null && !message.trim().isEmpty()) {
                logger.info(message);
            }
        }

        private void updateDialog() {
            if (!this.progressDialog.isShowing() && !this.taskComplete) {
                this.progressDialog.show();
            }
            int progressValue = this.progress.get();
            int progressPercent = (int)Math.round((double)progressValue / (double)this.maxProgress * 100.0);
            if (!this.cancelPressed && STARTING_MESSAGE.equals(this.progressDialog.getDialogPane().getHeaderText())) {
                this.progressDialog.getDialogPane().setHeaderText(RUNNING_MESSAGE);
            }
            if (this.lastMessage == null) {
                this.progressLabel.setText("");
            } else {
                this.progressLabel.setText(this.lastMessage + " (" + progressPercent + "%)");
            }
            if (progressValue >= this.maxProgress) {
                this.stopMonitoring(COMPLETED_MESSAGE);
            } else if (this.progressBar != null) {
                this.progressBar.setProgress((double)progressValue / (double)this.maxProgress);
            }
        }

        private void doDialogClose() {
            this.permitClose = true;
            if (this.progressDialog != null) {
                this.progressDialog.close();
            }
            if (this.timeline != null) {
                this.timeline.stop();
            }
        }
    }
}

