/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import qupath.lib.common.ThreadTools;

public class SharedThreadPoolManager
implements AutoCloseable {
    private Map<Object, ExecutorService> mapSingleThreadPools = new HashMap<Object, ExecutorService>();
    private ExecutorService poolMultipleThreads = Executors.newFixedThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors()), ThreadTools.createThreadFactory((String)"qupath-shared-", (boolean)false));

    private SharedThreadPoolManager() {
    }

    public static SharedThreadPoolManager create() {
        return new SharedThreadPoolManager();
    }

    public ExecutorService getSingleThreadExecutor(Object owner) {
        ExecutorService pool = this.mapSingleThreadPools.get(owner);
        if (pool == null || pool.isShutdown()) {
            pool = Executors.newSingleThreadExecutor(ThreadTools.createThreadFactory((String)(owner.getClass().getSimpleName().toLowerCase() + "-"), (boolean)false));
            this.mapSingleThreadPools.put(owner, pool);
        }
        return pool;
    }

    public <V> ExecutorCompletionService<V> createSharedPoolCompletionService(Class<V> cls) {
        return new ExecutorCompletionService(this.poolMultipleThreads);
    }

    public void submitShortTask(Runnable runnable) {
        this.poolMultipleThreads.submit(runnable);
    }

    @Override
    public void close() {
        this.poolMultipleThreads.shutdownNow();
        for (ExecutorService pool : this.mapSingleThreadPools.values()) {
            pool.shutdownNow();
        }
    }
}

