/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;

public class SelectableItem<T> {
    private final ObjectProperty<T> selected;
    private final BooleanProperty itemSelected = new SimpleBooleanProperty();
    private final T item;
    private final ChangeListener<T> selectedListener;
    private final ChangeListener<Boolean> itemSelectedListener;

    public SelectableItem(ObjectProperty<T> selected, T item) {
        this.selected = selected;
        this.item = item;
        this.selectedListener = (v, o, n) -> this.itemSelected.set(n == item);
        this.itemSelectedListener = (v, o, n) -> {
            if (n.booleanValue()) {
                selected.set(item);
            }
        };
        this.selected.addListener(this.selectedListener);
        this.itemSelected.addListener(this.itemSelectedListener);
    }

    public boolean isSelected() {
        return this.selected.get() == this.item;
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.selected.set(this.item);
        }
    }

    public BooleanProperty selectedProperty() {
        return this.itemSelected;
    }

    public T getItem() {
        return this.item;
    }
}

