/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.beans.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javax.script.ScriptException;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.scripting.ScriptEditor;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.tools.MenuTools;

class ScriptMenuLoader {
    private static final Logger logger = LoggerFactory.getLogger(ScriptMenuLoader.class);
    private ObservableStringValue scriptDirectory;
    private Menu menu;
    private MenuItem miSetPath;
    private MenuItem miCreateScript;
    private MenuItem miOpenDirectory;
    private static final String NO_SCRIPTS_NAME = "No scripts found";
    private MenuItem miPlaceholder = new MenuItem("No scripts found");
    private final Supplier<ScriptEditor> scriptEditorSupplier;

    ScriptMenuLoader(String name, ObservableStringValue scriptDirectory, Supplier<ScriptEditor> scriptEditorSupplier) {
        this.menu = new Menu(name);
        this.scriptDirectory = scriptDirectory;
        this.scriptEditorSupplier = scriptEditorSupplier;
        Action actionCreateScript = ActionTools.actionBuilder("New script...", e -> {
            ScriptEditor scriptEditor;
            File scriptFile;
            Object scriptName;
            String dir = (String)scriptDirectory.get();
            if (dir == null) {
                Dialogs.showErrorMessage((String)"New script error", (String)"No script directory set!");
            }
            if ((scriptName = Dialogs.showInputDialog((String)"New script", (String)"Enter script name", (String)"")) == null || ((String)scriptName).trim().isEmpty()) {
                return;
            }
            if (!((String)scriptName).contains(".")) {
                scriptName = (String)scriptName + ".groovy";
            }
            if (!(scriptFile = new File(dir, (String)scriptName)).exists()) {
                try {
                    File dirScripts = new File(dir);
                    if (!dirScripts.exists()) {
                        dirScripts.mkdir();
                    }
                    scriptFile.createNewFile();
                }
                catch (Exception e1) {
                    Dialogs.showErrorMessage((String)"New script error", (String)"Unable to create new script!");
                    logger.error("Create script error", (Throwable)e1);
                }
            }
            if ((scriptEditor = (ScriptEditor)scriptEditorSupplier.get()) != null) {
                scriptEditor.showScript(scriptFile);
            } else {
                QuPathGUI.getInstance().getScriptEditor().showScript(scriptFile);
            }
        }).longText("Create a new script.").build();
        Action actionOpenDirectory = ActionTools.actionBuilder("Open script directory", e -> {
            File dir = new File((String)scriptDirectory.get());
            if (!dir.exists()) {
                dir.mkdir();
            }
            GuiTools.openFile(dir);
        }).disabled((ObservableValue<Boolean>)Bindings.isNotNull((ObservableObjectValue)scriptDirectory).not()).longText("Open the script directory outside QuPath.").build();
        if (scriptDirectory instanceof StringProperty) {
            StringProperty scriptDirectoryProperty = (StringProperty)scriptDirectory;
            Action actionSetPath = ActionTools.actionBuilder("Set script directory...", e -> {
                File dirBase = scriptDirectoryProperty.get() == null ? null : new File((String)scriptDirectoryProperty.get());
                File dir = FileChoosers.promptForDirectory((String)"Set script directory", (File)dirBase);
                if (dir != null) {
                    scriptDirectoryProperty.set((Object)dir.getAbsolutePath());
                }
            }).longText("Set the directory containing scripts that should be shown in this menu.").build();
            this.miSetPath = ActionTools.createMenuItem(actionSetPath);
        }
        this.miCreateScript = ActionTools.createMenuItem(actionCreateScript);
        this.miOpenDirectory = ActionTools.createMenuItem(actionOpenDirectory);
        this.menu.getItems().setAll((Object[])new MenuItem[]{this.miPlaceholder});
        this.menu.setOnMenuValidation(e -> this.updateMenu());
    }

    private void updateMenu() {
        String scriptDir = (String)this.scriptDirectory.get();
        try {
            if (scriptDir != null) {
                if (this.miSetPath != null) {
                    this.menu.getItems().setAll((Object[])new MenuItem[]{this.miSetPath, this.miOpenDirectory, this.miCreateScript, new SeparatorMenuItem()});
                } else {
                    this.menu.getItems().setAll((Object[])new MenuItem[]{this.miOpenDirectory, this.miCreateScript, new SeparatorMenuItem()});
                }
                Path path = Paths.get(scriptDir, new String[0]);
                if (path.getFileName() != null) {
                    this.addMenuItemsForPath(this.menu, path);
                }
            } else if (this.miSetPath != null) {
                this.menu.getItems().setAll((Object[])new MenuItem[]{this.miSetPath});
            } else {
                this.menu.getItems().setAll((Object[])new MenuItem[]{this.miPlaceholder});
            }
        }
        catch (Exception e) {
            logger.warn("Unable to update scripts for path {} ({})", (Object)scriptDir, (Object)e.getLocalizedMessage());
            logger.debug("", (Throwable)e);
            this.menu.getItems().setAll((Object[])new MenuItem[]{this.miPlaceholder});
        }
    }

    private void addMenuItemsForPath(Menu menu, Path dir) {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.list(dir);){
            ArrayList<Object> items = new ArrayList<Object>();
            for (Path path : stream.sorted().toList()) {
                int dotInd;
                if (Files.isHidden(path)) continue;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Menu subMenu = MenuTools.createMenu(path.getFileName().toString(), new Object[0]);
                    subMenu.getItems().add((Object)new MenuItem(NO_SCRIPTS_NAME));
                    subMenu.setOnMenuValidation(e -> {
                        subMenu.getItems().clear();
                        this.addMenuItemsForPath(subMenu, path);
                    });
                    items.add(subMenu);
                    continue;
                }
                ScriptEditor scriptEditor = this.scriptEditorSupplier.get();
                if (scriptEditor != null && !scriptEditor.supportsFile(path.toFile())) continue;
                String name = path.getFileName().toString();
                boolean cleanName = true;
                if (cleanName && (dotInd = (name = name.replace("_", " ")).lastIndexOf(".")) > 0) {
                    name = name.substring(0, dotInd);
                }
                MenuItem item = new MenuItem(name);
                item.setOnAction(e -> {
                    File scriptFile = path.toFile();
                    if (scriptEditor != null) {
                        scriptEditor.showScript(scriptFile);
                    } else {
                        QuPathGUI qupath = QuPathGUI.getInstance();
                        try {
                            qupath.runScript(scriptFile, null);
                        }
                        catch (IllegalArgumentException | ScriptException e1) {
                            Dialogs.showErrorNotification((String)"Run script", (String)e1.getLocalizedMessage());
                            logger.error(e1.getLocalizedMessage(), (Object)e);
                        }
                    }
                });
                items.add(item);
            }
            if (!items.isEmpty()) {
                if (menu.getItems().size() == 1 && NO_SCRIPTS_NAME.equals(((MenuItem)menu.getItems().getFirst()).getText())) {
                    menu.getItems().setAll(items);
                } else {
                    menu.getItems().addAll(items);
                }
            }
        }
        catch (IOException e2) {
            logger.debug("Error adding menu item for {}", (Object)dir);
        }
    }

    public Menu getMenu() {
        return this.menu;
    }
}

