/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.CommonActions;

class QuPathUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(QuPathUncaughtExceptionHandler.class);
    private final QuPathGUI qupath;
    private long lastExceptionTimestamp = 0L;
    private String lastExceptionMessage = null;
    private long sameExceptionCount = 0L;
    private long minDelay = 1000L;

    QuPathUncaughtExceptionHandler(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String msg = e.getLocalizedMessage();
        long timestamp = System.currentTimeMillis();
        try {
            if (timestamp - this.lastExceptionTimestamp < this.minDelay && Objects.equals(msg, this.lastExceptionMessage)) {
                ++this.sameExceptionCount;
                if (this.sameExceptionCount > 3L) {
                    logger.error("{} (see full stack trace above, or use 'debug' log level)", (Object)e.getLocalizedMessage());
                } else {
                    logger.debug(e.getLocalizedMessage(), e);
                }
                return;
            }
            this.sameExceptionCount = 0L;
            if (e instanceof OutOfMemoryError) {
                this.qupath.getImageRegionStore().clearCache(true);
                Dialogs.showErrorNotification((String)"Out of memory error", (String)"Out of memory! You may need to decrease the 'Number of parallel threads' in the preferences, then restart QuPath.");
                logger.error(e.getMessage(), e);
            } else {
                CommonActions commonActions = this.qupath.getCommonActions();
                Dialogs.showErrorNotification((String)"QuPath exception", (Throwable)e);
                logger.error(e.getMessage(), e);
                if (commonActions.SHOW_LOG != null) {
                    commonActions.SHOW_LOG.handle(null);
                }
            }
        }
        finally {
            this.lastExceptionMessage = msg;
            this.lastExceptionTimestamp = timestamp;
        }
    }
}

