/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui;

import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.AnalysisTabPane;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.ToolBarComponent;
import qupath.lib.gui.panes.ProjectBrowser;
import qupath.lib.gui.tools.CommandFinderTools;

class QuPathMainPaneManager {
    private static final Logger logger = LoggerFactory.getLogger(QuPathMainPaneManager.class);
    private BorderPane pane = new BorderPane();
    private SplitPane splitPane = new SplitPane();
    private Region mainViewerPane;
    private ToolBarComponent toolbar;
    private AnalysisTabPane analysisTabPane;
    private double lastDividerLocation;

    QuPathMainPaneManager(QuPathGUI qupath) {
        this.analysisTabPane = new AnalysisTabPane(qupath);
        TabPane tabPane = this.analysisTabPane.getTabPane();
        tabPane.setMinWidth(300.0);
        tabPane.setPrefWidth(400.0);
        this.splitPane.setMinWidth(tabPane.getMinWidth() + 200.0);
        this.splitPane.setPrefWidth(tabPane.getPrefWidth() + 200.0);
        SplitPane.setResizableWithParent((Node)tabPane, (Boolean)Boolean.FALSE);
        Region viewerRegion = qupath.getViewerManager().getRegion();
        this.mainViewerPane = CommandFinderTools.createCommandFinderPane(qupath, (Node)viewerRegion, CommandFinderTools.commandBarDisplayProperty());
        this.splitPane.getItems().addAll((Object[])new Node[]{tabPane, this.mainViewerPane});
        SplitPane.setResizableWithParent((Node)viewerRegion, (Boolean)Boolean.TRUE);
        this.pane.setCenter((Node)this.splitPane);
        this.toolbar = new ToolBarComponent(qupath.getToolManager(), qupath.getViewerActions(), qupath.getCommonActions(), qupath.getAutomateActions(), qupath.getOverlayActions());
        this.pane.setTop((Node)this.toolbar.getToolBar());
        this.setAnalysisPaneVisible(true);
    }

    AnalysisTabPane getAnalysisTabPane() {
        return this.analysisTabPane;
    }

    ProjectBrowser getProjectBrowser() {
        return this.analysisTabPane == null ? null : this.analysisTabPane.getProjectBrowser();
    }

    ToolBar getToolBar() {
        return this.toolbar.getToolBar();
    }

    Pane getMainPane() {
        return this.pane;
    }

    void setDividerPosition(double pos) {
        this.splitPane.setDividerPosition(0, pos);
    }

    void setAnalysisPaneVisible(boolean visible) {
        if (visible) {
            if (this.analysisPanelVisible()) {
                return;
            }
            this.splitPane.getItems().setAll((Object[])new Node[]{this.analysisTabPane.getTabPane(), this.mainViewerPane});
            this.splitPane.setDividerPosition(0, this.lastDividerLocation);
            this.pane.setCenter((Node)this.splitPane);
        } else {
            if (!this.analysisPanelVisible()) {
                return;
            }
            this.lastDividerLocation = ((SplitPane.Divider)this.splitPane.getDividers().get(0)).getPosition();
            this.pane.setCenter((Node)this.mainViewerPane);
        }
    }

    private boolean analysisPanelVisible() {
        return this.pane.getCenter() == this.splitPane;
    }
}

